/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.templates;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmType;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.PojoType;
import org.sqlproc.dsl.property.EnumAttribute;
import org.sqlproc.dsl.property.ImplementsExtends;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.property.PojoAttrType;
import org.sqlproc.dsl.property.PojoAttribute;
import org.sqlproc.dsl.resolver.DbCheckConstraint;
import org.sqlproc.dsl.resolver.DbColumn;
import org.sqlproc.dsl.resolver.DbExport;
import org.sqlproc.dsl.resolver.DbImport;
import org.sqlproc.dsl.resolver.DbIndex;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.DbTable;
import org.sqlproc.dsl.ui.templates.Annotations;

public class TablePojoConverter {
    private boolean debug = false;
    protected static final String METHOD_TO_STRING = "toString";
    protected static final String METHOD_HASH_CODE = "hashCode";
    protected static final String METHOD_EQUALS = "equals";
    protected static final String METHOD_IS_DEF = "isDef";
    protected static final String ENUM_IS_DEF = "enumDef";
    protected static final String METHOD_TO_INIT = "toInit";
    protected static final String METHOD_INDEX = "index=";
    protected static final String ENUM_TO_INIT = "enumInit";
    protected static final String COLLECTION_LIST = "java.util.List";
    protected static final String ANNOTATION_NOT_NULL = "javax.validation.constraints.NotNull";
    protected static final String ANNOTATION_SIZE = "javax.validation.constraints.Size";
    protected static final String INDENT = "  ";
    protected static final String NLINDENT = "\n  ";
    protected String suffix;
    protected Set<String> finalEntities;
    protected Annotations annotations;
    protected Set<String> imports = new HashSet<String>();
    protected Map<String, PojoAttrType> sqlTypes = new HashMap<String, PojoAttrType>();
    protected Map<String, Map<String, PojoAttrType>> tableTypes = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, Map<String, PojoAttrType>> columnTypes = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, Map<String, PojoAttrType>> functionTypes = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, Map<String, PojoAttrType>> procedureTypes = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, String> tableNames = new HashMap<String, String>();
    protected Map<String, Map<String, String>> columnNames = new HashMap<String, Map<String, String>>();
    protected Set<String> ignoreTables = new HashSet<String>();
    protected Set<String> onlyTables = new HashSet<String>();
    protected Set<String> notAbstractTables = new HashSet<String>();
    protected Map<String, Set<String>> ignoreColumns = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> requiredColumns = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> notRequiredColumns = new HashMap<String, Set<String>>();
    protected Map<String, Map<String, PojoAttrType>> createColumns = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, Map<String, Map<String, String>>> ignoreExports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> ignoreImports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> createExports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> createImports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> inheritImports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> manyToManyImports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, List<String>>>> inheritance = new HashMap<String, Map<String, Map<String, List<String>>>>();
    protected Map<String, String> inheritanceColumns = new HashMap<String, String>();
    protected Set<String> generateMethods = new HashSet<String>();
    protected Map<String, ImplementsExtends> toImplements = new HashMap<String, ImplementsExtends>();
    protected ImplementsExtends toExtends = null;
    protected Map<String, List<String>> joinTables = new HashMap<String, List<String>>();
    protected boolean doGenerateWrappers;
    protected boolean doGenerateValidationAnnotations;
    protected String implementationPackage;
    protected boolean makeItFinal;
    protected String versionColumn;
    protected Map<String, String> versionColumns = new HashMap<String, String>();
    protected Map<String, String> notVersionColumns = new HashMap<String, String>();
    protected String generateOperators = null;
    protected Set<String> preserveForeignKeys = new HashSet<String>();
    protected Map<String, PojoType> pojosForProcedures = new HashMap<String, PojoType>();
    protected Map<String, PojoType> pojosForFunctions = new HashMap<String, PojoType>();
    protected Map<String, Map<String, PojoAttribute>> pojos = new TreeMap<String, Map<String, PojoAttribute>>();
    protected Map<String, Map<String, PojoAttribute>> procedures = new TreeMap<String, Map<String, PojoAttribute>>();
    protected Map<String, Map<String, PojoAttribute>> functions = new TreeMap<String, Map<String, PojoAttribute>>();
    protected Map<String, String> pojoExtends = new HashMap<String, String>();
    protected Map<String, Set<String>> pojoInheritanceDiscriminator = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> pojoInheritanceSimple = new HashMap<String, Set<String>>();
    protected Map<String, String> pojoDiscriminators = new HashMap<String, String>();
    protected Map<String, List<Map<PojoAttribute, Boolean>>> indexes = new TreeMap<String, List<Map<PojoAttribute, Boolean>>>();
    protected Set<String> dbSequences = new TreeSet<String>();
    protected DbResolver.DbType dbType = null;
    protected Map<String, List<EnumAttribute>> enums = new TreeMap<String, List<EnumAttribute>>();
    protected Map<String, String> comments = new HashMap<String, String>();
    protected Map<String, String> metaFunctionsResult = new HashMap<String, String>();
    public static final String FAKE_FUN_PROC_COLUMN_NAME = "_result_";
    public static final String FUN_PROC_COLUMN_NAME = "RESULT";
    protected static Map<String, String> metaType2classNameMap = new LinkedHashMap<String, String>();
    protected static Map<String, String> className2metaTypeMap;

    static {
        metaType2classNameMap.put("stamp", Timestamp.class.getName());
        metaType2classNameMap.put("timestamp", Timestamp.class.getName());
        metaType2classNameMap.put("date", Date.class.getName());
        metaType2classNameMap.put("datetime", java.util.Date.class.getName());
        metaType2classNameMap.put("time", Time.class.getName());
        metaType2classNameMap.put("byte", Byte.class.getName());
        metaType2classNameMap.put("boolean", Boolean.class.getName());
        metaType2classNameMap.put("bool", Boolean.class.getName());
        metaType2classNameMap.put("character", Character.class.getName());
        metaType2classNameMap.put("char", Character.class.getName());
        metaType2classNameMap.put("short", Short.class.getName());
        metaType2classNameMap.put("int", Integer.class.getName());
        metaType2classNameMap.put("integer", Integer.class.getName());
        metaType2classNameMap.put("long", Long.class.getName());
        metaType2classNameMap.put("string", String.class.getName());
        metaType2classNameMap.put("str", String.class.getName());
        metaType2classNameMap.put("text", String.class.getName());
        metaType2classNameMap.put("double", Double.class.getName());
        metaType2classNameMap.put("float", Float.class.getName());
        metaType2classNameMap.put("bigint", BigInteger.class.getName());
        metaType2classNameMap.put("biginteger", BigInteger.class.getName());
        metaType2classNameMap.put("bigdec", BigDecimal.class.getName());
        metaType2classNameMap.put("bigdecimal", BigDecimal.class.getName());
        metaType2classNameMap.put("blob", Blob.class.getName());
        metaType2classNameMap.put("clob", Clob.class.getName());
        metaType2classNameMap.put("bytes", Byte[].class.getName());
        metaType2classNameMap.put("bytearr", Byte[].class.getName());
        metaType2classNameMap.put("bytearray", Byte[].class.getName());
        className2metaTypeMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : metaType2classNameMap.entrySet()) {
            String value = entry.getValue();
            if (className2metaTypeMap.containsKey(value)) continue;
            className2metaTypeMap.put(value, entry.getKey());
        }
    }

    public TablePojoConverter() {
    }

    public TablePojoConverter(ModelProperty modelProperty, Artifacts artifacts, String suffix, Set<String> finalEntities, Annotations annotations, List<String> dbSequences, DbResolver.DbType dbType) {
        Map pojosForProcedures;
        Set preserveForeignKeys;
        Map notVersionColumns;
        Set generateMethods;
        Map inheritanceColumns;
        Map inheritance;
        Map manyToManyImports;
        Map inheritImports;
        Map createImports;
        Map createExports;
        Map ignoreImports;
        Map ignoreExports;
        Map createColumns;
        Map notRequiredColumns;
        Map requiredColumns;
        Map ignoreColumns;
        Set onlyTables;
        Set ignoreTables;
        Map columnNames;
        Map tableNames;
        Map functionTypes;
        Map procedureTypes;
        Map columnTypes;
        Map tableTypes;
        Map sqlTypes;
        this.debug = modelProperty.getDebugLevel((EObject)artifacts) != null && modelProperty.getDebugLevel((EObject)artifacts).isGreaterOrEqual((Priority)Level.DEBUG);
        this.suffix = suffix != null ? suffix : "";
        this.finalEntities = finalEntities;
        this.annotations = annotations;
        if (annotations != null) {
            this.imports = annotations.getImports();
        }
        if ((sqlTypes = modelProperty.getSqlTypes((EObject)artifacts)) != null) {
            this.sqlTypes.putAll(sqlTypes);
        }
        if ((tableTypes = modelProperty.getTableTypes((EObject)artifacts)) != null) {
            this.tableTypes.putAll(tableTypes);
        }
        if ((columnTypes = modelProperty.getColumnTypes((EObject)artifacts)) != null) {
            this.columnTypes.putAll(columnTypes);
        }
        if ((procedureTypes = modelProperty.getProcedureTypes((EObject)artifacts)) != null) {
            this.procedureTypes.putAll(procedureTypes);
        }
        if ((functionTypes = modelProperty.getFunctionTypes((EObject)artifacts)) != null) {
            this.functionTypes.putAll(functionTypes);
        }
        if ((tableNames = modelProperty.getTableNames((EObject)artifacts)) != null) {
            this.tableNames.putAll(tableNames);
        }
        if ((columnNames = modelProperty.getColumnNames((EObject)artifacts)) != null) {
            this.columnNames.putAll(columnNames);
        }
        if ((ignoreTables = modelProperty.getIgnoreTables((EObject)artifacts)) != null) {
            this.ignoreTables.addAll(ignoreTables);
        }
        if ((onlyTables = modelProperty.getOnlyTables((EObject)artifacts)) != null) {
            this.onlyTables.addAll(onlyTables);
        }
        Set notAbstractTables = modelProperty.getNotAbstractTables((EObject)artifacts);
        if (onlyTables != null) {
            this.notAbstractTables.addAll(notAbstractTables);
        }
        if ((ignoreColumns = modelProperty.getIgnoreColumns((EObject)artifacts)) != null) {
            this.ignoreColumns.putAll(ignoreColumns);
        }
        if ((requiredColumns = modelProperty.getRequiredColumns((EObject)artifacts)) != null) {
            this.requiredColumns.putAll(requiredColumns);
        }
        if ((notRequiredColumns = modelProperty.getNotRequiredColumns((EObject)artifacts)) != null) {
            this.notRequiredColumns.putAll(notRequiredColumns);
        }
        if ((createColumns = modelProperty.getCreateColumns((EObject)artifacts)) != null) {
            this.createColumns.putAll(createColumns);
        }
        if ((ignoreExports = modelProperty.getIgnoreExports((EObject)artifacts)) != null) {
            this.ignoreExports.putAll(ignoreExports);
        }
        if ((ignoreImports = modelProperty.getIgnoreImports((EObject)artifacts)) != null) {
            this.ignoreImports.putAll(ignoreImports);
        }
        if ((createExports = modelProperty.getCreateExports((EObject)artifacts)) != null) {
            this.createExports.putAll(createExports);
        }
        if ((createImports = modelProperty.getCreateImports((EObject)artifacts)) != null) {
            this.createImports.putAll(createImports);
        }
        if ((inheritImports = modelProperty.getInheritImports((EObject)artifacts)) != null) {
            this.inheritImports.putAll(inheritImports);
        }
        if ((manyToManyImports = modelProperty.getManyToManyImports((EObject)artifacts)) != null) {
            this.manyToManyImports.putAll(manyToManyImports);
        }
        if ((inheritance = modelProperty.getInheritance((EObject)artifacts)) != null) {
            this.inheritance.putAll(inheritance);
        }
        if ((inheritanceColumns = modelProperty.getInheritanceColumns((EObject)artifacts)) != null) {
            this.inheritanceColumns.putAll(inheritanceColumns);
        }
        if ((generateMethods = modelProperty.getGenerateMethods((EObject)artifacts)) != null) {
            this.generateMethods.addAll(generateMethods);
        }
        this.generateOperators = modelProperty.getGenerateOperators((EObject)artifacts);
        Map toImplements = modelProperty.getToImplements((EObject)artifacts);
        if (toImplements != null) {
            this.toImplements.putAll(toImplements);
        }
        this.toExtends = modelProperty.getToExtends((EObject)artifacts);
        Map joinTables = modelProperty.getJoinTables((EObject)artifacts);
        if (joinTables != null) {
            this.joinTables.putAll(joinTables);
        }
        this.doGenerateWrappers = modelProperty.isDoGenerateWrappers((EObject)artifacts);
        this.doGenerateValidationAnnotations = modelProperty.isDoGenerateValidationAnnotations((EObject)artifacts);
        this.implementationPackage = modelProperty.getImplementationPackage((EObject)artifacts);
        this.makeItFinal = modelProperty.isMakeItFinal((EObject)artifacts);
        this.versionColumn = modelProperty.getVersionColumn((EObject)artifacts);
        Map versionColumns = modelProperty.getVersionColumns((EObject)artifacts);
        if (versionColumns != null) {
            this.versionColumns.putAll(versionColumns);
        }
        if ((notVersionColumns = modelProperty.getNotVersionColumns((EObject)artifacts)) != null) {
            this.notVersionColumns.putAll(notVersionColumns);
        }
        if ((preserveForeignKeys = modelProperty.getPreserveForeignKeys((EObject)artifacts)) != null) {
            this.preserveForeignKeys.addAll(preserveForeignKeys);
        }
        if ((pojosForProcedures = modelProperty.getPojosForProcedures((EObject)artifacts)) != null) {
            this.pojosForProcedures.putAll(pojosForProcedures);
        }
        Map pojosForFunctions = modelProperty.getPojosForFunctions((EObject)artifacts);
        if (pojosForProcedures != null) {
            this.pojosForFunctions.putAll(pojosForFunctions);
        }
        for (Map.Entry<String, Map<String, Map<String, String>>> inheritImport : this.inheritImports.entrySet()) {
            for (Map.Entry<String, Map<String, String>> inherit : inheritImport.getValue().entrySet()) {
                for (Map.Entry<String, String> tabcol : inherit.getValue().entrySet()) {
                    if (!this.ignoreExports.containsKey(tabcol.getKey())) {
                        this.ignoreExports.put(tabcol.getKey(), new HashMap());
                    }
                    if (!this.ignoreExports.get(tabcol.getKey()).containsKey(tabcol.getValue())) {
                        this.ignoreExports.get(tabcol.getKey()).put(tabcol.getValue(), new HashMap());
                    }
                    this.ignoreExports.get(tabcol.getKey()).get(tabcol.getValue()).put(inheritImport.getKey(), null);
                    if (!this.ignoreColumns.containsKey(inheritImport.getKey())) {
                        this.ignoreColumns.put(inheritImport.getKey(), new HashSet());
                    }
                    this.ignoreColumns.get(inheritImport.getKey()).add(inherit.getKey());
                }
            }
        }
        this.dbSequences.addAll(dbSequences);
        this.dbType = dbType;
        Map metaFunctionsResult = modelProperty.getMetaFunctionsResult((EObject)artifacts);
        if (metaFunctionsResult != null) {
            this.metaFunctionsResult.putAll(metaFunctionsResult);
        }
        if (this.doGenerateValidationAnnotations) {
            if (this.imports == null) {
                this.imports = new HashSet<String>();
            }
            this.imports.add(ANNOTATION_NOT_NULL);
            this.imports.add(ANNOTATION_SIZE);
        }
        if (this.debug) {
            System.out.println("finalEntities " + this.finalEntities);
            System.out.println("annotations " + this.annotations);
            System.out.println("sqlTypes " + this.sqlTypes);
            System.out.println("tableTypes " + this.tableTypes);
            System.out.println("columnTypes " + this.columnTypes);
            System.out.println("procedureTypes " + this.procedureTypes);
            System.out.println("functionTypes " + this.functionTypes);
            System.out.println("tableNames " + this.tableNames);
            System.out.println("columnNames " + this.columnNames);
            System.out.println("ignoreTables " + this.ignoreTables);
            System.out.println("onlyTables " + this.onlyTables);
            System.out.println("ignoreColumns " + this.ignoreColumns);
            System.out.println("createColumns " + this.createColumns);
            System.out.println("ignoreExports " + this.ignoreExports);
            System.out.println("ignoreImports " + this.ignoreImports);
            System.out.println("createExports " + this.createExports);
            System.out.println("createImports " + this.createImports);
            System.out.println("inheritImports " + this.inheritImports);
            System.out.println("manyToManyImports " + this.manyToManyImports);
            System.out.println("inheritance " + this.inheritance);
            System.out.println("inheritanceColumns " + this.inheritanceColumns);
            System.out.println("generateMethods " + this.generateMethods);
            System.out.println("generateOperators " + this.generateOperators);
            System.out.println("toImplements " + this.toImplements);
            System.out.println("toExtends " + this.toExtends);
            System.out.println("joinTables " + this.joinTables);
            System.out.println("doGenerateWrappers " + this.doGenerateWrappers);
            System.out.println("doGenerateValidationAnnotations " + this.doGenerateValidationAnnotations);
            System.out.println("implementationPackage " + this.implementationPackage);
            System.out.println("makeItFinal " + this.makeItFinal);
            System.out.println("versionColumn " + this.versionColumn);
            System.out.println("versionColumns " + this.versionColumns);
            System.out.println("notVersionColumns " + this.notVersionColumns);
            System.out.println("sequences " + this.dbSequences);
            System.out.println("dbType " + this.dbType);
            System.out.println("metaFunctionsResult " + this.metaFunctionsResult);
            System.out.println("preserveForeignKeys " + this.preserveForeignKeys);
            System.out.println("pojosForProcedures " + this.pojosForProcedures);
            System.out.println("pojosForFunctions " + this.pojosForFunctions);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addTableDefinition(String table, List<DbColumn> dbColumns, List<String> dbPrimaryKeys, List<DbExport> dbExports, List<DbImport> dbImports, List<DbIndex> dbIndexes, List<DbCheckConstraint> dbCheckConstraints, String comment) {
        void var10_41;
        PojoAttribute attr;
        void var10_39;
        PojoAttribute attribute;
        if (this.debug) {
            System.out.println("addTableDefinition: " + table + " dbColumns " + dbColumns);
            System.out.println("addTableDefinition: " + table + " dbPrimaryKeys " + dbPrimaryKeys);
            System.out.println("addTableDefinition: " + table + " dbExports " + dbExports);
            System.out.println("addTableDefinition: " + table + " dbImports " + dbImports);
            System.out.println("addTableDefinition: " + table + " dbIndexes " + dbIndexes);
            System.out.println("addTableDefinition: " + table + " dbCheckConstraints " + dbCheckConstraints);
        }
        if (table == null || dbColumns == null) {
            return;
        }
        LinkedHashMap<String, PojoAttribute> attributes = new LinkedHashMap<String, PojoAttribute>();
        for (DbColumn dbColumn : dbColumns) {
            void var12_42;
            PojoAttribute pojoAttribute = this.convertDbColumnDefinition(table, dbColumn, this.columnTypes);
            if (pojoAttribute != null) {
                attributes.put(dbColumn.getName(), pojoAttribute);
            } else {
                PojoAttribute pojoAttribute2 = this.convertDbColumnDefault(table, dbColumn);
                if (pojoAttribute2 != null) {
                    attributes.put(dbColumn.getName(), pojoAttribute2);
                }
            }
            if (dbPrimaryKeys.contains(dbColumn.getName())) {
                var12_42.setPrimaryKey(true);
            }
            if (dbColumn.getName().equalsIgnoreCase(this.versionColumn) && !this.notVersionColumns.containsKey(table) && this.versionColumns.isEmpty()) {
                var12_42.setVersion(true);
            }
            if (!this.versionColumns.containsKey(table) || !dbColumn.getName().equals(this.versionColumns.get(table))) continue;
            var12_42.setVersion(true);
        }
        if (this.createColumns.containsKey(table)) {
            for (Map.Entry<String, PojoAttrType> entry : this.createColumns.get(table).entrySet()) {
                PojoAttribute pojoAttribute = this.convertDbColumnDefinition(entry.getKey(), entry.getValue());
                attributes.put(entry.getKey(), pojoAttribute);
            }
        }
        this.pojos.put(table, attributes);
        if (comment != null) {
            this.comments.put(table, comment);
        }
        for (DbImport dbImport : dbImports) {
            if (this.ignoreImports.containsKey(table) && (this.ignoreImports.get(table) == null || this.ignoreImports.get(table).containsKey(dbImport.getFkColumn()) && this.ignoreImports.get(table).get(dbImport.getFkColumn()).containsKey(dbImport.getPkTable()))) continue;
            if (this.manyToManyImports.containsKey(table)) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbImport.getFkColumn());
                pojoAttribute.setM2mTable(dbImport.getPkTable());
                pojoAttribute.setPkColumn(dbImport.getPkColumn());
                continue;
            }
            if (this.inheritImports.containsKey(table) && this.inheritImports.get(table).containsKey(dbImport.getFkColumn()) && this.inheritImports.get(table).get(dbImport.getFkColumn()).containsKey(dbImport.getPkTable())) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbImport.getFkColumn());
                pojoAttribute.setParentTable(dbImport.getPkTable());
                pojoAttribute.setPkColumn(dbImport.getPkColumn());
                continue;
            }
            PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbImport.getFkColumn());
            pojoAttribute.setPkTable(dbImport.getPkTable());
            pojoAttribute.setPkColumn(dbImport.getPkColumn());
        }
        if (this.createImports.containsKey(table)) {
            for (Map.Entry<String, Map<String, String>> entry : this.createImports.get(table).entrySet()) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(entry.getKey());
                for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                    pojoAttribute.setPkTable(entry2.getKey());
                    pojoAttribute.setPkColumn(entry2.getValue());
                }
            }
        }
        for (DbExport dbExport : dbExports) {
            String string;
            if (this.ignoreExports.containsKey(table) && this.ignoreExports.get(table).containsKey(dbExport.getPkColumn()) && this.ignoreExports.get(table).get(dbExport.getPkColumn()).containsKey(dbExport.getFkTable()) && ((string = this.ignoreExports.get(table).get(dbExport.getPkColumn()).get(dbExport.getFkTable())) == null || string.length() == 0 || string.equals(dbExport.getFkColumn()))) continue;
            if (this.manyToManyImports.containsKey(dbExport.getFkTable())) {
                if (!this.manyToManyImports.get(dbExport.getFkTable()).containsKey(dbExport.getPkColumn())) continue;
                for (Map.Entry<String, String> entry : this.manyToManyImports.get(dbExport.getFkTable()).get(dbExport.getPkColumn()).entrySet()) {
                    String fkTable = entry.getKey();
                    String fkColumn2 = entry.getValue();
                    if (dbExport.getPkTable().equals(fkTable)) continue;
                    attribute = (PojoAttribute)attributes.get(dbExport.getPkColumn());
                    attribute.getFkTables().put(fkTable, fkColumn2);
                    attribute.getM2Tables().put(fkTable, dbExport.getFkTable());
                }
                continue;
            }
            PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbExport.getPkColumn());
            pojoAttribute.getFkTables().put(dbExport.getFkTable(), null);
            if (!pojoAttribute.getFkColumns().containsKey(dbExport.getFkTable())) {
                pojoAttribute.getFkColumns().put(dbExport.getFkTable(), new ArrayList());
            }
            ((List)pojoAttribute.getFkColumns().get(dbExport.getFkTable())).add(dbExport.getFkColumn());
        }
        if (this.createExports.containsKey(table)) {
            for (Map.Entry<String, Map<String, String>> entry : this.createExports.get(table).entrySet()) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(entry.getKey());
                for (Map.Entry<String, String> entry3 : entry.getValue().entrySet()) {
                    pojoAttribute.getFkTables().put(entry3.getKey(), null);
                    if (!pojoAttribute.getFkColumns().containsKey(entry3.getKey())) {
                        pojoAttribute.getFkColumns().put(entry3.getKey(), new ArrayList());
                    }
                    ((List)pojoAttribute.getFkColumns().get(entry3.getKey())).add(entry3.getValue());
                }
            }
        }
        if (this.inheritance.containsKey(table)) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Map.Entry<String, Map<String, List<String>>> entry : this.inheritance.get(table).entrySet()) {
                String string = entry.getKey();
                LinkedHashMap<String, PojoAttribute> inheritedAttributes = new LinkedHashMap<String, PojoAttribute>();
                attribute = entry.getValue().entrySet().iterator();
                if (!attribute.hasNext()) continue;
                Map.Entry<String, List<String>> tabcols = attribute.next();
                String inheritedTable = tabcols.getKey();
                for (String dbColumn : tabcols.getValue()) {
                    if (!attributes.containsKey(dbColumn)) continue;
                    inheritedAttributes.put(dbColumn, (PojoAttribute)attributes.get(dbColumn));
                }
                linkedHashMap.putAll(inheritedAttributes);
                this.pojos.put(inheritedTable, inheritedAttributes);
                this.pojoDiscriminators.put(inheritedTable, string);
                this.pojoExtends.put(inheritedTable, table);
            }
            for (String string : linkedHashMap.keySet()) {
                attributes.remove(string);
            }
            this.pojoInheritanceDiscriminator.put(table, new LinkedHashSet());
        }
        boolean bl = false;
        int n = dbIndexes.size();
        while (var10_39 < n) {
            void var13_76;
            DbIndex dbIndex = dbIndexes.get((int)var10_39);
            List<Map<PojoAttribute, Boolean>> list = this.indexes.get(table);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                this.indexes.put(table, arrayList);
            }
            LinkedHashMap<PojoAttribute, Boolean> list2 = new LinkedHashMap<PojoAttribute, Boolean>();
            var13_76.add(list2);
            int ii = 0;
            int ll = dbIndex.getColumns().size();
            while (ii < ll) {
                DbIndex.DbIndexDetail dbIndexDetail = (DbIndex.DbIndexDetail)dbIndex.getColumns().get(ii);
                if (dbIndexDetail == null) {
                    System.out.println("Missing index in " + dbIndex);
                } else {
                    attr = (PojoAttribute)attributes.get(dbIndexDetail.getColname());
                    if (attr == null) {
                        System.out.println("Missing attibute for " + dbIndex);
                    } else {
                        list2.put(attr, dbIndexDetail.isDesc());
                        if (ll == 1) {
                            attr.setIndex(Integer.valueOf((int)(var10_39 + true)));
                        }
                    }
                }
                ++ii;
            }
            ++var10_39;
        }
        boolean bl2 = false;
        int n2 = dbCheckConstraints.size();
        while (var10_41 < n2) {
            PojoAttribute pojoAttribute;
            DbCheckConstraint dbCheckConstraint = dbCheckConstraints.get((int)var10_41);
            PojoAttribute pojoAttribute3 = pojoAttribute = this.pojos.containsKey(dbCheckConstraint.getTable()) && this.pojos.get(dbCheckConstraint.getTable()).containsKey(dbCheckConstraint.getColumn()) ? this.pojos.get(dbCheckConstraint.getTable()).get(dbCheckConstraint.getColumn()) : null;
            if (pojoAttribute == null) {
                System.out.println("For the constraint " + dbCheckConstraint.getEnumName() + " there's no table or column");
            } else {
                pojoAttribute.setDependencyClassName(this.tableToCamelCase(dbCheckConstraint.getEnumName()));
                pojoAttribute.setDependencyClassNameIsEnum(true);
                ArrayList<Object> attrs = new ArrayList<Object>();
                this.enums.put(dbCheckConstraint.getEnumName(), attrs);
                EnumAttribute pattr = new EnumAttribute();
                pattr.setName("VALUE");
                pattr.setClassName(pojoAttribute.getClassName());
                attrs.add(pattr);
                for (String val : dbCheckConstraint.getValues()) {
                    attr = new EnumAttribute();
                    attr.setClassName(pojoAttribute.getClassName());
                    if (pojoAttribute.isString()) {
                        attr.setStrValue(val);
                        if (val.isEmpty()) continue;
                        if (Character.isDigit(val.charAt(0))) {
                            attr.setName("I" + val);
                        } else {
                            attr.setName(val);
                        }
                    } else {
                        attr.setIntValue(val);
                        attr.setName("I" + val);
                    }
                    attrs.add(attr);
                }
            }
            ++var10_41;
        }
    }

    public void joinTables() {
        for (String table : this.joinTables.keySet()) {
            if (!this.pojos.containsKey(table)) continue;
            Stack<String> stack = new Stack<String>();
            stack.push(table);
            for (String table1 : this.joinTables.get(table)) {
                if (!this.pojos.containsKey(table1)) break;
                stack.push(table1);
            }
            if (stack.size() != this.joinTables.get(table).size() + 1) continue;
            String table0 = (String)stack.pop();
            HashSet<String> allAttributes = new HashSet<String>();
            allAttributes.addAll(this.pojos.get(table0).keySet());
            if (this.tableNames.containsKey(table0)) {
                table0 = this.tableNames.get(table0);
            }
            while (stack.size() > 0) {
                String table1 = (String)stack.pop();
                String newTable = String.valueOf(this.tableNames.containsKey(table1) ? this.tableNames.get(table1) : table1) + "_" + table0;
                LinkedHashMap<String, PojoAttribute> newAttributes = new LinkedHashMap<String, PojoAttribute>();
                for (Map.Entry<String, PojoAttribute> attr : this.pojos.get(table1).entrySet()) {
                    if (allAttributes.contains(attr.getKey())) continue;
                    newAttributes.put(attr.getKey(), attr.getValue());
                    allAttributes.add(attr.getKey());
                }
                this.pojos.put(newTable, newAttributes);
                this.pojoExtends.put(newTable, table0);
                if (!this.onlyTables.isEmpty()) {
                    this.onlyTables.add(newTable);
                }
                table0 = newTable;
            }
        }
    }

    protected String getTableName(String name) {
        String realName = this.tableNames.get(name);
        return realName != null ? realName : name;
    }

    public void resolveReferencesOnKeys() {
        for (String string : this.pojos.keySet()) {
            HashMap<String, PojoAttribute> newAttributes = new HashMap<String, PojoAttribute>();
            for (Map.Entry<String, PojoAttribute> entry : this.pojos.get(string).entrySet()) {
                PojoAttribute attribute = entry.getValue();
                if (attribute.getPkTable() != null && this.pojos.containsKey(attribute.getPkTable())) {
                    attribute.setDependencyClassName(this.tableToCamelCase(this.getTableName(attribute.getPkTable())));
                    attribute.setRef(attribute.getPkTable());
                    if (attribute.getName().length() >= 3) {
                        if (attribute.getName().startsWith("id")) {
                            attribute.setName(this.lowerFirstChar(attribute.getName().substring(2)));
                        } else if (attribute.getName().endsWith("Id")) {
                            attribute.setName(attribute.getName().substring(0, attribute.getName().length() - 2));
                        }
                    }
                }
                if (attribute.getParentTable() != null && this.pojos.containsKey(attribute.getParentTable())) {
                    this.pojoExtends.put(string, attribute.getParentTable());
                    this.pojoInheritanceSimple.put(attribute.getParentTable(), new LinkedHashSet());
                }
                for (Map.Entry fk : attribute.getFkTables().entrySet()) {
                    if (!this.pojos.containsKey(fk.getKey())) continue;
                    if (attribute.getFkColumns().containsKey(fk.getKey()) && ((List)attribute.getFkColumns().get(fk.getKey())).size() > 1) {
                        for (String fkColumn : (List)attribute.getFkColumns().get(fk.getKey())) {
                            PojoAttribute attrib = new PojoAttribute(null);
                            attrib.setName(this.collectionName((String)fk.getKey(), fkColumn));
                            attrib.setOneToManyColumn(entry.getKey());
                            attrib.setOneToManyOppositeColumn(fkColumn);
                            attrib.setOneToManyTable((String)fk.getKey());
                            attrib.setClassName("java.util.List <:" + this.tableToCamelCase(this.getTableName((String)fk.getKey())) + ">");
                            attrib.setRef((String)fk.getKey());
                            String dbColumnName = this.columnToDbConv(attrib.getName());
                            newAttributes.put(dbColumnName, attrib);
                        }
                    }
                    String referName = null;
                    if (fk.getValue() != null) {
                        referName = this.columnToCamelCase((String)fk.getValue());
                    } else {
                        if (attribute.getFkColumns().containsKey(fk.getKey()) && ((List)attribute.getFkColumns().get(fk.getKey())).size() > 1) continue;
                        referName = this.collectionName((String)fk.getKey(), null);
                    }
                    PojoAttribute attrib = new PojoAttribute(null);
                    attrib.setName(referName);
                    if (attribute.getM2Tables().containsKey(fk.getKey())) {
                        attrib.setManyToManyColumn(entry.getKey());
                        attrib.setManyToManyTable((String)fk.getKey());
                    } else if (attribute.getFkColumns().containsKey(fk.getKey())) {
                        attrib.setOneToManyColumn(entry.getKey());
                        attrib.setOneToManyOppositeColumn((String)((List)attribute.getFkColumns().get(fk.getKey())).get(0));
                        attrib.setOneToManyTable((String)fk.getKey());
                    }
                    attrib.setClassName("java.util.List <:" + this.tableToCamelCase(this.getTableName((String)fk.getKey())) + ">");
                    attrib.setRef((String)fk.getKey());
                    String dbColumnName = this.columnToDbConv(attrib.getName());
                    newAttributes.put(dbColumnName, attrib);
                }
            }
            if (newAttributes.isEmpty()) continue;
            this.pojos.get(string).putAll(newAttributes);
        }
        for (Map.Entry entry : this.pojoExtends.entrySet()) {
            if (this.pojoInheritanceDiscriminator.containsKey(entry.getValue())) {
                this.pojoInheritanceDiscriminator.get(entry.getValue()).add((String)entry.getKey());
                continue;
            }
            if (!this.pojoInheritanceSimple.containsKey(entry.getValue())) continue;
            this.pojoInheritanceSimple.get(entry.getValue()).add((String)entry.getKey());
        }
    }

    public void addProcedureDefinition(String procedure, DbTable dbProcedure, List<DbColumn> dbProcColumns, boolean isFunction, String comment) {
        PojoAttribute attribute;
        if (this.debug) {
            System.out.println("addProcedureDefinition: " + procedure + " dbProcedure " + dbProcedure);
            System.out.println("addProcedureDefinition: " + procedure + " dbProcColumns " + dbProcColumns);
        }
        if (procedure == null || dbProcColumns == null) {
            return;
        }
        LinkedHashMap<String, PojoAttribute> attributes = new LinkedHashMap<String, PojoAttribute>();
        int ix = 0;
        for (DbColumn dbColumn : dbProcColumns) {
            String metaType;
            ++ix;
            if (dbColumn.getColumnType() == 5 && (dbColumn.getName() == null || dbColumn.getName().trim().length() == 0 || dbColumn.getName().equalsIgnoreCase("returnValue") || dbColumn.getName().equalsIgnoreCase(FAKE_FUN_PROC_COLUMN_NAME) || dbColumn.getName().equalsIgnoreCase("null"))) {
                dbColumn.setName(FAKE_FUN_PROC_COLUMN_NAME);
            }
            if (this.dbType == DbResolver.DbType.INFORMIX && ix == 1 && isFunction && !FAKE_FUN_PROC_COLUMN_NAME.equals(dbColumn.getName())) continue;
            attribute = this.convertDbColumnDefinition(procedure, dbColumn, this.procedureTypes);
            if (attribute != null) {
                attributes.put(dbColumn.getName(), attribute);
            } else {
                attribute = this.convertDbColumnDefault(procedure, dbColumn);
                if (attribute != null) {
                    attributes.put(dbColumn.getName(), attribute);
                }
            }
            if (attribute != null) {
                attribute.setFunProcType(Short.valueOf(dbProcedure.getFtype()));
                attribute.setFunProcColumnType(Short.valueOf(dbColumn.getColumnType()));
            }
            if (!FAKE_FUN_PROC_COLUMN_NAME.equals(dbColumn.getName()) || !isFunction || attribute.getClassName() == null || (metaType = this.className2metaType(attribute.getClassName())) == null) continue;
            this.metaFunctionsResult.put(procedure, metaType);
        }
        if (this.createColumns.containsKey(procedure)) {
            for (Map.Entry entry : this.createColumns.get(procedure).entrySet()) {
                attribute = this.convertDbColumnDefinition((String)entry.getKey(), (PojoAttrType)entry.getValue());
                attributes.put((String)entry.getKey(), attribute);
                attribute.setFunProcType(Short.valueOf(dbProcedure.getFtype()));
                attribute.setFunProcColumnType(Short.valueOf((short)1));
            }
        }
        this.procedures.put(procedure, attributes);
        if (comment != null) {
            this.comments.put(procedure, comment);
        }
        if ((this.dbType == DbResolver.DbType.POSTGRESQL || this.dbType == DbResolver.DbType.INFORMIX) && isFunction) {
            this.functions.put(procedure, attributes);
        }
    }

    public void addFunctionDefinition(String function, DbTable dbFunction, List<DbColumn> dbFunColumns, String comment) {
        PojoAttribute attribute;
        if (this.debug) {
            System.out.println("addFunctionDefinition: " + function + " dbFunction " + dbFunction);
            System.out.println("addFunctionDefinition: " + function + " dbFunColumns " + dbFunColumns);
        }
        if (function == null || dbFunColumns == null) {
            return;
        }
        LinkedHashMap<String, PojoAttribute> attributes = new LinkedHashMap<String, PojoAttribute>();
        for (DbColumn dbColumn : dbFunColumns) {
            attribute = this.convertDbColumnDefinition(function, dbColumn, this.functionTypes);
            if (attribute != null) {
                attributes.put(dbColumn.getName(), attribute);
            } else {
                attribute = this.convertDbColumnDefault(function, dbColumn);
                if (attribute != null) {
                    attributes.put(dbColumn.getName(), attribute);
                }
            }
            if (attribute == null) continue;
            attribute.setFunProcType(Short.valueOf(dbFunction.getFtype()));
            attribute.setFunProcColumnType(Short.valueOf(dbColumn.getColumnType()));
        }
        if (this.createColumns.containsKey(function)) {
            for (Map.Entry entry : this.createColumns.get(function).entrySet()) {
                attribute = this.convertDbColumnDefinition((String)entry.getKey(), (PojoAttrType)entry.getValue());
                attributes.put((String)entry.getKey(), attribute);
                attribute.setFunProcType(Short.valueOf(dbFunction.getFtype()));
                attribute.setFunProcColumnType(Short.valueOf((short)1));
            }
        }
        if (this.dbType == DbResolver.DbType.DB2 && this.metaFunctionsResult.containsKey(function)) {
            PojoAttribute pojoAttribute = this.convertDbColumnDefinition(FUN_PROC_COLUMN_NAME, this.metaFunctionsResult.get(function));
            attributes.put(FUN_PROC_COLUMN_NAME, pojoAttribute);
            pojoAttribute.setFunProcType(Short.valueOf(dbFunction.getFtype()));
            pojoAttribute.setFunProcColumnType(Short.valueOf((short)5));
        }
        this.functions.put(function, attributes);
        if (comment != null) {
            this.comments.put(function, comment);
        }
    }

    protected String collectionName(String fkTable, String fkColumn) {
        String referName;
        String string = referName = fkColumn == null ? this.lowerFirstChar(this.tableToCamelCase(fkTable)) : this.tableToCamelCase(fkTable);
        if (!referName.endsWith("s")) {
            if (referName.endsWith("y")) {
                referName = referName.substring(0, referName.length() - 1);
                referName = String.valueOf(referName) + "ies";
            } else {
                referName = String.valueOf(referName) + "s";
            }
        }
        if (fkColumn != null) {
            referName = String.valueOf(this.lowerFirstChar(this.tableToCamelCase(fkColumn))) + referName;
        }
        return referName;
    }

    protected String lowerFirstChar(String s) {
        if (s == null) {
            return null;
        }
        String ss = s.substring(0, 1).toLowerCase();
        if (s.length() == 1) {
            return ss;
        }
        ss = String.valueOf(ss) + s.substring(1);
        return ss;
    }

    public void resolveReferencesOnConvention() {
        for (String pojo : this.pojos.keySet()) {
            for (PojoAttribute attribute : this.pojos.get(pojo).values()) {
                Map<String, PojoAttribute> referPojoAttr;
                String className;
                if (!attribute.getName().startsWith("id") || attribute.getName().length() <= 2 || pojo.equals(className = attribute.getName().substring(2)) || (referPojoAttr = this.pojos.get(className)) == null) continue;
                String name = className.substring(0, 1).toLowerCase();
                if (className.length() > 1) {
                    name = String.valueOf(name) + className.substring(1);
                }
                attribute.setName(name);
                attribute.setPrimitive(false);
                attribute.setDependencyClassName(className);
                String referName = pojo.substring(0, 1).toLowerCase();
                if (className.length() > 1) {
                    referName = String.valueOf(referName) + pojo.substring(1);
                }
                PojoAttribute attrib = new PojoAttribute(null);
                attrib.setName(String.valueOf(referName) + "s");
                attrib.setClassName("java.util.List <:" + pojo + ">");
                referPojoAttr.put(attrib.getName(), attrib);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getPojoDefinitions() {
        try {
            String pojoName;
            if (this.debug) {
                System.out.println("pojos " + this.pojos);
                System.out.println("pojoExtends " + this.pojoExtends);
                System.out.println("pojoInheritanceDiscriminator " + this.pojoInheritanceDiscriminator);
                System.out.println("pojoInheritanceSimple " + this.pojoInheritanceSimple);
                System.out.println("pojoDiscriminators " + this.pojoDiscriminators);
                System.out.println("indexes " + this.indexes);
                System.out.println("procedures " + this.procedures);
                System.out.println("functions " + this.functions);
                System.out.println("enums " + this.enums);
            }
            StringBuilder buffer = new StringBuilder();
            boolean isSerializable = false;
            HashSet<String> serializables = new HashSet<String>();
            boolean oneMoreLine = false;
            if (!this.toImplements.isEmpty()) {
                for (ImplementsExtends implementsExtends : this.toImplements.values()) {
                    String realPojoName;
                    JvmType type = implementsExtends.getToImplement();
                    if (type.getIdentifier().endsWith("Serializable")) {
                        if (!implementsExtends.getDbTables().isEmpty()) {
                            for (String dbTable : implementsExtends.getDbTables()) {
                                serializables.add(dbTable);
                            }
                            continue;
                        }
                        if (!implementsExtends.getDbNotTables().isEmpty()) {
                            for (String pojo : this.pojos.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String pojo : this.enums.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String pojo : this.procedures.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String pojo : this.functions.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String dbTable : implementsExtends.getDbNotTables()) {
                                serializables.remove(dbTable);
                            }
                            continue;
                        }
                        isSerializable = true;
                        continue;
                    }
                    buffer.append(NLINDENT).append("implements ").append(type.getIdentifier());
                    if (implementsExtends.isGenerics()) {
                        buffer.append(" <<>>");
                    }
                    if (!implementsExtends.getDbTables().isEmpty()) {
                        buffer.append(" onlyPojos");
                        for (String dbTable : implementsExtends.getDbTables()) {
                            void var10_31;
                            String string = this.tableNames.get(dbTable);
                            if (string == null) {
                                String string2 = dbTable;
                            }
                            realPojoName = this.tableToCamelCase((String)var10_31);
                            buffer.append(" ").append(realPojoName);
                        }
                    }
                    if (implementsExtends.getDbNotTables().isEmpty()) continue;
                    buffer.append(" exceptPojos");
                    for (String dbTable : implementsExtends.getDbNotTables()) {
                        void var10_34;
                        String string = this.tableNames.get(dbTable);
                        if (string == null) {
                            String string3 = dbTable;
                        }
                        realPojoName = this.tableToCamelCase((String)var10_34);
                        buffer.append(" ").append(realPojoName);
                    }
                }
                oneMoreLine = true;
            }
            if (this.toExtends != null) {
                String realPojoName;
                JvmType jvmType = this.toExtends.getToImplement();
                buffer.append(NLINDENT).append("extends ").append(jvmType.getIdentifier());
                if (this.toExtends.isGenerics()) {
                    buffer.append(" <<>>");
                }
                if (!this.toExtends.getDbTables().isEmpty()) {
                    buffer.append(" onlyPojos");
                    for (String dbTable : this.toExtends.getDbTables()) {
                        pojoName = this.tableNames.get(dbTable);
                        if (pojoName == null) {
                            pojoName = dbTable;
                        }
                        realPojoName = this.tableToCamelCase(pojoName);
                        buffer.append(" ").append(realPojoName);
                    }
                }
                if (!this.toExtends.getDbNotTables().isEmpty()) {
                    buffer.append(" exceptPojos");
                    for (String dbTable : this.toExtends.getDbNotTables()) {
                        pojoName = this.tableNames.get(dbTable);
                        if (pojoName == null) {
                            pojoName = dbTable;
                        }
                        realPojoName = this.tableToCamelCase(pojoName);
                        buffer.append(" ").append(realPojoName);
                    }
                }
                oneMoreLine = true;
            }
            if (this.implementationPackage != null) {
                buffer.append(NLINDENT).append("implementation-package ").append(this.implementationPackage);
                oneMoreLine = true;
            }
            if (oneMoreLine) {
                buffer.append("\n");
            }
            if (this.imports != null) {
                for (String string : this.imports) {
                    buffer.append(INDENT).append("import ").append(string).append("\n");
                }
            }
            for (Map.Entry entry : this.enums.entrySet()) {
                String pojo = (String)entry.getKey();
                if (!this.onlyTables.isEmpty() && !this.onlyTables.contains(pojo) || this.ignoreTables.contains(pojo)) continue;
                pojoName = this.tableNames.get(pojo);
                if (pojoName == null) {
                    pojoName = pojo;
                }
                if (this.finalEntities.contains(this.tableToCamelCase(pojoName))) continue;
                this.printComment(buffer, this.comments.get(pojo), INDENT);
                buffer.append(NLINDENT);
                if (this.makeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("enum ");
                buffer.append(this.tableToCamelCase(pojoName));
                if (this.pojoExtends.containsKey(pojo)) {
                    buffer.append(" extends ").append(this.tableToCamelCase(this.pojoExtends.get(pojo)));
                }
                if (this.pojoDiscriminators.containsKey(pojo)) {
                    buffer.append(" discriminator ").append(this.pojoDiscriminators.get(pojo));
                }
                if (isSerializable || serializables.contains(pojo)) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" {");
                for (EnumAttribute attribute : (List)entry.getValue()) {
                    String name;
                    String string = name = this.columnNames.containsKey(pojo) ? this.columnNames.get(pojo).get(attribute.getName()) : null;
                    if (name == null) {
                        name = attribute.getName();
                    }
                    if (attribute.getIntValue() == null && attribute.getStrValue() == null) {
                        name = this.columnToCamelCase(name);
                    }
                    buffer.append(NLINDENT).append(INDENT).append(name).append(' ');
                    if (attribute.getIntValue() == null && attribute.getStrValue() == null) {
                        buffer.append(": ").append(attribute.getClassName());
                        continue;
                    }
                    if (attribute.getIntValue() != null) {
                        buffer.append("::: ").append(attribute.getIntValue());
                        continue;
                    }
                    if (attribute.getStrValue() == null) continue;
                    buffer.append("::: \"").append(attribute.getStrValue()).append("\"");
                }
                if (this.pojoExtends.containsKey(pojo)) {
                    this.getParentAttrs(this.pojoExtends.get(pojo), null, null);
                }
                buffer.append(NLINDENT).append("}\n");
            }
            for (String string : this.pojos.keySet()) {
                Iterator<Map.Entry<String, Object>> iterator;
                PojoAttribute attribute;
                if (!this.onlyTables.isEmpty() && !this.onlyTables.contains(string) || this.ignoreTables.contains(string)) continue;
                String pojoName3 = this.tableNames.get(string);
                if (pojoName3 == null) {
                    pojoName3 = string;
                }
                if (this.finalEntities.contains(this.tableToCamelCase(pojoName3))) continue;
                String realPojoName = this.tableToCamelCase(pojoName3);
                this.printComment(buffer, this.comments.get(string), INDENT);
                if (this.annotations != null) {
                    buffer.append((CharSequence)this.annotations.getEntityAnnotationsDefinitions(realPojoName, true));
                    buffer.append((CharSequence)this.annotations.getConstructorAnnotationsDefinitions(realPojoName, true));
                    buffer.append((CharSequence)this.annotations.getStaticAnnotationsDefinitions(realPojoName, true));
                    buffer.append((CharSequence)this.annotations.getConflictAnnotationsDefinitions(realPojoName, true));
                }
                buffer.append(NLINDENT);
                if (this.makeItFinal) {
                    buffer.append("final ");
                }
                if ((this.pojoInheritanceDiscriminator.containsKey(string) || this.pojoInheritanceSimple.containsKey(string)) && !this.notAbstractTables.contains(string)) {
                    buffer.append("abstract ");
                }
                buffer.append("pojo ");
                buffer.append(realPojoName);
                if (this.pojoExtends.containsKey(string)) {
                    buffer.append(" extends ").append(this.tableToCamelCase(this.pojoExtends.get(string)));
                }
                if (this.pojoDiscriminators.containsKey(string)) {
                    buffer.append(" discriminator ").append(this.pojoDiscriminators.get(string));
                }
                if (isSerializable || serializables.contains(string)) {
                    buffer.append(" serializable 1");
                }
                if (this.generateOperators != null) {
                    buffer.append(" operators");
                    if (!"operators".equals(this.generateOperators)) {
                        buffer.append(" ").append(this.generateOperators);
                    }
                }
                buffer.append(" {");
                HashSet<String> pkeys = new HashSet<String>();
                HashSet<String> hashSet = new HashSet<String>();
                Iterator<String> isDef = new HashSet();
                HashSet<String> toInit = new HashSet<String>();
                LinkedHashMap<String, PojoAttribute> addedAttributes = new LinkedHashMap<String, PojoAttribute>();
                for (Map.Entry<String, PojoAttribute> entry : this.pojos.get(string).entrySet()) {
                    if (this.ignoreColumns.containsKey(string) && this.ignoreColumns.get(string).contains(entry.getKey())) continue;
                    attribute = entry.getValue();
                    String name2 = this.columnNames.containsKey(string) ? this.columnNames.get(string).get(entry.getKey()) : null;
                    name2 = name2 == null ? attribute.getName() : this.columnToCamelCase(name2);
                    this.printComment(buffer, attribute.getComment(), INDENT, INDENT);
                    if (this.annotations != null) {
                        buffer.append((CharSequence)this.annotations.getAttributeAnnotationsDefinitions(realPojoName, name2, true));
                        buffer.append((CharSequence)this.annotations.getGetterAnnotationsDefinitions(realPojoName, name2, true));
                        buffer.append((CharSequence)this.annotations.getSetterAnnotationsDefinitions(realPojoName, name2, true));
                    }
                    if (this.doGenerateValidationAnnotations) {
                        if (!((!this.requiredColumns.containsKey(string) || !this.requiredColumns.get(string).contains(entry.getKey())) && (!attribute.isRequired() || attribute.isPrimaryKey()) || this.notRequiredColumns.containsKey(string) && this.notRequiredColumns.get(string).contains(entry.getKey()) || this.annotations != null && this.annotations.hasAttributeAnnotationsDefinitions(realPojoName, name2, ANNOTATION_NOT_NULL))) {
                            buffer.append(NLINDENT).append(INDENT).append("@NotNull");
                        }
                        if (!(attribute.getDependencyClassName() != null || attribute.isPrimitive() || !attribute.getClassName().equals("java.lang.String") || attribute.getSize() <= 0 || this.annotations != null && this.annotations.hasAttributeAnnotationsDefinitions(realPojoName, name2, ANNOTATION_SIZE))) {
                            buffer.append(NLINDENT).append(INDENT).append("@Size ::: max ").append(attribute.getSize());
                        }
                    }
                    buffer.append(NLINDENT).append(INDENT).append(name2).append(' ');
                    if (attribute.getDependencyClassName() != null) {
                        buffer.append(":: ").append(attribute.getDependencyClassName());
                        if (attribute.isDependencyClassNameIsEnum()) {
                            hashSet.add(name2);
                        }
                        if ((this.preserveForeignKeys.contains(string) || this.preserveForeignKeys.contains("_ALL_")) && attribute.getPkTable() != null) {
                            addedAttributes.put(name2, entry.getValue());
                            buffer.append(" updateCol ").append(this.columnToCamelCase(attribute.getPkColumn())).append("->").append(this.columnToCamelCase(attribute.getDbName()));
                        }
                    } else if (attribute.isPrimitive()) {
                        buffer.append('_').append(attribute.getClassName());
                        hashSet.add(name2);
                    } else {
                        buffer.append(": ").append(attribute.getClassName());
                        if (!attribute.getClassName().startsWith(COLLECTION_LIST)) {
                            hashSet.add(name2);
                        }
                    }
                    if (attribute.isDef()) {
                        isDef.add(name2);
                    }
                    if (attribute.toInit()) {
                        toInit.add(name2);
                    }
                    if (this.inheritanceColumns.containsKey(string) && entry.getKey().equals(this.inheritanceColumns.get(string))) {
                        buffer.append(" discriminator");
                    }
                    if (attribute.isVersion()) {
                        buffer.append(" optLock");
                    }
                    if (!attribute.isVersion() && (this.requiredColumns.containsKey(string) && this.requiredColumns.get(string).contains(entry.getKey()) || attribute.isRequired() && !attribute.isPrimaryKey()) && (!this.notRequiredColumns.containsKey(string) || !this.notRequiredColumns.get(string).contains(entry.getKey()))) {
                        buffer.append(" required");
                    }
                    if (attribute.isPrimaryKey()) {
                        buffer.append(" primaryKey");
                        pkeys.add(name2);
                    }
                    if (this.generateMethods.contains(METHOD_INDEX) || attribute.getIndex() == null) continue;
                    buffer.append(" index ").append(attribute.getIndex());
                }
                if (this.pojoExtends.containsKey(string)) {
                    this.getParentAttrs(this.pojoExtends.get(string), (Set<String>)((Object)isDef), (Set<String>)toInit);
                }
                for (Map.Entry<String, Object> entry : addedAttributes.entrySet()) {
                    attribute = (PojoAttribute)entry.getValue();
                    buffer.append(NLINDENT).append(INDENT).append(this.columnToCamelCase(attribute.getDbName())).append(' ');
                    buffer.append(": ").append(attribute.getClassName());
                    buffer.append(" createCol ").append(entry.getKey()).append("->").append(this.columnToCamelCase(attribute.getPkColumn()));
                    hashSet.add(this.columnToCamelCase(attribute.getDbName()));
                }
                if (this.generateMethods.contains(METHOD_EQUALS) && !pkeys.isEmpty()) {
                    if (this.annotations != null) {
                        buffer.append((CharSequence)this.annotations.getAttributeAnnotationsDefinitions(realPojoName, METHOD_EQUALS, true));
                    }
                    buffer.append(NLINDENT).append(INDENT).append(METHOD_EQUALS).append(" :::");
                    for (String string4 : pkeys) {
                        buffer.append(" ").append(string4);
                    }
                }
                if (this.generateMethods.contains(METHOD_HASH_CODE) && !pkeys.isEmpty()) {
                    if (this.annotations != null) {
                        buffer.append((CharSequence)this.annotations.getAttributeAnnotationsDefinitions(realPojoName, METHOD_HASH_CODE, true));
                    }
                    buffer.append(NLINDENT).append(INDENT).append(METHOD_HASH_CODE).append(" :::");
                    for (String string5 : pkeys) {
                        buffer.append(" ").append(string5);
                    }
                }
                if (this.generateMethods.contains(METHOD_TO_INIT)) {
                    if (this.annotations != null) {
                        buffer.append((CharSequence)this.annotations.getAttributeAnnotationsDefinitions(realPojoName, METHOD_TO_INIT, true));
                    }
                    buffer.append(NLINDENT).append(INDENT).append(METHOD_TO_INIT).append(" :::");
                    for (String string6 : toInit) {
                        buffer.append(" ").append(string6);
                    }
                } else if (this.generateMethods.contains(ENUM_TO_INIT) && !toInit.isEmpty()) {
                    if (this.annotations != null) {
                        buffer.append((CharSequence)this.annotations.getAttributeAnnotationsDefinitions(realPojoName, ENUM_TO_INIT, true));
                    }
                    buffer.append(NLINDENT).append(INDENT).append(ENUM_TO_INIT).append(" :::");
                    for (String string7 : toInit) {
                        buffer.append(" ").append(string7);
                    }
                }
                if (this.generateMethods.contains(METHOD_IS_DEF)) {
                    if (this.annotations != null) {
                        buffer.append((CharSequence)this.annotations.getAttributeAnnotationsDefinitions(realPojoName, METHOD_IS_DEF, true));
                    }
                    buffer.append(NLINDENT).append(INDENT).append(METHOD_IS_DEF).append(" :::");
                    iterator = isDef.iterator();
                    while (iterator.hasNext()) {
                        String string8 = (String)((Object)iterator.next());
                        buffer.append(" ").append(string8);
                    }
                } else if (this.generateMethods.contains(ENUM_IS_DEF) && !isDef.isEmpty()) {
                    if (this.annotations != null) {
                        buffer.append((CharSequence)this.annotations.getAttributeAnnotationsDefinitions(realPojoName, ENUM_IS_DEF, true));
                    }
                    buffer.append(NLINDENT).append(INDENT).append(ENUM_IS_DEF).append(" :::");
                    iterator = isDef.iterator();
                    while (iterator.hasNext()) {
                        String string9 = (String)((Object)iterator.next());
                        buffer.append(" ").append(string9);
                    }
                }
                if (this.generateMethods.contains(METHOD_TO_STRING) && !hashSet.isEmpty()) {
                    if (this.annotations != null) {
                        buffer.append((CharSequence)this.annotations.getAttributeAnnotationsDefinitions(realPojoName, METHOD_TO_STRING, true));
                    }
                    buffer.append(NLINDENT).append(INDENT).append(METHOD_TO_STRING).append(" :::");
                    for (String string10 : hashSet) {
                        buffer.append(" ").append(string10);
                    }
                }
                if (this.generateMethods.contains(METHOD_INDEX) && this.indexes.containsKey(string)) {
                    List<Map<PojoAttribute, Boolean>> list = this.indexes.get(string);
                    int i = 0;
                    int l = list.size();
                    while (i < l) {
                        if (this.annotations != null) {
                            buffer.append((CharSequence)this.annotations.getAttributeAnnotationsDefinitions(realPojoName, METHOD_INDEX, true));
                        }
                        buffer.append(NLINDENT).append(INDENT).append(METHOD_INDEX).append(i + 1).append(" :::");
                        for (PojoAttribute attr : list.get(i).keySet()) {
                            String name4 = this.columnNames.containsKey(string) ? this.columnNames.get(string).get(attr.getName()) : null;
                            name4 = name4 == null ? attr.getName() : this.columnToCamelCase(name4);
                            buffer.append(" ").append(name4);
                        }
                        ++i;
                    }
                }
                buffer.append(NLINDENT).append("}\n");
            }
            for (String string : this.procedures.keySet()) {
                if (this.ignoreTables.contains(string) || this.pojosForProcedures.containsKey(string)) continue;
                boolean isFunction = this.functions.containsKey(string);
                pojoName = this.tableNames.get(string);
                if (pojoName == null) {
                    pojoName = string;
                }
                if (this.finalEntities.contains(this.tableToCamelCase(pojoName))) continue;
                this.printComment(buffer, this.comments.get(string), INDENT);
                buffer.append(NLINDENT);
                if (this.makeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("pojo ");
                buffer.append(this.tableToCamelCase(pojoName));
                if (this.pojoExtends.containsKey(string)) {
                    buffer.append(" extends ").append(this.tableToCamelCase(this.pojoExtends.get(string)));
                }
                if (isSerializable || serializables.contains(string)) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" { // ");
                if (isFunction) {
                    buffer.append("function");
                } else {
                    buffer.append("procedure");
                }
                HashSet<String> toStr = new HashSet<String>();
                for (Map.Entry entry : this.procedures.get(string).entrySet()) {
                    if (FAKE_FUN_PROC_COLUMN_NAME.equals(entry.getKey()) || this.ignoreColumns.containsKey(string) && this.ignoreColumns.get(string).contains(entry.getKey())) continue;
                    PojoAttribute attribute = (PojoAttribute)entry.getValue();
                    String name = this.columnNames.containsKey(string) ? this.columnNames.get(string).get(entry.getKey()) : null;
                    name = name == null ? attribute.getName() : this.columnToCamelCase(name);
                    buffer.append(NLINDENT).append(INDENT).append(name).append(' ');
                    if (attribute.getDependencyClassName() != null) {
                        buffer.append(":: ").append(attribute.getDependencyClassName());
                        toStr.add(name);
                    } else if (attribute.isPrimitive()) {
                        buffer.append('_').append(attribute.getClassName());
                        toStr.add(name);
                    } else {
                        buffer.append(": ").append(attribute.getClassName());
                        if (!attribute.getClassName().startsWith(COLLECTION_LIST)) {
                            toStr.add(name);
                        }
                    }
                    if (attribute.isVersion() || (!this.requiredColumns.containsKey(string) || !this.requiredColumns.get(string).contains(entry.getKey())) && (!attribute.isRequired() || attribute.isPrimaryKey()) || this.notRequiredColumns.containsKey(string) && this.notRequiredColumns.get(string).contains(entry.getKey())) continue;
                    buffer.append(" required");
                }
                if (this.pojoExtends.containsKey(string)) {
                    this.getParentAttrs(this.pojoExtends.get(string), null, null);
                }
                if (this.generateMethods.contains(METHOD_TO_STRING) && !toStr.isEmpty()) {
                    buffer.append(NLINDENT).append(INDENT).append(METHOD_TO_STRING).append(" :::");
                    for (String string11 : toStr) {
                        buffer.append(" ").append(string11);
                    }
                }
                buffer.append(NLINDENT).append("}\n");
            }
            for (String string : this.functions.keySet()) {
                if (this.ignoreTables.contains(string) || this.procedures.containsKey(string) || this.pojosForFunctions.containsKey(string)) continue;
                String pojoName4 = this.tableNames.get(string);
                if (pojoName4 == null) {
                    pojoName4 = string;
                }
                if (this.finalEntities.contains(this.tableToCamelCase(pojoName4))) continue;
                this.printComment(buffer, this.comments.get(string), INDENT);
                buffer.append(NLINDENT);
                if (this.makeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("pojo ");
                buffer.append(this.tableToCamelCase(pojoName4));
                if (this.pojoExtends.containsKey(string)) {
                    buffer.append(" extends ").append(this.tableToCamelCase(this.pojoExtends.get(string)));
                }
                if (isSerializable || serializables.contains(string)) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" { // function");
                HashSet<String> toStr = new HashSet<String>();
                for (Map.Entry<String, PojoAttribute> pentry : this.functions.get(string).entrySet()) {
                    if (FAKE_FUN_PROC_COLUMN_NAME.equals(pentry.getKey()) || this.ignoreColumns.containsKey(string) && this.ignoreColumns.get(string).contains(pentry.getKey())) continue;
                    PojoAttribute attribute = pentry.getValue();
                    String name = this.columnNames.containsKey(string) ? this.columnNames.get(string).get(pentry.getKey()) : null;
                    name = name == null ? attribute.getName() : this.columnToCamelCase(name);
                    buffer.append(NLINDENT).append(INDENT).append(name).append(' ');
                    if (attribute.getDependencyClassName() != null) {
                        buffer.append(":: ").append(attribute.getDependencyClassName());
                        toStr.add(name);
                    } else if (attribute.isPrimitive()) {
                        buffer.append('_').append(attribute.getClassName());
                        toStr.add(name);
                    } else {
                        buffer.append(": ").append(attribute.getClassName());
                        if (!attribute.getClassName().startsWith(COLLECTION_LIST)) {
                            toStr.add(name);
                        }
                    }
                    if (attribute.isVersion() || (!this.requiredColumns.containsKey(string) || !this.requiredColumns.get(string).contains(pentry.getKey())) && (!attribute.isRequired() || attribute.isPrimaryKey()) || this.notRequiredColumns.containsKey(string) && this.notRequiredColumns.get(string).contains(pentry.getKey())) continue;
                    buffer.append(" required");
                }
                if (this.pojoExtends.containsKey(string)) {
                    this.getParentAttrs(this.pojoExtends.get(string), null, null);
                }
                if (this.generateMethods.contains(METHOD_TO_STRING) && !toStr.isEmpty()) {
                    buffer.append(NLINDENT).append(INDENT).append(METHOD_TO_STRING).append(" :::");
                    for (String name : toStr) {
                        buffer.append(" ").append(name);
                    }
                }
                buffer.append(NLINDENT).append("}\n");
            }
            return buffer.toString();
        }
        catch (RuntimeException ex) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            String s = ((Object)writer).toString();
            return s;
        }
    }

    protected void getParentAttrs(String pojo, Set<String> isDef, Set<String> toInit) {
        for (Map.Entry<String, PojoAttribute> pentry : this.pojos.get(pojo).entrySet()) {
            if (this.ignoreColumns.containsKey(pojo) && this.ignoreColumns.get(pojo).contains(pentry.getKey())) continue;
            PojoAttribute attribute = pentry.getValue();
            String name = this.columnNames.containsKey(pojo) ? this.columnNames.get(pojo).get(pentry.getKey()) : null;
            name = name == null ? attribute.getName() : this.columnToCamelCase(name);
            if (attribute.isDef() && isDef != null) {
                isDef.add(name);
            }
            if (!attribute.toInit() || toInit == null) continue;
            toInit.add(name);
        }
        if (this.pojoExtends.containsKey(pojo)) {
            this.getParentAttrs(this.pojoExtends.get(pojo), isDef, toInit);
        }
    }

    protected String tableToCamelCase(String value) {
        if (value == null) {
            return null;
        }
        String[] parts = value.split("_");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (camelCaseString.length() == 0) {
                camelCaseString = part.length() > 1 ? String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase() : String.valueOf(camelCaseString) + part.toUpperCase();
            } else if (part.length() == 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.toUpperCase();
            } else if (part.length() > 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            }
            ++n2;
        }
        return String.valueOf(camelCaseString) + this.suffix;
    }

    protected String columnToCamelCase(String value) {
        if (value == null) {
            return null;
        }
        String[] parts = value.split("_");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (camelCaseString.length() == 0) {
                camelCaseString = String.valueOf(camelCaseString) + part.toLowerCase();
            } else if (part.length() == 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.toUpperCase();
            } else if (part.length() > 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            }
            ++n2;
        }
        return camelCaseString;
    }

    protected String columnToDbConv(String value) {
        if (value == null) {
            return null;
        }
        String result = "";
        int last = 0;
        int i = 0;
        int l = value.length();
        while (i < l) {
            if (Character.isUpperCase(value.charAt(i))) {
                result = String.valueOf(result) + value.substring(last, i).toUpperCase() + "_";
                last = i;
            }
            ++i;
        }
        if (last < value.length()) {
            result = String.valueOf(result) + value.substring(last).toUpperCase();
        }
        return result;
    }

    protected PojoAttribute convertDbColumnDefinition(String dbName, PojoAttrType sqlType) {
        PojoAttribute attribute = new PojoAttribute(dbName);
        attribute.setName(this.columnToCamelCase(dbName));
        if (sqlType.getNativeType() != null) {
            attribute.setPrimitive(true);
            attribute.setClassName(String.valueOf(sqlType.getNativeType().substring(1)) + (sqlType.isArray() ? " []" : ""));
        } else if (sqlType.getRef() != null) {
            attribute.setPrimitive(false);
            attribute.setDependencyClassName(sqlType.getRef().getName());
            if (attribute.getDependencyClassName() == null) {
                attribute.setDependencyClassName(sqlType.getText());
            }
        } else {
            attribute.setPrimitive(false);
            attribute.setClassName(sqlType.getType().getIdentifier());
            if (sqlType.getGtype() != null) {
                attribute.setClassName(String.valueOf(attribute.getClassName()) + "<" + sqlType.getGtype().getIdentifier() + ">");
            }
        }
        return attribute;
    }

    protected PojoAttribute convertDbColumnDefinition(String dbName, String metaType) {
        PojoAttribute attribute = new PojoAttribute(dbName);
        attribute.setName(this.columnToCamelCase(dbName));
        attribute.setPrimitive(false);
        attribute.setClassName(this.metaType2className(metaType));
        return attribute;
    }

    protected PojoAttribute convertDbColumnDefinition(String table, DbColumn dbColumn, Map<String, Map<String, PojoAttrType>> redefinedTypes) {
        PojoAttrType sqlType;
        if (dbColumn == null) {
            return null;
        }
        PojoAttrType pojoAttrType = sqlType = redefinedTypes.containsKey(table) ? redefinedTypes.get(table).get(dbColumn.getName()) : null;
        if (sqlType == null) {
            PojoAttrType pojoAttrType2 = sqlType = this.tableTypes.containsKey(table) ? this.tableTypes.get(table).get(String.valueOf(dbColumn.getType()) + dbColumn.getSize()) : null;
        }
        if (sqlType == null) {
            sqlType = this.sqlTypes.get(String.valueOf(dbColumn.getType()) + dbColumn.getSize());
        }
        if (sqlType == null) {
            return null;
        }
        PojoAttribute attribute = new PojoAttribute(dbColumn.getName());
        attribute.setName(this.columnToCamelCase(dbColumn.getName()));
        attribute.setRequired(!dbColumn.isNullable());
        if (sqlType.getRef() != null) {
            attribute.setPrimitive(false);
            attribute.setDependencyClassName(sqlType.getRef().getName());
        } else if (sqlType.getNativeType() != null) {
            attribute.setPrimitive(true);
            attribute.setClassName(String.valueOf(sqlType.getNativeType().substring(1)) + (sqlType.isArray() ? " []" : ""));
        } else {
            attribute.setPrimitive(false);
            attribute.setClassName(sqlType.getType().getIdentifier());
        }
        attribute.setSqlType(dbColumn.getSqlType());
        attribute.setSize(dbColumn.getSize());
        attribute.setComment(dbColumn.getComment());
        return attribute;
    }

    protected PojoAttribute convertDbColumnDefault(String table, DbColumn dbColumn) {
        if (dbColumn == null) {
            return null;
        }
        PojoAttribute attribute = new PojoAttribute(dbColumn.getName());
        attribute.setName(this.columnToCamelCase(dbColumn.getName()));
        attribute.setRequired(!dbColumn.isNullable());
        switch (dbColumn.getSqlType()) {
            case -7: 
            case 16: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Boolean.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.BOOLEAN.getName());
                break;
            }
            case -6: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Byte.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.BYTE.getName());
                break;
            }
            case 5: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Short.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.SHORT.getName());
                break;
            }
            case 4: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Integer.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.INT.getName());
                break;
            }
            case -5: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Long.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.LONG.getName());
                break;
            }
            case 6: 
            case 7: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Float.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.FLOAT.getName());
                break;
            }
            case 8: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Double.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.DOUBLE.getName());
                break;
            }
            case 2: {
                attribute.setPrimitive(false);
                attribute.setClassName(BigDecimal.class.getName());
                break;
            }
            case 3: {
                attribute.setPrimitive(false);
                if (dbColumn.getSize() < 3) {
                    attribute.setClassName(Byte.class.getName());
                    break;
                }
                if (dbColumn.getSize() < 5) {
                    attribute.setClassName(Short.class.getName());
                    break;
                }
                if (dbColumn.getSize() < 10) {
                    attribute.setClassName(Integer.class.getName());
                    break;
                }
                if (dbColumn.getSize() < 20) {
                    attribute.setClassName(Long.class.getName());
                    break;
                }
                attribute.setClassName(BigInteger.class.getName());
                break;
            }
            case -15: 
            case 1: {
                if (dbColumn.isNullable() || dbColumn.getSize() > 1 || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(String.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.CHAR.getName());
                break;
            }
            case -16: 
            case -9: 
            case 12: {
                attribute.setPrimitive(false);
                attribute.setClassName(String.class.getName());
                break;
            }
            case 91: {
                attribute.setPrimitive(false);
                attribute.setClassName(java.util.Date.class.getName());
                break;
            }
            case 92: {
                attribute.setPrimitive(false);
                attribute.setClassName(Time.class.getName());
                break;
            }
            case 93: {
                attribute.setPrimitive(false);
                attribute.setClassName(Timestamp.class.getName());
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.BYTE_ARRAY.getName());
                break;
            }
            case 2005: {
                attribute.setPrimitive(false);
                attribute.setClassName(String.class.getName());
                break;
            }
            default: {
                attribute.setPrimitive(false);
                if (dbColumn.getType().indexOf("TIMESTAMP") == 0 || dbColumn.getType().indexOf("timestamp") == 0) {
                    attribute.setClassName(Timestamp.class.getName());
                    break;
                }
                attribute.setClassName("java.lang.Object");
            }
        }
        attribute.setSqlType(dbColumn.getSqlType());
        attribute.setSize(dbColumn.getSize());
        attribute.setComment(dbColumn.getComment());
        return attribute;
    }

    protected String metaType2className(String metaType) {
        if (metaType == null) {
            return null;
        }
        String className = metaType2classNameMap.get(metaType.toLowerCase());
        if (className == null) {
            return metaType;
        }
        return className;
    }

    protected String className2metaType(String className) {
        if (className == null) {
            return null;
        }
        String metaType = className2metaTypeMap.get(className);
        if (metaType == null) {
            return null;
        }
        return metaType;
    }

    protected void printComment(StringBuilder buffer, String comment, String ... indents) {
        if (comment == null || comment.trim().length() == 0) {
            return;
        }
        int l = comment.length();
        while (l > 0) {
            buffer.append("\n");
            String[] stringArray = indents;
            int n = indents.length;
            int n2 = 0;
            while (n2 < n) {
                String indent = stringArray[n2];
                buffer.append(indent);
                ++n2;
            }
            buffer.append("// ");
            if (l > 100) {
                buffer.append(comment.substring(0, 100));
                comment = comment.substring(100);
            } else {
                buffer.append(comment);
                comment = "";
            }
            l = comment.length();
        }
    }

    protected static enum PrimitiveType {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        CHAR,
        BYTE_ARRAY,
        CHAR_ARRAY;


        public String getName() {
            if (this == BYTE_ARRAY) {
                return "byte []";
            }
            if (this == CHAR_ARRAY) {
                return "char []";
            }
            return this.name().toLowerCase();
        }
    }
}

