/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.templates;

import com.google.inject.Inject;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.ui.editor.templates.DefaultTemplateProposalProvider;
import org.sqlproc.dsl.services.ProcessorDslGrammarAccess;

public class ProcessorTemplateProposalProvider
extends DefaultTemplateProposalProvider {
    ContextTypeIdHelper helper;
    @Inject
    ProcessorDslGrammarAccess ga;

    @Inject
    public ProcessorTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
        this.helper = helper;
    }

    protected boolean validate1(Template template, ContentAssistContext context) {
        boolean result = context.getMatcher().isCandidateMatchingPrefix(template.getName(), context.getPrefix());
        return result;
    }

    protected TemplateProposal createProposal1(Template template, TemplateContext templateContext, ContentAssistContext context, Image image, int relevance) {
        if (!this.validate1(template, context)) {
            return null;
        }
        return this.doCreateProposal(template, templateContext, context, image, relevance);
    }

    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        TemplateProposal tp;
        Template template;
        super.createTemplates(templateContext, context, acceptor);
        if (templateContext.getContextType().getId().equals(this.helper.getId((AbstractRule)this.ga.getSqlValueRule()))) {
            template = new Template("ins", "CRUD insert statement", "insertTemplateID", "\n  insert into ${dbTable}\n  (${dbInsertColumn})\n  {= values (${pojoColumn}) }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("get", "CRUD get statement", "getTemplateID", "\n  select ${dbSelectColumn}\n  from ${dbTable}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("upd", "CRUD update statement", "updateTemplateID", "\n  update ${dbTable}\n  {= set (${dbUpdateColumn})}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("upd-opt", "CRUD optimistic update statement", "updateOptTemplateID", "\n  update ${dbTable}\n  {= set (${dbVerUpdateColumn}${dbOptUpdateColumn})}\n  {= where${dbOptCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("del", "CRUD delete statement", "deleteTemplateID", "\n  delete from ${dbTable}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("select", "QRY select statement", "selectTemplateID", "\n  select ${dbSelectColumn}\n  from ${dbTable}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
        if (templateContext.getContextType().getId().equals(this.helper.getId((AbstractRule)this.ga.getOptionalFeatureRule()))) {
            template = new Template("pojos", "Pojos definitions", "pojosTemplateID", "${pojoDefinitions}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("tables", "Tables definitions", "uniqueTemplateID", "${tableDefinitions}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("metagen", "Meta SQL generator", "metagenTemplateID", "${metaGenerator}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("procedures", "Procedures definitions", "uniqueTemplateID", "${procedureDefinitions}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("functions", "Functions definitions", "uniqueTemplateID", "${functionDefinitions}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
        if (templateContext.getContextType().getId().equals(this.helper.getId((AbstractRule)this.ga.getAbstractPojoEntityRule()))) {
            template = new Template("pojogen", "Pojo generator", "pojogenTemplateID", "${pojoGenerator}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
        if (templateContext.getContextType().getId().equals(this.helper.getId((AbstractRule)this.ga.getAbstractPojoEntityRule()))) {
            template = new Template("daogen", "DAO generator", "daogenTemplateID", "${daoGenerator}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
    }
}

