/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.templates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sqlproc.dsl.processorDsl.Annotation;
import org.sqlproc.dsl.processorDsl.AnnotationProperty;

public class Annotations {
    Map<String, List<Annotation>> entityAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, List<Annotation>> constructorAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, List<Annotation>> staticAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, List<Annotation>> conflictAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, Map<String, List<Annotation>>> setterAnnotations = new HashMap<String, Map<String, List<Annotation>>>();
    Map<String, Map<String, List<Annotation>>> getterAnnotations = new HashMap<String, Map<String, List<Annotation>>>();
    Map<String, Map<String, List<Annotation>>> attributeAnnotations = new HashMap<String, Map<String, List<Annotation>>>();

    void addEntityAnnotations(String pojoName, List<Annotation> annotations) {
        this.entityAnnotations.put(pojoName, new ArrayList());
        this.entityAnnotations.get(pojoName).addAll(annotations);
    }

    void addConstructorAnnotations(String pojoName, List<Annotation> annotations) {
        this.constructorAnnotations.put(pojoName, new ArrayList());
        this.constructorAnnotations.get(pojoName).addAll(annotations);
    }

    void addStaticAnnotations(String pojoName, List<Annotation> annotations) {
        this.staticAnnotations.put(pojoName, new ArrayList());
        this.staticAnnotations.get(pojoName).addAll(annotations);
    }

    void addConflictAnnotations(String pojoName, List<Annotation> annotations) {
        this.conflictAnnotations.put(pojoName, new ArrayList());
        this.conflictAnnotations.get(pojoName).addAll(annotations);
    }

    void addGetterAnnotations(String pojoName, String featureName, List<Annotation> annotations) {
        List<Annotation> list;
        if (!this.getterAnnotations.containsKey(pojoName)) {
            this.getterAnnotations.put(pojoName, new HashMap());
        }
        if ((list = this.getterAnnotations.get(pojoName).get(featureName)) == null) {
            list = new ArrayList<Annotation>();
            this.getterAnnotations.get(pojoName).put(featureName, list);
        }
        list.addAll(annotations);
    }

    void addSetterAnnotations(String pojoName, String featureName, List<Annotation> annotations) {
        List<Annotation> list;
        if (!this.setterAnnotations.containsKey(pojoName)) {
            this.setterAnnotations.put(pojoName, new HashMap());
        }
        if ((list = this.setterAnnotations.get(pojoName).get(featureName)) == null) {
            list = new ArrayList<Annotation>();
            this.setterAnnotations.get(pojoName).put(featureName, list);
        }
        list.addAll(annotations);
    }

    void addAttributeAnnotations(String pojoName, String featureName, List<Annotation> annotations) {
        List<Annotation> list;
        if (!this.attributeAnnotations.containsKey(pojoName)) {
            this.attributeAnnotations.put(pojoName, new HashMap());
        }
        if ((list = this.attributeAnnotations.get(pojoName).get(featureName)) == null) {
            list = new ArrayList<Annotation>();
            this.attributeAnnotations.get(pojoName).put(featureName, list);
        }
        list.addAll(annotations);
    }

    StringBuilder getEntityAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.entityAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.entityAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  @", simpleNames);
        }
        return sb;
    }

    StringBuilder getConstructorAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.constructorAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.constructorAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  @@", simpleNames);
        }
        return sb;
    }

    StringBuilder getStaticAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.staticAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.staticAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  @@@", simpleNames);
        }
        return sb;
    }

    StringBuilder getConflictAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.conflictAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.conflictAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  @@@@", simpleNames);
        }
        return sb;
    }

    StringBuilder getGetterAnnotationsDefinitions(String pojoName, String featureName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.getterAnnotations.containsKey(pojoName) || !this.getterAnnotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (Annotation a : this.getterAnnotations.get(pojoName).get(featureName)) {
            this.getAnnotationDefinition(sb, a, "\n    @@", simpleNames);
        }
        return sb;
    }

    StringBuilder getSetterAnnotationsDefinitions(String pojoName, String featureName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.setterAnnotations.containsKey(pojoName) || !this.setterAnnotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (Annotation a : this.setterAnnotations.get(pojoName).get(featureName)) {
            this.getAnnotationDefinition(sb, a, "\n    @@@", simpleNames);
        }
        return sb;
    }

    StringBuilder getAttributeAnnotationsDefinitions(String pojoName, String featureName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.attributeAnnotations.containsKey(pojoName) || !this.attributeAnnotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (Annotation a : this.attributeAnnotations.get(pojoName).get(featureName)) {
            this.getAnnotationDefinition(sb, a, "\n    @", simpleNames);
        }
        return sb;
    }

    void getAnnotationDefinition(StringBuilder sb, Annotation a, String prefix, boolean simpleNames) {
        sb.append(prefix).append(simpleNames ? a.getType().getSimpleName() : a.getType().getQualifiedName());
        if (a.getFeatures() != null && !a.getFeatures().isEmpty()) {
            sb.append(" ::: ");
            boolean first = true;
            for (AnnotationProperty ap : a.getFeatures()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                this.getAnnotationPropertyDefinition(sb, ap, simpleNames);
            }
        }
    }

    void getAnnotationPropertyDefinition(StringBuilder sb, AnnotationProperty ap, boolean simpleNames) {
        sb.append(ap.getName());
        if (ap.getType() != null) {
            sb.append(" :").append(simpleNames ? ap.getType().getSimpleName() : ap.getType().getQualifiedName());
        } else if (ap.getRef() != null) {
            sb.append(" ::").append(ap.getRef().getName());
        }
        sb.append(" ");
        if (ap.getValue() != null) {
            sb.append(ap.getValue());
        } else if (ap.getNumber() != null) {
            sb.append(ap.getNumber());
        } else {
            sb.append(ap.getConstant());
        }
    }

    Set<String> getImports() {
        HashSet<String> imports = new HashSet<String>();
        for (List<Annotation> list : this.entityAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (List<Annotation> list : this.constructorAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (List<Annotation> list : this.staticAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (List<Annotation> list : this.conflictAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (Map map : this.attributeAnnotations.values()) {
            for (List al : map.values()) {
                this.getImports(imports, al);
            }
        }
        for (Map map : this.getterAnnotations.values()) {
            for (List al : map.values()) {
                this.getImports(imports, al);
            }
        }
        for (Map map : this.setterAnnotations.values()) {
            for (List al : map.values()) {
                this.getImports(imports, al);
            }
        }
        return imports;
    }

    void getImports(Set<String> imports, List<Annotation> al) {
        for (Annotation a : al) {
            if (a.getType() != null) {
                imports.add(a.getType().getQualifiedName());
            }
            for (AnnotationProperty ap : a.getFeatures()) {
                if (ap.getType() == null) continue;
                imports.add(ap.getType().getQualifiedName());
            }
        }
    }

    public String toString() {
        return "Annotations [entityAnnotations=" + this.entityAnnotations + ", constructorAnnotations=" + this.constructorAnnotations + ", staticAnnotations=" + this.staticAnnotations + ", conflictAnnotations=" + this.conflictAnnotations + ", setterAnnotations=" + this.setterAnnotations + ", getterAnnotations=" + this.getterAnnotations + ", attributeAnnotations=" + this.attributeAnnotations + "]";
    }
}

