/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.templates;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmType;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.property.PojoAttrType;
import org.sqlproc.dsl.property.PojoAttribute;
import org.sqlproc.dsl.resolver.DbColumn;
import org.sqlproc.dsl.resolver.DbExport;
import org.sqlproc.dsl.resolver.DbImport;

public class TablePojoConverter {
    private static final String METHOD_TO_STRING = "toString";
    private static final String METHOD_HASH_CODE = "hashCode";
    private static final String METHOD_EQUALS = "equals";
    private static final String COLLECTION_LIST = "java.util.List";
    private String suffix;
    private Set<String> finalEntities;
    private Map<String, PojoAttrType> sqlTypes = new HashMap<String, PojoAttrType>();
    private Map<String, Map<String, PojoAttrType>> tableTypes = new HashMap<String, Map<String, PojoAttrType>>();
    private Map<String, Map<String, PojoAttrType>> columnTypes = new HashMap<String, Map<String, PojoAttrType>>();
    private Map<String, String> tableNames = new HashMap<String, String>();
    private Map<String, Map<String, String>> columnNames = new HashMap<String, Map<String, String>>();
    private Set<String> ignoreTables = new HashSet<String>();
    private Set<String> onlyTables = new HashSet<String>();
    private Map<String, Set<String>> ignoreColumns = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> requiredColumns = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> notRequiredColumns = new HashMap<String, Set<String>>();
    private Map<String, Map<String, PojoAttrType>> createColumns = new HashMap<String, Map<String, PojoAttrType>>();
    private Map<String, Map<String, Map<String, String>>> ignoreExports = new HashMap<String, Map<String, Map<String, String>>>();
    private Map<String, Map<String, Map<String, String>>> ignoreImports = new HashMap<String, Map<String, Map<String, String>>>();
    private Map<String, Map<String, Map<String, String>>> createExports = new HashMap<String, Map<String, Map<String, String>>>();
    private Map<String, Map<String, Map<String, String>>> createImports = new HashMap<String, Map<String, Map<String, String>>>();
    private Map<String, Map<String, Map<String, String>>> inheritImports = new HashMap<String, Map<String, Map<String, String>>>();
    private Map<String, Map<String, Map<String, String>>> manyToManyImports = new HashMap<String, Map<String, Map<String, String>>>();
    private Map<String, Map<String, Map<String, List<String>>>> inheritance = new HashMap<String, Map<String, Map<String, List<String>>>>();
    private Map<String, String> inheritanceColumns = new HashMap<String, String>();
    private Set<String> generateMethods = new HashSet<String>();
    private Map<String, JvmType> toImplements = new HashMap<String, JvmType>();
    private JvmType toExtends = null;
    private Map<String, List<String>> joinTables = new HashMap<String, List<String>>();
    private Map<String, Map<String, PojoAttribute>> pojos = new TreeMap<String, Map<String, PojoAttribute>>();
    private Map<String, String> pojoExtends = new HashMap<String, String>();
    private Set<String> pojoAbstracts = new HashSet<String>();
    private Map<String, String> pojoDiscriminators = new HashMap<String, String>();

    public TablePojoConverter() {
    }

    public TablePojoConverter(ModelProperty modelProperty, Artifacts artifacts, String suffix, Set<String> finalEntities) {
        Map toImplements;
        Set generateMethods;
        Map inheritanceColumns;
        Map inheritance;
        Map manyToManyImports;
        Map inheritImports;
        Map createImports;
        Map createExports;
        Map ignoreImports;
        Map ignoreExports;
        Map createColumns;
        Map notRequiredColumns;
        Map requiredColumns;
        Map ignoreColumns;
        Set onlyTables;
        Set ignoreTables;
        Map columnNames;
        Map tableNames;
        Map columnTypes;
        Map tableTypes;
        this.suffix = suffix != null ? suffix : "";
        this.finalEntities = finalEntities;
        Map sqlTypes = modelProperty.getSqlTypes((EObject)artifacts);
        if (sqlTypes != null) {
            this.sqlTypes.putAll(sqlTypes);
        }
        if ((tableTypes = modelProperty.getTableTypes((EObject)artifacts)) != null) {
            this.tableTypes.putAll(tableTypes);
        }
        if ((columnTypes = modelProperty.getColumnTypes((EObject)artifacts)) != null) {
            this.columnTypes.putAll(columnTypes);
        }
        if ((tableNames = modelProperty.getTableNames((EObject)artifacts)) != null) {
            this.tableNames.putAll(tableNames);
        }
        if ((columnNames = modelProperty.getColumnNames((EObject)artifacts)) != null) {
            this.columnNames.putAll(columnNames);
        }
        if ((ignoreTables = modelProperty.getIgnoreTables((EObject)artifacts)) != null) {
            this.ignoreTables.addAll(ignoreTables);
        }
        if ((onlyTables = modelProperty.getOnlyTables((EObject)artifacts)) != null) {
            this.onlyTables.addAll(onlyTables);
        }
        if ((ignoreColumns = modelProperty.getIgnoreColumns((EObject)artifacts)) != null) {
            this.ignoreColumns.putAll(ignoreColumns);
        }
        if ((requiredColumns = modelProperty.getRequiredColumns((EObject)artifacts)) != null) {
            this.requiredColumns.putAll(requiredColumns);
        }
        if ((notRequiredColumns = modelProperty.getNotRequiredColumns((EObject)artifacts)) != null) {
            this.notRequiredColumns.putAll(notRequiredColumns);
        }
        if ((createColumns = modelProperty.getCreateColumns((EObject)artifacts)) != null) {
            this.createColumns.putAll(createColumns);
        }
        if ((ignoreExports = modelProperty.getIgnoreExports((EObject)artifacts)) != null) {
            this.ignoreExports.putAll(ignoreExports);
        }
        if ((ignoreImports = modelProperty.getIgnoreImports((EObject)artifacts)) != null) {
            this.ignoreImports.putAll(ignoreImports);
        }
        if ((createExports = modelProperty.getCreateExports((EObject)artifacts)) != null) {
            this.createExports.putAll(createExports);
        }
        if ((createImports = modelProperty.getCreateImports((EObject)artifacts)) != null) {
            this.createImports.putAll(createImports);
        }
        if ((inheritImports = modelProperty.getInheritImports((EObject)artifacts)) != null) {
            this.inheritImports.putAll(inheritImports);
        }
        if ((manyToManyImports = modelProperty.getManyToManyImports((EObject)artifacts)) != null) {
            this.manyToManyImports.putAll(manyToManyImports);
        }
        if ((inheritance = modelProperty.getInheritance((EObject)artifacts)) != null) {
            this.inheritance.putAll(inheritance);
        }
        if ((inheritanceColumns = modelProperty.getInheritanceColumns((EObject)artifacts)) != null) {
            this.inheritanceColumns.putAll(inheritanceColumns);
        }
        if ((generateMethods = modelProperty.getGenerateMethods((EObject)artifacts)) != null) {
            this.generateMethods.addAll(generateMethods);
        }
        if ((toImplements = modelProperty.getToImplements((EObject)artifacts)) != null) {
            this.toImplements.putAll(toImplements);
        }
        this.toExtends = modelProperty.getToExtends((EObject)artifacts);
        Map joinTables = modelProperty.getJoinTables((EObject)artifacts);
        if (joinTables != null) {
            this.joinTables.putAll(joinTables);
        }
        for (Map.Entry<String, Map<String, Map<String, String>>> inheritImport : this.inheritImports.entrySet()) {
            for (Map.Entry<String, Map<String, String>> inherit : inheritImport.getValue().entrySet()) {
                for (Map.Entry<String, String> tabcol : inherit.getValue().entrySet()) {
                    if (!this.ignoreExports.containsKey(tabcol.getKey())) {
                        this.ignoreExports.put(tabcol.getKey(), new HashMap());
                    }
                    if (!this.ignoreExports.get(tabcol.getKey()).containsKey(tabcol.getValue())) {
                        this.ignoreExports.get(tabcol.getKey()).put(tabcol.getValue(), new HashMap());
                    }
                    this.ignoreExports.get(tabcol.getKey()).get(tabcol.getValue()).put(inheritImport.getKey(), null);
                    if (!this.ignoreColumns.containsKey(inheritImport.getKey())) {
                        this.ignoreColumns.put(inheritImport.getKey(), new HashSet());
                    }
                    this.ignoreColumns.get(inheritImport.getKey()).add(inherit.getKey());
                }
            }
        }
        for (Map.Entry<String, Map<String, Map<String, String>>> manyToManyExport : this.manyToManyImports.entrySet()) {
            String table = manyToManyExport.getKey();
            if (this.ignoreImports.containsKey(table)) continue;
            this.ignoreImports.put(table, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addTableDefinition(String table, List<DbColumn> dbColumns, List<String> dbPrimaryKeys, List<DbExport> dbExports, List<DbImport> dbImports) {
        if (table == null || dbColumns == null) {
            return;
        }
        LinkedHashMap<String, PojoAttribute> attributes = new LinkedHashMap<String, PojoAttribute>();
        for (DbColumn dbColumn : dbColumns) {
            void var9_20;
            PojoAttribute pojoAttribute = this.convertDbColumnDefinition(table, dbColumn);
            if (pojoAttribute != null) {
                attributes.put(dbColumn.getName(), pojoAttribute);
            } else {
                PojoAttribute pojoAttribute2 = this.convertDbColumnDefault(table, dbColumn);
                if (pojoAttribute2 != null) {
                    attributes.put(dbColumn.getName(), pojoAttribute2);
                }
            }
            if (!dbPrimaryKeys.contains(dbColumn.getName())) continue;
            var9_20.setPrimaryKey(true);
        }
        if (this.createColumns.containsKey(table)) {
            for (Map.Entry entry : this.createColumns.get(table).entrySet()) {
                PojoAttribute pojoAttribute = this.convertDbColumnDefinition((String)entry.getKey(), (PojoAttrType)entry.getValue());
                attributes.put((String)entry.getKey(), pojoAttribute);
            }
        }
        this.pojos.put(table, attributes);
        for (DbImport dbImport : dbImports) {
            if (this.ignoreImports.containsKey(table) && (this.ignoreImports.get(table) == null || this.ignoreImports.get(table).containsKey(dbImport.getFkColumn()) && this.ignoreImports.get(table).get(dbImport.getFkColumn()).containsKey(dbImport.getPkTable()))) continue;
            if (this.inheritImports.containsKey(table) && this.inheritImports.get(table).containsKey(dbImport.getFkColumn()) && this.inheritImports.get(table).get(dbImport.getFkColumn()).containsKey(dbImport.getPkTable())) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbImport.getFkColumn());
                pojoAttribute.setParentTable(dbImport.getPkTable());
                continue;
            }
            PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbImport.getFkColumn());
            pojoAttribute.setPkTable(dbImport.getPkTable());
        }
        if (this.createImports.containsKey(table)) {
            for (Map.Entry entry : this.createImports.get(table).entrySet()) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(entry.getKey());
                for (Object pkTable : ((Map)entry.getValue()).keySet()) {
                    pojoAttribute.setPkTable((String)pkTable);
                }
            }
        }
        for (DbExport dbExport : dbExports) {
            if (this.ignoreExports.containsKey(table) && this.ignoreExports.get(table).containsKey(dbExport.getPkColumn()) && this.ignoreExports.get(table).get(dbExport.getPkColumn()).containsKey(dbExport.getFkTable())) continue;
            if (this.manyToManyImports.containsKey(dbExport.getFkTable())) {
                if (!this.manyToManyImports.get(dbExport.getFkTable()).containsKey(dbExport.getPkColumn())) continue;
                for (Map.Entry entry : this.manyToManyImports.get(dbExport.getFkTable()).get(dbExport.getPkColumn()).entrySet()) {
                    String fkTable = (String)entry.getKey();
                    String fkColumn = (String)entry.getValue();
                    if (dbExport.getPkTable().equals(fkTable)) continue;
                    PojoAttribute attribute2 = (PojoAttribute)attributes.get(dbExport.getPkColumn());
                    attribute2.getFkTables().put(fkTable, fkColumn);
                }
                continue;
            }
            PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbExport.getPkColumn());
            pojoAttribute.getFkTables().put(dbExport.getFkTable(), null);
        }
        if (this.createExports.containsKey(table)) {
            for (Map.Entry entry : this.createExports.get(table).entrySet()) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(entry.getKey());
                for (Map.Entry fk : ((Map)entry.getValue()).entrySet()) {
                    pojoAttribute.getFkTables().put((String)fk.getKey(), (String)fk.getValue());
                }
            }
        }
        if (this.inheritance.containsKey(table)) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Map.Entry<String, Map<String, List<String>>> inheritance1 : this.inheritance.get(table).entrySet()) {
                String discriminator = inheritance1.getKey();
                LinkedHashMap<String, PojoAttribute> inheritedAttributes = new LinkedHashMap<String, PojoAttribute>();
                Iterator<Map.Entry<String, List<String>>> iterator = inheritance1.getValue().entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry<String, List<String>> tabcols = iterator.next();
                String inheritedTable = tabcols.getKey();
                for (String dbColumn : tabcols.getValue()) {
                    if (!attributes.containsKey(dbColumn)) continue;
                    inheritedAttributes.put(dbColumn, (PojoAttribute)attributes.get(dbColumn));
                }
                linkedHashMap.putAll(inheritedAttributes);
                this.pojos.put(inheritedTable, inheritedAttributes);
                this.pojoDiscriminators.put(inheritedTable, discriminator);
                this.pojoExtends.put(inheritedTable, this.tableToCamelCase(table));
            }
            for (String dbColumn : linkedHashMap.keySet()) {
                attributes.remove(dbColumn);
            }
            this.pojoAbstracts.add(table);
        }
    }

    public void joinTables() {
        for (String table : this.joinTables.keySet()) {
            if (!this.pojos.containsKey(table)) continue;
            Stack<String> stack = new Stack<String>();
            stack.push(table);
            for (String table1 : this.joinTables.get(table)) {
                if (!this.pojos.containsKey(table1)) break;
                stack.push(table1);
            }
            if (stack.size() != this.joinTables.get(table).size() + 1) continue;
            String table0 = (String)stack.pop();
            HashSet<String> allAttributes = new HashSet<String>();
            allAttributes.addAll(this.pojos.get(table0).keySet());
            if (this.tableNames.containsKey(table0)) {
                table0 = this.tableNames.get(table0);
            }
            while (stack.size() > 0) {
                String table1 = (String)stack.pop();
                String newTable = String.valueOf(this.tableNames.containsKey(table1) ? this.tableNames.get(table1) : table1) + "_" + table0;
                LinkedHashMap<String, PojoAttribute> newAttributes = new LinkedHashMap<String, PojoAttribute>();
                for (Map.Entry<String, PojoAttribute> attr : this.pojos.get(table1).entrySet()) {
                    if (allAttributes.contains(attr.getKey())) continue;
                    newAttributes.put(attr.getKey(), attr.getValue());
                    allAttributes.add(attr.getKey());
                }
                this.pojos.put(newTable, newAttributes);
                this.pojoExtends.put(newTable, this.tableToCamelCase(table0));
                if (!this.onlyTables.isEmpty()) {
                    this.onlyTables.add(newTable);
                }
                table0 = newTable;
            }
        }
    }

    public void resolveReferencesOnKeys() {
        for (String pojo : this.pojos.keySet()) {
            HashMap<String, PojoAttribute> newAttributes = new HashMap<String, PojoAttribute>();
            for (PojoAttribute attribute : this.pojos.get(pojo).values()) {
                if (attribute.getPkTable() != null && this.pojos.containsKey(attribute.getPkTable())) {
                    attribute.setDependencyClassName(this.tableToCamelCase(attribute.getPkTable()));
                    if (attribute.getName().length() >= 3) {
                        if (attribute.getName().startsWith("id")) {
                            attribute.setName(this.lowerFirstChar(attribute.getName().substring(2)));
                        } else if (attribute.getName().endsWith("Id")) {
                            attribute.setName(attribute.getName().substring(0, attribute.getName().length() - 2));
                        }
                    }
                }
                if (attribute.getParentTable() != null && this.pojos.containsKey(attribute.getParentTable())) {
                    this.pojoExtends.put(pojo, this.tableToCamelCase(attribute.getParentTable()));
                    this.pojoAbstracts.add(attribute.getParentTable());
                }
                for (Map.Entry fk : attribute.getFkTables().entrySet()) {
                    if (!this.pojos.containsKey(fk.getKey())) continue;
                    String referName = null;
                    if (fk.getValue() != null) {
                        referName = this.columnToCamelCase((String)fk.getValue());
                    } else {
                        referName = this.lowerFirstChar(this.tableToCamelCase((String)fk.getKey()));
                        if (!referName.endsWith("s")) {
                            if (referName.endsWith("y")) {
                                referName = referName.substring(0, referName.length() - 1);
                                referName = String.valueOf(referName) + "ies";
                            } else {
                                referName = String.valueOf(referName) + "s";
                            }
                        }
                    }
                    PojoAttribute attrib = new PojoAttribute();
                    attrib.setName(referName);
                    attrib.setClassName("java.util.List <:" + this.tableToCamelCase((String)fk.getKey()) + ">");
                    newAttributes.put(this.columnToDbConv(attrib.getName()), attrib);
                }
            }
            if (newAttributes.isEmpty()) continue;
            this.pojos.get(pojo).putAll(newAttributes);
        }
    }

    private String lowerFirstChar(String s) {
        if (s == null) {
            return null;
        }
        String ss = s.substring(0, 1).toLowerCase();
        if (s.length() == 1) {
            return ss;
        }
        ss = String.valueOf(ss) + s.substring(1);
        return ss;
    }

    public void resolveReferencesOnConvention() {
        for (String pojo : this.pojos.keySet()) {
            for (PojoAttribute attribute : this.pojos.get(pojo).values()) {
                Map<String, PojoAttribute> referPojoAttr;
                String className;
                if (!attribute.getName().startsWith("id") || attribute.getName().length() <= 2 || pojo.equals(className = attribute.getName().substring(2)) || (referPojoAttr = this.pojos.get(className)) == null) continue;
                String name = className.substring(0, 1).toLowerCase();
                if (className.length() > 1) {
                    name = String.valueOf(name) + className.substring(1);
                }
                attribute.setName(name);
                attribute.setPrimitive(false);
                attribute.setDependencyClassName(className);
                String referName = pojo.substring(0, 1).toLowerCase();
                if (className.length() > 1) {
                    referName = String.valueOf(referName) + pojo.substring(1);
                }
                PojoAttribute attrib = new PojoAttribute();
                attrib.setName(String.valueOf(referName) + "s");
                attrib.setClassName("java.util.List <:" + pojo + ">");
                referPojoAttr.put(attrib.getName(), attrib);
            }
        }
    }

    public String getPojoDefinitions() {
        StringBuilder buffer = new StringBuilder();
        boolean isSerializable = false;
        if (!this.toImplements.isEmpty()) {
            for (JvmType type : this.toImplements.values()) {
                if (type.getIdentifier().endsWith("Serializable")) {
                    isSerializable = true;
                    continue;
                }
                buffer.append("\n  implements ").append(type.getIdentifier());
            }
        }
        if (this.toExtends != null) {
            buffer.append("\n  extends ").append(this.toExtends.getIdentifier());
        }
        if (!this.toImplements.isEmpty() || this.toExtends != null) {
            buffer.append("\n");
        }
        for (String pojo : this.pojos.keySet()) {
            if (!this.onlyTables.isEmpty() && !this.onlyTables.contains(pojo) || this.ignoreTables.contains(pojo) || this.finalEntities.contains(this.tableToCamelCase(pojo))) continue;
            String pojoName = this.tableNames.get(pojo);
            if (pojoName == null) {
                pojoName = pojo;
            }
            buffer.append("\n");
            if (this.pojoAbstracts.contains(pojo)) {
                buffer.append("abstract ");
            }
            buffer.append("pojo ");
            buffer.append(this.tableToCamelCase(pojoName));
            if (this.pojoExtends.containsKey(pojo)) {
                buffer.append(" extends ").append(this.pojoExtends.get(pojo));
            }
            if (this.pojoDiscriminators.containsKey(pojo)) {
                buffer.append(" discriminator ").append(this.pojoDiscriminators.get(pojo));
            }
            if (isSerializable) {
                buffer.append(" serializable 1 ");
            }
            buffer.append(" {");
            HashSet<String> pkeys = new HashSet<String>();
            HashSet<String> strs = new HashSet<String>();
            for (Map.Entry<String, PojoAttribute> pentry : this.pojos.get(pojo).entrySet()) {
                if (this.ignoreColumns.containsKey(pojo) && this.ignoreColumns.get(pojo).contains(pentry.getKey())) continue;
                PojoAttribute attribute = pentry.getValue();
                String name = this.columnNames.containsKey(pojo) ? this.columnNames.get(pojo).get(pentry.getKey()) : null;
                name = name == null ? attribute.getName() : this.columnToCamelCase(name);
                buffer.append("\n    ").append(name).append(' ');
                if (attribute.getDependencyClassName() != null) {
                    buffer.append(":: ").append(attribute.getDependencyClassName());
                    strs.add(name);
                } else if (attribute.isPrimitive()) {
                    buffer.append('_').append(attribute.getClassName());
                    strs.add(name);
                } else {
                    buffer.append(": ").append(attribute.getClassName());
                    if (!attribute.getClassName().startsWith(COLLECTION_LIST)) {
                        strs.add(name);
                    }
                }
                if (this.inheritanceColumns.containsKey(pojo) && pentry.getKey().equals(this.inheritanceColumns.get(pojo))) {
                    buffer.append(" discriminator");
                }
                if ((this.requiredColumns.containsKey(pojo) && this.requiredColumns.get(pojo).contains(pentry.getKey()) || attribute.isRequired() && !attribute.isPrimaryKey()) && (!this.notRequiredColumns.containsKey(pojo) || !this.notRequiredColumns.get(pojo).contains(pentry.getKey()))) {
                    buffer.append(" required");
                }
                if (!attribute.isPrimaryKey()) continue;
                buffer.append(" primaryKey");
                pkeys.add(name);
            }
            if (this.generateMethods.contains(METHOD_EQUALS) && !pkeys.isEmpty()) {
                buffer.append("\n    ").append(METHOD_EQUALS).append(" :::");
                for (String name : pkeys) {
                    buffer.append(" ").append(name);
                }
            }
            if (this.generateMethods.contains(METHOD_HASH_CODE) && !pkeys.isEmpty()) {
                buffer.append("\n    ").append(METHOD_HASH_CODE).append(" :::");
                for (String name : pkeys) {
                    buffer.append(" ").append(name);
                }
            }
            if (this.generateMethods.contains(METHOD_TO_STRING) && !strs.isEmpty()) {
                buffer.append("\n    ").append(METHOD_TO_STRING).append(" :::");
                for (String name : strs) {
                    buffer.append(" ").append(name);
                }
            }
            buffer.append("\n  }\n");
        }
        return buffer.toString();
    }

    private String tableToCamelCase(String value) {
        if (value == null) {
            return null;
        }
        String[] parts = value.split("_");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (camelCaseString.length() == 0) {
                camelCaseString = part.length() > 1 ? String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase() : String.valueOf(camelCaseString) + part.toUpperCase();
            } else if (part.length() == 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.toUpperCase();
            } else if (part.length() > 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            }
            ++n2;
        }
        return String.valueOf(camelCaseString) + this.suffix;
    }

    private String columnToCamelCase(String value) {
        if (value == null) {
            return null;
        }
        String[] parts = value.split("_");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (camelCaseString.length() == 0) {
                camelCaseString = String.valueOf(camelCaseString) + part.toLowerCase();
            } else if (part.length() == 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.toUpperCase();
            } else if (part.length() > 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            }
            ++n2;
        }
        return camelCaseString;
    }

    private String columnToDbConv(String value) {
        if (value == null) {
            return null;
        }
        String result = "";
        int last = 0;
        int i = 0;
        int l = value.length();
        while (i < l) {
            if (Character.isUpperCase(value.charAt(i))) {
                result = String.valueOf(result) + value.substring(last, i).toUpperCase() + "_";
                last = i;
            }
            ++i;
        }
        if (last < value.length()) {
            result = String.valueOf(result) + value.substring(last).toUpperCase();
        }
        return result;
    }

    private PojoAttribute convertDbColumnDefinition(String dbName, PojoAttrType sqlType) {
        PojoAttribute attribute = new PojoAttribute();
        attribute.setName(this.columnToCamelCase(dbName));
        if (sqlType.getNativeType() != null) {
            attribute.setPrimitive(true);
            attribute.setClassName(String.valueOf(sqlType.getNativeType().substring(1)) + (sqlType.isArray() ? " []" : ""));
        } else if (sqlType.getRef() != null) {
            attribute.setPrimitive(false);
            attribute.setDependencyClassName(sqlType.getRef().getName());
            if (attribute.getDependencyClassName() == null) {
                attribute.setDependencyClassName(sqlType.getText());
            }
        } else {
            attribute.setPrimitive(false);
            attribute.setClassName(sqlType.getType().getIdentifier());
        }
        return attribute;
    }

    private PojoAttribute convertDbColumnDefinition(String table, DbColumn dbColumn) {
        PojoAttrType sqlType;
        if (dbColumn == null) {
            return null;
        }
        PojoAttrType pojoAttrType = sqlType = this.columnTypes.containsKey(table) ? this.columnTypes.get(table).get(dbColumn.getName()) : null;
        if (sqlType == null) {
            PojoAttrType pojoAttrType2 = sqlType = this.tableTypes.containsKey(table) ? this.tableTypes.get(table).get(String.valueOf(dbColumn.getType()) + dbColumn.getSize()) : null;
        }
        if (sqlType == null) {
            sqlType = this.sqlTypes.get(String.valueOf(dbColumn.getType()) + dbColumn.getSize());
        }
        if (sqlType == null) {
            return null;
        }
        PojoAttribute attribute = new PojoAttribute();
        attribute.setName(this.columnToCamelCase(dbColumn.getName()));
        attribute.setRequired(!dbColumn.isNullable());
        if (sqlType.getRef() != null) {
            attribute.setPrimitive(false);
            attribute.setDependencyClassName(sqlType.getRef().getName());
        } else if (sqlType.getNativeType() != null) {
            attribute.setPrimitive(true);
            attribute.setClassName(String.valueOf(sqlType.getNativeType().substring(1)) + (sqlType.isArray() ? " []" : ""));
        } else {
            attribute.setPrimitive(false);
            attribute.setClassName(sqlType.getType().getIdentifier());
        }
        return attribute;
    }

    private PojoAttribute convertDbColumnDefault(String table, DbColumn dbColumn) {
        if (dbColumn == null) {
            return null;
        }
        PojoAttribute attribute = new PojoAttribute();
        attribute.setName(this.columnToCamelCase(dbColumn.getName()));
        attribute.setRequired(!dbColumn.isNullable());
        switch (dbColumn.getSqlType()) {
            case -7: 
            case 16: {
                if (!dbColumn.isNullable()) {
                    attribute.setPrimitive(true);
                    attribute.setClassName(PrimitiveType.BOOLEAN.getName());
                    break;
                }
                attribute.setPrimitive(false);
                attribute.setClassName(Boolean.class.getName());
                break;
            }
            case -6: {
                if (!dbColumn.isNullable()) {
                    attribute.setPrimitive(true);
                    attribute.setClassName(PrimitiveType.BYTE.getName());
                    break;
                }
                attribute.setPrimitive(false);
                attribute.setClassName(Byte.class.getName());
                break;
            }
            case 5: {
                if (!dbColumn.isNullable()) {
                    attribute.setPrimitive(true);
                    attribute.setClassName(PrimitiveType.SHORT.getName());
                    break;
                }
                attribute.setPrimitive(false);
                attribute.setClassName(Short.class.getName());
                break;
            }
            case 4: {
                if (!dbColumn.isNullable()) {
                    attribute.setPrimitive(true);
                    attribute.setClassName(PrimitiveType.INT.getName());
                    break;
                }
                attribute.setPrimitive(false);
                attribute.setClassName(Integer.class.getName());
                break;
            }
            case -5: {
                if (!dbColumn.isNullable()) {
                    attribute.setPrimitive(true);
                    attribute.setClassName(PrimitiveType.LONG.getName());
                    break;
                }
                attribute.setPrimitive(false);
                attribute.setClassName(Long.class.getName());
                break;
            }
            case 6: 
            case 7: {
                if (!dbColumn.isNullable()) {
                    attribute.setPrimitive(true);
                    attribute.setClassName(PrimitiveType.FLOAT.getName());
                    break;
                }
                attribute.setPrimitive(false);
                attribute.setClassName(Float.class.getName());
                break;
            }
            case 8: {
                if (!dbColumn.isNullable()) {
                    attribute.setPrimitive(true);
                    attribute.setClassName(PrimitiveType.DOUBLE.getName());
                    break;
                }
                attribute.setPrimitive(false);
                attribute.setClassName(Double.class.getName());
                break;
            }
            case 2: {
                attribute.setPrimitive(false);
                attribute.setClassName(BigDecimal.class.getName());
                break;
            }
            case 3: {
                attribute.setPrimitive(false);
                if (dbColumn.getSize() < 3) {
                    attribute.setClassName(Byte.class.getName());
                    break;
                }
                if (dbColumn.getSize() < 5) {
                    attribute.setClassName(Short.class.getName());
                    break;
                }
                if (dbColumn.getSize() < 10) {
                    attribute.setClassName(Integer.class.getName());
                    break;
                }
                if (dbColumn.getSize() < 20) {
                    attribute.setClassName(Long.class.getName());
                    break;
                }
                attribute.setClassName(BigInteger.class.getName());
                break;
            }
            case -15: 
            case 1: {
                if (!dbColumn.isNullable() && dbColumn.getSize() == 1) {
                    attribute.setPrimitive(true);
                    attribute.setClassName(PrimitiveType.CHAR.getName());
                    break;
                }
                attribute.setPrimitive(false);
                attribute.setClassName(String.class.getName());
                break;
            }
            case -16: 
            case -9: 
            case 12: {
                attribute.setPrimitive(false);
                attribute.setClassName(String.class.getName());
                break;
            }
            case 91: {
                attribute.setPrimitive(false);
                attribute.setClassName(Date.class.getName());
                break;
            }
            case 92: {
                attribute.setPrimitive(false);
                attribute.setClassName(Time.class.getName());
                break;
            }
            case 93: {
                attribute.setPrimitive(false);
                attribute.setClassName(Timestamp.class.getName());
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.BYTE_ARRAY.getName());
                break;
            }
            case 2005: {
                attribute.setPrimitive(false);
                attribute.setClassName(String.class.getName());
                break;
            }
            default: {
                attribute.setPrimitive(false);
                if (dbColumn.getType().indexOf("TIMESTAMP") == 0 || dbColumn.getType().indexOf("timestamp") == 0) {
                    attribute.setClassName(Timestamp.class.getName());
                    break;
                }
                attribute.setClassName("java.lang.Object");
            }
        }
        return attribute;
    }

    private static enum PrimitiveType {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        CHAR,
        BYTE_ARRAY,
        CHAR_ARRAY;


        public String getName() {
            if (this == BYTE_ARRAY) {
                return "byte []";
            }
            if (this == CHAR_ARRAY) {
                return "char []";
            }
            return this.name().toLowerCase();
        }
    }
}

