/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.syntaxcoloring;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.nodemodel.util.NodeTreeIterator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.sqlproc.dsl.processorDsl.Column;
import org.sqlproc.dsl.processorDsl.ColumnUsage;
import org.sqlproc.dsl.processorDsl.ColumnUsageExt;
import org.sqlproc.dsl.processorDsl.Constant;
import org.sqlproc.dsl.processorDsl.ConstantUsage;
import org.sqlproc.dsl.processorDsl.ConstantUsageExt;
import org.sqlproc.dsl.processorDsl.DatabaseColumn;
import org.sqlproc.dsl.processorDsl.DatabaseTable;
import org.sqlproc.dsl.processorDsl.Identifier;
import org.sqlproc.dsl.processorDsl.IdentifierUsage;
import org.sqlproc.dsl.processorDsl.IdentifierUsageExt;
import org.sqlproc.dsl.processorDsl.MappingColumn;
import org.sqlproc.dsl.processorDsl.MappingItem;
import org.sqlproc.dsl.processorDsl.MappingRule;
import org.sqlproc.dsl.processorDsl.MappingUsage;
import org.sqlproc.dsl.processorDsl.MappingUsageExt;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.OptionalFeature;
import org.sqlproc.dsl.processorDsl.PackageDeclaration;
import org.sqlproc.dsl.processorDsl.PojoDefinition;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.processorDsl.TableUsage;
import org.sqlproc.dsl.resolver.PojoResolver;
import org.sqlproc.dsl.resolver.PojoResolverFactory;

public class SemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    public static final String CARET = "^";
    public static final String STRING = "$";
    @Inject
    PojoResolver pojoResolver;
    @Inject
    PojoResolverFactory pojoResolverFactory;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (this.pojoResolverFactory != null && this.pojoResolverFactory.getPojoResolver() == null) {
            this.pojoResolverFactory.setPojoResolver(this.pojoResolver);
        }
        if (resource == null) {
            return;
        }
        TreeIterator iter = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (iter.hasNext()) {
            PojoEntity gref;
            MappingRule rule;
            PojoDefinition pojo;
            MetaStatement statement;
            ColumnUsage usage;
            PojoDefinition pojo2;
            ICompositeNode node;
            ICompositeNode node2;
            EObject current = (EObject)iter.next();
            if (current instanceof MetaStatement) {
                MetaStatement statement2 = (MetaStatement)current;
                if (statement2.getName() == null) continue;
                node2 = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node2.getOffset(), statement2.getName().length(), new String[]{"name"});
                this.provideHighlightingForFilters((EList<String>)statement2.getFilters(), node2, acceptor);
                continue;
            }
            if (current instanceof MappingRule) {
                MappingRule rule2 = (MappingRule)current;
                if (rule2.getName() == null) continue;
                node2 = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node2.getOffset(), rule2.getName().length(), new String[]{"name"});
                this.provideHighlightingForFilters((EList<String>)rule2.getFilters(), node2, acceptor);
                continue;
            }
            if (current instanceof OptionalFeature) {
                OptionalFeature feature = (OptionalFeature)current;
                if (feature.getName() == null) continue;
                node2 = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node2.getOffset(), feature.getName().length(), new String[]{"name"});
                this.provideHighlightingForFilters((EList<String>)feature.getFilters(), node2, acceptor);
                continue;
            }
            if (current instanceof Constant) {
                node = NodeModelUtils.getNode((EObject)current);
                this.provideHighlightingForFragment("constant", node, acceptor);
                continue;
            }
            if (current instanceof Identifier) {
                node = NodeModelUtils.getNode((EObject)current);
                this.provideHighlightingForFragment("identifier", node, acceptor);
                continue;
            }
            if (current instanceof Column) {
                node = NodeModelUtils.getNode((EObject)current);
                this.provideHighlightingForFragment("column", node, acceptor);
                continue;
            }
            if (current instanceof MappingColumn) {
                node = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"column"});
                continue;
            }
            if (current instanceof MappingItem) {
                node = NodeModelUtils.getNode((EObject)current);
                this.provideHighlightingForMappingItem(node, acceptor);
                continue;
            }
            if (current instanceof DatabaseColumn) {
                node = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"dbcolumn"});
                continue;
            }
            if (current instanceof DatabaseTable) {
                node = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"dbtable"});
                continue;
            }
            if (current instanceof PojoDefinition) {
                node = NodeModelUtils.getNode((EObject)current);
                pojo2 = (PojoDefinition)current;
                this.provideHighlightingForPojo(null, pojo2.getName(), node, acceptor);
                continue;
            }
            if (current instanceof ColumnUsage) {
                node = NodeModelUtils.getNode((EObject)current);
                usage = (ColumnUsage)current;
                statement = usage.getStatement();
                pojo = usage.getPojo();
                if (statement == null || pojo == null) continue;
                this.provideHighlightingForPojo(statement.getName(), pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof IdentifierUsage) {
                node = NodeModelUtils.getNode((EObject)current);
                usage = (IdentifierUsage)current;
                statement = usage.getStatement();
                pojo = usage.getPojo();
                if (statement == null || pojo == null) continue;
                this.provideHighlightingForPojo(statement.getName(), pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof ConstantUsage) {
                node = NodeModelUtils.getNode((EObject)current);
                usage = (ConstantUsage)current;
                statement = usage.getStatement();
                pojo = usage.getPojo();
                if (statement == null || pojo == null) continue;
                this.provideHighlightingForPojo(statement.getName(), pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof MappingUsage) {
                node = NodeModelUtils.getNode((EObject)current);
                usage = (MappingUsage)current;
                rule = usage.getStatement();
                pojo = usage.getPojo();
                if (rule == null || pojo == null) continue;
                this.provideHighlightingForPojo(rule.getName(), pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof ColumnUsageExt) {
                node = NodeModelUtils.getNode((EObject)current);
                usage = (ColumnUsageExt)current;
                statement = usage.getStatement();
                pojo = usage.getPojo();
                if (statement == null || pojo == null) continue;
                this.provideHighlightingForPojoExt(statement.getName(), pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof IdentifierUsageExt) {
                node = NodeModelUtils.getNode((EObject)current);
                usage = (IdentifierUsageExt)current;
                statement = usage.getStatement();
                pojo = usage.getPojo();
                if (statement == null || pojo == null) continue;
                this.provideHighlightingForPojoExt(statement.getName(), pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof ConstantUsageExt) {
                node = NodeModelUtils.getNode((EObject)current);
                usage = (ConstantUsageExt)current;
                statement = usage.getStatement();
                pojo = usage.getPojo();
                if (statement == null || pojo == null) continue;
                this.provideHighlightingForPojoExt(statement.getName(), pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof MappingUsageExt) {
                node = NodeModelUtils.getNode((EObject)current);
                usage = (MappingUsageExt)current;
                rule = usage.getStatement();
                pojo = usage.getPojo();
                if (rule == null || pojo == null) continue;
                this.provideHighlightingForPojoExt(rule.getName(), pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof TableDefinition) {
                node = NodeModelUtils.getNode((EObject)current);
                TableDefinition table = (TableDefinition)current;
                this.provideHighlightingForTable(null, table.getName(), node, acceptor);
                continue;
            }
            if (current instanceof TableUsage) {
                node = NodeModelUtils.getNode((EObject)current);
                usage = (TableUsage)current;
                statement = usage.getStatement();
                TableDefinition table = usage.getTable();
                if (statement == null || table == null) continue;
                this.provideHighlightingForTable(statement.getName(), table.getName(), node, acceptor);
                continue;
            }
            if (current instanceof PackageDeclaration) {
                node = NodeModelUtils.getNode((EObject)current);
                PackageDeclaration pkg = (PackageDeclaration)current;
                this.provideHighlightingForPojoPackage(pkg.getName(), node, acceptor);
                continue;
            }
            if (current instanceof PojoEntity) {
                node = NodeModelUtils.getNode((EObject)current);
                pojo2 = (PojoEntity)current;
                this.provideHighlightingForPojoEntity(pojo2.getName(), node, acceptor);
                continue;
            }
            if (!(current instanceof PojoProperty)) continue;
            node = NodeModelUtils.getNode((EObject)current);
            PojoProperty property = (PojoProperty)current;
            this.provideHighlightingForPojoProperty(property.getName(), node, acceptor);
            PojoEntity ref = property.getRef();
            if (ref != null) {
                this.provideHighlightingForPojoEntity(ref.getName(), node, acceptor);
            }
            if ((gref = property.getGref()) == null) continue;
            this.provideHighlightingForPojoEntity(gref.getName(), node, acceptor);
        }
    }

    private void provideHighlightingForFilters(EList<String> filters, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (filters != null && !filters.isEmpty()) {
            int count = filters.size();
            NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
            while (iterator.hasNext()) {
                INode inode = (INode)iterator.next();
                if (!filters.contains((Object)inode.getText())) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"filter"});
                if (--count > 0) continue;
                return;
            }
        }
    }

    private void provideHighlightingForPojo(String name, String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (name != null && name.contains(inode.getText())) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (pojo == null) {
                    return;
                }
            }
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
            return;
        }
    }

    private void provideHighlightingForPojoExt(String name, String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (name != null && name.contains(inode.getText())) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (pojo == null) {
                    return;
                }
            }
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"entityName"});
            return;
        }
    }

    private void provideHighlightingForTypeDefinition(String definition, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (definition == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (definition == null || !definition.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"typeName"});
            return;
        }
    }

    private void provideHighlightingForPojoPackage(String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"packageName"});
            return;
        }
    }

    private void provideHighlightingForPojoEntity(String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"entityName"});
            return;
        }
    }

    private void provideHighlightingForPojoProperty(String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"propertyName"});
            return;
        }
    }

    private void provideHighlightingForTable(String name, String table, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && table == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (name != null && name.contains(inode.getText())) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (table == null) {
                    return;
                }
            }
            if (table == null || !table.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
            return;
        }
    }

    private void provideHighlightingForFragment(String defaultColor, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        int index = 0;
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (CARET.equals(inode.getText())) {
                ++index;
                continue;
            }
            switch (index) {
                case 1: {
                    acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"metatype"});
                    break;
                }
                case 2: {
                    acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"metaident"});
                    break;
                }
                default: {
                    acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{defaultColor});
                }
            }
        }
    }

    private void provideHighlightingForMappingItem(ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        int index = 0;
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (STRING.equals(inode.getText())) {
                ++index;
                continue;
            }
            switch (index) {
                case 1: {
                    acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"metatype"});
                    break;
                }
                default: {
                    acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
                }
            }
        }
    }
}

