/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.contentassist;

import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.ColumnUsage;
import org.sqlproc.dsl.processorDsl.ColumnUsageExt;
import org.sqlproc.dsl.processorDsl.ConstantUsage;
import org.sqlproc.dsl.processorDsl.ConstantUsageExt;
import org.sqlproc.dsl.processorDsl.ExportAssignement;
import org.sqlproc.dsl.processorDsl.IdentifierUsage;
import org.sqlproc.dsl.processorDsl.IdentifierUsageExt;
import org.sqlproc.dsl.processorDsl.ImportAssignement;
import org.sqlproc.dsl.processorDsl.InheritanceAssignement;
import org.sqlproc.dsl.processorDsl.ManyToManyAssignement;
import org.sqlproc.dsl.processorDsl.MappingRule;
import org.sqlproc.dsl.processorDsl.MappingUsage;
import org.sqlproc.dsl.processorDsl.MappingUsageExt;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.PojoDefinition;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.processorDsl.PojoUsage;
import org.sqlproc.dsl.processorDsl.PojoUsageExt;
import org.sqlproc.dsl.processorDsl.PojogenProperty;
import org.sqlproc.dsl.processorDsl.ProcessorDslPackage;
import org.sqlproc.dsl.processorDsl.ShowColumnTypeAssignement;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.processorDsl.TableUsage;
import org.sqlproc.dsl.resolver.DbExport;
import org.sqlproc.dsl.resolver.DbImport;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.PojoResolver;
import org.sqlproc.dsl.ui.contentassist.AbstractProcessorDslProposalProvider;
import org.sqlproc.dsl.util.Utils;

public class ProcessorDslProposalProvider
extends AbstractProcessorDslProposalProvider {
    @Inject
    PojoResolver pojoResolver;
    @Inject
    DbResolver dbResolver;
    private static final List<String> ON_OFF = Collections.unmodifiableList(Arrays.asList("ON", "OFF"));
    private static final List<String> STATEMEN_TYPE = Collections.unmodifiableList(Arrays.asList("QRY", "CRUD", "CALL"));
    private static final List<String> MAPPING_TYPE = Collections.unmodifiableList(Arrays.asList("OUT"));
    private static final List<String> OPTION_TYPE = Collections.unmodifiableList(Arrays.asList("OPT", "LOPT", "IOPT", "SOPT", "BOPT"));
    private static final List<String> TYPES = Collections.unmodifiableList(Arrays.asList("int", "integer", "long", "byte", "short", "float", "double", "character", "char", "string", "str", "time", "date", "datetime", "timestamp", "stamp", "bool", "boolean", "bigint", "biginteger", "bigdec", "bigdecimal", "bytearr", "bytearray", "bytes", "text", "blob", "clob", "einteger", "eint", "enumstring", "estring", "fromdate", "todate", "h_big_decimal", "h_big_integer", "h_blob", "h_boolean", "h_binary", "h_byte", "h_clob", "h_timestamp", "h_date", "h_double", "h_float", "h_date", "h_character", "h_integer", "h_long", "h_short", "h_string", "h_text", "h_timestamp", "h_time"));
    private static final List<String> F_TYPES = Collections.unmodifiableList(Arrays.asList("set", "update", "values", "where"));
    private static final List<String> IDENT_VALS = Collections.unmodifiableList(Arrays.asList("any", "null", "notnull", "seq", "seq=", "idsel", "idsel="));
    private static final List<String> COL_VALS = Collections.unmodifiableList(Arrays.asList("id"));
    private static final String[] methods = new String[]{"toString", "hashCode", "equals"};

    @Override
    public void completeMetaStatement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(STATEMEN_TYPE, "STATEMEN_TYPE", context, acceptor);
    }

    @Override
    public void completeMappingRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(MAPPING_TYPE, "MAPPING_TYPE", context, acceptor);
    }

    @Override
    public void completeOptionalFeature_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(OPTION_TYPE, "OPTION_TYPE", context, acceptor);
    }

    @Override
    public void completeColumn_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor);
    }

    @Override
    public void completeConstant_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor);
    }

    @Override
    public void completeIdentifier_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor);
    }

    @Override
    public void completeMappingItem_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor);
    }

    protected void addProposalList(List<String> values, String lexerRule, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            String proposal = this.getValueConverter().toString((Object)value, lexerRule);
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetaSql_Ftype(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(F_TYPES, "IDENT", context, acceptor);
    }

    @Override
    public void completeConstant_Vals(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(IDENT_VALS, "IDENT", context, acceptor);
    }

    @Override
    public void completeIdentifier_Vals(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(IDENT_VALS, "IDENT", context, acceptor);
    }

    @Override
    public void completeColumn_Vals(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(COL_VALS, "IDENT", context, acceptor);
    }

    @Override
    public void completeMappingColumn_Vals(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(COL_VALS, "IDENT", context, acceptor);
    }

    @Override
    public void completeColumn_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.completeUsage(model, assignment, context, acceptor, ProcessorDslPackage.Literals.COLUMN_USAGE.getName(), ProcessorDslPackage.Literals.COLUMN_USAGE_EXT.getName())) {
            super.completeColumn_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeConstant_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.completeUsage(model, assignment, context, acceptor, ProcessorDslPackage.Literals.CONSTANT_USAGE.getName(), ProcessorDslPackage.Literals.CONSTANT_USAGE_EXT.getName())) {
            super.completeConstant_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeIdentifier_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.completeUsage(model, assignment, context, acceptor, ProcessorDslPackage.Literals.IDENTIFIER_USAGE.getName(), ProcessorDslPackage.Literals.IDENTIFIER_USAGE_EXT.getName())) {
            super.completeIdentifier_Name(model, assignment, context, acceptor);
        }
    }

    public boolean completeUsage(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String name, String nameExt) {
        PojoEntity pojoEntity;
        if (!this.isResolvePojo(model)) {
            return false;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        PojoDefinition pojoDefinition = this.findPojo(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__USAGES), name, metaStatement.getName());
        PojoEntity pojoEntity2 = pojoEntity = pojoDefinition != null ? null : this.findEntity(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__USAGES_EXT), nameExt, metaStatement.getName());
        if (pojoDefinition == null && pojoEntity == null) {
            String proposal = this.getValueConverter().toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
            return true;
        }
        String prefix = context.getPrefix();
        int pos = prefix.lastIndexOf(46);
        prefix = pos > 0 ? prefix.substring(0, pos + 1) : "";
        if (pojoDefinition != null) {
            String clazz = this.getClassName(pojoDefinition.getClass_(), prefix);
            if (clazz == null) {
                return false;
            }
            PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz);
            if (descriptors == null) {
                return false;
            }
            PropertyDescriptor[] propertyDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                if (!"class".equals(descriptor.getName())) {
                    String proposal = this.getValueConverter().toString((Object)descriptor.getName(), "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(prefix) + proposal, context);
                    acceptor.accept(completionProposal);
                }
                ++n2;
            }
            return true;
        }
        List<PojoProperty> properties = this.getProperties(pojoEntity, null);
        if (properties.isEmpty()) {
            return false;
        }
        for (PojoProperty pojoProperty : properties) {
            String proposal = this.getValueConverter().toString((Object)pojoProperty.getName(), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(prefix) + proposal, context);
            acceptor.accept(completionProposal);
        }
        return true;
    }

    @Override
    public void completeMappingColumn_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String prefix;
        int pos;
        PojoEntity pojoEntity;
        if (!this.isResolvePojo(model)) {
            super.completeMappingColumn_Name(model, assignment, context, acceptor);
            return;
        }
        MappingRule mappingRule = (MappingRule)EcoreUtil2.getContainerOfType((EObject)model, MappingRule.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)mappingRule, Artifacts.class);
        PojoDefinition pojoDefinition = this.findPojo(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__USAGES), ProcessorDslPackage.Literals.MAPPING_USAGE.getName(), mappingRule.getName());
        PojoEntity pojoEntity2 = pojoEntity = pojoDefinition != null ? null : this.findEntity(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__USAGES_EXT), ProcessorDslPackage.Literals.MAPPING_USAGE_EXT.getName(), mappingRule.getName());
        if (pojoDefinition == null && pojoEntity == null) {
            String proposal = this.getValueConverter().toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        prefix = (pos = (prefix = context.getPrefix()).lastIndexOf(46)) > 0 ? prefix.substring(0, pos + 1) : "";
        if (pojoDefinition != null) {
            String clazz = this.getClassName(pojoDefinition.getClass_(), prefix);
            if (clazz == null) {
                return;
            }
            PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz);
            if (descriptors == null) {
                super.completeMappingColumn_Name(model, assignment, context, acceptor);
            } else {
                PropertyDescriptor[] propertyDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                    if (!"class".equals(descriptor.getName())) {
                        String proposal = this.getValueConverter().toString((Object)descriptor.getName(), "IDENT");
                        ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(prefix) + proposal, context);
                        acceptor.accept(completionProposal);
                    }
                    ++n2;
                }
            }
        } else {
            List<PojoProperty> properties = this.getProperties(pojoEntity, null);
            if (properties.isEmpty()) {
                return;
            }
            for (PojoProperty pojoProperty : properties) {
                String proposal = this.getValueConverter().toString((Object)pojoProperty.getName(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(prefix) + proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    List<PojoProperty> getProperties(PojoEntity pojoEntity, List<PojoProperty> inproperties) {
        ArrayList<PojoProperty> properties = inproperties != null ? inproperties : new ArrayList<PojoProperty>();
        for (PojoProperty pojoProperty : pojoEntity.getFeatures()) {
            properties.add(pojoProperty);
        }
        PojoEntity superType = Utils.getSuperType((PojoEntity)pojoEntity);
        if (superType != null) {
            return this.getProperties(superType, properties);
        }
        return properties;
    }

    protected PojoDefinition findPojo(ResourceSet resourceSet, IScope scope, String typeName, String name) {
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            PojoUsage pojoUsage;
            if (!typeName.equals(description.getEClass().getName()) || !name.equals(this.getUsageName((EObject)(pojoUsage = (PojoUsage)resourceSet.getEObject(description.getEObjectURI(), true))))) continue;
            return pojoUsage.getPojo();
        }
        return null;
    }

    protected PojoEntity findEntity(ResourceSet resourceSet, IScope scope, String typeName, String name) {
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            PojoUsageExt pojoUsage;
            if (!typeName.equals(description.getEClass().getName()) || !name.equals(this.getUsageName((EObject)(pojoUsage = (PojoUsageExt)resourceSet.getEObject(description.getEObjectURI(), true))))) continue;
            return pojoUsage.getPojo();
        }
        return null;
    }

    protected String getUsageName(EObject pojoUsage) {
        if (pojoUsage instanceof ColumnUsage) {
            return ((ColumnUsage)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof IdentifierUsage) {
            return ((IdentifierUsage)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof ConstantUsage) {
            return ((ConstantUsage)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof MappingUsage) {
            return ((MappingUsage)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof ColumnUsageExt) {
            return ((ColumnUsageExt)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof IdentifierUsageExt) {
            return ((IdentifierUsageExt)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof ConstantUsageExt) {
            return ((ConstantUsageExt)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof MappingUsageExt) {
            return ((MappingUsageExt)pojoUsage).getStatement().getName();
        }
        return "";
    }

    protected boolean isPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == String.class) {
            return true;
        }
        if (clazz == java.util.Date.class) {
            return true;
        }
        if (clazz == Date.class) {
            return true;
        }
        if (clazz == Time.class) {
            return true;
        }
        if (clazz == Timestamp.class) {
            return true;
        }
        if (clazz == Blob.class) {
            return true;
        }
        if (clazz == Clob.class) {
            return true;
        }
        if (clazz == BigDecimal.class) {
            return true;
        }
        return clazz == BigInteger.class;
    }

    protected String getClassName(String baseClass, String property) {
        PropertyDescriptor[] descriptors;
        int pos2;
        if (baseClass == null || property == null) {
            return baseClass;
        }
        int pos1 = property.indexOf(46);
        if (pos1 == -1) {
            return baseClass;
        }
        String checkProperty = property;
        pos1 = checkProperty.indexOf(61);
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(46, pos1)) > pos1) {
            checkProperty = String.valueOf(checkProperty.substring(0, pos1)) + checkProperty.substring(pos2);
        }
        String innerProperty = null;
        pos1 = checkProperty.indexOf(46);
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1);
            checkProperty = checkProperty.substring(0, pos1);
        }
        if ((descriptors = this.pojoResolver.getPropertyDescriptors(baseClass)) == null) {
            return null;
        }
        PropertyDescriptor innerDesriptor = null;
        PropertyDescriptor[] propertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            if (descriptor.getName().equals(checkProperty)) {
                innerDesriptor = descriptor;
                break;
            }
            ++n2;
        }
        if (innerDesriptor == null) {
            return null;
        }
        Class innerClass = innerDesriptor.getPropertyType();
        if (innerClass.isArray()) {
            ParameterizedType type = (ParameterizedType)innerDesriptor.getReadMethod().getGenericReturnType();
            if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0) {
                return null;
            }
            innerClass = (Class)type.getActualTypeArguments()[0];
            if (this.isPrimitive(innerClass)) {
                return null;
            }
            return this.getClassName(innerClass.getName(), innerProperty);
        }
        if (Collection.class.isAssignableFrom(innerClass)) {
            ParameterizedType type = (ParameterizedType)innerDesriptor.getReadMethod().getGenericReturnType();
            if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0) {
                return null;
            }
            innerClass = (Class)type.getActualTypeArguments()[0];
            if (this.isPrimitive(innerClass)) {
                return null;
            }
            return this.getClassName(innerClass.getName(), innerProperty);
        }
        if (this.isPrimitive(innerClass)) {
            return null;
        }
        return this.getClassName(innerClass.getName(), innerProperty);
    }

    protected boolean isResolvePojo(EObject model) {
        return this.pojoResolver.isResolvePojo(model);
    }

    protected boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    @Override
    public void completeTableDefinition_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeTableDefinition_Table(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void complete_DatabaseColumn(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.complete_DatabaseColumn(model, ruleCall, context, acceptor);
            return;
        }
        String prefix = context.getPrefix();
        int pos = prefix.indexOf(46);
        prefix = pos > 0 ? prefix.substring(0, pos) : null;
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        TableDefinition tableDefinition = this.getTableDefinition(artifacts, metaStatement, prefix);
        if (tableDefinition != null && tableDefinition.getTable() != null) {
            for (String column : this.dbResolver.getColumns(model, tableDefinition.getTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                String completion = prefix != null ? String.valueOf(prefix) + '.' + proposal : proposal;
                ICompletionProposal completionProposal = this.createCompletionProposal(completion, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    protected TableDefinition getTableDefinition(Artifacts artifacts, MetaStatement statement, String prefix) {
        TableUsage usage = null;
        IScope scope = this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLE_USAGES);
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            TableUsage tableUsage;
            if (!ProcessorDslPackage.Literals.TABLE_USAGE.getName().equals(description.getEClass().getName()) || !(tableUsage = (TableUsage)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true)).getStatement().getName().equals(statement.getName())) continue;
            if (prefix == null && tableUsage.getPrefix() == null) {
                usage = tableUsage;
                break;
            }
            if (prefix == null || !prefix.equals(tableUsage.getPrefix())) continue;
            usage = tableUsage;
            break;
        }
        if (usage != null && usage.getTable() != null && usage.getTable().getName() != null) {
            scope = this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES);
            iterable = scope.getAllElements();
            for (IEObjectDescription description : iterable) {
                if (!ProcessorDslPackage.Literals.TABLE_DEFINITION.getName().equals(description.getEClass().getName())) continue;
                TableDefinition tableDefinition = (TableDefinition)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
                if (!usage.getTable().getName().equals(tableDefinition.getName())) continue;
                return tableDefinition;
            }
        }
        return null;
    }

    @Override
    public void complete_DatabaseTable(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.complete_DatabaseTable(model, ruleCall, context, acceptor);
            return;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        IScope scope = this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLE_USAGES);
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            TableUsage tableUsage;
            if (!ProcessorDslPackage.Literals.TABLE_USAGE.getName().equals(description.getEClass().getName()) || !(tableUsage = (TableUsage)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true)).getStatement().getName().equals(metaStatement.getName())) continue;
            String proposal = this.getValueConverter().toString((Object)tableUsage.getTable().getTable(), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completePojogenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completePojogenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeInheritanceAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeInheritanceAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completePojogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completePojogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completePojogenProperty_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completePojogenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeColumnAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeColumnAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeImportAssignement_PkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)imp, PojogenProperty.class);
        if (prop.getDbTable() != null && imp.getDbColumn() != null) {
            for (DbImport dbImport : this.dbResolver.getDbImports(model, prop.getDbTable())) {
                if (dbImport.getFkColumn() == null || !dbImport.getFkColumn().equals(imp.getDbColumn())) continue;
                String proposal = this.getValueConverter().toString((Object)dbImport.getPkTable(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeImportAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)imp, PojogenProperty.class);
        if (prop.getDbTable() != null && imp.getDbColumn() != null & imp.getPkTable() != null) {
            for (DbImport dbImport : this.dbResolver.getDbImports(model, prop.getDbTable())) {
                if (dbImport.getFkColumn() == null || !dbImport.getFkColumn().equals(imp.getDbColumn()) || dbImport.getPkTable() == null || !dbImport.getPkTable().equals(imp.getPkTable())) continue;
                String proposal = this.getValueConverter().toString((Object)dbImport.getPkColumn(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeImportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeImportAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeExportAssignement_FkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkTable(model, assignment, context, acceptor);
            return;
        }
        ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)exp, PojogenProperty.class);
        if (prop.getDbTable() != null && exp.getDbColumn() != null) {
            for (DbExport dbExport : this.dbResolver.getDbExports(model, prop.getDbTable())) {
                if (dbExport.getPkColumn() == null || !dbExport.getPkColumn().equals(exp.getDbColumn())) continue;
                String proposal = this.getValueConverter().toString((Object)dbExport.getFkTable(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeExportAssignement_FkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkColumn(model, assignment, context, acceptor);
            return;
        }
        ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)exp, PojogenProperty.class);
        if (prop.getDbTable() != null && exp.getDbColumn() != null & exp.getFkTable() != null) {
            for (DbExport dbExport : this.dbResolver.getDbExports(model, prop.getDbTable())) {
                if (dbExport.getPkColumn() == null || !dbExport.getPkColumn().equals(exp.getDbColumn()) || dbExport.getFkTable() == null || !dbExport.getFkTable().equals(exp.getFkTable())) continue;
                String proposal = this.getValueConverter().toString((Object)dbExport.getFkColumn(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeExportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeExportAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeManyToManyAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeManyToManyAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (DbImport dbImport : this.dbResolver.getDbImports(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)dbImport.getPkColumn(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeManyToManyAssignement_PkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof ManyToManyAssignement)) {
            super.completeManyToManyAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        ManyToManyAssignement many2 = (ManyToManyAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)many2, PojogenProperty.class);
        if (prop.getDbTable() != null && many2.getPkColumn() != null) {
            for (DbImport dbImport : this.dbResolver.getDbImports(model, prop.getDbTable())) {
                if (dbImport.getPkColumn() == null || !dbImport.getPkColumn().equals(many2.getPkColumn())) continue;
                String proposal = this.getValueConverter().toString((Object)dbImport.getPkTable(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeInheritanceAssignement_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof InheritanceAssignement)) {
            super.completeInheritanceAssignement_DbColumns(model, assignment, context, acceptor);
            return;
        }
        InheritanceAssignement cfr_ignored_0 = (InheritanceAssignement)model;
        PojogenProperty pojogenProperty = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (pojogenProperty.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, pojogenProperty.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completePojogenProperty_Methods(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof PojogenProperty)) {
            super.completePojogenProperty_Methods(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty cfr_ignored_0 = (PojogenProperty)model;
        String[] stringArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            String proposal = this.getValueConverter().toString((Object)method, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
            ++n2;
        }
    }

    @Override
    public void completeShowColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeShowColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeShowColumnTypeAssignement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof ShowColumnTypeAssignement)) {
            super.completeShowColumnTypeAssignement_Type(model, assignment, context, acceptor);
            return;
        }
        ShowColumnTypeAssignement prop = (ShowColumnTypeAssignement)model;
        PojogenProperty pojogenProperty = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String table = pojogenProperty.getDbTable();
        String column = prop.getDbColumn();
        String type = this.dbResolver.getType(model, table, column);
        String proposal = this.getValueConverter().toString((Object)type, "PropertyValue");
        ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(completionProposal);
    }

    @Override
    public void completeJoinTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeJoinTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeJoinTableAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeJoinTableAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }
}

