/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.templates;

import com.google.inject.Inject;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.ui.editor.templates.DefaultTemplateProposalProvider;
import org.sqlproc.dsl.processorDsl.SqlFragment;
import org.sqlproc.dsl.services.ProcessorDslGrammarAccess;

public class ProcessorTemplateProposalProvider
extends DefaultTemplateProposalProvider {
    ContextTypeIdHelper helper;
    @Inject
    ProcessorDslGrammarAccess ga;

    @Inject
    public ProcessorTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
        this.helper = helper;
    }

    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        super.createTemplates(templateContext, context, acceptor);
        String id = this.helper.getId((AbstractRule)this.ga.getSqlValueRule());
        if (templateContext.getContextType().getId().equals(id) && (context.getPreviousModel() == null || context.getPreviousModel() instanceof SqlFragment)) {
            Template template = new Template("ins", "CRUD insert statement", "uniqueTemplateID", "\n  insert into ${dbTable}\n  (${dbInsertColumn})\n  {= values (${pojoColumn}) }\n", false);
            TemplateProposal tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("sel", "CRUD select statement", "uniqueTemplateID", "\n  select ${dbSelectColumn}\n  from ${dbTable}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("upd", "CRUD update statement", "uniqueTemplateID", "\n  update ${dbTable}\n  {= set (${dbUpdateColumn})}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("upd-opt", "CRUD optimistic update statement", "uniqueTemplateID", "\n  update ${dbTable}\n  {= set (${dbVerUpdateColumn}${dbOptUpdateColumn})}\n  {= where${dbOptCondColumn}\n  }\n", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("del", "CRUD delete statement", "uniqueTemplateID", "\n  delete from ${dbTable}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
        String idDef = this.helper.getId((AbstractRule)this.ga.getOptionalFeatureRule());
        if (templateContext.getContextType().getId().equals(idDef)) {
            Template template = new Template("pojos", "Pojo definitions", "uniqueTemplateID", "${pojoDefinitions}", false);
            TemplateProposal tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("tables", "Table definitions", "uniqueTemplateID", "${tableDefinitions}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
    }
}

