/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.templates;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContextType;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.ProcessorDslPackage;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.processorDsl.TableUsage;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.PojoResolver;

public class ProcessorDslTemplateContextType
extends XtextTemplateContextType {
    @Inject
    PojoResolver pojoResolver;
    @Inject
    DbResolver dbResolver;
    @Inject
    IScopeProvider scopeProvider;

    protected void addDefaultTemplateVariables() {
        super.addDefaultTemplateVariables();
        super.addResolver((TemplateVariableResolver)new DbTableResolver());
        super.addResolver((TemplateVariableResolver)new PojoColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbSelectColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbInsertColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbUpdateColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbCondColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbVerUpdateColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbOptUpdateColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbOptCondColumnResolver());
        super.addResolver((TemplateVariableResolver)new PojoDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new TableDefinitionsResolver());
    }

    protected Artifacts getArtifacts(XtextTemplateContext xtextTemplateContext) {
        if (xtextTemplateContext == null) {
            return null;
        }
        EObject object = xtextTemplateContext.getContentAssistContext().getCurrentModel();
        return (Artifacts)EcoreUtil2.getContainerOfType((EObject)object, Artifacts.class);
    }

    protected MetaStatement getMetaStatement(XtextTemplateContext xtextTemplateContext) {
        if (xtextTemplateContext == null) {
            return null;
        }
        EObject object = xtextTemplateContext.getContentAssistContext().getCurrentModel();
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)object, MetaStatement.class);
        return statement;
    }

    protected TableDefinition getTableDefinition(MetaStatement statement) {
        if (statement == null) {
            return null;
        }
        TableUsage usage = null;
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)statement, Artifacts.class);
        IScope scope = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLE_USAGES);
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            TableUsage tableUsage;
            if (!ProcessorDslPackage.Literals.TABLE_USAGE.getName().equals(description.getEClass().getName()) || !(tableUsage = (TableUsage)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true)).getStatement().getName().equals(statement.getName())) continue;
            usage = tableUsage;
            break;
        }
        if (usage != null && usage.getTable() != null && usage.getTable().getName() != null) {
            scope = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES);
            iterable = scope.getAllElements();
            for (IEObjectDescription description : iterable) {
                if (!ProcessorDslPackage.Literals.TABLE_DEFINITION.getName().equals(description.getEClass().getName())) continue;
                TableDefinition tableDefinition = (TableDefinition)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
                if (!usage.getTable().getName().equals(tableDefinition.getName())) continue;
                return tableDefinition;
            }
        }
        return null;
    }

    protected String toCamelCase(String value) {
        if (value == null) {
            return null;
        }
        String[] parts = value.split("_");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (camelCaseString.length() == 0) {
                camelCaseString = String.valueOf(camelCaseString) + part.toLowerCase();
            } else if (part.length() == 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.toUpperCase();
            } else if (part.length() > 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            }
            ++n2;
        }
        return camelCaseString;
    }

    protected String toCamelCase(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String camelCaseString = clazz.getSimpleName();
        if (camelCaseString.length() == 1) {
            camelCaseString = camelCaseString.toLowerCase();
        } else if (camelCaseString.length() > 1) {
            camelCaseString = String.valueOf(camelCaseString.substring(0, 1).toLowerCase()) + camelCaseString.substring(1);
        }
        return camelCaseString;
    }

    protected String getPojoColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append(':').append(this.toCamelCase(columns.get(i)));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getSelectColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append(columns.get(i)).append(" @").append(this.toCamelCase(columns.get(i)));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getInsertColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append(columns.get(i));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getUpdateColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append(columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i)));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getCondColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append("\n  {& ").append(columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" }");
            ++i;
        }
        return builder.toString();
    }

    protected String getVerUpdateColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            if (columns.get(i).toUpperCase().indexOf("VER") == 0) {
                builder.append(columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" + 1, ");
                break;
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getOptUpdateColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        boolean idFind = false;
        boolean verFind = false;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            if (!idFind && (columns.get(i).toUpperCase().equals("ID") || columns.get(i).toUpperCase().indexOf("ID_") == 0)) {
                idFind = true;
            } else if (!verFind && columns.get(i).toUpperCase().indexOf("VER") == 0) {
                verFind = true;
            } else {
                builder.append(columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i)));
                if (i < columns.size() - 1) {
                    builder.append(", ");
                }
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getOptCondColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        boolean idFind = false;
        boolean verFind = false;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            if (!idFind && (columns.get(i).toUpperCase().equals("ID") || columns.get(i).toUpperCase().indexOf("ID_") == 0)) {
                idFind = true;
                builder.append("\n  {& ").append(columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" }");
            } else if (!verFind && columns.get(i).toUpperCase().indexOf("VER") == 0) {
                verFind = true;
                builder.append("\n  {& ").append(columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" }");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getPojoDefinitions(List<Class<?>> pojoClasses) {
        if (pojoClasses == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Class<?> clazz : pojoClasses) {
            map.put(this.toCamelCase(clazz), clazz.getName());
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry pojo : map.entrySet()) {
            builder.append("pojo ").append((String)pojo.getKey()).append(' ').append((String)pojo.getValue()).append(";\n");
        }
        return builder.toString();
    }

    protected String getTableDefinitions(List<String> tables) {
        if (tables == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String table : tables) {
            map.put(this.toCamelCase(table), table);
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry table : map.entrySet()) {
            builder.append("table ").append((String)table.getKey()).append(' ').append((String)table.getValue()).append(";\n");
        }
        return builder.toString();
    }

    public class DbCondColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbCondColumn";

        public DbCondColumnResolver() {
            super(NAME, "DbCondColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getCondColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbInsertColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbInsertColumn";

        public DbInsertColumnResolver() {
            super(NAME, "DbInsertColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getInsertColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbOptCondColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbOptCondColumn";

        public DbOptCondColumnResolver() {
            super(NAME, "DbOptCondColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getOptCondColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbOptUpdateColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbOptUpdateColumn";

        public DbOptUpdateColumnResolver() {
            super(NAME, "DbOptUpdateColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getOptUpdateColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbSelectColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbSelectColumn";

        public DbSelectColumnResolver() {
            super(NAME, "DbSelectColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getSelectColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbTableResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbTable";

        public DbTableResolver() {
            super(NAME, "DbTable");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                return tableDefinition.getTable();
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbUpdateColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbUpdateColumn";

        public DbUpdateColumnResolver() {
            super(NAME, "DbUpdateColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getUpdateColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbVerUpdateColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbVerUpdateColumn";

        public DbVerUpdateColumnResolver() {
            super(NAME, "DbVerUpdateColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getVerUpdateColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class PojoColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "pojoColumn";

        public PojoColumnResolver() {
            super(NAME, "PojoColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getPojoColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class PojoDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "pojoDefinitions";

        public PojoDefinitionsResolver() {
            super(NAME, "PojoDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorDslTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorDslTemplateContextType.this.pojoResolver.isResolvePojo((EObject)artifacts)) {
                List pojoClasses = ProcessorDslTemplateContextType.this.pojoResolver.getPojoClasses();
                return ProcessorDslTemplateContextType.this.getPojoDefinitions(pojoClasses);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class TableDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "tableDefinitions";

        public TableDefinitionsResolver() {
            super(NAME, "TableDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorDslTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                List tables = ProcessorDslTemplateContextType.this.dbResolver.getTables((EObject)artifacts);
                return ProcessorDslTemplateContextType.this.getTableDefinitions(tables);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }
}

