/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.syntaxcoloring;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class HighlightingConfiguration
extends DefaultHighlightingConfiguration {
    public static final String PUNCTATION = "punctation";
    public static final String TYPE = "type";
    public static final String DEFAULT = "default";
    public static final String NAME = "name";
    public static final String COMMENT = "comment";
    public static final String CONSTANT = "constant";
    public static final String IDENTIFIER = "identifier";
    public static final String COLUMN = "column";
    public static final String DATABASE_COLUMN = "dbcolumn";
    public static final String DATABASE_TABLE = "dbtable";
    public static final String FILTER = "filter";
    public static final String META_TYPE = "metatype";
    public static final String META_IDENT = "metaident";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        acceptor.acceptDefaultHighlighting(PUNCTATION, "Control characters", this.punctationStyle());
        acceptor.acceptDefaultHighlighting(TYPE, "Artifact type", this.typeStyle());
        acceptor.acceptDefaultHighlighting(COMMENT, "Comment", this.commentStyle());
        acceptor.acceptDefaultHighlighting(DEFAULT, "Default", this.defaultStyle());
        acceptor.acceptDefaultHighlighting(CONSTANT, "Constant", this.constantStyle());
        acceptor.acceptDefaultHighlighting(IDENTIFIER, "Identifier", this.identifierStyle());
        acceptor.acceptDefaultHighlighting(COLUMN, "Column", this.columnStyle());
        acceptor.acceptDefaultHighlighting(DATABASE_COLUMN, "Database column", this.databaseColumnStyle());
        acceptor.acceptDefaultHighlighting(DATABASE_TABLE, "Database table", this.databaseTableStyle());
        acceptor.acceptDefaultHighlighting(NAME, "Artifact name", this.nameStyle());
        acceptor.acceptDefaultHighlighting(FILTER, "Filters", this.filterStyle());
        acceptor.acceptDefaultHighlighting(META_TYPE, "Meta type", this.metaTypeStyle());
        acceptor.acceptDefaultHighlighting(META_IDENT, "Meta identifier", this.metaIdentStyle());
    }

    public TextStyle punctationStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(100, 100, 100));
        return textStyle;
    }

    public TextStyle typeStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setStyle(2);
        return textStyle;
    }

    public TextStyle constantStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(42, 0, 255));
        return textStyle;
    }

    public TextStyle columnStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(42, 0, 255));
        return textStyle;
    }

    public TextStyle identifierStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(42, 0, 255));
        return textStyle;
    }

    public TextStyle databaseColumnStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(165, 42, 42));
        return textStyle;
    }

    public TextStyle databaseTableStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(165, 42, 42));
        return textStyle;
    }

    public TextStyle metatTypeStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(139, 105, 20));
        return textStyle;
    }

    public TextStyle commentStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(63, 127, 95));
        return textStyle;
    }

    public TextStyle defaultStyle() {
        TextStyle textStyle = new TextStyle();
        textStyle.setStyle(0);
        textStyle.setColor(new RGB(0, 0, 0));
        return textStyle;
    }

    public TextStyle nameStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(127, 0, 85));
        textStyle.setStyle(1);
        return textStyle;
    }

    public TextStyle filterStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setStyle(2);
        return textStyle;
    }

    public TextStyle metaTypeStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(210, 105, 30));
        return textStyle;
    }

    public TextStyle metaIdentStyle() {
        TextStyle textStyle = this.defaultStyle();
        textStyle.setColor(new RGB(34, 139, 34));
        return textStyle;
    }
}

