/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.outline;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.Column;
import org.sqlproc.dsl.processorDsl.Constant;
import org.sqlproc.dsl.processorDsl.DatabaseColumn;
import org.sqlproc.dsl.processorDsl.Identifier;
import org.sqlproc.dsl.processorDsl.MappingColumn;
import org.sqlproc.dsl.processorDsl.MappingRule;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.OptionalFeature;
import org.sqlproc.dsl.util.Collector;

public class ProcessorDslOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    protected void _createChildren(DocumentRootNode parentNode, EObject rootElement) {
        Artifacts artifacts = (Artifacts)rootElement;
        if (artifacts.getFeatures() != null) {
            for (OptionalFeature optionalFeature : artifacts.getFeatures()) {
                this.createNode((IOutlineNode)parentNode, (EObject)optionalFeature);
            }
        }
        if (artifacts.getStatements() != null) {
            for (MetaStatement metaStatement : artifacts.getStatements()) {
                this.createNode((IOutlineNode)parentNode, (EObject)metaStatement);
            }
        }
        if (artifacts.getMappings() != null) {
            for (MappingRule mappingRule : artifacts.getMappings()) {
                this.createNode((IOutlineNode)parentNode, (EObject)mappingRule);
            }
        }
    }

    protected void _createChildren(IOutlineNode parentNode, EObject modelElement) {
        block11: {
            block10: {
                if (!(modelElement instanceof MetaStatement)) break block10;
                TreeSet<Identifier> identifiers = new TreeSet<Identifier>(new Comparator<Identifier>(){

                    @Override
                    public int compare(Identifier o1, Identifier o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                TreeSet<Constant> constants = new TreeSet<Constant>(new Comparator<Constant>(){

                    @Override
                    public int compare(Constant o1, Constant o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                TreeSet<Column> columns = new TreeSet<Column>(new Comparator<Column>(){

                    @Override
                    public int compare(Column o1, Column o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                TreeSet<DatabaseColumn> databaseColumns = new TreeSet<DatabaseColumn>(new Comparator<DatabaseColumn>(){

                    @Override
                    public int compare(DatabaseColumn o1, DatabaseColumn o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                Collector.allVariables((MetaStatement)((MetaStatement)modelElement), identifiers, constants, columns, databaseColumns);
                if (!identifiers.isEmpty()) {
                    for (Identifier identifier : identifiers) {
                        this.createNode(parentNode, (EObject)identifier);
                    }
                }
                if (!constants.isEmpty()) {
                    for (Constant constant : constants) {
                        this.createNode(parentNode, (EObject)constant);
                    }
                }
                if (!columns.isEmpty()) {
                    for (Column column : columns) {
                        this.createNode(parentNode, (EObject)column);
                    }
                }
                if (databaseColumns.isEmpty()) break block11;
                for (DatabaseColumn databaseColumn : databaseColumns) {
                    this.createNode(parentNode, (EObject)databaseColumn);
                }
                break block11;
            }
            if (modelElement instanceof MappingRule) {
                TreeSet<MappingColumn> columns = new TreeSet<MappingColumn>(new Comparator<MappingColumn>(){

                    @Override
                    public int compare(MappingColumn o1, MappingColumn o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                Collector.allVariables((MappingRule)((MappingRule)modelElement), columns);
                if (!columns.isEmpty()) {
                    for (MappingColumn column : columns) {
                        this.createNode(parentNode, (EObject)column);
                    }
                }
            }
        }
    }

    protected boolean _isLeaf(MetaStatement metaStatement) {
        return false;
    }

    protected boolean _isLeaf(MappingRule mappingRule) {
        return false;
    }

    protected boolean _isLeaf(OptionalFeature optionalFeature) {
        return true;
    }

    protected boolean _isLeaf(Identifier identifier) {
        return true;
    }

    protected boolean _isLeaf(Constant constant) {
        return true;
    }

    protected boolean _isLeaf(Column column) {
        return true;
    }

    protected boolean _isLeaf(DatabaseColumn column) {
        return true;
    }

    protected boolean _isLeaf(MappingColumn column) {
        return true;
    }
}

