/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.contentassist;

import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.ColumnUsage;
import org.sqlproc.dsl.processorDsl.ConstantUsage;
import org.sqlproc.dsl.processorDsl.IdentifierUsage;
import org.sqlproc.dsl.processorDsl.MappingRule;
import org.sqlproc.dsl.processorDsl.MappingUsage;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.PojoDefinition;
import org.sqlproc.dsl.processorDsl.PojoUsage;
import org.sqlproc.dsl.processorDsl.ProcessorDslPackage;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.processorDsl.TableUsage;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.PojoResolver;
import org.sqlproc.dsl.ui.contentassist.AbstractProcessorDslProposalProvider;

public class ProcessorDslProposalProvider
extends AbstractProcessorDslProposalProvider {
    @Inject
    PojoResolver pojoResolver;
    @Inject
    DbResolver dbResolver;
    private static final List<String> ON_OFF = Collections.unmodifiableList(Arrays.asList("ON", "OFF"));
    private static final List<String> STATEMEN_TYPE = Collections.unmodifiableList(Arrays.asList("QRY", "CRUD", "CALL"));
    private static final List<String> MAPPING_TYPE = Collections.unmodifiableList(Arrays.asList("OUT"));
    private static final List<String> OPTION_TYPE = Collections.unmodifiableList(Arrays.asList("OPT", "LOPT", "IOPT", "SOPT", "BOPT"));
    private static final List<String> TYPES = Collections.unmodifiableList(Arrays.asList("int", "integer", "long", "byte", "short", "float", "double", "character", "char", "string", "str", "time", "date", "datetime", "timestamp", "stamp", "bool", "boolean", "bigint", "biginteger", "bigdec", "bigdecimal", "bytearr", "bytearray", "bytes", "text", "blob", "clob", "einteger", "eint", "enumstring", "estring", "fromdate", "todate", "h_big_decimal", "h_big_integer", "h_blob", "h_boolean", "h_binary", "h_byte", "h_clob", "h_timestamp", "h_date", "h_double", "h_float", "h_date", "h_character", "h_integer", "h_long", "h_short", "h_string", "h_text", "h_timestamp", "h_time"));
    private static final List<String> F_TYPES = Collections.unmodifiableList(Arrays.asList("set", "update", "values", "where"));
    private static final List<String> IDENT_VALS = Collections.unmodifiableList(Arrays.asList("any", "null", "notnull", "seq", "seq=", "idsel", "idsel="));
    private static final List<String> COL_VALS = Collections.unmodifiableList(Arrays.asList("id"));

    @Override
    public void completeProperty_DoResolvePojo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(ON_OFF, "ON_OFF", context, acceptor);
    }

    @Override
    public void completeProperty_DoResolveDb(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(ON_OFF, "ON_OFF", context, acceptor);
    }

    @Override
    public void completeMetaStatement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(STATEMEN_TYPE, "STATEMEN_TYPE", context, acceptor);
    }

    @Override
    public void completeMappingRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(MAPPING_TYPE, "MAPPING_TYPE", context, acceptor);
    }

    @Override
    public void completeOptionalFeature_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(OPTION_TYPE, "OPTION_TYPE", context, acceptor);
    }

    @Override
    public void completeColumn_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor);
    }

    @Override
    public void completeConstant_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor);
    }

    @Override
    public void completeIdentifier_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor);
    }

    @Override
    public void completeMappingItem_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor);
    }

    protected void addProposalList(List<String> values, String lexerRule, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            String proposal = this.getValueConverter().toString((Object)value, lexerRule);
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetaSql_Ftype(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(F_TYPES, "IDENT", context, acceptor);
    }

    @Override
    public void completeConstant_Vals(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(IDENT_VALS, "IDENT", context, acceptor);
    }

    @Override
    public void completeIdentifier_Vals(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(IDENT_VALS, "IDENT", context, acceptor);
    }

    @Override
    public void completeColumn_Vals(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(COL_VALS, "IDENT", context, acceptor);
    }

    @Override
    public void completeMappingColumn_Vals(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(COL_VALS, "IDENT", context, acceptor);
    }

    @Override
    public void completeColumn_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.completeUsage(model, assignment, context, acceptor, ProcessorDslPackage.Literals.COLUMN_USAGE.getName())) {
            super.completeColumn_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeConstant_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.completeUsage(model, assignment, context, acceptor, ProcessorDslPackage.Literals.CONSTANT_USAGE.getName())) {
            super.completeConstant_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeIdentifier_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.completeUsage(model, assignment, context, acceptor, ProcessorDslPackage.Literals.IDENTIFIER_USAGE.getName())) {
            super.completeIdentifier_Name(model, assignment, context, acceptor);
        }
    }

    public boolean completeUsage(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String name) {
        if (!this.isResolvePojo(model)) {
            return false;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        IScope scope = this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__USAGES);
        PojoDefinition pojoDefinition = this.findPojo(artifacts.eResource().getResourceSet(), scope, name, metaStatement.getName());
        if (pojoDefinition == null) {
            String proposal = this.getValueConverter().toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
            return true;
        }
        String prefix = context.getPrefix();
        int pos = prefix.lastIndexOf(46);
        prefix = pos > 0 ? prefix.substring(0, pos + 1) : "";
        String clazz = this.getClassName(pojoDefinition.getClass_(), prefix);
        if (clazz == null) {
            return false;
        }
        PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz);
        if (descriptors == null) {
            return false;
        }
        PropertyDescriptor[] propertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            if (!"class".equals(descriptor.getName())) {
                String proposal = this.getValueConverter().toString((Object)descriptor.getName(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(prefix) + proposal, context);
                acceptor.accept(completionProposal);
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void completeMappingColumn_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String prefix;
        int pos;
        if (!this.isResolvePojo(model)) {
            super.completeMappingColumn_Name(model, assignment, context, acceptor);
            return;
        }
        MappingRule mappingRule = (MappingRule)EcoreUtil2.getContainerOfType((EObject)model, MappingRule.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)mappingRule, Artifacts.class);
        IScope scope = this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__USAGES);
        PojoDefinition pojoDefinition = this.findPojo(artifacts.eResource().getResourceSet(), scope, ProcessorDslPackage.Literals.MAPPING_USAGE.getName(), mappingRule.getName());
        if (pojoDefinition == null) {
            String proposal = this.getValueConverter().toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        prefix = (pos = (prefix = context.getPrefix()).lastIndexOf(46)) > 0 ? prefix.substring(0, pos + 1) : "";
        String clazz = this.getClassName(pojoDefinition.getClass_(), prefix);
        if (clazz == null) {
            return;
        }
        PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz);
        if (descriptors == null) {
            super.completeMappingColumn_Name(model, assignment, context, acceptor);
        } else {
            PropertyDescriptor[] propertyDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                if (!"class".equals(descriptor.getName())) {
                    String proposal = this.getValueConverter().toString((Object)descriptor.getName(), "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(prefix) + proposal, context);
                    acceptor.accept(completionProposal);
                }
                ++n2;
            }
        }
    }

    protected PojoDefinition findPojo(ResourceSet resourceSet, IScope scope, String typeName, String name) {
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            PojoUsage pojoUsage;
            if (!typeName.equals(description.getEClass().getName()) || !name.equals(this.getUsageName((EObject)(pojoUsage = (PojoUsage)resourceSet.getEObject(description.getEObjectURI(), true))))) continue;
            return pojoUsage.getPojo();
        }
        return null;
    }

    protected String getUsageName(EObject pojoUsage) {
        if (pojoUsage instanceof ColumnUsage) {
            return ((ColumnUsage)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof IdentifierUsage) {
            return ((IdentifierUsage)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof ConstantUsage) {
            return ((ConstantUsage)pojoUsage).getStatement().getName();
        }
        if (pojoUsage instanceof MappingUsage) {
            return ((MappingUsage)pojoUsage).getStatement().getName();
        }
        return "";
    }

    protected boolean isPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == String.class) {
            return true;
        }
        if (clazz == java.util.Date.class) {
            return true;
        }
        if (clazz == Date.class) {
            return true;
        }
        if (clazz == Time.class) {
            return true;
        }
        if (clazz == Timestamp.class) {
            return true;
        }
        if (clazz == Blob.class) {
            return true;
        }
        if (clazz == Clob.class) {
            return true;
        }
        if (clazz == BigDecimal.class) {
            return true;
        }
        return clazz == BigInteger.class;
    }

    protected String getClassName(String baseClass, String property) {
        PropertyDescriptor[] descriptors;
        int pos2;
        if (baseClass == null || property == null) {
            return baseClass;
        }
        int pos1 = property.indexOf(46);
        if (pos1 == -1) {
            return baseClass;
        }
        String checkProperty = property;
        pos1 = checkProperty.indexOf(61);
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(46, pos1)) > pos1) {
            checkProperty = String.valueOf(checkProperty.substring(0, pos1)) + checkProperty.substring(pos2);
        }
        String innerProperty = null;
        pos1 = checkProperty.indexOf(46);
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1);
            checkProperty = checkProperty.substring(0, pos1);
        }
        if ((descriptors = this.pojoResolver.getPropertyDescriptors(baseClass)) == null) {
            return null;
        }
        PropertyDescriptor innerDesriptor = null;
        PropertyDescriptor[] propertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            if (descriptor.getName().equals(checkProperty)) {
                innerDesriptor = descriptor;
                break;
            }
            ++n2;
        }
        if (innerDesriptor == null) {
            return null;
        }
        Class innerClass = innerDesriptor.getPropertyType();
        if (innerClass.isArray()) {
            ParameterizedType type = (ParameterizedType)innerDesriptor.getReadMethod().getGenericReturnType();
            if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0) {
                return null;
            }
            innerClass = (Class)type.getActualTypeArguments()[0];
            if (this.isPrimitive(innerClass)) {
                return null;
            }
            return this.getClassName(innerClass.getName(), innerProperty);
        }
        if (Collection.class.isAssignableFrom(innerClass)) {
            ParameterizedType type = (ParameterizedType)innerDesriptor.getReadMethod().getGenericReturnType();
            if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0) {
                return null;
            }
            innerClass = (Class)type.getActualTypeArguments()[0];
            if (this.isPrimitive(innerClass)) {
                return null;
            }
            return this.getClassName(innerClass.getName(), innerProperty);
        }
        if (this.isPrimitive(innerClass)) {
            return null;
        }
        return this.getClassName(innerClass.getName(), innerProperty);
    }

    protected boolean isResolvePojo(EObject model) {
        return this.pojoResolver.isResolvePojo(model);
    }

    protected boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    @Override
    public void completeTableDefinition_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeTableDefinition_Table(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void complete_DatabaseColumn(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.complete_DatabaseColumn(model, ruleCall, context, acceptor);
            return;
        }
        String prefix = context.getPrefix();
        int pos = prefix.indexOf(46);
        prefix = pos > 0 ? prefix.substring(0, pos) : null;
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        TableDefinition tableDefinition = this.getTableDefinition(artifacts, metaStatement, prefix);
        if (tableDefinition != null && tableDefinition.getTable() != null) {
            for (String column : this.dbResolver.getColumns(model, tableDefinition.getTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                String completion = prefix != null ? String.valueOf(prefix) + '.' + proposal : proposal;
                ICompletionProposal completionProposal = this.createCompletionProposal(completion, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    protected TableDefinition getTableDefinition(Artifacts artifacts, MetaStatement statement, String prefix) {
        TableUsage usage = null;
        IScope scope = this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLE_USAGES);
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            TableUsage tableUsage;
            if (!ProcessorDslPackage.Literals.TABLE_USAGE.getName().equals(description.getEClass().getName()) || !(tableUsage = (TableUsage)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true)).getStatement().getName().equals(statement.getName())) continue;
            if (prefix == null && tableUsage.getPrefix() == null) {
                usage = tableUsage;
                break;
            }
            if (prefix == null || !prefix.equals(tableUsage.getPrefix())) continue;
            usage = tableUsage;
            break;
        }
        if (usage != null && usage.getTable() != null && usage.getTable().getName() != null) {
            scope = this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES);
            iterable = scope.getAllElements();
            for (IEObjectDescription description : iterable) {
                if (!ProcessorDslPackage.Literals.TABLE_DEFINITION.getName().equals(description.getEClass().getName())) continue;
                TableDefinition tableDefinition = (TableDefinition)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
                if (!usage.getTable().getName().equals(tableDefinition.getName())) continue;
                return tableDefinition;
            }
        }
        return null;
    }

    @Override
    public void complete_DatabaseTable(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.complete_DatabaseTable(model, ruleCall, context, acceptor);
            return;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        IScope scope = this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLE_USAGES);
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            TableUsage tableUsage;
            if (!ProcessorDslPackage.Literals.TABLE_USAGE.getName().equals(description.getEClass().getName()) || !(tableUsage = (TableUsage)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true)).getStatement().getName().equals(metaStatement.getName())) continue;
            String proposal = this.getValueConverter().toString((Object)tableUsage.getTable().getTable(), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }
}

