/*
 * generated by Xtext
 */
package org.sqlproc.dsl.validation
import org.eclipse.xtext.validation.Check

import static org.sqlproc.dsl.util.Constants.*

import java.lang.reflect.Modifier
import java.lang.reflect.ParameterizedType
import java.util.Collection
import java.util.List

import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.naming.IQualifiedNameConverter
import org.eclipse.xtext.scoping.IScopeProvider
import org.sqlproc.dsl.processorDsl.AbstractPojoEntity
import org.sqlproc.dsl.processorDsl.Artifacts
import org.sqlproc.dsl.processorDsl.Column
import org.sqlproc.dsl.processorDsl.Constant
import org.sqlproc.dsl.processorDsl.DatabaseColumn
import org.sqlproc.dsl.processorDsl.DatabaseTable
import org.sqlproc.dsl.processorDsl.EnumEntity
import org.sqlproc.dsl.processorDsl.EnumProperty
import org.sqlproc.dsl.processorDsl.FunctionDefinition
import org.sqlproc.dsl.processorDsl.Identifier
import org.sqlproc.dsl.processorDsl.MappingColumn
import org.sqlproc.dsl.processorDsl.MappingRule
import org.sqlproc.dsl.processorDsl.MetaSql
import org.sqlproc.dsl.processorDsl.MetaStatement
import org.sqlproc.dsl.processorDsl.OptionalFeature
import org.sqlproc.dsl.processorDsl.Package
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty
import org.sqlproc.dsl.processorDsl.PojoDao
import org.sqlproc.dsl.processorDsl.PojoDefinition
import org.sqlproc.dsl.processorDsl.PojoEntity
import org.sqlproc.dsl.processorDsl.PojoProperty
import org.sqlproc.dsl.processorDsl.ProcedureDefinition
import org.sqlproc.dsl.processorDsl.ProcessorDslPackage
import org.sqlproc.dsl.processorDsl.Property
import org.sqlproc.dsl.processorDsl.TableDefinition
import org.sqlproc.dsl.property.ModelProperty
import org.sqlproc.dsl.resolver.DbResolver
import org.sqlproc.dsl.resolver.PojoResolverFactory
import org.sqlproc.dsl.util.Utils

import com.google.inject.Inject

import static extension org.eclipse.xtext.EcoreUtil2.*
import static extension org.eclipse.emf.ecore.util.EcoreUtil.*
import org.sqlproc.dsl.generator.ProcessorGeneratorUtils
import org.sqlproc.dsl.processorDsl.DirectiveProperties
import org.sqlproc.dsl.processorDsl.PojoDirective

enum ValidationResult {
	OK, WARNING, ERROR
}

/**
 * Custom validation rules. 
 *
 * see http://www.eclipse.org/Xtext/documentation.html#validation
 */
class ProcessorDslValidator extends AbstractProcessorDslValidator {

    @Inject
    PojoResolverFactory pojoResolverFactory

    @Inject
    DbResolver dbResolver

    @Inject
    IScopeProvider scopeProvider

    @Inject
    IQualifiedNameConverter qualifiedNameConverter

    @Inject
    ModelProperty modelProperty

	@Inject extension ProcessorGeneratorUtils

    val F_TYPES = <String>newArrayList("set", "update", "values", "where", "columns", "set=opt", "where=opt")

    @Check
    def checkMetaSqlFtype(MetaSql metaSql) {
        if (metaSql.getFtype() == null)
            return;
        if (!findInListIgnoreCase(F_TYPES, metaSql.getFtype())) {
            error("Invalid ftype : " + metaSql.getFtype(), ProcessorDslPackage.Literals.META_SQL__FTYPE)
        }
    }

    def findInListIgnoreCase(List<String> list, String value) {
        if (list == null)
            return false
        for (String item : list) {
            if (item.equalsIgnoreCase(value))
                return true
        }
        return false
    }

    @Check
    def checkUniqueMetaStatement(MetaStatement metaStatement) {
        if (!(metaStatement.rootContainer instanceof Artifacts))
            return
        val artifacts = metaStatement.rootContainer as Artifacts
        for (MetaStatement metaStmt : artifacts.getStatements()) {
            if (metaStmt != null && metaStmt !== metaStatement) {
	            if (equalsStatement(metaStatement, metaStmt)) {
	                error("Duplicate name : " + metaStatement.getName() + "[" + metaStatement.getType() + "]",
	                        ProcessorDslPackage.Literals.META_STATEMENT__NAME)
	                return
	            }
            }
        }
    }

    @Check
    def checkUniqueMappingRule(MappingRule mappingRule) {
        if (!(mappingRule.rootContainer instanceof Artifacts))
            return
        val artifacts = mappingRule.rootContainer as Artifacts
        for (MappingRule rule : artifacts.getMappings()) {
            if (rule != null && rule !== mappingRule) {
	            if (equalsRule(mappingRule, rule)) {
	                error("Duplicate name : " + mappingRule.getName() + "[" + mappingRule.getType() + "]",
	                        ProcessorDslPackage.Literals.MAPPING_RULE__NAME)
	                return
	            }
            }
        }
    }

    @Check
    def checkUniqueOptionalFeature(OptionalFeature optionalFeature) {
        if (!(optionalFeature.rootContainer instanceof Artifacts))
            return
        val artifacts = optionalFeature.rootContainer as Artifacts
        for (OptionalFeature feature : artifacts.getFeatures()) {
            if (feature != null && feature != optionalFeature) {
	            if (equalsFeature(optionalFeature, feature)) {
	                error("Duplicate name : " + optionalFeature.getName() + "[" + optionalFeature.getType() + "]",
	                        ProcessorDslPackage.Literals.OPTIONAL_FEATURE__NAME)
	                return
	            }
            }
        }
    }

    @Check
    def checkUniquePojoDefinition(PojoDefinition pojoDefinition) {
        if (isResolvePojo(pojoDefinition) && !checkClass(getClass(pojoDefinition)))
            error("Class name : " + getClass(pojoDefinition) + " not exists",
                    ProcessorDslPackage.Literals.POJO_DEFINITION__NAME)
        if (!(pojoDefinition.rootContainer instanceof Artifacts))
            return
        val artifacts = pojoDefinition.rootContainer as Artifacts
        for (PojoDefinition definition : artifacts.getPojos()) {
            if (definition != null && definition !== pojoDefinition) {
	            if (pojoDefinition.getName().equals(definition.getName())) {
	                error("Duplicate name : " + pojoDefinition.getName(),
	                        ProcessorDslPackage.Literals.POJO_DEFINITION__NAME)
	                return
	            }
            }
        }
    }

    def equalsStatement(MetaStatement statement1, MetaStatement statement2) {
        if (statement1 == null && statement2 == null)
            return true
        if (statement1 == null || statement1.getName() == null)
            return false
        if (statement2 == null || statement2.getName() == null)
            return false
        if (statement1.getName().equals(statement2.getName()) && statement1.getType().equals(statement2.getType())) {
            return equalsModifiers(statement1.getModifiers(), statement2.getModifiers())
        }
        return false
    }

    def equalsRule(MappingRule rule1, MappingRule rule2) {
        if (rule1 == null && rule2 == null)
            return true
        if (rule1 == null || rule1.getName() == null)
            return false
        if (rule2 == null || rule2.getName() == null)
            return false
        if (rule1.getName().equals(rule2.getName()) && rule1.getType().equals(rule2.getType())) {
            return equalsModifiers(rule1.getModifiers(), rule2.getModifiers())
        }
        return false
    }

    def equalsFeature(OptionalFeature feature1, OptionalFeature feature2) {
        if (feature1 == null && feature2 == null)
            return true
        if (feature1 == null || feature1.getName() == null)
            return false
        if (feature2 == null || feature2.getName() == null)
            return false
        if (feature1.getName().equals(feature2.getName()) && feature1.getType().equals(feature2.getType())) {
            return equalsModifiers(feature1.getModifiers(), feature2.getModifiers())
        }
        return false
    }

    def equalsModifiers(List<String> modifiers1, List<String> modifiers2) {
        val filteredModifiers1 = filteredModifiers(modifiers1)
        val filteredModifiers2 = filteredModifiers(modifiers2)
        if (filteredModifiers1 == null && filteredModifiers2 == null)
            return true
        if (filteredModifiers1 == null)
            return false
        if (filteredModifiers2 == null)
            return false
        if (filteredModifiers1.isEmpty() && filteredModifiers2.isEmpty())
            return true
        // Filtry musi byt disjunktni, pro jednu shodu je vysledek komparace kladny
        for (String modifier1 : filteredModifiers1)
            for (String modifier2 : filteredModifiers2)
                if (modifier1.equals(modifier2))
                    return true
        return false
    }

    def List<String> filteredModifiers(List<String> modifiers) {
        if (modifiers == null)
            return null
        val filteredModifiers = <String>newArrayList()
        modifiers.forEach[modifier |
            if (modifier.indexOf('=') < 0)
                filteredModifiers.add(modifier)
        ]
        return filteredModifiers
    }

    def checkClass(String className) {
        if (className == null || pojoResolverFactory.getPojoResolver() == null)
            return true

        val clazz = pojoResolverFactory.getPojoResolver().loadClass(className)
        return clazz != null
    }

    def isResolvePojo(EObject model) {
        if (pojoResolverFactory.getPojoResolver() == null
                || !pojoResolverFactory.getPojoResolver().isResolvePojo(model))
            return false
        return true

    }

    def isResolveDb(EObject model) {
        return dbResolver.isResolveDb(model)
    }

    def String getClass(PojoDefinition pojo) {
        if (pojo.getClassx() != null)
            return pojo.getClassx().getQualifiedName()
        return pojo.getClass_()
    }

    @Check
    def checkColumn(Column column) {
        if (!isResolvePojo(column))
            return
        val columnName = Utils.getName(column)
        if (Utils.isNumber(columnName))
            return
        val statement = column.getContainerOfType(typeof(MetaStatement))
        val artifacts = statement.getContainerOfType(typeof(Artifacts))
        
        val entityName = Utils.getTokenFromModifier(statement, COLUMN_USAGE_EXTENDED)
        val entity = if (entityName != null) Utils.findEntity(qualifiedNameConverter, artifacts,
                scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PACKAGES), entityName)
        if (entity != null) {
            switch (checkEntityProperty(entity, columnName)) {
            case ValidationResult.WARNING:
                warning("Problem property : " + columnName + "[" + entity.getName() + "]",
                        ProcessorDslPackage.Literals.COLUMN__COLUMNS)
            case ValidationResult.ERROR:
                error("Cannot find property : " + columnName + "[" + entity.getName() + "]",
                        ProcessorDslPackage.Literals.COLUMN__COLUMNS)
            }
            return
        }

        val pojoName = Utils.getTokenFromModifier(statement, COLUMN_USAGE)
        val pojo = if (pojoName != null) Utils.findPojo(qualifiedNameConverter, artifacts,
                scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), pojoName)
        val columnUsageClass = if (pojo != null) getClass(pojo)
        if (columnUsageClass != null) {
            switch (checkClassProperty(columnUsageClass, columnName)) {
            case ValidationResult.WARNING:
                warning("Problem property : " + columnName + "[" + columnUsageClass + "]",
                        ProcessorDslPackage.Literals.COLUMN__COLUMNS)
            case ValidationResult.ERROR:
                error("Cannot find property : " + columnName + "[" + columnUsageClass + "]",
                        ProcessorDslPackage.Literals.COLUMN__COLUMNS)
            }
            return
        }

        if (pojoResolverFactory.getPojoResolver() != null) {
            error("Cannot check result class attribute : " + columnName, ProcessorDslPackage.Literals.COLUMN__COLUMNS)
        }
    }

    @Check
    def checkIdentifier(Identifier identifier) {
        if (!isResolvePojo(identifier))
            return
        val identifierName = identifier.getName()
        val statement = identifier.getContainerOfType(typeof(MetaStatement))
        val artifacts = statement.getContainerOfType(typeof(Artifacts))

        val entityName = Utils.getTokenFromModifier(statement, IDENTIFIER_USAGE_EXTENDED)
        val entity = if (entityName != null) Utils.findEntity(qualifiedNameConverter, artifacts,
                scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PACKAGES), entityName)
        if (entity != null) {
            switch (checkEntityProperty(entity, identifierName)) {
            case ValidationResult.WARNING:
                warning("Problem property : " + identifierName + "[" + entity.getName() + "]",
                        ProcessorDslPackage.Literals.IDENTIFIER__NAME)
            case ValidationResult.ERROR:
                error("Cannot find property : " + identifierName + "[" + entity.getName() + "]",
                        ProcessorDslPackage.Literals.IDENTIFIER__NAME)
            }
            return
        }

        val pojoName = Utils.getTokenFromModifier(statement, IDENTIFIER_USAGE)
        val pojo = if (pojoName != null) Utils.findPojo(qualifiedNameConverter, artifacts,
                scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), pojoName)
        val identifierUsageClass = if (pojo != null) getClass(pojo)
        if (identifierUsageClass != null) {
            switch (checkClassProperty(identifierUsageClass, identifierName)) {
            case ValidationResult.WARNING:
                warning("Problem property : " + identifierName + "[" + identifierUsageClass + "]",
                        ProcessorDslPackage.Literals.IDENTIFIER__NAME)
            case ValidationResult.ERROR:
                error("Cannot find property : " + identifierName + "[" + identifierUsageClass + "]",
                        ProcessorDslPackage.Literals.IDENTIFIER__NAME)
            }
            return
        }

        if (pojoResolverFactory.getPojoResolver() != null) {
            error("Cannot check input form attribute : " + identifierName,
                    ProcessorDslPackage.Literals.IDENTIFIER__NAME)
        }
    }

    @Check
    def checkConstant(Constant constant) {
        if (!isResolvePojo(constant))
            return
        val statement = constant.getContainerOfType(typeof(MetaStatement))
        val artifacts = statement.getContainerOfType(typeof(Artifacts))

        val entityName = Utils.getTokenFromModifier(statement, CONSTANT_USAGE_EXTENDED)
        val entity = if (entityName != null) Utils.findEntity(qualifiedNameConverter, artifacts,
                scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PACKAGES), entityName)
        if (entity != null) {
            switch (checkEntityProperty(entity, constant.getName())) {
            case ValidationResult.WARNING:
                warning("Problem property : " + constant.getName() + "[" + entity.getName() + "]",
                        ProcessorDslPackage.Literals.CONSTANT__NAME)
            case ValidationResult.ERROR:
                error("Cannot find property : " + constant.getName() + "[" + entity.getName() + "]",
                        ProcessorDslPackage.Literals.CONSTANT__NAME)
            }
            return
        }

        val pojoName = Utils.getTokenFromModifier(statement, CONSTANT_USAGE)
        val pojo = if (pojoName != null) Utils.findPojo(qualifiedNameConverter, artifacts,
                scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), pojoName)
        val constantUsageClass = if (pojo != null) getClass(pojo)
        if (constantUsageClass != null) {
            switch (checkClassProperty(constantUsageClass, constant.getName())) {
            case ValidationResult.WARNING:
                warning("Problem property : " + constant.getName() + "[" + constantUsageClass + "]",
                        ProcessorDslPackage.Literals.CONSTANT__NAME)
            case ValidationResult.ERROR:
                error("Cannot find property : " + constant.getName() + "[" + constantUsageClass + "]",
                        ProcessorDslPackage.Literals.CONSTANT__NAME)
            }
            return
        }

        if (pojoResolverFactory.getPojoResolver() != null) {
            error("Cannot check constant form attribute : " + constant.getName(),
                    ProcessorDslPackage.Literals.CONSTANT__NAME)
        }
    }

    @Check
    def checkMappingColumn(MappingColumn column) {
        if (!isResolvePojo(column))
            return
        val columnName = Utils.getName(column)
        if (Utils.isNumber(columnName))
            return
        val rule = column.getContainerOfType(typeof(MetaStatement))
        val artifacts = rule.getContainerOfType(typeof(Artifacts))

        val entityName = Utils.getTokenFromModifier(rule, MAPPING_USAGE_EXTENDED)
        val entity = if (entityName != null) Utils.findEntity(qualifiedNameConverter, artifacts,
                scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PACKAGES), entityName)
        if (entity != null) {
            switch (checkEntityProperty(entity, columnName)) {
            case ValidationResult.WARNING:
                warning("Problem property : " + columnName + "[" + entity.getName() + "]",
                        ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS)
            case ValidationResult.ERROR:
                error("Cannot find property : " + columnName + "[" + entity.getName() + "]",
                        ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS)
            }
            return
        }

        val pojoName = Utils.getTokenFromModifier(rule, MAPPING_USAGE)
        val pojo = if (pojoName != null) Utils.findPojo(qualifiedNameConverter, artifacts,
                scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), pojoName)
        val mappingUsageClass = if (pojo != null) getClass(pojo)
        if (mappingUsageClass != null) {
            switch (checkClassProperty(mappingUsageClass, columnName)) {
            case ValidationResult.WARNING:
                warning("Problem property : " + columnName + "[" + mappingUsageClass + "]",
                        ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS)
            case ValidationResult.ERROR:
                error("Cannot find property : " + columnName + "[" + mappingUsageClass + "]",
                        ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS)

            }
            return
        }

        if (pojoResolverFactory.getPojoResolver() != null) {
            error("Cannot check result class attribute : " + columnName,
                    ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS)
        }
    }

    @Check
    def checkMetaStatement(MetaStatement statement) {
        val artifacts = statement.getContainerOfType(typeof(Artifacts))

        if (statement.getModifiers() == null || statement.getModifiers().isEmpty())
            return

        var index = 0
        for (String modifier : statement.getModifiers()) {
            var ix = modifier.indexOf('=')
            if (ix > 0) {
	            val key = modifier.substring(0, ix)
	            var value = modifier.substring(ix + 1)
	            if (IDENTIFIER_USAGE_EXTENDED.equals(key)) {
	                val entity = Utils.findEntity(qualifiedNameConverter, artifacts,
	                        scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PACKAGES), value)
	                if (entity == null) {
	                    error("Cannot find entity : " + value + "[" + IDENTIFIER_USAGE_EXTENDED + "]",
	                            ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	            } else if (IDENTIFIER_USAGE.equals(key)) {
	                val pojo = Utils.findPojo(qualifiedNameConverter, artifacts,
	                        scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), value)
	                if (pojo == null) {
	                    error("Cannot find pojo : " + value + "[" + IDENTIFIER_USAGE + "]",
	                            ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	            } else if (COLUMN_USAGE_EXTENDED.equals(key)) {
	                val entity = Utils.findEntity(qualifiedNameConverter, artifacts,
	                        scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PACKAGES), value)
	                if (entity == null) {
	                    error("Cannot find entity : " + value + "[" + COLUMN_USAGE_EXTENDED + "]",
	                            ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	            } else if (COLUMN_USAGE.equals(key)) {
	                val pojo = Utils.findPojo(qualifiedNameConverter, artifacts,
	                        scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), value)
	                if (pojo == null) {
	                    error("Cannot find pojo : " + value + "[" + COLUMN_USAGE + "]",
	                            ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	            } else if (CONSTANT_USAGE_EXTENDED.equals(key)) {
	                val entity = Utils.findEntity(qualifiedNameConverter, artifacts,
	                        scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PACKAGES), value)
	                if (entity == null) {
	                    error("Cannot find entity : " + value + "[" + CONSTANT_USAGE_EXTENDED + "]",
	                            ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	            } else if (CONSTANT_USAGE.equals(key)) {
	                val pojo = Utils.findPojo(qualifiedNameConverter, artifacts,
	                        scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), value)
	                if (pojo == null) {
	                    error("Cannot find pojo : " + value + "[" + CONSTANT_USAGE + "]",
	                            ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	            } else if (TABLE_USAGE.equals(key)) {
	                var ix1 = value.indexOf('=')
	                if (ix1 >= 0)
	                    value = value.substring(0, ix1)
	                val table = Utils.findTable(qualifiedNameConverter, artifacts,
	                        scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES), value)
	                if (table == null) {
	                    error("Cannot find table : " + value + "[" + TABLE_USAGE + "]",
	                            ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	            }
	            index = index + 1
            }
        }
    }

    @Check
    def checkMappingRule(MappingRule rule) {
        if (rule.getModifiers() == null || rule.getModifiers().isEmpty())
            return

        val artifacts = rule.getContainerOfType(typeof(Artifacts))
        var index = 0
        for (String modifier : rule.getModifiers()) {
            var ix = modifier.indexOf('=')
            if (ix > 0) {
	            val key = modifier.substring(0, ix)
	            val value = modifier.substring(ix + 1)
	            if (MAPPING_USAGE_EXTENDED.equals(key)) {
	                val entity = Utils.findEntity(qualifiedNameConverter, artifacts,
	                        scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PACKAGES), value)
	                if (entity == null) {
	                    error("Cannot find entity : " + value + "[" + MAPPING_USAGE_EXTENDED + "]",
	                            ProcessorDslPackage.Literals.MAPPING_RULE__MODIFIERS, index)
	                }
	            } else if (MAPPING_USAGE.equals(key)) {
	                val pojo = Utils.findPojo(qualifiedNameConverter, artifacts,
	                        scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), value)
	                if (pojo == null) {
	                    error("Cannot find pojo : " + value + "[" + MAPPING_USAGE + "]",
	                            ProcessorDslPackage.Literals.MAPPING_RULE__MODIFIERS, index)
	                }
	            }
	            index = index + 1
	        }
        }
    }

    def isNumber(String param) {
        if (param == null)
            return false
        var i = param.length() - 1
        while(i >= 0) {
            if (!Character.isDigit(param.charAt(i)))
                return false
            i = i - 1
        }
        return true
    }

    def isPrimitive(Class<?> clazz) {
        if (clazz == null)
            return true
        if (clazz == typeof(String))
            return true
        if (clazz == typeof(java.util.Date))
            return true
        if (clazz == typeof(java.sql.Date))
            return true
        if (clazz == typeof(java.sql.Time))
            return true
        if (clazz == typeof(java.sql.Timestamp))
            return true
        if (clazz == typeof(java.sql.Blob))
            return true
        if (clazz == typeof(java.sql.Clob))
            return true
        if (clazz == typeof(java.math.BigDecimal))
            return true
        if (clazz == typeof(java.math.BigInteger))
            return true
        return false
    }

    def ValidationResult checkClassProperty(String className, String property) {
        if (property == null || isNumber(property) || pojoResolverFactory.getPojoResolver() == null)
            return ValidationResult.OK
        if (className == null)
            return ValidationResult.ERROR
        var descriptors = pojoResolverFactory.getPojoResolver().getPropertyDescriptors(className)
        if (descriptors == null) {
            return ValidationResult.WARNING
        }
        var checkProperty = property
        var pos1 = checkProperty.indexOf('=')
        if (pos1 > 0) {
            var pos2 = checkProperty.indexOf('.', pos1)
            if (pos2 > pos1)
                checkProperty = checkProperty.substring(0, pos1) + checkProperty.substring(pos2)
        }
        var innerProperty = null as String
        pos1 = checkProperty.indexOf('.')
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1)
            checkProperty = checkProperty.substring(0, pos1)
        }
        val _checkProperty = checkProperty
        var innerDesriptor = descriptors.findFirst[descriptor |
            descriptor.name == _checkProperty
        ]
        if (innerDesriptor == null) {
            val clazz = pojoResolverFactory.getPojoResolver().loadClass(className)
            if (clazz != null && Modifier.isAbstract(clazz.getModifiers()))
                return ValidationResult.WARNING
            return ValidationResult.ERROR
        }
        if (innerProperty != null) {
            var innerClass = innerDesriptor.getPropertyType()
            if (innerClass.isArray()) {
                val type = innerDesriptor.getReadMethod().getGenericReturnType() as ParameterizedType
                if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0)
                    return ValidationResult.WARNING
                innerClass = type.getActualTypeArguments().head as Class<?>
                if (isPrimitive(innerClass))
                    return ValidationResult.ERROR
                return checkClassProperty(innerClass.getName(), innerProperty)
            } else if (typeof(Collection).isAssignableFrom(innerClass)) {
                val type = innerDesriptor.getReadMethod().getGenericReturnType() as ParameterizedType
                if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0)
                    return ValidationResult.WARNING
                innerClass = type.getActualTypeArguments().head as Class<?>
                if (isPrimitive(innerClass))
                    return ValidationResult.ERROR
                return checkClassProperty(innerClass.getName(), innerProperty)
            } else {
                if (isPrimitive(innerClass))
                    return ValidationResult.ERROR
                return checkClassProperty(innerClass.getName(), innerProperty)
            }
        }
        return ValidationResult.OK
    }

    def ValidationResult checkEntityProperty(PojoEntity entity, String property) {
        if (property == null || isNumber(property))
            return ValidationResult.OK
        var checkProperty = property
        var pos1 = checkProperty.indexOf('=')
        if (pos1 > 0) {
            var pos2 = checkProperty.indexOf('.', pos1)
            if (pos2 > pos1)
                checkProperty = checkProperty.substring(0, pos1) + checkProperty.substring(pos2)
        }
        var innerProperty = null as String
        pos1 = checkProperty.indexOf('.')
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1)
            checkProperty = checkProperty.substring(0, pos1)
        }

        for (PojoAnnotatedProperty apojoProperty : entity.getFeatures()) {
            var pojoProperty = apojoProperty.getFeature()
            if (pojoProperty.getName().equals(checkProperty)) {
                if (innerProperty == null)
                    return ValidationResult.OK
                if (pojoProperty.getRef() != null) {
                    if (pojoProperty.getRef() instanceof PojoEntity) {
                        return checkEntityProperty(pojoProperty.getRef() as PojoEntity, innerProperty)
                    }
                    return ValidationResult.OK
                }
                if (pojoProperty.getGref() != null)
                    return checkEntityProperty(pojoProperty.getGref(), innerProperty)
                return ValidationResult.ERROR
            }
        }
        var superType = getSuperType(entity)
        if (superType != null) {
            var result = checkEntityProperty(superType, property)
            if (result == ValidationResult.WARNING || result == ValidationResult.OK)
                return result
        }
        if (isAbstract(entity)) {
            return ValidationResult.WARNING
        }
        else {
            val suppressedAbstracts = modelProperty.getNotAbstractTables(entity)
            if (suppressedAbstracts != null && suppressedAbstracts.contains(Utils.dbName(entity))) {
                return ValidationResult.WARNING
            }
            else {
                return ValidationResult.ERROR
            }
        }
    }

    @Check
    def checkUniqueProperty(Property property) {
        if (!(property.rootContainer instanceof Artifacts))
            return
        val artifacts = property.rootContainer as Artifacts
        for (Property prop : artifacts.getProperties()) {
            if (prop != null && prop !== property) {
	            if (prop.getName().equals(property.getName()) && !prop.getName().startsWith("pojogen")
	                    && !prop.getName().startsWith("database") && !prop.getName().startsWith("metagen")
	                    && !prop.getName().startsWith("daogen") && !prop.getName().startsWith("replace-all")) {
	                error("Duplicate name : " + property.getName(), ProcessorDslPackage.Literals.PROPERTY__NAME)
	                return
	            }
            }
        }
    }

    @Check
    def checkTableDefinition(TableDefinition tableDefinition) {
        if (!(tableDefinition.rootContainer instanceof Artifacts))
            return
        val artifacts = tableDefinition.rootContainer as Artifacts
        for (TableDefinition table : artifacts.getTables()) {
            if (table != null && table !== tableDefinition) {
	            if (tableDefinition.getName().equals(table.getName())) {
	                error("Duplicate name : " + tableDefinition.getName() + "[table]",
	                        ProcessorDslPackage.Literals.TABLE_DEFINITION__NAME)
	                return
				}
	           }
        }
        if (isResolveDb(tableDefinition) && !dbResolver.checkTable(tableDefinition, tableDefinition.getTable())) {
            error("Cannot find table in DB : " + tableDefinition.getTable(),
                    ProcessorDslPackage.Literals.TABLE_DEFINITION__TABLE)
        }
    }

    @Check
    def checkProcedureDefinition(ProcedureDefinition procedureDefinition) {
        if (!(procedureDefinition.rootContainer instanceof Artifacts))
            return
        val artifacts = procedureDefinition.rootContainer as Artifacts
        for (ProcedureDefinition procedure : artifacts.getProcedures()) {
            if (procedure != null && procedure !== procedureDefinition) {
	            if (procedureDefinition.getName().equals(procedure.getName())) {
	                error("Duplicate name : " + procedureDefinition.getName() + "[procedure]",
	                        ProcessorDslPackage.Literals.PROCEDURE_DEFINITION__NAME)
	                return
	            }
	        }
        }
        if (isResolveDb(procedureDefinition)
                && !dbResolver.checkProcedure(procedureDefinition, procedureDefinition.getTable())) {
            error("Cannot find procedure in DB : " + procedureDefinition.getTable(),
                    ProcessorDslPackage.Literals.PROCEDURE_DEFINITION__NAME)
        }
    }

    @Check
    def checkFunctionDefinition(FunctionDefinition functionDefinition) {
        if (!(functionDefinition.rootContainer instanceof Artifacts))
            return
        val artifacts = functionDefinition.rootContainer as Artifacts
        for (FunctionDefinition function : artifacts.getFunctions()) {
            if (function != null && function !== functionDefinition) {
	            if (functionDefinition.getName().equals(function.getName())) {
	                error("Duplicate name : " + functionDefinition.getName() + "[function]",
	                        ProcessorDslPackage.Literals.FUNCTION_DEFINITION__NAME)
	                return
	            }
	    	}
        }
    }

    @Check
    def checkDatabaseColumn(DatabaseColumn databaseColumn) {
        if (!isResolveDb(databaseColumn))
            return
        var prefix = databaseColumn.getName()
        var columnName = null as String
        val pos = prefix.indexOf('.')
        if (pos > 0) {
            prefix = databaseColumn.getName().substring(0, pos)
            columnName = databaseColumn.getName().substring(pos + 1)
        } else {
            prefix = null
            columnName = databaseColumn.getName()
        }

        val statement = databaseColumn.getContainerOfType(typeof(MetaStatement))
        val artifacts = statement.getContainerOfType(typeof(Artifacts))
        val value = Utils.getTokenFromModifier(statement, TABLE_USAGE, prefix)
        val tableDefinition = if (value != null) Utils.findTable(qualifiedNameConverter, artifacts,
                scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES), value)
        val tableName = if (tableDefinition != null) tableDefinition.getTable()
        if (tableName == null || !dbResolver.checkColumn(databaseColumn, tableName, columnName)) {
            error("Cannot find column in DB : " + databaseColumn.getName() + "[" + tableName + "]",
                    ProcessorDslPackage.Literals.DATABASE_COLUMN__NAME)
        }
    }

    @Check
    def checkDatabaseTable(DatabaseTable databaseTable) {
        if (!isResolveDb(databaseTable))
            return
        val statement = databaseTable.getContainerOfType(typeof(MetaStatement))
        val artifacts = statement.getContainerOfType(typeof(Artifacts))

        val tableName = databaseTable.getName()
        val tableDefinitions = Utils.getTokensFromModifier(statement, TABLE_USAGE).map[value |
        	Utils.findTable(qualifiedNameConverter, artifacts,
                    scopeProvider.getScope(artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES), value)
        ]
        val tableDefinition = tableDefinitions.findFirst[it != null] 
        if (tableDefinition == null || !dbResolver.checkTable(databaseTable, tableName)) {
            error("Cannot find table in DB : " + tableName, ProcessorDslPackage.Literals.DATABASE_TABLE__NAME)
        }
    }
    
    @Check
    def checkUniquePojoEntity(PojoEntity pojoEntity) {
        if (!(pojoEntity.rootContainer instanceof Artifacts))
            return
        val artifacts = pojoEntity.rootContainer as Artifacts
        for (Package pkg : artifacts.getPackages()) {
            if (pkg != null) {
	            for (AbstractPojoEntity entity : pkg.getElements()) {
	                if (entity != null && (entity instanceof PojoEntity)) {
		                val pentity = entity as PojoEntity
		                if (pentity !== pojoEntity) {
			                if (pojoEntity.getName().equals(pentity.getName())) {
			                    error("Duplicate name : " + pojoEntity.getName(), ProcessorDslPackage.Literals.ENTITY__NAME)
			                    return
			                }
		                }
					}
	            }
            }
        }
    }

    @Check
    def checkUniquePojoProperty(PojoProperty pojoProperty) {
        val entity = pojoProperty.getContainerOfType(typeof(PojoEntity))
        for (PojoAnnotatedProperty aproperty : entity.getFeatures()) {
            val property = aproperty.getFeature()
            if (property != null && property !== pojoProperty) {
	            if (pojoProperty.getName().equals(property.getName())) {
	                error("Duplicate name : " + pojoProperty.getName(), ProcessorDslPackage.Literals.POJO_PROPERTY__NAME)
	                return
	            }
            }
        }
    }

    @Check
    def checkUniqueEnumEntity(EnumEntity enumEntity) {
        if (!(enumEntity.rootContainer instanceof Artifacts))
            return
        val artifacts = enumEntity.rootContainer as Artifacts
        for (Package pkg : artifacts.getPackages()) {
            if (pkg != null) {
	            for (AbstractPojoEntity entity : pkg.getElements()) {
	                if (entity != null && (entity instanceof EnumEntity)) {
		                val pentity = entity as EnumEntity
		                if (pentity != enumEntity) {
			                if (enumEntity.getName().equals(pentity.getName())) {
			                    error("Duplicate name : " + enumEntity.getName(), ProcessorDslPackage.Literals.ENTITY__NAME)
			                    return
			                }
						}
					}
	            }
            }
        }
    }

    @Check
    def checkUniqueEnumProperty(EnumProperty enumProperty) {
        val entity = enumProperty.getContainerOfType(typeof(EnumEntity))
        for (EnumProperty property : entity.getFeatures()) {
            if (property != null && property !== enumProperty) {
	            if (enumProperty.getName().equals(property.getName())) {
	                error("Duplicate name : " + enumProperty.getName(), ProcessorDslPackage.Literals.ENUM_PROPERTY__NAME)
	                return
	            }
            }
        }
    }

    @Check
    def checkUniquePojoDao(PojoDao pojoDao) {
        if (!(pojoDao.rootContainer instanceof Artifacts))
            return
        val artifacts = pojoDao.rootContainer as Artifacts
        for (Package pkg : artifacts.getPackages()) {
            if (pkg != null) {
	            for (AbstractPojoEntity dao : pkg.getElements()) {
	                if (dao != null && (dao instanceof PojoDao)) {
		                val pdao = dao as PojoDao
		                if (pdao != pojoDao) {
			                if (pojoDao.getName().equals(pdao.getName())) {
			                    error("Duplicate name : " + pojoDao.getName(), ProcessorDslPackage.Literals.POJO_DAO__NAME)
			                    return
			                }
		                }
	                }
	            }
            }
        }
    }


	// see ProcessorDslScopeProvider
//	@Check
//	def checkDirectiveProperties(DirectiveProperties directiveProperties) {
//		if (directiveProperties.features == null || directiveProperties.features.empty)
//			return;
//        val directive = directiveProperties.getContainerOfType(typeof(PojoDirective))
//        val entity = directive.getContainerOfType(typeof(PojoEntity))
//		val attributes = attributesAsMap(entity)
//        for (PojoProperty prop : directiveProperties.features) {
//        	if (!attributes.containsKey(prop.name)) {
//                error("Cannot find property : " + prop.name + "[" + entity.name + "]",
//                        ProcessorDslPackage.Literals.DIRECTIVE_PROPERTIES__FEATURES)
//                return
//        	}
//        }
//		return
//	}
}
