/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sqlproc.dsl.processorDsl.AnnotatedEntity;
import org.sqlproc.dsl.processorDsl.Annotation;
import org.sqlproc.dsl.processorDsl.AnnotationDirective;
import org.sqlproc.dsl.processorDsl.AnnotationDirectiveAttribute;
import org.sqlproc.dsl.processorDsl.AnnotationDirectiveConflict;
import org.sqlproc.dsl.processorDsl.AnnotationDirectiveConstructor;
import org.sqlproc.dsl.processorDsl.AnnotationDirectiveGetter;
import org.sqlproc.dsl.processorDsl.AnnotationDirectiveSetter;
import org.sqlproc.dsl.processorDsl.AnnotationDirectiveStandard;
import org.sqlproc.dsl.processorDsl.AnnotationDirectiveStatic;
import org.sqlproc.dsl.processorDsl.AnnotationProperty;
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty;
import org.sqlproc.dsl.processorDsl.PojoEntity;

public class Annotations {
    protected static final String INDENT = "  ";
    protected static final String NLINDENT = "\n  ";
    protected static final String NL = "\n";
    Map<String, List<Annotation>> entityAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, List<Annotation>> constructorAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, List<Annotation>> staticAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, List<Annotation>> conflictAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, Map<String, List<Annotation>>> setterAnnotations = new HashMap<String, Map<String, List<Annotation>>>();
    Map<String, Map<String, List<Annotation>>> getterAnnotations = new HashMap<String, Map<String, List<Annotation>>>();
    Map<String, Map<String, List<Annotation>>> attributeAnnotations = new HashMap<String, Map<String, List<Annotation>>>();

    public void addAnnotation(String pojoName, Annotation annotation, Map<String, List<Annotation>> annotations) {
        List<Annotation> list = annotations.get(pojoName);
        if (list == null) {
            list = new ArrayList<Annotation>();
            annotations.put(pojoName, list);
        }
        list.add(annotation);
    }

    public void addAttributeAnnotation(String pojoName, String featureName, Annotation annotation, Map<String, Map<String, List<Annotation>>> annotations) {
        List<Annotation> list;
        Map<String, List<Annotation>> map = annotations.get(pojoName);
        if (map == null) {
            map = new HashMap<String, List<Annotation>>();
            annotations.put(pojoName, map);
        }
        if ((list = map.get(featureName)) == null) {
            list = new ArrayList<Annotation>();
            map.put(featureName, list);
        }
        list.add(annotation);
    }

    public StringBuilder getEntityAnnotationsDefinitions(String pojoName, boolean simpleNames, boolean nonStandardAnnotations) {
        StringBuilder sb = new StringBuilder();
        if (!this.entityAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.entityAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, String.valueOf(nonStandardAnnotations ? "\n  #Standard" : "") + NLINDENT + "@", simpleNames);
        }
        return sb;
    }

    public StringBuilder getConstructorAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.constructorAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.constructorAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  #Constructor\n  @", simpleNames);
        }
        return sb;
    }

    public StringBuilder getStaticAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.staticAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.staticAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  #Static\n  @", simpleNames);
        }
        return sb;
    }

    public StringBuilder getConflictAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.conflictAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.conflictAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  #Conflict\n  @", simpleNames);
        }
        return sb;
    }

    public boolean isNonStandardPojoAnnotations(String pojoName) {
        return this.constructorAnnotations.containsKey(pojoName) && !this.constructorAnnotations.get(pojoName).isEmpty() || this.staticAnnotations.containsKey(pojoName) && !this.staticAnnotations.get(pojoName).isEmpty() || this.conflictAnnotations.containsKey(pojoName) && !this.conflictAnnotations.get(pojoName).isEmpty();
    }

    public StringBuilder getGetterAnnotationsDefinitions(String pojoName, String featureName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.getterAnnotations.containsKey(pojoName) || !this.getterAnnotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (Annotation a : this.getterAnnotations.get(pojoName).get(featureName)) {
            this.getAnnotationDefinition(sb, a, "\n    #Getter\n    @", simpleNames);
        }
        return sb;
    }

    public StringBuilder getSetterAnnotationsDefinitions(String pojoName, String featureName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.setterAnnotations.containsKey(pojoName) || !this.setterAnnotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (Annotation a : this.setterAnnotations.get(pojoName).get(featureName)) {
            this.getAnnotationDefinition(sb, a, "\n    #Setter\n    @", simpleNames);
        }
        return sb;
    }

    public StringBuilder getAttributeAnnotationsDefinitions(String pojoName, String featureName, boolean simpleNames, boolean nonStandardAnnotations) {
        StringBuilder sb = new StringBuilder();
        if (!this.attributeAnnotations.containsKey(pojoName) || !this.attributeAnnotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (Annotation a : this.attributeAnnotations.get(pojoName).get(featureName)) {
            this.getAnnotationDefinition(sb, a, String.valueOf(nonStandardAnnotations ? "\n    #Attribute" : "") + NLINDENT + INDENT + "@", simpleNames);
        }
        return sb;
    }

    public boolean isNonStandardPojoAnnotations(String pojoName, String featureName) {
        return this.getterAnnotations.containsKey(pojoName) && this.getterAnnotations.get(pojoName).containsKey(featureName) && !this.getterAnnotations.get(pojoName).get(featureName).isEmpty() || this.setterAnnotations.containsKey(pojoName) && this.setterAnnotations.get(pojoName).containsKey(featureName) && !this.setterAnnotations.get(pojoName).get(featureName).isEmpty();
    }

    public boolean hasAttributeAnnotationsDefinitions(String pojoName, String featureName, String annotationName) {
        if (this.attributeAnnotations == null) {
            return false;
        }
        if (!this.attributeAnnotations.containsKey(pojoName) || !this.attributeAnnotations.get(pojoName).containsKey(featureName)) {
            return false;
        }
        for (Annotation a : this.attributeAnnotations.get(pojoName).get(featureName)) {
            String aName = a.getType().getQualifiedName();
            if (!annotationName.equals(aName)) continue;
            return true;
        }
        return false;
    }

    public void getAnnotationDefinition(StringBuilder sb, Annotation a, String prefix, boolean simpleNames) {
        sb.append(prefix).append(simpleNames ? a.getType().getSimpleName() : a.getType().getQualifiedName());
        if (a.getFeatures() != null && !a.getFeatures().isEmpty()) {
            sb.append("(");
            boolean first = true;
            for (AnnotationProperty ap : a.getFeatures()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                this.getAnnotationPropertyDefinition(sb, ap, simpleNames);
            }
            sb.append(")");
        }
    }

    public void getAnnotationPropertyDefinition(StringBuilder sb, AnnotationProperty ap, boolean simpleNames) {
        sb.append(ap.getName());
        sb.append(" = ");
        if (ap.getValue() != null) {
            sb.append(ap.getValue());
        } else if (ap.getNumber() != null) {
            sb.append(ap.getNumber());
        } else {
            sb.append(ap.getConstant());
        }
        if (ap.getType() != null) {
            sb.append(" :").append(simpleNames ? ap.getType().getSimpleName() : ap.getType().getQualifiedName());
        } else if (ap.getRef() != null) {
            sb.append(" ").append(ap.getRef().getName());
        }
    }

    public Set<String> getImports() {
        HashSet<String> imports = new HashSet<String>();
        for (List<Annotation> list : this.entityAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (List<Annotation> list : this.constructorAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (List<Annotation> list : this.staticAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (List<Annotation> list : this.conflictAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (Map map : this.attributeAnnotations.values()) {
            for (List al : map.values()) {
                this.getImports(imports, al);
            }
        }
        for (Map map : this.getterAnnotations.values()) {
            for (List al : map.values()) {
                this.getImports(imports, al);
            }
        }
        for (Map map : this.setterAnnotations.values()) {
            for (List al : map.values()) {
                this.getImports(imports, al);
            }
        }
        return imports;
    }

    public void getImports(Set<String> imports, List<Annotation> al) {
        for (Annotation a : al) {
            if (a.getType() != null) {
                imports.add(a.getType().getQualifiedName());
            }
            for (AnnotationProperty ap : a.getFeatures()) {
                if (ap.getType() == null) continue;
                imports.add(ap.getType().getQualifiedName());
            }
        }
    }

    public static void grabAnnotations(AnnotatedEntity apojo, PojoEntity pojo, Annotations as) {
        String pojoName = pojo.getName();
        if (apojo.getAnnotations() != null && !apojo.getAnnotations().isEmpty()) {
            for (Annotation an : apojo.getAnnotations()) {
                if (an.getDirectives() == null || an.getDirectives().isEmpty()) {
                    as.addAnnotation(pojoName, an, as.entityAnnotations);
                    continue;
                }
                for (AnnotationDirective dir : an.getDirectives()) {
                    if (dir instanceof AnnotationDirectiveConflict) {
                        as.addAnnotation(pojoName, an, as.conflictAnnotations);
                        continue;
                    }
                    if (dir instanceof AnnotationDirectiveConstructor) {
                        as.addAnnotation(pojoName, an, as.constructorAnnotations);
                        continue;
                    }
                    if (dir instanceof AnnotationDirectiveStandard) {
                        as.addAnnotation(pojoName, an, as.entityAnnotations);
                        continue;
                    }
                    if (!(dir instanceof AnnotationDirectiveStatic)) continue;
                    as.addAnnotation(pojoName, an, as.staticAnnotations);
                }
            }
        }
        for (PojoAnnotatedProperty feature : pojo.getFeatures()) {
            if (feature.getFeature() == null || feature.getAnnotations() == null || feature.getAnnotations().isEmpty()) continue;
            for (Annotation an : feature.getAnnotations()) {
                if (an.getDirectives() == null || an.getDirectives().isEmpty()) {
                    as.addAttributeAnnotation(pojoName, feature.getFeature().getName(), an, as.attributeAnnotations);
                    continue;
                }
                for (AnnotationDirective dir : an.getDirectives()) {
                    if (dir instanceof AnnotationDirectiveSetter) {
                        as.addAttributeAnnotation(pojoName, feature.getFeature().getName(), an, as.setterAnnotations);
                        continue;
                    }
                    if (dir instanceof AnnotationDirectiveGetter) {
                        as.addAttributeAnnotation(pojoName, feature.getFeature().getName(), an, as.getterAnnotations);
                        continue;
                    }
                    if (!(dir instanceof AnnotationDirectiveAttribute)) continue;
                    as.addAttributeAnnotation(pojoName, feature.getFeature().getName(), an, as.attributeAnnotations);
                }
            }
        }
    }

    public String toString() {
        return "Annotations [entityAnnotations=" + this.entityAnnotations + ", constructorAnnotations=" + this.constructorAnnotations + ", staticAnnotations=" + this.staticAnnotations + ", conflictAnnotations=" + this.conflictAnnotations + ", setterAnnotations=" + this.setterAnnotations + ", getterAnnotations=" + this.getterAnnotations + ", attributeAnnotations=" + this.attributeAnnotations + "]";
    }
}

