/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.sqlproc.dsl.ImportManager;
import org.sqlproc.dsl.generator.ProcessorGeneratorUtils;
import org.sqlproc.dsl.processorDsl.DaoDirectiveParameters;
import org.sqlproc.dsl.processorDsl.Extends;
import org.sqlproc.dsl.processorDsl.FunProcDirective;
import org.sqlproc.dsl.processorDsl.FunProcType;
import org.sqlproc.dsl.processorDsl.FunctionCall;
import org.sqlproc.dsl.processorDsl.FunctionCallQuery;
import org.sqlproc.dsl.processorDsl.FunctionQuery;
import org.sqlproc.dsl.processorDsl.Implements;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.processorDsl.PojoType;
import org.sqlproc.dsl.processorDsl.ProcedureCallQuery;
import org.sqlproc.dsl.processorDsl.ProcedureUpdate;
import org.sqlproc.dsl.util.Utils;

public class ProcessorDaoGenerator {
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private ProcessorGeneratorUtils _processorGeneratorUtils;

    public CharSequence compile(PojoDao d) {
        boolean _notEquals_4;
        String _sernum;
        boolean _notEquals_3;
        List<String> _imports;
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals_2;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        ImportManager im = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        this.addImplements(d, im);
        _builder.newLineIfNotEmpty();
        this.addExtends(d, im);
        _builder.newLineIfNotEmpty();
        Map<String, Map<String, PojoType>> moreResultClasses = this._processorGeneratorUtils.getMoreResultClasses(d);
        _builder.newLineIfNotEmpty();
        PojoEntity pojo = this._processorGeneratorUtils.getPojo(d);
        _builder.newLineIfNotEmpty();
        String implPackage = Utils.getImplPackage(d);
        _builder.newLineIfNotEmpty();
        CharSequence classBody = this.compile(d, pojo, moreResultClasses, im, implPackage);
        _builder.newLineIfNotEmpty();
        EObject _eContainer = d.eContainer();
        boolean bl = _notEquals = !Objects.equal((Object)_eContainer, null);
        if (_notEquals) {
            boolean _notEquals_1;
            _builder.append((Object)"package ");
            EObject _eContainer_1 = d.eContainer();
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_1);
            _builder.append((Object)_fullyQualifiedName, "");
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)implPackage, null);
            if (_notEquals_1) {
                _builder.append((Object)".");
                _builder.append((Object)implPackage, "");
            }
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)implPackage, null);
        if (_notEquals_2) {
            _builder.newLine();
            _builder.append((Object)"import ");
            EObject _eContainer_2 = d.eContainer();
            QualifiedName _fullyQualifiedName_1 = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_2);
            _builder.append((Object)_fullyQualifiedName_1, "");
            _builder.append((Object)".");
            String _name = d.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        boolean bl4 = _not = !(_isEmpty = (_imports = im.getImports()).isEmpty());
        if (_not) {
            _builder.append((Object)"\t");
            _builder.newLine();
            List<String> _imports_1 = im.getImports();
            for (String i : _imports_1) {
                _builder.append((Object)"import ");
                _builder.append((Object)i, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl5 = _notEquals_3 = !Objects.equal((Object)(_sernum = this._processorGeneratorUtils.getSernum(d)), null);
        if (_notEquals_3) {
            _builder.newLine();
            _builder.append((Object)"import java.io.Serializable;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"import java.util.HashMap;");
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Map;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlControl;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlCrudEngine;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlEngineFactory;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlQueryEngine;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlProcedureEngine;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlSession;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlSessionFactory;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.impl.SqlStandardControl;");
        _builder.newLine();
        boolean bl6 = _notEquals_4 = !Objects.equal((Object)pojo, null);
        if (_notEquals_4) {
            _builder.append((Object)"import ");
            String _completeName = this._processorGeneratorUtils.completeName(pojo);
            _builder.append((Object)_completeName, "");
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        Set<Map.Entry<String, Map<String, PojoType>>> _entrySet = moreResultClasses.entrySet();
        for (Map.Entry<String, Map<String, PojoType>> f : _entrySet) {
            Map<String, PojoType> _value = f.getValue();
            Collection<PojoType> _values = _value.values();
            boolean _hasElements = false;
            for (PojoType a : _values) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n\t\t", "");
                }
                _builder.append((Object)"import ");
                PojoEntity _ref = a.getRef();
                String _completeName_1 = this._processorGeneratorUtils.completeName(_ref);
                _builder.append((Object)_completeName_1, "");
                _builder.append((Object)";");
            }
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)classBody, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compile(PojoDao d, PojoEntity e, Map<String, Map<String, PojoType>> moreResultClasses, ImportManager im, String implPackage) {
        boolean _not;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        boolean _isAbstract = this._processorGeneratorUtils.isAbstract(d);
        if (_isAbstract) {
            _builder.append((Object)"abstract ");
        }
        _builder.append((Object)"class ");
        String _name = d.getName();
        _builder.append((Object)_name, "");
        boolean bl = _notEquals = !Objects.equal((Object)implPackage, null);
        if (_notEquals) {
            _builder.append((Object)"Impl");
        }
        _builder.append((Object)" ");
        CharSequence _compileExtends = this.compileExtends(d, im);
        _builder.append((Object)_compileExtends, "");
        CharSequence _compileImplements = this.compileImplements(d, implPackage);
        _builder.append((Object)_compileImplements, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        String _sernum = this._processorGeneratorUtils.getSernum(d);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_sernum, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private static final long serialVersionUID = ");
            String _sernum_1 = this._processorGeneratorUtils.getSernum(d);
            _builder.append((Object)_sernum_1, "\t");
            _builder.append((Object)"L;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"protected final Logger logger = LoggerFactory.getLogger(getClass());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected SqlEngineFactory sqlEngineFactory;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected SqlSessionFactory sqlSessionFactory;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = d.getName();
        _builder.append((Object)_name_1, "\t");
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)implPackage, null);
        if (_notEquals_2) {
            _builder.append((Object)"Impl");
        }
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = d.getName();
        _builder.append((Object)_name_2, "\t");
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)implPackage, null);
        if (_notEquals_3) {
            _builder.append((Object)"Impl");
        }
        _builder.append((Object)"(SqlEngineFactory sqlEngineFactory) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.sqlEngineFactory = sqlEngineFactory;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = d.getName();
        _builder.append((Object)_name_3, "\t");
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)implPackage, null);
        if (_notEquals_4) {
            _builder.append((Object)"Impl");
        }
        _builder.append((Object)"(SqlEngineFactory sqlEngineFactory, SqlSessionFactory sqlSessionFactory) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.sqlEngineFactory = sqlEngineFactory;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.sqlSessionFactory = sqlSessionFactory;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        boolean _isCRUD = this._processorGeneratorUtils.isCRUD(d);
        if (_isCRUD) {
            PojoEntity _parent = this._processorGeneratorUtils.getParent(e);
            CharSequence _compileInsert = this.compileInsert(d, e, _parent, im, true);
            _builder.append((Object)_compileInsert, "");
            _builder.newLineIfNotEmpty();
            CharSequence _compileGet = this.compileGet(d, e, moreResultClasses, im, true);
            _builder.append((Object)_compileGet, "");
            _builder.newLineIfNotEmpty();
            PojoEntity _parent_1 = this._processorGeneratorUtils.getParent(e);
            CharSequence _compileUpdate = this.compileUpdate(d, e, _parent_1, im, true);
            _builder.append((Object)_compileUpdate, "");
            _builder.newLineIfNotEmpty();
            PojoEntity _parent_2 = this._processorGeneratorUtils.getParent(e);
            CharSequence _compileDelete = this.compileDelete(d, e, _parent_2, im, true);
            _builder.append((Object)_compileDelete, "");
        }
        _builder.newLineIfNotEmpty();
        boolean _isQuery = this._processorGeneratorUtils.isQuery(d);
        if (_isQuery) {
            CharSequence _compileList = this.compileList(d, e, moreResultClasses, im, true);
            _builder.append((Object)_compileList, "");
            _builder.newLineIfNotEmpty();
            CharSequence _compileCount = this.compileCount(d, e, moreResultClasses, im, true);
            _builder.append((Object)_compileCount, "");
        }
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = moreResultClasses.isEmpty();
        boolean bl6 = _not = !_isEmpty;
        if (_not) {
            CharSequence _compileMoreResultClasses = this.compileMoreResultClasses(d, e, moreResultClasses, im);
            _builder.append((Object)_compileMoreResultClasses, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        List<FunProcDirective> _listFunctionsDirectives = this._processorGeneratorUtils.listFunctionsDirectives(d);
        for (FunProcDirective fp : _listFunctionsDirectives) {
            FunProcType _type = fp.getType();
            DaoDirectiveParameters _paramlist = fp.getParamlist();
            CharSequence _compileFunctionProcedure = this.compileFunctionProcedure(d, e, _type, _paramlist, im, true);
            _builder.append((Object)_compileFunctionProcedure, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _compileFunctionProcedure(PojoDao d, PojoEntity e, FunctionCallQuery type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        PojoType _out = p.getOut();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_out, im);
        _builder.append((Object)_compileType, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType_1, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)": \" + ");
        EList<PojoType> _ins_1 = p.getIns();
        boolean _hasElements_1 = false;
        for (PojoType ma_1 : _ins_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \" \" ", "\t\t");
            }
            String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
            _builder.append((Object)_paramName_1, "\t\t");
        }
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"SqlProcedureEngine sqlProc");
        String _name = d.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"FUN_");
        String _dbName = Utils.dbName(d);
        _builder.append((Object)_dbName, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        PojoType _out_1 = p.getOut();
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_out_1, im);
        _builder.append((Object)_compileType_2, "\t");
        _builder.append((Object)" list = sqlProc");
        String _name_1 = d.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)".callQuery(sqlSession, ");
        PojoType _out_2 = p.getOut();
        PojoEntity _gref = _out_2.getGref();
        String _name_2 = _gref.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)".class, ");
        EList<PojoType> _ins_2 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "\t");
        }
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)" result: \" + list);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return list;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_3 = p.getOut();
            CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_out_3, im);
            _builder.append((Object)_compileType_3, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_3 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_4, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
            EList<PojoType> _ins_4 = p.getIns();
            boolean _hasElements_4 = false;
            for (PojoType ma_4 : _ins_4) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_4 = this._processorGeneratorUtils.getParamName(ma_4);
                _builder.append((Object)_paramName_4, "\t");
            }
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"public ");
        PojoType _out_4 = p.getOut();
        CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(_out_4, im);
        _builder.append((Object)_compileType_5, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_5 = p.getIns();
        boolean _hasElements_5 = false;
        for (PojoType ma_5 : _ins_5) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(ma_5, im);
            _builder.append((Object)_compileType_6, "");
            _builder.append((Object)" ");
            String _paramName_5 = this._processorGeneratorUtils.getParamName(ma_5);
            _builder.append((Object)_paramName_5, "");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"(sqlSession, ");
        EList<PojoType> _ins_6 = p.getIns();
        boolean _hasElements_6 = false;
        for (PojoType ma_6 : _ins_6) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_6 = this._processorGeneratorUtils.getParamName(ma_6);
            _builder.append((Object)_paramName_6, "\t");
        }
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_5 = p.getOut();
            CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(_out_5, im);
            _builder.append((Object)_compileType_7, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_7 = p.getIns();
            boolean _hasElements_7 = false;
            for (PojoType ma_7 : _ins_7) {
                if (!_hasElements_7) {
                    _hasElements_7 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_8 = this._processorGeneratorUtils.compileType(ma_7, im);
                _builder.append((Object)_compileType_8, "");
                _builder.append((Object)" ");
                String _paramName_7 = this._processorGeneratorUtils.getParamName(ma_7);
                _builder.append((Object)_paramName_7, "");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(");
            EList<PojoType> _ins_8 = p.getIns();
            boolean _hasElements_8 = false;
            for (PojoType ma_8 : _ins_8) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_8 = this._processorGeneratorUtils.getParamName(ma_8);
                _builder.append((Object)_paramName_8, "\t");
            }
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _compileFunctionProcedure(PojoDao d, PojoEntity e, ProcedureCallQuery type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        PojoType _out = p.getOut();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_out, im);
        _builder.append((Object)_compileType, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType_1, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)": \" + ");
        EList<PojoType> _ins_1 = p.getIns();
        boolean _hasElements_1 = false;
        for (PojoType ma_1 : _ins_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \" \" ", "\t\t");
            }
            String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
            _builder.append((Object)_paramName_1, "\t\t");
        }
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"SqlProcedureEngine sqlProc");
        String _name = d.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"PROC_");
        String _dbName = Utils.dbName(d);
        _builder.append((Object)_dbName, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        PojoType _out_1 = p.getOut();
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_out_1, im);
        _builder.append((Object)_compileType_2, "\t");
        _builder.append((Object)" list = sqlProc");
        String _name_1 = d.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)".callQuery(sqlSession, ");
        PojoType _out_2 = p.getOut();
        PojoEntity _gref = _out_2.getGref();
        boolean bl = _notEquals = !Objects.equal((Object)_gref, null);
        if (_notEquals) {
            PojoType _out_3 = p.getOut();
            PojoEntity _gref_1 = _out_3.getGref();
            String _name_2 = _gref_1.getName();
            _builder.append((Object)_name_2, "\t");
        } else {
            PojoType _out_4 = p.getOut();
            JvmType _gtype = _out_4.getGtype();
            String _simpleName = _gtype.getSimpleName();
            _builder.append((Object)_simpleName, "\t");
        }
        _builder.append((Object)".class, ");
        EList<PojoType> _ins_2 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "\t");
        }
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)" result: \" + list);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return list;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_5 = p.getOut();
            CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_out_5, im);
            _builder.append((Object)_compileType_3, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_3 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_4, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
            EList<PojoType> _ins_4 = p.getIns();
            boolean _hasElements_4 = false;
            for (PojoType ma_4 : _ins_4) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_4 = this._processorGeneratorUtils.getParamName(ma_4);
                _builder.append((Object)_paramName_4, "\t");
            }
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"public ");
        PojoType _out_6 = p.getOut();
        CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(_out_6, im);
        _builder.append((Object)_compileType_5, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_5 = p.getIns();
        boolean _hasElements_5 = false;
        for (PojoType ma_5 : _ins_5) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(ma_5, im);
            _builder.append((Object)_compileType_6, "");
            _builder.append((Object)" ");
            String _paramName_5 = this._processorGeneratorUtils.getParamName(ma_5);
            _builder.append((Object)_paramName_5, "");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"(sqlSession, ");
        EList<PojoType> _ins_6 = p.getIns();
        boolean _hasElements_6 = false;
        for (PojoType ma_6 : _ins_6) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_6 = this._processorGeneratorUtils.getParamName(ma_6);
            _builder.append((Object)_paramName_6, "\t");
        }
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_7 = p.getOut();
            CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(_out_7, im);
            _builder.append((Object)_compileType_7, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_7 = p.getIns();
            boolean _hasElements_7 = false;
            for (PojoType ma_7 : _ins_7) {
                if (!_hasElements_7) {
                    _hasElements_7 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_8 = this._processorGeneratorUtils.compileType(ma_7, im);
                _builder.append((Object)_compileType_8, "");
                _builder.append((Object)" ");
                String _paramName_7 = this._processorGeneratorUtils.getParamName(ma_7);
                _builder.append((Object)_paramName_7, "");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(");
            EList<PojoType> _ins_8 = p.getIns();
            boolean _hasElements_8 = false;
            for (PojoType ma_8 : _ins_8) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_8 = this._processorGeneratorUtils.getParamName(ma_8);
                _builder.append((Object)_paramName_8, "\t");
            }
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _compileFunctionProcedure(PojoDao d, PojoEntity e, FunctionCall type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        PojoType _out = p.getOut();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_out, im);
        _builder.append((Object)_compileType, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType_1, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)": \" + ");
        EList<PojoType> _ins_1 = p.getIns();
        boolean _hasElements_1 = false;
        for (PojoType ma_1 : _ins_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \" \" ", "\t\t");
            }
            String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
            _builder.append((Object)_paramName_1, "\t\t");
        }
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"SqlProcedureEngine sqlFun");
        String _name = d.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"FUN_");
        String _dbName = Utils.dbName(d);
        _builder.append((Object)_dbName, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"Object result = sqlFun");
        String _name_1 = d.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)".callFunction(sqlSession, ");
        EList<PojoType> _ins_2 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "\t");
        }
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)" result: \" + result);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return (");
        PojoType _out_1 = p.getOut();
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_out_1, im);
        _builder.append((Object)_compileType_2, "\t");
        _builder.append((Object)") result;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_2 = p.getOut();
            CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_out_2, im);
            _builder.append((Object)_compileType_3, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_3 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_4, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
            EList<PojoType> _ins_4 = p.getIns();
            boolean _hasElements_4 = false;
            for (PojoType ma_4 : _ins_4) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_4 = this._processorGeneratorUtils.getParamName(ma_4);
                _builder.append((Object)_paramName_4, "\t");
            }
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"public ");
        PojoType _out_3 = p.getOut();
        CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(_out_3, im);
        _builder.append((Object)_compileType_5, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_5 = p.getIns();
        boolean _hasElements_5 = false;
        for (PojoType ma_5 : _ins_5) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(ma_5, im);
            _builder.append((Object)_compileType_6, "");
            _builder.append((Object)" ");
            String _paramName_5 = this._processorGeneratorUtils.getParamName(ma_5);
            _builder.append((Object)_paramName_5, "");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"(sqlSession, ");
        EList<PojoType> _ins_6 = p.getIns();
        boolean _hasElements_6 = false;
        for (PojoType ma_6 : _ins_6) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_6 = this._processorGeneratorUtils.getParamName(ma_6);
            _builder.append((Object)_paramName_6, "\t");
        }
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_4 = p.getOut();
            CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(_out_4, im);
            _builder.append((Object)_compileType_7, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_7 = p.getIns();
            boolean _hasElements_7 = false;
            for (PojoType ma_7 : _ins_7) {
                if (!_hasElements_7) {
                    _hasElements_7 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_8 = this._processorGeneratorUtils.compileType(ma_7, im);
                _builder.append((Object)_compileType_8, "");
                _builder.append((Object)" ");
                String _paramName_7 = this._processorGeneratorUtils.getParamName(ma_7);
                _builder.append((Object)_paramName_7, "");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(");
            EList<PojoType> _ins_8 = p.getIns();
            boolean _hasElements_8 = false;
            for (PojoType ma_8 : _ins_8) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_8 = this._processorGeneratorUtils.getParamName(ma_8);
                _builder.append((Object)_paramName_8, "\t");
            }
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _compileFunctionProcedure(PojoDao d, PojoEntity e, ProcedureUpdate type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public int ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)": \" + ");
        EList<PojoType> _ins_1 = p.getIns();
        boolean _hasElements_1 = false;
        for (PojoType ma_1 : _ins_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \" \" ", "\t\t");
            }
            String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
            _builder.append((Object)_paramName_1, "\t\t");
        }
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"SqlProcedureEngine sqlProc");
        String _name = d.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"PROC_");
        String _dbName = Utils.dbName(d);
        _builder.append((Object)_dbName, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"int count = sqlProc");
        String _name_1 = d.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)".callUpdate(sqlSession, ");
        EList<PojoType> _ins_2 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "\t");
        }
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)" result: \" + count);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return count;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public int ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_3 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_1, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
            EList<PojoType> _ins_4 = p.getIns();
            boolean _hasElements_4 = false;
            for (PojoType ma_4 : _ins_4) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_4 = this._processorGeneratorUtils.getParamName(ma_4);
                _builder.append((Object)_paramName_4, "\t");
            }
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"public int ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_5 = p.getIns();
        boolean _hasElements_5 = false;
        for (PojoType ma_5 : _ins_5) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(ma_5, im);
            _builder.append((Object)_compileType_2, "");
            _builder.append((Object)" ");
            String _paramName_5 = this._processorGeneratorUtils.getParamName(ma_5);
            _builder.append((Object)_paramName_5, "");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"(sqlSession, ");
        EList<PojoType> _ins_6 = p.getIns();
        boolean _hasElements_6 = false;
        for (PojoType ma_6 : _ins_6) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_6 = this._processorGeneratorUtils.getParamName(ma_6);
            _builder.append((Object)_paramName_6, "\t");
        }
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public int ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_7 = p.getIns();
            boolean _hasElements_7 = false;
            for (PojoType ma_7 : _ins_7) {
                if (!_hasElements_7) {
                    _hasElements_7 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(ma_7, im);
                _builder.append((Object)_compileType_3, "");
                _builder.append((Object)" ");
                String _paramName_7 = this._processorGeneratorUtils.getParamName(ma_7);
                _builder.append((Object)_paramName_7, "");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(");
            EList<PojoType> _ins_8 = p.getIns();
            boolean _hasElements_8 = false;
            for (PojoType ma_8 : _ins_8) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_8 = this._processorGeneratorUtils.getParamName(ma_8);
                _builder.append((Object)_paramName_8, "\t");
            }
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _compileFunctionProcedure(PojoDao d, PojoEntity e, FunctionQuery type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        PojoType _out = p.getOut();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_out, im);
        _builder.append((Object)_compileType, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType_1, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)": \" + ");
        EList<PojoType> _ins_1 = p.getIns();
        boolean _hasElements_1 = false;
        for (PojoType ma_1 : _ins_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \" \" ", "\t\t");
            }
            String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
            _builder.append((Object)_paramName_1, "\t\t");
        }
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"SqlQueryEngine sqlFun");
        String _name = d.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"FUN_");
        String _dbName = Utils.dbName(d);
        _builder.append((Object)_dbName, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.List<");
        EList<PojoType> _ins_2 = p.getIns();
        PojoType _get = (PojoType)_ins_2.get(0);
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_get, im);
        _builder.append((Object)_compileType_2, "\t");
        _builder.append((Object)"> list = sqlFun");
        String _name_1 = d.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)".query(sqlSession, ");
        EList<PojoType> _ins_3 = p.getIns();
        PojoType _get_1 = (PojoType)_ins_3.get(0);
        CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_get_1, im);
        _builder.append((Object)_compileType_3, "\t");
        _builder.append((Object)".class, ");
        EList<PojoType> _ins_4 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_4) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "\t");
        }
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.trace(\"");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)" result: \" + list);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return (list != null && !list.isEmpty()) ? list.get(0).getResult() : null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_1 = p.getOut();
            CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_out_1, im);
            _builder.append((Object)_compileType_4, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_5 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_5) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_5, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
            EList<PojoType> _ins_6 = p.getIns();
            boolean _hasElements_4 = false;
            for (PojoType ma_4 : _ins_6) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_4 = this._processorGeneratorUtils.getParamName(ma_4);
                _builder.append((Object)_paramName_4, "\t");
            }
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"public ");
        PojoType _out_2 = p.getOut();
        CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_out_2, im);
        _builder.append((Object)_compileType_6, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_7 = p.getIns();
        boolean _hasElements_5 = false;
        for (PojoType ma_5 : _ins_7) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(ma_5, im);
            _builder.append((Object)_compileType_7, "");
            _builder.append((Object)" ");
            String _paramName_5 = this._processorGeneratorUtils.getParamName(ma_5);
            _builder.append((Object)_paramName_5, "");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"(sqlSession, ");
        EList<PojoType> _ins_8 = p.getIns();
        boolean _hasElements_6 = false;
        for (PojoType ma_6 : _ins_8) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _paramName_6 = this._processorGeneratorUtils.getParamName(ma_6);
            _builder.append((Object)_paramName_6, "\t");
        }
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_3 = p.getOut();
            CharSequence _compileType_8 = this._processorGeneratorUtils.compileType(_out_3, im);
            _builder.append((Object)_compileType_8, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_9 = p.getIns();
            boolean _hasElements_7 = false;
            for (PojoType ma_7 : _ins_9) {
                if (!_hasElements_7) {
                    _hasElements_7 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_9 = this._processorGeneratorUtils.compileType(ma_7, im);
                _builder.append((Object)_compileType_9, "");
                _builder.append((Object)" ");
                String _paramName_7 = this._processorGeneratorUtils.getParamName(ma_7);
                _builder.append((Object)_paramName_7, "");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            _builder.append((Object)name, "\t");
            _builder.append((Object)"(");
            EList<PojoType> _ins_10 = p.getIns();
            boolean _hasElements_8 = false;
            for (PojoType ma_8 : _ins_10) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _paramName_8 = this._processorGeneratorUtils.getParamName(ma_8);
                _builder.append((Object)_paramName_8, "\t");
            }
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileInsert(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im, boolean all) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" insert(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"insert ");
        String _name_3 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_4 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_4);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlCrudEngine sqlInsert");
        String _name_5 = e.getName();
        _builder.append((Object)_name_5, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"INSERT_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        boolean bl = _notEquals = !Objects.equal((Object)pe, null);
        if (_notEquals) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"SqlCrudEngine sqlInsert");
            String _name_6 = pe.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"INSERT_");
            String _dbName_1 = Utils.dbName(pe);
            _builder.append((Object)_dbName_1, "\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"int count = sqlInsert");
            String _name_7 = pe.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)".insert(sqlSession, ");
            String _name_8 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_8);
            _builder.append((Object)_firstLower_3, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"sqlInsert");
            String _name_9 = e.getName();
            _builder.append((Object)_name_9, "\t\t\t");
            _builder.append((Object)".insert(sqlSession, ");
            String _name_10 = e.getName();
            String _firstLower_4 = StringExtensions.toFirstLower((String)_name_10);
            _builder.append((Object)_firstLower_4, "\t\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        } else {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"int count = sqlInsert");
            String _name_11 = e.getName();
            _builder.append((Object)_name_11, "\t\t");
            _builder.append((Object)".insert(sqlSession, ");
            String _name_12 = e.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_12);
            _builder.append((Object)_firstLower_5, "\t\t");
            _builder.append((Object)", sqlControl);");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"insert ");
        String _name_13 = e.getName();
        String _firstLower_6 = StringExtensions.toFirstLower((String)_name_13);
        _builder.append((Object)_firstLower_6, "\t\t\t");
        _builder.append((Object)" result: \" + count + \" \" + ");
        String _name_14 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_14);
        _builder.append((Object)_firstLower_7, "\t\t\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return (count > 0) ? ");
        String _name_15 = e.getName();
        String _firstLower_8 = StringExtensions.toFirstLower((String)_name_15);
        _builder.append((Object)_firstLower_8, "\t\t");
        _builder.append((Object)" : null;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_16 = e.getName();
            _builder.append((Object)_name_16, "\t");
            _builder.append((Object)" insert(");
            String _name_17 = e.getName();
            _builder.append((Object)_name_17, "\t");
            _builder.append((Object)" ");
            String _name_18 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_18);
            _builder.append((Object)_firstLower_9, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return insert(sqlSessionFactory.getSqlSession(), ");
            String _name_19 = e.getName();
            String _firstLower_10 = StringExtensions.toFirstLower((String)_name_19);
            _builder.append((Object)_firstLower_10, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_20 = e.getName();
        _builder.append((Object)_name_20, "\t");
        _builder.append((Object)" insert(SqlSession sqlSession, ");
        String _name_21 = e.getName();
        _builder.append((Object)_name_21, "\t");
        _builder.append((Object)" ");
        String _name_22 = e.getName();
        String _firstLower_11 = StringExtensions.toFirstLower((String)_name_22);
        _builder.append((Object)_firstLower_11, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return insert(sqlSession, ");
        String _name_23 = e.getName();
        String _firstLower_12 = StringExtensions.toFirstLower((String)_name_23);
        _builder.append((Object)_firstLower_12, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_24 = e.getName();
            _builder.append((Object)_name_24, "\t");
            _builder.append((Object)" insert(");
            String _name_25 = e.getName();
            _builder.append((Object)_name_25, "\t");
            _builder.append((Object)" ");
            String _name_26 = e.getName();
            String _firstLower_13 = StringExtensions.toFirstLower((String)_name_26);
            _builder.append((Object)_firstLower_13, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return insert(");
            String _name_27 = e.getName();
            String _firstLower_14 = StringExtensions.toFirstLower((String)_name_27);
            _builder.append((Object)_firstLower_14, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileGet(PojoDao d, PojoEntity e, Map<String, Map<String, PojoType>> moreResultClasses, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" get(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"get get: \" + ");
        String _name_3 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlCrudEngine sqlGetEngine");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"GET_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        boolean _isEmpty = moreResultClasses.isEmpty();
        if (_isEmpty) {
            _builder.append((Object)"//");
        }
        _builder.append((Object)"sqlControl = getMoreResultClasses(");
        String _name_5 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)" ");
        String _name_7 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)"Got = sqlGetEngine");
        String _name_8 = e.getName();
        _builder.append((Object)_name_8, "\t\t");
        _builder.append((Object)".get(sqlSession, ");
        String _name_9 = e.getName();
        _builder.append((Object)_name_9, "\t\t");
        _builder.append((Object)".class, ");
        String _name_10 = e.getName();
        String _firstLower_4 = StringExtensions.toFirstLower((String)_name_10);
        _builder.append((Object)_firstLower_4, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"get ");
        String _name_11 = e.getName();
        String _firstLower_5 = StringExtensions.toFirstLower((String)_name_11);
        _builder.append((Object)_firstLower_5, "\t\t\t");
        _builder.append((Object)" result: \" + ");
        String _name_12 = e.getName();
        String _firstLower_6 = StringExtensions.toFirstLower((String)_name_12);
        _builder.append((Object)_firstLower_6, "\t\t\t");
        _builder.append((Object)"Got);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_13 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_13);
        _builder.append((Object)_firstLower_7, "\t\t");
        _builder.append((Object)"Got;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_14 = e.getName();
            _builder.append((Object)_name_14, "\t");
            _builder.append((Object)" get(");
            String _name_15 = e.getName();
            _builder.append((Object)_name_15, "\t");
            _builder.append((Object)" ");
            String _name_16 = e.getName();
            String _firstLower_8 = StringExtensions.toFirstLower((String)_name_16);
            _builder.append((Object)_firstLower_8, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return get(sqlSessionFactory.getSqlSession(), ");
            String _name_17 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_17);
            _builder.append((Object)_firstLower_9, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_18 = e.getName();
        _builder.append((Object)_name_18, "\t");
        _builder.append((Object)" get(SqlSession sqlSession, ");
        String _name_19 = e.getName();
        _builder.append((Object)_name_19, "\t");
        _builder.append((Object)" ");
        String _name_20 = e.getName();
        String _firstLower_10 = StringExtensions.toFirstLower((String)_name_20);
        _builder.append((Object)_firstLower_10, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return get(sqlSession, ");
        String _name_21 = e.getName();
        String _firstLower_11 = StringExtensions.toFirstLower((String)_name_21);
        _builder.append((Object)_firstLower_11, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_22 = e.getName();
            _builder.append((Object)_name_22, "\t");
            _builder.append((Object)" get(");
            String _name_23 = e.getName();
            _builder.append((Object)_name_23, "\t");
            _builder.append((Object)" ");
            String _name_24 = e.getName();
            String _firstLower_12 = StringExtensions.toFirstLower((String)_name_24);
            _builder.append((Object)_firstLower_12, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return get(");
            String _name_25 = e.getName();
            String _firstLower_13 = StringExtensions.toFirstLower((String)_name_25);
            _builder.append((Object)_firstLower_13, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileUpdate(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im, boolean all) {
        PojoProperty f;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int update(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"update ");
        String _name_2 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_3 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlCrudEngine sqlUpdateEngine");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"UPDATE_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        boolean bl = _notEquals = !Objects.equal((Object)pe, null);
        if (_notEquals) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"SqlCrudEngine sqlUpdate");
            String _name_5 = pe.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"UPDATE_");
            String _dbName_1 = Utils.dbName(pe);
            _builder.append((Object)_dbName_1, "\t\t");
            _builder.append((Object)"\");");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int count = sqlUpdateEngine");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)".update(sqlSession, ");
        String _name_7 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)", sqlControl);");
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pe, null);
        if (_notEquals_1) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"sqlUpdate");
            String _name_8 = pe.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)".update(sqlSession, ");
            String _name_9 = e.getName();
            String _firstLower_4 = StringExtensions.toFirstLower((String)_name_9);
            _builder.append((Object)_firstLower_4, "\t\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        }
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)(f = this._processorGeneratorUtils.getOptLock(e)), null);
        if (_notEquals_2) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _name_10 = e.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_10);
            _builder.append((Object)_firstLower_5, "\t\t\t");
            _builder.append((Object)".set");
            String _name_11 = f.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_11);
            _builder.append((Object)_firstUpper, "\t\t\t");
            _builder.append((Object)"(");
            String _name_12 = e.getName();
            String _firstLower_6 = StringExtensions.toFirstLower((String)_name_12);
            _builder.append((Object)_firstLower_6, "\t\t\t");
            _builder.append((Object)".get");
            String _name_13 = f.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_13);
            _builder.append((Object)_firstUpper_1, "\t\t\t");
            _builder.append((Object)"() + 1);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"update ");
        String _name_14 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_14);
        _builder.append((Object)_firstLower_7, "\t\t\t");
        _builder.append((Object)" result count: \" + count);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return count;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int update(");
            String _name_15 = e.getName();
            _builder.append((Object)_name_15, "\t");
            _builder.append((Object)" ");
            String _name_16 = e.getName();
            String _firstLower_8 = StringExtensions.toFirstLower((String)_name_16);
            _builder.append((Object)_firstLower_8, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return update(sqlSessionFactory.getSqlSession(), ");
            String _name_17 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_17);
            _builder.append((Object)_firstLower_9, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int update(SqlSession sqlSession, ");
        String _name_18 = e.getName();
        _builder.append((Object)_name_18, "\t");
        _builder.append((Object)" ");
        String _name_19 = e.getName();
        String _firstLower_10 = StringExtensions.toFirstLower((String)_name_19);
        _builder.append((Object)_firstLower_10, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return update(sqlSession, ");
        String _name_20 = e.getName();
        String _firstLower_11 = StringExtensions.toFirstLower((String)_name_20);
        _builder.append((Object)_firstLower_11, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int update(");
            String _name_21 = e.getName();
            _builder.append((Object)_name_21, "\t");
            _builder.append((Object)" ");
            String _name_22 = e.getName();
            String _firstLower_12 = StringExtensions.toFirstLower((String)_name_22);
            _builder.append((Object)_firstLower_12, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return update(");
            String _name_23 = e.getName();
            String _firstLower_13 = StringExtensions.toFirstLower((String)_name_23);
            _builder.append((Object)_firstLower_13, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileDelete(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im, boolean all) {
        PojoProperty f;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int delete(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"delete ");
        String _name_2 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_3 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlCrudEngine sqlDeleteEngine");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"DELETE_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        boolean bl = _notEquals = !Objects.equal((Object)pe, null);
        if (_notEquals) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"SqlCrudEngine sqlDelete");
            String _name_5 = pe.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"DELETE_");
            String _dbName_1 = Utils.dbName(pe);
            _builder.append((Object)_dbName_1, "\t\t");
            _builder.append((Object)"\");");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int count = sqlDeleteEngine");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)".delete(sqlSession, ");
        String _name_7 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)", sqlControl);");
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pe, null);
        if (_notEquals_1) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"sqlDelete");
            String _name_8 = pe.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)".delete(sqlSession, ");
            String _name_9 = e.getName();
            String _firstLower_4 = StringExtensions.toFirstLower((String)_name_9);
            _builder.append((Object)_firstLower_4, "\t\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        }
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)(f = this._processorGeneratorUtils.getOptLock(e)), null);
        if (_notEquals_2) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _name_10 = e.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_10);
            _builder.append((Object)_firstLower_5, "\t\t\t");
            _builder.append((Object)".set");
            String _name_11 = f.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_11);
            _builder.append((Object)_firstUpper, "\t\t\t");
            _builder.append((Object)"(");
            String _name_12 = e.getName();
            String _firstLower_6 = StringExtensions.toFirstLower((String)_name_12);
            _builder.append((Object)_firstLower_6, "\t\t\t");
            _builder.append((Object)".get");
            String _name_13 = f.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_13);
            _builder.append((Object)_firstUpper_1, "\t\t\t");
            _builder.append((Object)"() + 1);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"delete ");
        String _name_14 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_14);
        _builder.append((Object)_firstLower_7, "\t\t\t");
        _builder.append((Object)" result count: \" + count);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return count;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int delete(");
            String _name_15 = e.getName();
            _builder.append((Object)_name_15, "\t");
            _builder.append((Object)" ");
            String _name_16 = e.getName();
            String _firstLower_8 = StringExtensions.toFirstLower((String)_name_16);
            _builder.append((Object)_firstLower_8, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return delete(sqlSessionFactory.getSqlSession(), ");
            String _name_17 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_17);
            _builder.append((Object)_firstLower_9, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int delete(SqlSession sqlSession, ");
        String _name_18 = e.getName();
        _builder.append((Object)_name_18, "\t");
        _builder.append((Object)" ");
        String _name_19 = e.getName();
        String _firstLower_10 = StringExtensions.toFirstLower((String)_name_19);
        _builder.append((Object)_firstLower_10, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return delete(sqlSession, ");
        String _name_20 = e.getName();
        String _firstLower_11 = StringExtensions.toFirstLower((String)_name_20);
        _builder.append((Object)_firstLower_11, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int delete(");
            String _name_21 = e.getName();
            _builder.append((Object)_name_21, "\t");
            _builder.append((Object)" ");
            String _name_22 = e.getName();
            String _firstLower_12 = StringExtensions.toFirstLower((String)_name_22);
            _builder.append((Object)_firstLower_12, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return delete(");
            String _name_23 = e.getName();
            String _firstLower_13 = StringExtensions.toFirstLower((String)_name_23);
            _builder.append((Object)_firstLower_13, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileList(PojoDao d, PojoEntity e, Map<String, Map<String, PojoType>> moreResultClasses, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"> list(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"list ");
        String _name_3 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_4 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_4);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlQueryEngine sqlEngine");
        String _name_5 = e.getName();
        _builder.append((Object)_name_5, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"SELECT_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        boolean _isEmpty = moreResultClasses.isEmpty();
        if (_isEmpty) {
            _builder.append((Object)"//");
        }
        _builder.append((Object)"sqlControl = getMoreResultClasses(");
        String _name_6 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_6);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"List<");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "\t\t");
        _builder.append((Object)"> ");
        String _name_8 = e.getName();
        String _firstLower_4 = StringExtensions.toFirstLower((String)_name_8);
        _builder.append((Object)_firstLower_4, "\t\t");
        _builder.append((Object)"List = sqlEngine");
        String _name_9 = e.getName();
        _builder.append((Object)_name_9, "\t\t");
        _builder.append((Object)".query(sqlSession, ");
        String _name_10 = e.getName();
        _builder.append((Object)_name_10, "\t\t");
        _builder.append((Object)".class, ");
        String _name_11 = e.getName();
        String _firstLower_5 = StringExtensions.toFirstLower((String)_name_11);
        _builder.append((Object)_firstLower_5, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"list ");
        String _name_12 = e.getName();
        String _firstLower_6 = StringExtensions.toFirstLower((String)_name_12);
        _builder.append((Object)_firstLower_6, "\t\t\t");
        _builder.append((Object)" size: \" + ((");
        String _name_13 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_13);
        _builder.append((Object)_firstLower_7, "\t\t\t");
        _builder.append((Object)"List != null) ? ");
        String _name_14 = e.getName();
        String _firstLower_8 = StringExtensions.toFirstLower((String)_name_14);
        _builder.append((Object)_firstLower_8, "\t\t\t");
        _builder.append((Object)"List.size() : \"null\"));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_15 = e.getName();
        String _firstLower_9 = StringExtensions.toFirstLower((String)_name_15);
        _builder.append((Object)_firstLower_9, "\t\t");
        _builder.append((Object)"List;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<");
            String _name_16 = e.getName();
            _builder.append((Object)_name_16, "\t");
            _builder.append((Object)"> list(");
            String _name_17 = e.getName();
            _builder.append((Object)_name_17, "\t");
            _builder.append((Object)" ");
            String _name_18 = e.getName();
            String _firstLower_10 = StringExtensions.toFirstLower((String)_name_18);
            _builder.append((Object)_firstLower_10, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return list(sqlSessionFactory.getSqlSession(), ");
            String _name_19 = e.getName();
            String _firstLower_11 = StringExtensions.toFirstLower((String)_name_19);
            _builder.append((Object)_firstLower_11, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<");
        String _name_20 = e.getName();
        _builder.append((Object)_name_20, "\t");
        _builder.append((Object)"> list(SqlSession sqlSession, ");
        String _name_21 = e.getName();
        _builder.append((Object)_name_21, "\t");
        _builder.append((Object)" ");
        String _name_22 = e.getName();
        String _firstLower_12 = StringExtensions.toFirstLower((String)_name_22);
        _builder.append((Object)_firstLower_12, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return list(sqlSession, ");
        String _name_23 = e.getName();
        String _firstLower_13 = StringExtensions.toFirstLower((String)_name_23);
        _builder.append((Object)_firstLower_13, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<");
            String _name_24 = e.getName();
            _builder.append((Object)_name_24, "\t");
            _builder.append((Object)"> list(");
            String _name_25 = e.getName();
            _builder.append((Object)_name_25, "\t");
            _builder.append((Object)" ");
            String _name_26 = e.getName();
            String _firstLower_14 = StringExtensions.toFirstLower((String)_name_26);
            _builder.append((Object)_firstLower_14, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return list(");
            String _name_27 = e.getName();
            String _firstLower_15 = StringExtensions.toFirstLower((String)_name_27);
            _builder.append((Object)_firstLower_15, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileCount(PojoDao d, PojoEntity e, Map<String, Map<String, PojoType>> moreResultClasses, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int count(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"count ");
        String _name_2 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_3 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlQueryEngine sqlEngine");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"SELECT_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        boolean _isEmpty = moreResultClasses.isEmpty();
        if (_isEmpty) {
            _builder.append((Object)"//");
        }
        _builder.append((Object)"sqlControl = getMoreResultClasses(");
        String _name_5 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int count = sqlEngine");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)".queryCount(sqlSession, ");
        String _name_7 = e.getName();
        String _firstLower_4 = StringExtensions.toFirstLower((String)_name_7);
        _builder.append((Object)_firstLower_4, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"count: \" + count);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return count;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int count(");
            String _name_8 = e.getName();
            _builder.append((Object)_name_8, "\t");
            _builder.append((Object)" ");
            String _name_9 = e.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_9);
            _builder.append((Object)_firstLower_5, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return count(sqlSessionFactory.getSqlSession(), ");
            String _name_10 = e.getName();
            String _firstLower_6 = StringExtensions.toFirstLower((String)_name_10);
            _builder.append((Object)_firstLower_6, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int count(SqlSession sqlSession, ");
        String _name_11 = e.getName();
        _builder.append((Object)_name_11, "\t");
        _builder.append((Object)" ");
        String _name_12 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_12);
        _builder.append((Object)_firstLower_7, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return count(sqlSession, ");
        String _name_13 = e.getName();
        String _firstLower_8 = StringExtensions.toFirstLower((String)_name_13);
        _builder.append((Object)_firstLower_8, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int count(");
            String _name_14 = e.getName();
            _builder.append((Object)_name_14, "\t");
            _builder.append((Object)" ");
            String _name_15 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_15);
            _builder.append((Object)_firstLower_9, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return count(");
            String _name_16 = e.getName();
            String _firstLower_10 = StringExtensions.toFirstLower((String)_name_16);
            _builder.append((Object)_firstLower_10, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileMoreResultClasses(PojoDao d, PojoEntity e, Map<String, Map<String, PojoType>> moreResultClasses, ImportManager im) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"SqlControl getMoreResultClasses(");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (sqlControl != null && sqlControl.getMoreResultClasses() != null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return sqlControl;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Map<String, Class<?>> moreResultClasses = null;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        Set<Map.Entry<String, Map<String, PojoType>>> _entrySet = moreResultClasses.entrySet();
        boolean _hasElements = false;
        for (Map.Entry<String, Map<String, PojoType>> f : _entrySet) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n\t", "\t\t");
            }
            _builder.append((Object)"\t\tif (");
            String _name_2 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
            _builder.append((Object)_firstLower_1, "\t\t");
            _builder.append((Object)" != null && ");
            String _name_3 = e.getName();
            String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
            _builder.append((Object)_firstLower_2, "\t\t");
            _builder.append((Object)".toInit(");
            String _name_4 = e.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)".Association.");
            String _key = f.getKey();
            _builder.append((Object)_key, "\t\t");
            _builder.append((Object)".name())) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if (moreResultClasses == null)");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"moreResultClasses = new HashMap<String, Class<?>>();");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            Map<String, PojoType> _value = f.getValue();
            Set<Map.Entry<String, PojoType>> _entrySet_1 = _value.entrySet();
            boolean _hasElements_1 = false;
            for (Map.Entry<String, PojoType> a : _entrySet_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)"\n\t", "\t\t");
                }
                _builder.append((Object)"\t\tmoreResultClasses.put(\"");
                String _key_1 = a.getKey();
                _builder.append((Object)_key_1, "\t\t");
                _builder.append((Object)"\", ");
                PojoType _value_1 = a.getValue();
                PojoEntity _ref = _value_1.getRef();
                QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)_ref);
                _builder.append((Object)_fullyQualifiedName, "\t\t");
                _builder.append((Object)".class);");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (moreResultClasses != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"sqlControl = new SqlStandardControl(sqlControl);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"((SqlStandardControl) sqlControl).setMoreResultClasses(moreResultClasses);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return sqlControl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileIfx(PojoDao d) {
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        ImportManager im = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        this.addImplements(d, im);
        _builder.newLineIfNotEmpty();
        this.addExtends(d, im);
        _builder.newLineIfNotEmpty();
        PojoEntity pojo = this._processorGeneratorUtils.getPojo(d);
        _builder.newLineIfNotEmpty();
        CharSequence classBody = this.compileIfx(d, pojo, im);
        _builder.newLineIfNotEmpty();
        EObject _eContainer = d.eContainer();
        boolean bl = _notEquals = !Objects.equal((Object)_eContainer, null);
        if (_notEquals) {
            _builder.append((Object)"package ");
            EObject _eContainer_1 = d.eContainer();
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_1);
            _builder.append((Object)_fullyQualifiedName, "");
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlSession;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlControl;");
        _builder.newLine();
        _builder.append((Object)"import ");
        String _completeName = this._processorGeneratorUtils.completeName(pojo);
        _builder.append((Object)_completeName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        List<String> _imports = im.getImports();
        boolean _isEmpty = _imports.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            List<String> _imports_1 = im.getImports();
            for (String i : _imports_1) {
                _builder.append((Object)"import ");
                _builder.append((Object)i, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)classBody, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compileIfx(PojoDao d, PojoEntity e, ImportManager im) {
        boolean _isQuery;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public interface ");
        String _name = d.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        boolean _isCRUD = this._processorGeneratorUtils.isCRUD(d);
        if (_isCRUD) {
            CharSequence _compileInsertIfx = this.compileInsertIfx(d, e, im, true);
            _builder.append((Object)_compileInsertIfx, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _compileGetIfx = this.compileGetIfx(d, e, im, true);
            _builder.append((Object)_compileGetIfx, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _compileUpdateIfx = this.compileUpdateIfx(d, e, im, true);
            _builder.append((Object)_compileUpdateIfx, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _compileDeleteIfx = this.compileDeleteIfx(d, e, im, true);
            _builder.append((Object)_compileDeleteIfx, "\t");
        }
        if (_isQuery = this._processorGeneratorUtils.isQuery(d)) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _compileListIfx = this.compileListIfx(d, e, im, true);
            _builder.append((Object)_compileListIfx, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _compileCountIfx = this.compileCountIfx(d, e, im, true);
            _builder.append((Object)_compileCountIfx, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        List<FunProcDirective> _listFunctionsDirectives = this._processorGeneratorUtils.listFunctionsDirectives(d);
        for (FunProcDirective fp : _listFunctionsDirectives) {
            FunProcType _type = fp.getType();
            DaoDirectiveParameters _paramlist = fp.getParamlist();
            CharSequence _compileFunctionProcedureIfx = this.compileFunctionProcedureIfx(d, e, _type, _paramlist, im, true);
            _builder.append((Object)_compileFunctionProcedureIfx, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _compileFunctionProcedureIfx(PojoDao d, PojoEntity e, FunctionCallQuery type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        PojoType _out = p.getOut();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_out, im);
        _builder.append((Object)_compileType, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType_1, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_1 = p.getOut();
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_out_1, im);
            _builder.append((Object)_compileType_2, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_1 = p.getIns();
            boolean _hasElements_1 = false;
            for (PojoType ma_1 : _ins_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(ma_1, im);
                _builder.append((Object)_compileType_3, "");
                _builder.append((Object)" ");
                String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
                _builder.append((Object)_paramName_1, "");
            }
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public ");
        PojoType _out_2 = p.getOut();
        CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_out_2, im);
        _builder.append((Object)_compileType_4, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_2 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(ma_2, im);
            _builder.append((Object)_compileType_5, "");
            _builder.append((Object)" ");
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_3 = p.getOut();
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_out_3, im);
            _builder.append((Object)_compileType_6, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_3 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_7, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _compileFunctionProcedureIfx(PojoDao d, PojoEntity e, ProcedureCallQuery type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        PojoType _out = p.getOut();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_out, im);
        _builder.append((Object)_compileType, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType_1, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_1 = p.getOut();
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_out_1, im);
            _builder.append((Object)_compileType_2, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_1 = p.getIns();
            boolean _hasElements_1 = false;
            for (PojoType ma_1 : _ins_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(ma_1, im);
                _builder.append((Object)_compileType_3, "");
                _builder.append((Object)" ");
                String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
                _builder.append((Object)_paramName_1, "");
            }
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public ");
        PojoType _out_2 = p.getOut();
        CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_out_2, im);
        _builder.append((Object)_compileType_4, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_2 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(ma_2, im);
            _builder.append((Object)_compileType_5, "");
            _builder.append((Object)" ");
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_3 = p.getOut();
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_out_3, im);
            _builder.append((Object)_compileType_6, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_3 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_7, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _compileFunctionProcedureIfx(PojoDao d, PojoEntity e, FunctionCall type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        PojoType _out = p.getOut();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_out, im);
        _builder.append((Object)_compileType, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType_1, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_1 = p.getOut();
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_out_1, im);
            _builder.append((Object)_compileType_2, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_1 = p.getIns();
            boolean _hasElements_1 = false;
            for (PojoType ma_1 : _ins_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(ma_1, im);
                _builder.append((Object)_compileType_3, "");
                _builder.append((Object)" ");
                String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
                _builder.append((Object)_paramName_1, "");
            }
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public ");
        PojoType _out_2 = p.getOut();
        CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_out_2, im);
        _builder.append((Object)_compileType_4, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_2 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(ma_2, im);
            _builder.append((Object)_compileType_5, "");
            _builder.append((Object)" ");
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_3 = p.getOut();
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_out_3, im);
            _builder.append((Object)_compileType_6, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_3 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_7, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _compileFunctionProcedureIfx(PojoDao d, PojoEntity e, ProcedureUpdate type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public int ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public int ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_1 = p.getIns();
            boolean _hasElements_1 = false;
            for (PojoType ma_1 : _ins_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma_1, im);
                _builder.append((Object)_compileType_1, "");
                _builder.append((Object)" ");
                String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
                _builder.append((Object)_paramName_1, "");
            }
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public int ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_2 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(ma_2, im);
            _builder.append((Object)_compileType_2, "");
            _builder.append((Object)" ");
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public int ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_3 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_3, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _compileFunctionProcedureIfx(PojoDao d, PojoEntity e, FunctionQuery type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        String name = this._processorGeneratorUtils.getFunProcName(d);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        PojoType _out = p.getOut();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_out, im);
        _builder.append((Object)_compileType, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins = p.getIns();
        boolean _hasElements = false;
        for (PojoType ma : _ins) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ma, im);
            _builder.append((Object)_compileType_1, "");
            _builder.append((Object)" ");
            String _paramName = this._processorGeneratorUtils.getParamName(ma);
            _builder.append((Object)_paramName, "");
        }
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_1 = p.getOut();
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_out_1, im);
            _builder.append((Object)_compileType_2, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_1 = p.getIns();
            boolean _hasElements_1 = false;
            for (PojoType ma_1 : _ins_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(ma_1, im);
                _builder.append((Object)_compileType_3, "");
                _builder.append((Object)" ");
                String _paramName_1 = this._processorGeneratorUtils.getParamName(ma_1);
                _builder.append((Object)_paramName_1, "");
            }
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public ");
        PojoType _out_2 = p.getOut();
        CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_out_2, im);
        _builder.append((Object)_compileType_4, "");
        _builder.append((Object)" ");
        _builder.append((Object)name, "");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoType> _ins_2 = p.getIns();
        boolean _hasElements_2 = false;
        for (PojoType ma_2 : _ins_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(ma_2, im);
            _builder.append((Object)_compileType_5, "");
            _builder.append((Object)" ");
            String _paramName_2 = this._processorGeneratorUtils.getParamName(ma_2);
            _builder.append((Object)_paramName_2, "");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            PojoType _out_3 = p.getOut();
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_out_3, im);
            _builder.append((Object)_compileType_6, "");
            _builder.append((Object)" ");
            _builder.append((Object)name, "");
            _builder.append((Object)"(");
            EList<PojoType> _ins_3 = p.getIns();
            boolean _hasElements_3 = false;
            for (PojoType ma_3 : _ins_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(ma_3, im);
                _builder.append((Object)_compileType_7, "");
                _builder.append((Object)" ");
                String _paramName_3 = this._processorGeneratorUtils.getParamName(ma_3);
                _builder.append((Object)_paramName_3, "");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileInsertIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" insert(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            String _name_3 = e.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)" insert(");
            String _name_4 = e.getName();
            _builder.append((Object)_name_4, "");
            _builder.append((Object)" ");
            String _name_5 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_1, "");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public ");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "");
        _builder.append((Object)" insert(SqlSession sqlSession, ");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "");
        _builder.append((Object)" ");
        String _name_8 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_8);
        _builder.append((Object)_firstLower_2, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            String _name_9 = e.getName();
            _builder.append((Object)_name_9, "");
            _builder.append((Object)" insert(");
            String _name_10 = e.getName();
            _builder.append((Object)_name_10, "");
            _builder.append((Object)" ");
            String _name_11 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_11);
            _builder.append((Object)_firstLower_3, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileGetIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" get(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            String _name_3 = e.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)" get(");
            String _name_4 = e.getName();
            _builder.append((Object)_name_4, "");
            _builder.append((Object)" ");
            String _name_5 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_1, "");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public ");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "");
        _builder.append((Object)" get(SqlSession sqlSession, ");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "");
        _builder.append((Object)" ");
        String _name_8 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_8);
        _builder.append((Object)_firstLower_2, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public ");
            String _name_9 = e.getName();
            _builder.append((Object)_name_9, "");
            _builder.append((Object)" get(");
            String _name_10 = e.getName();
            _builder.append((Object)_name_10, "");
            _builder.append((Object)" ");
            String _name_11 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_11);
            _builder.append((Object)_firstLower_3, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileUpdateIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public int update(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public int update(");
            String _name_2 = e.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)" ");
            String _name_3 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
            _builder.append((Object)_firstLower_1, "");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public int update(SqlSession sqlSession, ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)" ");
        String _name_5 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public int update(");
            String _name_6 = e.getName();
            _builder.append((Object)_name_6, "");
            _builder.append((Object)" ");
            String _name_7 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
            _builder.append((Object)_firstLower_3, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileDeleteIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public int delete(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public int delete(");
            String _name_2 = e.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)" ");
            String _name_3 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
            _builder.append((Object)_firstLower_1, "");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public int delete(SqlSession sqlSession, ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)" ");
        String _name_5 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public int delete(");
            String _name_6 = e.getName();
            _builder.append((Object)_name_6, "");
            _builder.append((Object)" ");
            String _name_7 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
            _builder.append((Object)_firstLower_3, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileListIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public List<");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"> list(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public List<");
            String _name_3 = e.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)"> list(");
            String _name_4 = e.getName();
            _builder.append((Object)_name_4, "");
            _builder.append((Object)" ");
            String _name_5 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_1, "");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public List<");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "");
        _builder.append((Object)"> list(SqlSession sqlSession, ");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "");
        _builder.append((Object)" ");
        String _name_8 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_8);
        _builder.append((Object)_firstLower_2, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public List<");
            String _name_9 = e.getName();
            _builder.append((Object)_name_9, "");
            _builder.append((Object)"> list(");
            String _name_10 = e.getName();
            _builder.append((Object)_name_10, "");
            _builder.append((Object)" ");
            String _name_11 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_11);
            _builder.append((Object)_firstLower_3, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileCountIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public int count(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public int count(");
            String _name_2 = e.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)" ");
            String _name_3 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
            _builder.append((Object)_firstLower_1, "");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public int count(SqlSession sqlSession, ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)" ");
        String _name_5 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"public int count(");
            String _name_6 = e.getName();
            _builder.append((Object)_name_6, "");
            _builder.append((Object)" ");
            String _name_7 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
            _builder.append((Object)_firstLower_3, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileExtends(PojoDao e, ImportManager im) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        PojoDao _superType = this._processorGeneratorUtils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            _builder.append((Object)"extends ");
            PojoDao _superType_1 = this._processorGeneratorUtils.getSuperType(e);
            PojoDao _superType_2 = this._processorGeneratorUtils.getSuperType(e);
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)_superType_2);
            String _fullName = Utils.getFullName(e, _superType_1, _fullyQualifiedName, im);
            _builder.append((Object)_fullName, "");
            _builder.append((Object)" ");
        } else {
            boolean _notEquals_1;
            String _extends = this.getExtends(e);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_extends, (Object)"");
            if (_notEquals_1) {
                _builder.append((Object)"extends ");
                String _extends_1 = this.getExtends(e);
                _builder.append((Object)_extends_1, "");
                _builder.append((Object)" ");
            }
        }
        return _builder;
    }

    public CharSequence compileImplements(PojoDao d, String implPackage) {
        boolean _notEquals_1;
        String _sernum;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _or = false;
        boolean _or_1 = false;
        boolean _isImplements = this.isImplements(d);
        _or_1 = _isImplements ? true : (_notEquals = !Objects.equal((Object)(_sernum = this._processorGeneratorUtils.getSernum(d)), null));
        _or = _or_1 ? true : (_notEquals_1 = !Objects.equal((Object)implPackage, null));
        if (_or) {
            boolean _notEquals_3;
            boolean _notEquals_2;
            _builder.append((Object)"implements ");
            ArrayList<Implements> _implements = this.getImplements(d);
            boolean _hasElements = false;
            for (Implements f : _implements) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _daoImplements = this._processorGeneratorUtils.getDaoImplements(d, f);
                _builder.append((Object)_daoImplements, "");
            }
            String _sernum_1 = this._processorGeneratorUtils.getSernum(d);
            boolean bl = _notEquals_2 = !Objects.equal((Object)_sernum_1, null);
            if (_notEquals_2) {
                boolean _isImplements_1 = this.isImplements(d);
                if (_isImplements_1) {
                    _builder.append((Object)", ");
                }
                _builder.append((Object)"Serializable");
            }
            boolean bl2 = _notEquals_3 = !Objects.equal((Object)implPackage, null);
            if (_notEquals_3) {
                String _sernum_2;
                boolean _notEquals_4;
                boolean _or_2 = false;
                boolean _isImplements_2 = this.isImplements(d);
                _or_2 = _isImplements_2 ? true : (_notEquals_4 = !Objects.equal((Object)(_sernum_2 = this._processorGeneratorUtils.getSernum(d)), null));
                if (_or_2) {
                    _builder.append((Object)", ");
                }
                String _name = d.getName();
                _builder.append((Object)_name, "");
            }
            _builder.append((Object)" ");
        }
        return _builder;
    }

    public void addImplements(PojoDao e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements impl : _filter) {
            JvmType _implements = impl.getImplements();
            im.addImportFor(_implements);
        }
    }

    public void addExtends(PojoDao e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            JvmType _extends = ext.getExtends();
            im.addImportFor(_extends);
        }
    }

    public boolean isExtends(PojoDao e) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            boolean _not;
            Extends ext = (Extends)iterator.next();
            EList<PojoDao> _onlyDaos = ext.getOnlyDaos();
            boolean _isEmpty = _onlyDaos.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                EList<PojoDao> _onlyDaos_1 = ext.getOnlyDaos();
                for (PojoDao ee : _onlyDaos_1) {
                    String _name_1;
                    String _name = ee.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                    if (!_equals) continue;
                    return true;
                }
                return false;
            }
            EList<PojoDao> _exceptDaos = ext.getExceptDaos();
            for (PojoDao ee_1 : _exceptDaos) {
                String _name_3;
                String _name_2 = ee_1.getName();
                boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
                if (!_equals_1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isExtends(PojoDao e, Extends ext) {
        boolean _not;
        EList<PojoDao> _onlyDaos = ext.getOnlyDaos();
        boolean _isEmpty = _onlyDaos.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<PojoDao> _onlyDaos_1 = ext.getOnlyDaos();
            for (PojoDao ee : _onlyDaos_1) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return true;
            }
            return false;
        }
        EList<PojoDao> _exceptDaos = ext.getExceptDaos();
        for (PojoDao ee_1 : _exceptDaos) {
            String _name_3;
            String _name_2 = ee_1.getName();
            boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
            if (!_equals_1) continue;
            return false;
        }
        return true;
    }

    public String getExtends(PojoDao e) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            boolean _isExtends = this.isExtends(e, ext);
            if (!_isExtends) continue;
            JvmType _extends = ext.getExtends();
            return _extends.getSimpleName();
        }
        return "";
    }

    public boolean isImplements(PojoDao e) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements ext : _filter) {
            boolean _not;
            EList<PojoDao> _exceptDaos = ext.getExceptDaos();
            for (PojoDao ee : _exceptDaos) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return false;
            }
            EList<PojoDao> _onlyDaos = ext.getOnlyDaos();
            boolean _isEmpty = _onlyDaos.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                EList<PojoDao> _onlyDaos_1 = ext.getOnlyDaos();
                for (PojoDao ee_1 : _onlyDaos_1) {
                    String _name_3;
                    String _name_2 = ee_1.getName();
                    boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
                    if (!_equals_1) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean isImplements(PojoDao e, Implements ext) {
        boolean _not;
        EList<PojoDao> _onlyDaos = ext.getOnlyDaos();
        boolean _isEmpty = _onlyDaos.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<PojoDao> _onlyDaos_1 = ext.getOnlyDaos();
            for (PojoDao ee : _onlyDaos_1) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return true;
            }
            return false;
        }
        EList<PojoDao> _exceptDaos = ext.getExceptDaos();
        for (PojoDao ee_1 : _exceptDaos) {
            String _name_3;
            String _name_2 = ee_1.getName();
            boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
            if (!_equals_1) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Implements> getImplements(PojoDao e) {
        ArrayList<Implements> list = new ArrayList<Implements>();
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements ext : _filter) {
            boolean _isImplements = this.isImplements(e, ext);
            if (!_isImplements) continue;
            list.add(ext);
        }
        return list;
    }

    public CharSequence compileFunctionProcedure(PojoDao d, PojoEntity e, FunProcType type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        if (type instanceof FunctionCall) {
            return this._compileFunctionProcedure(d, e, (FunctionCall)type, p, im, all);
        }
        if (type instanceof FunctionCallQuery) {
            return this._compileFunctionProcedure(d, e, (FunctionCallQuery)type, p, im, all);
        }
        if (type instanceof FunctionQuery) {
            return this._compileFunctionProcedure(d, e, (FunctionQuery)type, p, im, all);
        }
        if (type instanceof ProcedureCallQuery) {
            return this._compileFunctionProcedure(d, e, (ProcedureCallQuery)type, p, im, all);
        }
        if (type instanceof ProcedureUpdate) {
            return this._compileFunctionProcedure(d, e, (ProcedureUpdate)type, p, im, all);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(d, e, type, p, im, all).toString());
    }

    public CharSequence compileFunctionProcedureIfx(PojoDao d, PojoEntity e, FunProcType type, DaoDirectiveParameters p, ImportManager im, boolean all) {
        if (type instanceof FunctionCall) {
            return this._compileFunctionProcedureIfx(d, e, (FunctionCall)type, p, im, all);
        }
        if (type instanceof FunctionCallQuery) {
            return this._compileFunctionProcedureIfx(d, e, (FunctionCallQuery)type, p, im, all);
        }
        if (type instanceof FunctionQuery) {
            return this._compileFunctionProcedureIfx(d, e, (FunctionQuery)type, p, im, all);
        }
        if (type instanceof ProcedureCallQuery) {
            return this._compileFunctionProcedureIfx(d, e, (ProcedureCallQuery)type, p, im, all);
        }
        if (type instanceof ProcedureUpdate) {
            return this._compileFunctionProcedureIfx(d, e, (ProcedureUpdate)type, p, im, all);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(d, e, type, p, im, all).toString());
    }
}

