/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.util.Strings;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.Package;
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoEntity;

public class ImportManager {
    private Map<String, String> imports = Maps.newHashMap();
    private boolean organizeImports;
    private String thisTypeSimpleName;
    private String thisTypeQualifiedName;
    private final char innerTypeSeparator;
    private Pattern JAVA_LANG_PACK = Pattern.compile("java\\.lang\\.[\\w]+");
    private boolean thisCollidesWithJavaLang;

    public ImportManager(boolean organizeImports, char innerTypeSeparator) {
        this(organizeImports, null, innerTypeSeparator);
    }

    public ImportManager(boolean organizeImports) {
        this(organizeImports, null);
    }

    public ImportManager(boolean organizeImports, JvmDeclaredType thisType) {
        this(organizeImports, thisType, '.');
    }

    public ImportManager(boolean organizeImports, JvmDeclaredType thisType, char innerTypeSeparator) {
        this.organizeImports = organizeImports;
        this.innerTypeSeparator = innerTypeSeparator;
        if (thisType != null) {
            this.thisTypeSimpleName = thisType.getSimpleName();
            this.thisTypeQualifiedName = thisType.getQualifiedName(innerTypeSeparator);
            this.thisCollidesWithJavaLang = CodeGenUtil.isJavaLangType((String)this.thisTypeSimpleName);
        }
    }

    public CharSequence serialize(JvmType type) {
        StringBuilder sb = new StringBuilder();
        this.appendType(type, sb);
        return sb;
    }

    public void appendType(JvmType type, StringBuilder builder) {
        if (type instanceof JvmPrimitiveType || type instanceof JvmVoid || type instanceof JvmTypeParameter) {
            builder.append(type.getQualifiedName(this.innerTypeSeparator));
        } else if (type instanceof JvmArrayType) {
            this.appendType((JvmType)((JvmArrayType)type).getComponentType(), builder);
            builder.append("[]");
        } else {
            String simpleName;
            String qualifiedName = type.getQualifiedName(this.innerTypeSeparator);
            if (this.allowsSimpleName(qualifiedName, simpleName = type.getSimpleName())) {
                builder.append(simpleName);
            } else if (this.needsQualifiedName(qualifiedName, simpleName)) {
                builder.append(qualifiedName);
            } else if (this.imports.containsKey(simpleName)) {
                if (qualifiedName.equals(this.imports.get(simpleName))) {
                    builder.append(simpleName);
                } else {
                    builder.append(qualifiedName);
                }
            } else {
                this.imports.put(simpleName, qualifiedName);
                builder.append(simpleName);
            }
        }
    }

    protected boolean allowsSimpleName(String qualifiedName, String simpleName) {
        return Strings.equal((String)qualifiedName, (String)this.thisTypeQualifiedName) || !this.thisCollidesWithJavaLang && this.JAVA_LANG_PACK.matcher(qualifiedName).matches() || Strings.equal((String)qualifiedName, (String)simpleName);
    }

    protected boolean needsQualifiedName(String qualifiedName, String simpleName) {
        return !this.organizeImports || Strings.equal((String)simpleName, (String)this.thisTypeSimpleName) && !Strings.equal((String)qualifiedName, (String)this.thisTypeQualifiedName) || CodeGenUtil.isJavaLangType((String)simpleName);
    }

    public boolean addImportFor(JvmType type) {
        String simpleName;
        String qualifiedName = type.getQualifiedName(this.innerTypeSeparator);
        if (!(this.allowsSimpleName(qualifiedName, simpleName = type.getSimpleName()) || this.needsQualifiedName(qualifiedName, simpleName) || this.imports.containsKey(simpleName))) {
            this.imports.put(simpleName, qualifiedName);
            return true;
        }
        return false;
    }

    public boolean addImportFor(PojoEntity type) {
        Package packageDeclaration = (Package)EcoreUtil2.getContainerOfType((EObject)type, Package.class);
        String simpleName = type.getName();
        String qualifiedName = String.valueOf(packageDeclaration.getName()) + "." + simpleName;
        if (!(this.allowsSimpleName(qualifiedName, simpleName) || this.needsQualifiedName(qualifiedName, simpleName) || this.imports.containsKey(simpleName))) {
            this.imports.put(simpleName, qualifiedName);
            return true;
        }
        return false;
    }

    public boolean addImportFor(EnumEntity type) {
        Package packageDeclaration = (Package)EcoreUtil2.getContainerOfType((EObject)type, Package.class);
        String simpleName = type.getName();
        String qualifiedName = String.valueOf(packageDeclaration.getName()) + "." + simpleName;
        if (!(this.allowsSimpleName(qualifiedName, simpleName) || this.needsQualifiedName(qualifiedName, simpleName) || this.imports.containsKey(simpleName))) {
            this.imports.put(simpleName, qualifiedName);
            return true;
        }
        return false;
    }

    public boolean addImportFor(PojoDao type) {
        Package packageDeclaration = (Package)EcoreUtil2.getContainerOfType((EObject)type, Package.class);
        String simpleName = type.getName();
        String qualifiedName = String.valueOf(packageDeclaration.getName()) + "." + simpleName;
        if (!(this.allowsSimpleName(qualifiedName, simpleName) || this.needsQualifiedName(qualifiedName, simpleName) || this.imports.containsKey(simpleName))) {
            this.imports.put(simpleName, qualifiedName);
            return true;
        }
        return false;
    }

    public boolean addImportFor(PojoAnnotatedProperty type, String name) {
        Package packageDeclaration = (Package)EcoreUtil2.getContainerOfType((EObject)type, Package.class);
        String simpleName = name;
        String qualifiedName = String.valueOf(packageDeclaration.getName()) + "." + simpleName;
        if (!(this.allowsSimpleName(qualifiedName, simpleName) || this.needsQualifiedName(qualifiedName, simpleName) || this.imports.containsKey(simpleName))) {
            this.imports.put(simpleName, qualifiedName);
            return true;
        }
        return false;
    }

    public List<String> getImports() {
        ArrayList result = Lists.newArrayList(this.imports.values());
        Collections.sort(result);
        return result;
    }
}

