/*
 * generated by Xtext
 */
package org.sqlproc.dsl.generator

import org.sqlproc.dsl.processorDsl.PojoEntity
import com.google.inject.Inject
import org.eclipse.xtext.naming.IQualifiedNameProvider
import org.sqlproc.dsl.ImportManager

import static org.sqlproc.dsl.util.Utils.*;
import java.util.ArrayList
import org.sqlproc.dsl.processorDsl.Implements
import org.sqlproc.dsl.processorDsl.Extends
import org.sqlproc.dsl.processorDsl.PojoDao
import java.util.List
import org.sqlproc.dsl.processorDsl.PojoMethodArg
import java.util.Map
import org.sqlproc.dsl.processorDsl.ImplPackage
import org.sqlproc.dsl.processorDsl.PojoMethod

/**
 * Generates code from your model files on save.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#TutorialCodeGeneration
 */
class ProcessorDaoGenerator {
	
	@Inject extension IQualifiedNameProvider
	@Inject extension ProcessorGeneratorUtils
	
	def compile(PojoDao d) '''
		«val im = new ImportManager(true)»
		«addImplements(d, im)»
		«addExtends(d, im)»
		«val toInits = getToInits(d)»
		«val classBody = compile(d, d.pojo, toInits, im)»
		«IF d.eContainer != null»package «d.eContainer.fullyQualifiedName»«IF d.implPackage != null».«d.implPackage»«ENDIF»;«ENDIF»
		«IF d.implPackage != null»
		
		import «d.eContainer.fullyQualifiedName».«d.name»;
		«ENDIF»
		«IF !im.imports.empty»
			
		«FOR i : im.imports»
		import «i»;
		«ENDFOR»
		«ENDIF»
		«IF getSernum(d) != null»
		
		import java.io.Serializable;
		«ENDIF»
		
		import java.util.HashMap;
		import java.util.List;
		import java.util.Map;
		
		import org.slf4j.Logger;
		import org.slf4j.LoggerFactory;
		import org.sqlproc.engine.SqlControl;
		import org.sqlproc.engine.SqlCrudEngine;
		import org.sqlproc.engine.SqlEngineFactory;
		import org.sqlproc.engine.SqlQueryEngine;
		import org.sqlproc.engine.SqlProcedureEngine;
		import org.sqlproc.engine.SqlSession;
		import org.sqlproc.engine.SqlSessionFactory;
		import org.sqlproc.engine.impl.SqlStandardControl;
		«IF d.pojo != null»import «d.pojo.completeName»;«ENDIF»
		«FOR f:toInits.entrySet»«FOR a:f.value SEPARATOR "
		"»import «a.type.ref.completeName»;«ENDFOR»«ENDFOR»
		
		«classBody»
	'''
	
	def compile(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im) '''
		public «IF isAbstract(d)»abstract «ENDIF»class «d.name»«IF d.implPackage != null»Impl«ENDIF» «compileExtends(d, im)»«compileImplements(d)»{
			«IF getSernum(d) != null»
			
			private static final long serialVersionUID = «getSernum(d)»L;
			«ENDIF»
			protected final Logger logger = LoggerFactory.getLogger(getClass());
		
			protected SqlEngineFactory sqlEngineFactory;
			protected SqlSessionFactory sqlSessionFactory;
					
			public «d.name»«IF d.implPackage != null»Impl«ENDIF»() {
			}
					
			public «d.name»«IF d.implPackage != null»Impl«ENDIF»(SqlEngineFactory sqlEngineFactory) {
				this.sqlEngineFactory = sqlEngineFactory;
			}
					
			public «d.name»«IF d.implPackage != null»Impl«ENDIF»(SqlEngineFactory sqlEngineFactory, SqlSessionFactory sqlSessionFactory) {
				this.sqlEngineFactory = sqlEngineFactory;
				this.sqlSessionFactory = sqlSessionFactory;
			}
			
		«FOR m:d.methods»«IF m.name == "scaffold" || m.name == "scaffold0"»«compileInsert(d, e, getParent(e), im, m.name == "scaffold")»
		«compileGet(d, e, toInits, im, m.name == "scaffold")»
		«compileUpdate(d, e, getParent(e), im, m.name == "scaffold")»
		«compileDelete(d, e, getParent(e), im, m.name == "scaffold")»
		«compileList(d, e, toInits, im, m.name == "scaffold")»
		«compileCount(d, e, toInits, im, m.name == "scaffold")»
		«IF !toInits.empty»«compileMoreResultClasses(d, e, toInits, im)»«ENDIF»«ELSEIF isCallUpdate(m)»
		«compileCallUpdate(d, m, im, true)»«ELSEIF isCallFunction(m)»«compileCallFunction(d, m, im, true)»«ELSEIF isCallQuery(m) || isCallQueryFunction(m)»«compileCallQuery(d, m, im, isCallQueryFunction(m), true)»«ELSEIF isCallSelectFunction(m)»«compileCallSelectFunction(d, m, im, true)»«ENDIF»«ENDFOR»
		}
	'''
	
	def compileCallQuery(PojoDao d, PojoMethod m, ImportManager im, boolean isFunction, boolean all) '''
	
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("«m.name»: " + «FOR ma:m.args SEPARATOR " + \" \" "»«ma.name»«ENDFOR» + " " + sqlControl);
			}
			SqlProcedureEngine sqlProc«m.name.toFirstUpper» = sqlEngineFactory.getCheckedProcedureEngine("«IF isFunction»FUN«ELSE»PROC«ENDIF»_«dbName(m)»");
			«m.type.compileType(im)» list = sqlProc«m.name.toFirstUpper».callQuery(sqlSession, «m.type.gref.name».class, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
			if (logger.isTraceEnabled()) {
				logger.trace("«m.name» result: " + list);
			}
			return list;
		}
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
			return «m.name»(sqlSessionFactory.getSqlSession(), «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
		}
		«ENDIF»
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
			return «m.name»(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
		}
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
			return «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
		}
		«ENDIF»
	'''
	
	def compileCallFunction(PojoDao d, PojoMethod m, ImportManager im, boolean all) '''
	
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("«m.name»: " + «FOR ma:m.args SEPARATOR " + \" \" "»«ma.name»«ENDFOR» + " " + sqlControl);
			}
			SqlProcedureEngine sqlFun«m.name.toFirstUpper» = sqlEngineFactory.getCheckedProcedureEngine("FUN_«dbName(m)»");
			Object result = sqlFun«m.name.toFirstUpper».callFunction(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
			if (logger.isTraceEnabled()) {
				logger.trace("«m.name» result: " + result);
			}
			return («m.type.compileType(im)») result;
		}
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
			return «m.name»(sqlSessionFactory.getSqlSession(), «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
		}
		«ENDIF»
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
			return «m.name»(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
		}
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
			return «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
		}
		«ENDIF»
	'''
	
	def compileCallUpdate(PojoDao d, PojoMethod m, ImportManager im, boolean all) '''
	
		public int «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("«m.name»: " + «FOR ma:m.args SEPARATOR " + \" \" "»«ma.name»«ENDFOR» + " " + sqlControl);
			}
			SqlProcedureEngine sqlProc«m.name.toFirstUpper» = sqlEngineFactory.getCheckedProcedureEngine("PROC_«dbName(m)»");
			int count = sqlProc«m.name.toFirstUpper».callUpdate(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
			if (logger.isTraceEnabled()) {
				logger.trace("«m.name» result: " + count);
			}
			return count;
		}
		«IF all»
		public int «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
			return «m.name»(sqlSessionFactory.getSqlSession(), «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
		}
		«ENDIF»
		public int «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
			return «m.name»(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
		}
		«IF all»
		public int «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
			return «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
		}
		«ENDIF»
	'''
	
	def compileCallSelectFunction(PojoDao d, PojoMethod m, ImportManager im, boolean all) '''
	
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("«m.name»: " + «FOR ma:m.args SEPARATOR " + \" \" "»«ma.name»«ENDFOR» + " " + sqlControl);
			}
			SqlQueryEngine sqlFun«m.name.toFirstUpper» = sqlEngineFactory.getCheckedQueryEngine("FUN_«dbName(m)»");
			java.util.List<«m.args.get(0).type.compileType(im)»> list = sqlFun«m.name.toFirstUpper».query(sqlSession, «m.args.get(0).type.compileType(im)».class, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
			if (logger.isTraceEnabled()) {
				logger.trace("«m.name» result: " + list);
			}
			return (list != null && !list.isEmpty()) ? list.get(0).getResult() : null;
		}
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
			return «m.name»(sqlSessionFactory.getSqlSession(), «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
		}
		«ENDIF»
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
			return «m.name»(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
		}
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
			return «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
		}
		«ENDIF»
	'''
	
	def compileInsert(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im, boolean all) '''
	
		public «e.name» insert(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("insert «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
			}
			SqlCrudEngine sqlInsert«e.name» = sqlEngineFactory.getCheckedCrudEngine("INSERT_«dbName(e)»");«IF pe != null»
			SqlCrudEngine sqlInsert«pe.name» = sqlEngineFactory.getCheckedCrudEngine("INSERT_«dbName(pe)»");
			int count = sqlInsert«pe.name».insert(sqlSession, «e.name.toFirstLower», sqlControl);
			if (count > 0) {
				sqlInsert«e.name».insert(sqlSession, «e.name.toFirstLower», sqlControl);
			}«ELSE»
			int count = sqlInsert«e.name».insert(sqlSession, «e.name.toFirstLower», sqlControl);«ENDIF»
			if (logger.isTraceEnabled()) {
				logger.trace("insert «e.name.toFirstLower» result: " + count + " " + «e.name.toFirstLower»);
			}
			return (count > 0) ? «e.name.toFirstLower» : null;
		}
		«IF all»
		public «e.name» insert(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			return insert(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
		}
		«ENDIF»
		public «e.name» insert(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
			return insert(sqlSession, «e.name.toFirstLower», null);
		}
		«IF all»
		public «e.name» insert(«e.name» «e.name.toFirstLower») {
			return insert(«e.name.toFirstLower», null);
		}
		«ENDIF»
	'''	
	def compileGet(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im, boolean all) '''
	
		public «e.name» get(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("get get: " + «e.name.toFirstLower» + " " + sqlControl);
			}
			SqlCrudEngine sqlGetEngine«e.name» = sqlEngineFactory.getCheckedCrudEngine("GET_«dbName(e)»");
			«IF toInits.empty»//«ENDIF»sqlControl = getMoreResultClasses(«e.name.toFirstLower», sqlControl);
			«e.name» «e.name.toFirstLower»Got = sqlGetEngine«e.name».get(sqlSession, «e.name».class, «e.name.toFirstLower», sqlControl);
			if (logger.isTraceEnabled()) {
				logger.trace("get «e.name.toFirstLower» result: " + «e.name.toFirstLower»Got);
			}
			return «e.name.toFirstLower»Got;
		}
		«IF all»
		public «e.name» get(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			return get(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
		}
		«ENDIF»
		public «e.name» get(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
			return get(sqlSession, «e.name.toFirstLower», null);
		}
		«IF all»
		public «e.name» get(«e.name» «e.name.toFirstLower») {
			return get(«e.name.toFirstLower», null);
		}
		«ENDIF»
	'''
	
	def compileUpdate(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im, boolean all) '''
	
		public int update(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("update «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
			}
			SqlCrudEngine sqlUpdateEngine«e.name» = sqlEngineFactory.getCheckedCrudEngine("UPDATE_«dbName(e)»");«IF pe != null»
			SqlCrudEngine sqlUpdate«pe.name» = sqlEngineFactory.getCheckedCrudEngine("UPDATE_«dbName(pe)»");«ENDIF»
			int count = sqlUpdateEngine«e.name».update(sqlSession, «e.name.toFirstLower», sqlControl);«IF pe != null»
			if (count > 0) {
				sqlUpdate«pe.name».update(sqlSession, «e.name.toFirstLower», sqlControl);
			}«ENDIF»«val f=getOptLock(e)»«IF f != null»
			if (count > 0) {
				«e.name.toFirstLower».set«f.name.toFirstUpper»(«e.name.toFirstLower».get«f.name.toFirstUpper»() + 1);
			}«ENDIF»
			if (logger.isTraceEnabled()) {
				logger.trace("update «e.name.toFirstLower» result count: " + count);
			}
			return count;
		}
		«IF all»
		public int update(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			return update(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
		}
		«ENDIF»
		public int update(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
			return update(sqlSession, «e.name.toFirstLower», null);
		}
		«IF all»
		public int update(«e.name» «e.name.toFirstLower») {
			return update(«e.name.toFirstLower», null);
		}
		«ENDIF»
	'''	
	def compileDelete(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im, boolean all) '''
	
		public int delete(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("delete «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
			}
			SqlCrudEngine sqlDeleteEngine«e.name» = sqlEngineFactory.getCheckedCrudEngine("DELETE_«dbName(e)»");«IF pe != null»
			SqlCrudEngine sqlDelete«pe.name» = sqlEngineFactory.getCheckedCrudEngine("DELETE_«dbName(pe)»");«ENDIF»
			int count = sqlDeleteEngine«e.name».delete(sqlSession, «e.name.toFirstLower», sqlControl);«IF pe != null»
			if (count > 0) {
				sqlDelete«pe.name».delete(sqlSession, «e.name.toFirstLower», sqlControl);
			}«ENDIF»«val f=getOptLock(e)»«IF f != null»
			if (count > 0) {
				«e.name.toFirstLower».set«f.name.toFirstUpper»(«e.name.toFirstLower».get«f.name.toFirstUpper»() + 1);
			}«ENDIF»
			if (logger.isTraceEnabled()) {
				logger.trace("delete «e.name.toFirstLower» result count: " + count);
			}
			return count;
		}
		«IF all»
		public int delete(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			return delete(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
		}
		«ENDIF»
		public int delete(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
			return delete(sqlSession, «e.name.toFirstLower», null);
		}
		«IF all»
		public int delete(«e.name» «e.name.toFirstLower») {
			return delete(«e.name.toFirstLower», null);
		}
		«ENDIF»
	'''
	
	def compileList(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im, boolean all) '''
	
		public List<«e.name»> list(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("list «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
			}
			SqlQueryEngine sqlEngine«e.name» = sqlEngineFactory.getCheckedQueryEngine("SELECT_«dbName(e)»");
			«IF toInits.empty»//«ENDIF»sqlControl = getMoreResultClasses(«e.name.toFirstLower», sqlControl);
			List<«e.name»> «e.name.toFirstLower»List = sqlEngine«e.name».query(sqlSession, «e.name».class, «e.name.toFirstLower», sqlControl);
			if (logger.isTraceEnabled()) {
				logger.trace("list «e.name.toFirstLower» size: " + ((«e.name.toFirstLower»List != null) ? «e.name.toFirstLower»List.size() : "null"));
			}
			return «e.name.toFirstLower»List;
		}
		«IF all»
		public List<«e.name»> list(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			return list(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
		}
		«ENDIF»
		public List<«e.name»> list(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
			return list(sqlSession, «e.name.toFirstLower», null);
		}
		«IF all»
		public List<«e.name»> list(«e.name» «e.name.toFirstLower») {
			return list(«e.name.toFirstLower», null);
		}
		«ENDIF»
	'''
	
	def compileCount(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im, boolean all) '''
	
		public int count(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			if (logger.isTraceEnabled()) {
				logger.trace("count «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
			}
			SqlQueryEngine sqlEngine«e.name» = sqlEngineFactory.getCheckedQueryEngine("SELECT_«dbName(e)»");
			«IF toInits.empty»//«ENDIF»sqlControl = getMoreResultClasses(«e.name.toFirstLower», sqlControl);
			int count = sqlEngine«e.name».queryCount(sqlSession, «e.name.toFirstLower», sqlControl);
			if (logger.isTraceEnabled()) {
				logger.trace("count: " + count);
			}
			return count;
		}
		«IF all»
		public int count(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			return count(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
		}
		«ENDIF»
		public int count(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
			return count(sqlSession, «e.name.toFirstLower», null);
		}
		«IF all»
		public int count(«e.name» «e.name.toFirstLower») {
			return count(«e.name.toFirstLower», null);
		}
		«ENDIF»
	'''
	
	def compileMoreResultClasses(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im) '''
	
		SqlControl getMoreResultClasses(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
			if (sqlControl != null && sqlControl.getMoreResultClasses() != null)
				return sqlControl;
			Map<String, Class<?>> moreResultClasses = null;
			«FOR f:toInits.entrySet SEPARATOR "
	"»		if («e.name.toFirstLower» != null && «e.name.toFirstLower».toInit(«e.name».Association.«f.key».name())) {
				if (moreResultClasses == null)
					moreResultClasses = new HashMap<String, Class<?>>();
			«FOR a:f.value SEPARATOR "
	"»		moreResultClasses.put("«a.name»", «a.type.ref.fullyQualifiedName».class);«ENDFOR»
			}
			«ENDFOR»
			if (moreResultClasses != null) {
				sqlControl = new SqlStandardControl(sqlControl);
				((SqlStandardControl) sqlControl).setMoreResultClasses(moreResultClasses);
			}
			return sqlControl;
		}
	'''
	
	def compileIfx(PojoDao d) '''
	«val im = new ImportManager(true)»
	«addImplements(d, im)»
	«addExtends(d, im)»
	«val classBody = compileIfx(d, d.pojo, im)»
	«IF d.eContainer != null»package «d.eContainer.fullyQualifiedName»;«ENDIF»
	
	import java.util.List;
	import org.sqlproc.engine.SqlSession;
	import org.sqlproc.engine.SqlControl;
	import «d.pojo.completeName»;
	
	«classBody»
	'''
	
	def compileIfx(PojoDao d, PojoEntity e, ImportManager im) '''
	public interface «d.name» {
		«FOR m:d.methods»«IF m.name == "scaffold" || m.name == "scaffold0"»«compileInsertIfx(d, e, im, m.name == "scaffold")»
		«compileGetIfx(d, e, im, m.name == "scaffold")»
		«compileUpdateIfx(d, e, im, m.name == "scaffold")»
		«compileDeleteIfx(d, e, im, m.name == "scaffold")»
		«compileListIfx(d, e, im, m.name == "scaffold")»
		«compileCountIfx(d, e, im, m.name == "scaffold")»
		«ELSEIF isCallUpdate(m)»
		«compileCallUpdateIfx(d, m, im, true)»«ELSEIF isCallFunction(m)»«compileCallFunctionIfx(d, m, im, true)»«ELSEIF isCallQuery(m) || isCallQueryFunction(m)»«compileCallQueryIfx(d, m, im, isCallQueryFunction(m), true)»«ELSEIF isCallSelectFunction(m)»«compileCallSelectFunctionIfx(d, m, im, true)»«ENDIF»«ENDFOR»
	}
	'''
	
	def compileCallQueryIfx(PojoDao d, PojoMethod m, ImportManager im, boolean isFunction, boolean all) '''
	
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);
		«ENDIF»
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
		«ENDIF»
	'''
	
	def compileCallFunctionIfx(PojoDao d, PojoMethod m, ImportManager im, boolean all) '''
	
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);
		«ENDIF»
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
		«ENDIF»
	'''
	
	def compileCallUpdateIfx(PojoDao d, PojoMethod m, ImportManager im, boolean all) '''
	
		public int «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);
		«IF all»
		public int «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);
		«ENDIF»
		public int «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
		«IF all»
		public int «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
		«ENDIF»
	'''
	
	def compileCallSelectFunctionIfx(PojoDao d, PojoMethod m, ImportManager im, boolean all) '''
	
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);
		«ENDIF»
		public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
		«IF all»
		public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
		«ENDIF»
	'''
	
	def compileInsertIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) '''
	
		public «e.name» insert(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«IF all»
		public «e.name» insert(«e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«ENDIF»
		public «e.name» insert(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);
		«IF all»
		public «e.name» insert(«e.name» «e.name.toFirstLower»);
		«ENDIF»
	'''
	
	def compileGetIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) '''
	
		public «e.name» get(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«IF all»
		public «e.name» get(«e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«ENDIF»
			public «e.name» get(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);
		«IF all»
		public «e.name» get(«e.name» «e.name.toFirstLower»);
		«ENDIF»
	'''
	
	def compileUpdateIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) '''
	
		public int update(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«IF all»
		public int update(«e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«ENDIF»
		public int update(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);
		«IF all»
		public int update(«e.name» «e.name.toFirstLower»);
		«ENDIF»
	'''
	
	def compileDeleteIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) '''
	
		public int delete(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«IF all»
		public int delete(«e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«ENDIF»
		public int delete(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);
		«IF all»
		public int delete(«e.name» «e.name.toFirstLower»);
		«ENDIF»
	'''
	
	def compileListIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) '''
	
		public List<«e.name»> list(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«IF all»
		public List<«e.name»> list(«e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«ENDIF»
		public List<«e.name»> list(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);
		«IF all»
		public List<«e.name»> list(«e.name» «e.name.toFirstLower»);
		«ENDIF»
	'''
	
	def compileCountIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) '''
	
		public int count(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«IF all»
		public int count(«e.name» «e.name.toFirstLower», SqlControl sqlControl);
		«ENDIF»
		public int count(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);
		«IF all»
		public int count(«e.name» «e.name.toFirstLower»);
		«ENDIF»
	'''
	
	def compileExtends(PojoDao e, ImportManager im) '''
		«IF getSuperType(e) != null»extends «getFullName(e, getSuperType(e), getSuperType(e).fullyQualifiedName, im)» «ELSEIF getExtends(e) != ""»extends «getExtends(e)» «ENDIF»'''
	
	def compileImplements(PojoDao d) '''
		«IF isImplements(d) || getSernum(d) != null || d.implPackage != null»implements «FOR f:getImplements(d) SEPARATOR ", " »«getDaoImplements(d, f)»«ENDFOR»«IF getSernum(d) != null»«IF isImplements(d)», «ENDIF»Serializable«ENDIF»«IF d.implPackage != null»«IF isImplements(d) || getSernum(d) != null», «ENDIF»«d.name»«ENDIF» «ENDIF»'''
	
	def addImplements(PojoDao e, ImportManager im) {
		for(impl: e.eContainer.eContents.filter(typeof(Implements))) {
			im.addImportFor(impl.getImplements())
		}
	}
	
	def addExtends(PojoDao e, ImportManager im) {
		for(ext: e.eContainer.eContents.filter(typeof(Extends))) {
			im.addImportFor(ext.getExtends())
		}
	}
	
	def isExtends(PojoDao e) {
		for(ext: e.eContainer.eContents.filter(typeof(Extends))) {
			if (!ext.onlyDaos.empty) {
				for (ee : ext.onlyDaos) {
					if (ee.name == e.name)
						return true
				}
				return false
			}
			for (ee : ext.exceptDaos) {
				if (ee.name == e.name)
					return false;
			}
			return true
		}
		return false
	}
	
	def isExtends(PojoDao e, Extends ext) {
		if (!ext.onlyDaos.empty) {
			for (ee : ext.onlyDaos) {
				if (ee.name == e.name)
				return true
			}
			return false
		}
		for (ee : ext.exceptDaos) {
			if (ee.name == e.name)
				return false;
		}
		return true
	}
	
	def getExtends(PojoDao e) {
		for(ext: e.eContainer.eContents.filter(typeof(Extends))) {
			if (isExtends(e, ext))
				return ext.getExtends().simpleName
		}
		return ""
	}
	
	def isImplements(PojoDao e) {
		for(ext: e.eContainer.eContents.filter(typeof(Implements))) {
			for (ee : ext.exceptDaos) {
				if (ee.name == e.name)
					return false;
			}
			if (!ext.onlyDaos.empty) {
				for (ee : ext.onlyDaos) {
					if (ee.name == e.name)
						return true
				}
			}
			else {
				return true
			}
		}
		return false
	}
	
	def isImplements(PojoDao e, Implements ext) {
		if (!ext.onlyDaos.empty) {
			for (ee : ext.onlyDaos) {
				if (ee.name == e.name)
				return true
			}
			return false
		}
		for (ee : ext.exceptDaos) {
			if (ee.name == e.name)
				return false;
		}
		return true
	}
	
	def getImplements(PojoDao e) {
		val list = new ArrayList<Implements>()
		
		for(ext: e.eContainer.eContents.filter(typeof(Implements))) {
			if (isImplements(e, ext))
				list.add(ext)
		}
		return list
	}
	
	def getImplPackage(PojoDao e) {
		for(ext: e.eContainer.eContents.filter(typeof(ImplPackage))) {
			return ext.name
		}
		return null
	}
}
