/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.generator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.sqlproc.dsl.generator.TableMetaGenerator;
import org.sqlproc.dsl.generator.TablePojoGenerator;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.PojoType;
import org.sqlproc.dsl.property.ImplementsExtends;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.property.PojoAttribute;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.util.Debug;

public class TableDaoGenerator
extends TableMetaGenerator {
    protected Logger LOGGER = Logger.getLogger(TableDaoGenerator.class);
    private Debug debug = new Debug(this.LOGGER);
    protected Map<String, String> finalDaos;
    protected Set<String> daoIgnoreTables = new HashSet<String>();
    protected Set<String> daoOnlyTables = new HashSet<String>();
    protected String daoImplementationPackage;
    protected Map<String, ImplementsExtends> daoToImplements = new HashMap<String, ImplementsExtends>();
    protected ImplementsExtends daoToExtends = null;
    protected boolean daoMakeItFinal;
    protected Map<String, PojoType> daoFunctionsResult = new HashMap<String, PojoType>();
    protected Set<String> notGenerics;
    protected Set<String> generics;
    protected TablePojoGenerator.Filter daoActiveFilter = null;

    public TableDaoGenerator() {
    }

    public TableDaoGenerator(ModelProperty modelProperty, Artifacts artifacts, String suffix, IScopeProvider scopeProvider, Map<String, String> finalDaos, List<String> dbSequences, DbResolver.DbType dbType) {
        super(modelProperty, artifacts, null, Collections.emptyMap(), dbSequences, dbType);
        Set<String> daoOnlyTables;
        this.debug = new Debug(modelProperty.getDaoDebugLevel(artifacts), modelProperty.getDaoDebugScope(artifacts), this.LOGGER);
        this.suffix = suffix != null ? suffix : "";
        this.finalDaos = finalDaos;
        Set<String> daoIgnoreTables = modelProperty.getDaoIgnoreTables(artifacts);
        if (daoIgnoreTables != null) {
            this.daoIgnoreTables.addAll(daoIgnoreTables);
        }
        if ((daoOnlyTables = modelProperty.getDaoOnlyTables(artifacts)) != null) {
            this.daoOnlyTables.addAll(daoOnlyTables);
        }
        this.daoImplementationPackage = modelProperty.getDaoImplementationPackage(artifacts);
        Map<String, ImplementsExtends> daoToImplements = modelProperty.getDaoToImplements(artifacts);
        if (daoToImplements != null) {
            this.daoToImplements.putAll(daoToImplements);
        }
        this.daoToExtends = modelProperty.getDaoToExtends(artifacts);
        this.daoMakeItFinal = modelProperty.isDaoMakeItFinal(artifacts);
        Map<String, PojoType> daoFunctionsResult = modelProperty.getDaoFunctionsResult(artifacts);
        if (daoFunctionsResult != null) {
            this.daoFunctionsResult.putAll(daoFunctionsResult);
        }
        this.daoActiveFilter = TablePojoGenerator.Filter.parse(modelProperty.getDaoActiveFilter(artifacts));
        if (this.debug.debug) {
            System.out.println("finalDaos " + this.finalDaos);
            System.out.println("daoIgnoreTables " + this.daoIgnoreTables);
            System.out.println("daoOnlyTables " + this.daoOnlyTables);
            System.out.println("daoImplementationPackage " + this.daoImplementationPackage);
            System.out.println("daoToImplements " + this.daoToImplements);
            System.out.println("daoToExtends " + this.daoToExtends);
            System.out.println("daoFunctionsResult " + this.daoFunctionsResult);
            System.out.println("daoActiveFilter " + this.daoActiveFilter);
        }
    }

    public String getDaoDefinitions(ModelProperty modelProperty, Artifacts artifacts) {
        String result = this.getDaoDefinitions();
        return this.replaceAll(modelProperty, result, artifacts);
    }

    /*
     * WARNING - void declaration
     */
    public String getDaoDefinitions() {
        try {
            boolean bl;
            PojoType ptype;
            String dispName;
            PojoAttribute returnAttribute;
            String name;
            Map attributes;
            boolean bl2;
            if (this.debug.debug) {
                System.out.println("pojos " + this.pojos);
                System.out.println("pojoExtends " + this.pojoExtends);
                System.out.println("pojoInheritanceDiscriminator " + this.pojoInheritanceDiscriminator);
                System.out.println("pojoInheritanceSimple " + this.pojoInheritanceSimple);
                System.out.println("pojoDiscriminators " + this.pojoDiscriminators);
                System.out.println("indexes " + this.indexes);
                System.out.println("procedures " + this.procedures);
                System.out.println("functions " + this.functions);
            }
            StringBuilder buffer = new StringBuilder();
            boolean isSerializable = false;
            HashSet<String> serializables = new HashSet<String>();
            boolean oneMoreLine = false;
            if (!this.daoToImplements.isEmpty()) {
                for (ImplementsExtends ie : this.daoToImplements.values()) {
                    Object daoName;
                    JvmType type = ie.getToImplement();
                    if (type.getIdentifier().endsWith("Serializable")) {
                        if (!ie.getDbTables().isEmpty()) {
                            for (String dbTable : ie.getDbTables()) {
                                if (dbTable.equalsIgnoreCase("Procedures")) {
                                    serializables.add("Procedures");
                                    continue;
                                }
                                if (dbTable.equalsIgnoreCase("Functions")) {
                                    serializables.add("Functions");
                                    continue;
                                }
                                serializables.add(dbTable);
                            }
                            continue;
                        }
                        if (!ie.getDbNotTables().isEmpty()) {
                            for (String pojo : this.pojos.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String pojo : this.enums.keySet()) {
                                serializables.add(pojo);
                            }
                            serializables.add("Procedures");
                            serializables.add("Functions");
                            for (String dbTable : ie.getDbNotTables()) {
                                serializables.remove(dbTable);
                            }
                            continue;
                        }
                        isSerializable = true;
                        continue;
                    }
                    buffer.append("\n  implements ").append(type.getIdentifier());
                    if (ie.isGenerics()) {
                        buffer.append(" <<>>");
                        if (this.notGenerics == null) {
                            this.notGenerics = new HashSet<String>();
                        }
                        if (this.generics == null) {
                            this.generics = new HashSet<String>();
                        }
                    }
                    if (!ie.getDbTables().isEmpty()) {
                        buffer.append(" onlyDaos");
                        for (String dbColumn : ie.getDbTables()) {
                            void var10_40;
                            String string = (String)this.tableNames.get(dbColumn);
                            if (string == null) {
                                String string2 = dbColumn;
                            }
                            daoName = String.valueOf(this.tableToCamelCase((String)var10_40)) + "Dao";
                            if (this.generics != null) {
                                this.generics.add((String)daoName);
                            }
                            buffer.append(" ").append((String)daoName);
                        }
                    }
                    if (ie.getDbNotTables().isEmpty()) continue;
                    buffer.append(" exceptDaos");
                    for (String dbColumn : ie.getDbNotTables()) {
                        void var10_43;
                        String string = (String)this.tableNames.get(dbColumn);
                        if (string == null) {
                            String string3 = dbColumn;
                        }
                        daoName = String.valueOf(this.tableToCamelCase((String)var10_43)) + "Dao";
                        if (this.notGenerics != null) {
                            this.notGenerics.add((String)daoName);
                        }
                        buffer.append(" ").append((String)daoName);
                    }
                }
                oneMoreLine = true;
            }
            if (this.generics != null && this.notGenerics != null) {
                this.notGenerics.removeAll(this.generics);
            }
            if (this.daoToExtends != null) {
                String daoName;
                JvmType type = this.daoToExtends.getToImplement();
                buffer.append("\n  extends ").append(type.getIdentifier());
                if (this.daoToExtends.isGenerics()) {
                    buffer.append(" <<>>");
                }
                if (!this.daoToExtends.getDbTables().isEmpty()) {
                    buffer.append(" onlyDaos");
                    for (String string : this.daoToExtends.getDbTables()) {
                        String pojoName2 = (String)this.tableNames.get(string);
                        if (pojoName2 == null) {
                            pojoName2 = string;
                        }
                        daoName = String.valueOf(this.tableToCamelCase(pojoName2)) + "Dao";
                        buffer.append(" ").append(daoName);
                    }
                }
                if (!this.daoToExtends.getDbNotTables().isEmpty()) {
                    buffer.append(" exceptDaos");
                    for (String string : this.daoToExtends.getDbNotTables()) {
                        String pojoName = (String)this.tableNames.get(string);
                        if (pojoName == null) {
                            pojoName = string;
                        }
                        daoName = String.valueOf(this.tableToCamelCase(pojoName)) + "Dao";
                        buffer.append(" ").append(daoName);
                    }
                }
                oneMoreLine = true;
            }
            if (this.daoImplementationPackage != null) {
                buffer.append("\n  implementation-package ").append(this.daoImplementationPackage);
                oneMoreLine = true;
            }
            if (oneMoreLine) {
                buffer.append("\n");
            }
            for (String pojo : this.pojos.keySet()) {
                String daoName;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(pojo) || this.daoIgnoreTables.contains(pojo) || !TablePojoGenerator.Filter.isTable(this.daoActiveFilter, pojo)) continue;
                Object pojoName3 = (String)this.tableNames.get(pojo);
                if (pojoName3 == null) {
                    pojoName3 = pojo;
                }
                if (this.finalDaos.containsKey(daoName = String.valueOf(this.tableToCamelCase((String)pojoName3)) + "Dao")) {
                    buffer.append(this.getFinalContent(this.finalDaos.get(daoName)));
                    continue;
                }
                if ((this.pojoInheritanceDiscriminator.containsKey(pojo) || this.pojoInheritanceSimple.containsKey(pojo)) && !this.notAbstractTables.contains(pojo)) continue;
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao ");
                buffer.append(daoName);
                if (this.generics == null && this.notGenerics == null) {
                    buffer.append(" :: ");
                } else if (this.generics != null && !this.generics.isEmpty() && this.generics.contains(daoName)) {
                    buffer.append(" ::: ");
                } else if (this.notGenerics != null && !this.notGenerics.isEmpty() && this.notGenerics.contains(daoName)) {
                    buffer.append(" :: ");
                } else {
                    buffer.append(" ::: ");
                }
                buffer.append(this.tableToCamelCase((String)pojoName3));
                if (isSerializable || serializables.contains(pojo)) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" {");
                buffer.append("\n    scaffold");
                if (this.generateMethods.contains("toInit")) {
                    LinkedHashMap<String, String> toInit = new LinkedHashMap<String, String>();
                    this.toInits(pojo, toInit);
                    for (Map.Entry entry : toInit.entrySet()) {
                        String pojoName2;
                        buffer.append("\n    ").append((String)entry.getKey()).append(" :::");
                        if (this.pojoInheritanceSimple.containsKey(entry.getValue())) {
                            for (String pojo2 : (Set)this.pojoInheritanceSimple.get(entry.getValue())) {
                                buffer.append(" ").append(this.columnToCamelCase(pojo2));
                                pojoName2 = (String)this.tableNames.get(pojo2);
                                if (pojoName2 == null) {
                                    pojoName2 = pojo2;
                                }
                                buffer.append(" ::").append(this.tableToCamelCase(pojoName2));
                            }
                            continue;
                        }
                        for (String pojo2 : (Set)this.pojoInheritanceDiscriminator.get(entry.getValue())) {
                            buffer.append(" ").append((String)this.pojoDiscriminators.get(pojo2));
                            pojoName2 = (String)this.tableNames.get(pojo2);
                            if (pojoName2 == null) {
                                pojoName2 = pojo2;
                            }
                            buffer.append(" ::").append(this.tableToCamelCase(pojoName2));
                        }
                    }
                }
                buffer.append("\n  }\n");
            }
            boolean hasProcedures = false;
            for (String string : this.procedures.keySet()) {
                boolean isFunction;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(string) || this.daoIgnoreTables.contains(string) || !TablePojoGenerator.Filter.isTable(this.daoActiveFilter, string) || (isFunction = this.functions.containsKey(string))) continue;
                hasProcedures = true;
                break;
            }
            if (hasProcedures && !this.finalDaos.containsKey("ProceduresDao")) {
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao ProceduresDao");
                if (isSerializable || serializables.contains("Procedures")) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" {");
                for (String string : this.procedures.keySet()) {
                    boolean isFunction;
                    if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(string) || this.daoIgnoreTables.contains(string) || (isFunction = this.functions.containsKey(string))) continue;
                    buffer.append("\n    ");
                    String pojoName4 = (String)this.tableNames.get(string);
                    if (pojoName4 == null) {
                        pojoName4 = string;
                    }
                    pojoName4 = this.tableToCamelCase(pojoName4);
                    String string4 = this.lowerFirstChar(pojoName4);
                    Map attributes2 = (Map)this.procedures.get(string);
                    if (this.metaProceduresResultSet.containsKey(string)) {
                        String name2 = (String)this.metaProceduresResultSet.get(string);
                        if (this.tableNames.containsKey(name2)) {
                            name2 = (String)this.tableNames.get(name2);
                        }
                        buffer.append("callQuery ").append(string4).append(" :java.util.List<:").append(this.tableToCamelCase(name2)).append(">");
                    } else {
                        PojoAttribute returnAttribute2;
                        PojoAttribute pojoAttribute = returnAttribute2 = attributes2.containsKey("_result_") ? (PojoAttribute)attributes2.get("_result_") : null;
                        if (returnAttribute2 != null && this.dbType != DbResolver.DbType.POSTGRESQL && this.dbType != DbResolver.DbType.MS_SQL) {
                            buffer.append("callQuery ").append(string4).append(" :").append(returnAttribute2.getClassName());
                        } else {
                            buffer.append("callUpdate ").append(string4).append(" _void");
                        }
                    }
                    String dispName2 = null;
                    PojoType ptype2 = (PojoType)this.pojosForProcedures.get(string);
                    if (ptype2 != null) {
                        dispName2 = ptype2.getRef() != null ? ptype2.getRef().getName() : ptype2.getType().getSimpleName();
                    }
                    buffer.append(" ::: ").append(this.lowerFirstChar(pojoName4)).append(" ::").append(dispName2 != null ? dispName2 : pojoName4);
                }
                buffer.append("\n  }\n");
            } else if (hasProcedures) {
                buffer.append(this.getFinalContent(this.finalDaos.get("ProceduresDao")));
            }
            boolean bl3 = false;
            for (String pojo : this.procedures.keySet()) {
                boolean isFunction;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(pojo) || this.daoIgnoreTables.contains(pojo) || !TablePojoGenerator.Filter.isTable(this.daoActiveFilter, pojo) || !(isFunction = this.functions.containsKey(pojo))) continue;
                bl2 = true;
                break;
            }
            if (bl2 && !this.finalDaos.containsKey("FunctionsDao")) {
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao FunctionsDao");
                if (isSerializable || serializables.contains("Functions")) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" {");
                for (String procedure : this.procedures.keySet()) {
                    void var10_51;
                    boolean isFunction;
                    if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(procedure) || this.daoIgnoreTables.contains(procedure) || !(isFunction = this.functions.containsKey(procedure))) continue;
                    buffer.append("\n    ");
                    String string = (String)this.tableNames.get(procedure);
                    if (string == null) {
                        String string5 = procedure;
                    }
                    String string6 = this.tableToCamelCase((String)var10_51);
                    String procedureName = this.lowerFirstChar(string6);
                    attributes = (Map)this.procedures.get(procedure);
                    if (this.metaFunctionsResultSet.containsKey(procedure)) {
                        name = (String)this.metaFunctionsResultSet.get(procedure);
                        if (this.tableNames.containsKey(name)) {
                            name = (String)this.tableNames.get(name);
                        }
                        buffer.append("callQueryFunction ").append(procedureName).append(" :java.util.List<:").append(this.tableToCamelCase(name)).append(">");
                    } else if (this.metaFunctionsResult.containsKey(procedure)) {
                        buffer.append("callFunction ").append(procedureName).append(" :").append(this.metaType2className((String)this.metaFunctionsResult.get(procedure)));
                    } else {
                        PojoAttribute pojoAttribute = returnAttribute = attributes.containsKey("_result_") ? (PojoAttribute)attributes.get("_result_") : null;
                        if (returnAttribute != null) {
                            buffer.append("callQueryFunction ").append(procedureName).append(" :").append(returnAttribute.getClassName());
                        } else {
                            buffer.append("callUpdateFunction ").append(procedureName).append(" _void");
                        }
                    }
                    dispName = null;
                    ptype = (PojoType)this.pojosForProcedures.get(procedure);
                    if (ptype != null) {
                        dispName = ptype.getRef() != null ? ptype.getRef().getName() : ptype.getType().getSimpleName();
                    }
                    buffer.append(" ::: ").append(this.lowerFirstChar(string6)).append(" ::").append(dispName != null ? dispName : string6);
                }
                buffer.append("\n  }\n");
            } else if (bl2) {
                buffer.append(this.getFinalContent(this.finalDaos.get("FunctionsDao")));
            }
            boolean bl4 = false;
            for (String pojo : this.functions.keySet()) {
                boolean isProcedure;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(pojo) || this.daoIgnoreTables.contains(pojo) || (isProcedure = this.procedures.containsKey(pojo))) continue;
                bl = true;
                break;
            }
            if (bl && !this.finalDaos.containsKey("FunctionsDao")) {
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao FunctionsDao");
                if (isSerializable || serializables.contains("Functions")) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" {");
                for (String function : this.functions.keySet()) {
                    void var10_56;
                    boolean isProcedure;
                    if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(function) || this.daoIgnoreTables.contains(function) || (isProcedure = this.procedures.containsKey(function))) continue;
                    buffer.append("\n    ");
                    String string = (String)this.tableNames.get(function);
                    if (string == null) {
                        String string7 = function;
                    }
                    String string8 = this.tableToCamelCase((String)var10_56);
                    String functionName = this.lowerFirstChar(string8);
                    attributes = (Map)this.functions.get(function);
                    if (this.metaFunctionsResultSet.containsKey(function)) {
                        name = (String)this.metaFunctionsResultSet.get(function);
                        if (this.tableNames.containsKey(name)) {
                            name = (String)this.tableNames.get(name);
                        }
                        buffer.append("callQueryFunction ").append(functionName).append(" :java.util.List<:").append(this.tableToCamelCase(name)).append(">");
                    } else if (this.metaFunctionsResult.containsKey(function) && this.dbType == DbResolver.DbType.DB2) {
                        buffer.append("callSelectFunction ").append(functionName).append(" :").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
                    } else if (this.metaFunctionsResult.containsKey(function)) {
                        buffer.append("callFunction ").append(functionName).append(" :").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
                    } else {
                        PojoAttribute pojoAttribute = returnAttribute = attributes.containsKey("_result_") ? (PojoAttribute)attributes.get("_result_") : null;
                        if (returnAttribute != null) {
                            buffer.append("callQueryFunction ").append(functionName).append(" :").append(returnAttribute.getClassName());
                        } else {
                            buffer.append("callUpdateFunction ").append(functionName).append(" _void");
                        }
                    }
                    dispName = null;
                    ptype = (PojoType)this.pojosForFunctions.get(function);
                    if (ptype != null) {
                        dispName = ptype.getRef() != null ? ptype.getRef().getName() : ptype.getType().getSimpleName();
                    }
                    buffer.append(" ::: ").append(this.lowerFirstChar(string8)).append(" ::").append(dispName != null ? dispName : string8);
                }
                buffer.append("\n  }\n");
            } else if (bl) {
                buffer.append(this.getFinalContent(this.finalDaos.get("FunctionsDao")));
            }
            return buffer.toString();
        }
        catch (RuntimeException ex) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            String s = ((Object)writer).toString();
            return s;
        }
    }

    protected void toInits(String pojo, Map<String, String> toInit) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            if (this.ignoreColumns.containsKey(pojo) && ((Set)this.ignoreColumns.get(pojo)).contains(pentry.getKey())) continue;
            PojoAttribute attribute = (PojoAttribute)pentry.getValue();
            String name = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(pentry.getKey()) : null;
            name = name == null ? attribute.getName() : this.columnToCamelCase(name);
            if (!attribute.toInit() || attribute.getRef() == null || !this.pojoInheritanceDiscriminator.containsKey(attribute.getRef()) && !this.pojoInheritanceSimple.containsKey(attribute.getRef())) continue;
            toInit.put(name, attribute.getRef());
        }
        if (this.pojoExtends.containsKey(pojo)) {
            this.toInits((String)this.pojoExtends.get(pojo), toInit);
        }
    }
}

