/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.sqlproc.dsl.ImportManager;
import org.sqlproc.dsl.generator.ProcessorGeneratorUtils;
import org.sqlproc.dsl.processorDsl.AnnotatedEntity;
import org.sqlproc.dsl.processorDsl.Annotation;
import org.sqlproc.dsl.processorDsl.AnnotationProperty;
import org.sqlproc.dsl.processorDsl.Entity;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.EnumProperty;
import org.sqlproc.dsl.processorDsl.Extends;
import org.sqlproc.dsl.processorDsl.Implements;
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.util.Utils;

public class ProcessorPojoGenerator {
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private ProcessorGeneratorUtils _processorGeneratorUtils;

    public CharSequence compile(AnnotatedEntity e) {
        Entity _entity_1;
        StringConcatenation _builder = new StringConcatenation();
        Entity _entity = e.getEntity();
        if (_entity instanceof EnumEntity) {
            EnumEntity _enumEntity = Utils.enumEntity(e);
            CharSequence _compile = this.compile(_enumEntity);
            _builder.append((Object)_compile, "");
        }
        if ((_entity_1 = e.getEntity()) instanceof PojoEntity) {
            PojoEntity _pojoEntity = Utils.pojoEntity(e);
            CharSequence _compile_1 = this.compile(_pojoEntity, e);
            _builder.append((Object)_compile_1, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compile(EnumEntity e) {
        EList<EnumProperty> _features;
        boolean _isEmpty_1;
        boolean _not_1;
        String _sernum;
        boolean _notEquals_1;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        ImportManager im = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        EnumProperty eattr = Utils.getEnumAttr(e);
        _builder.newLineIfNotEmpty();
        this.addImplements(e, im);
        _builder.newLineIfNotEmpty();
        this.addExtends(e, im);
        _builder.newLineIfNotEmpty();
        CharSequence classBody = this.compile(e, im, eattr);
        _builder.newLineIfNotEmpty();
        EObject _eContainer = e.eContainer();
        boolean bl = _notEquals = !Objects.equal((Object)_eContainer, null);
        if (_notEquals) {
            _builder.append((Object)"package ");
            EObject _eContainer_1 = e.eContainer();
            EObject _eContainer_2 = _eContainer_1.eContainer();
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_2);
            _builder.append((Object)_fullyQualifiedName, "");
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        List<String> _imports = im.getImports();
        boolean _isEmpty = _imports.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.newLine();
            List<String> _imports_1 = im.getImports();
            for (String i : _imports_1) {
                _builder.append((Object)"import ");
                _builder.append((Object)i, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)(_sernum = Utils.getSernum(e)), null);
        if (_notEquals_1) {
            _builder.newLine();
            _builder.append((Object)"import java.io.Serializable;");
            _builder.newLine();
        }
        boolean bl4 = _not_1 = !(_isEmpty_1 = (_features = e.getFeatures()).isEmpty());
        if (_not_1) {
            _builder.append((Object)"import java.util.HashMap;");
            _builder.newLine();
            _builder.append((Object)"import java.util.Map;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)classBody, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compile(EnumEntity e, ImportManager im, EnumProperty ea) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public enum ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" ");
        CharSequence _compileImplements = this.compileImplements(e);
        _builder.append((Object)_compileImplements, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        EList<EnumProperty> _features = e.getFeatures();
        Functions.Function1<EnumProperty, Boolean> _function = new Functions.Function1<EnumProperty, Boolean>(){

            public Boolean apply(EnumProperty x) {
                String _value = x.getValue();
                return !Objects.equal((Object)_value, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features, (Functions.Function1)_function);
        boolean _hasElements = false;
        for (EnumProperty f : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            String _name_1 = f.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)"(");
            String _value = f.getValue();
            _builder.append((Object)_value, "\t");
            _builder.append((Object)")");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _sernum = Utils.getSernum(e);
        boolean bl = _notEquals = !Objects.equal((Object)_sernum, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private static final long serialVersionUID = ");
            String _sernum_1 = Utils.getSernum(e);
            _builder.append((Object)_sernum_1, "\t");
            _builder.append((Object)"L;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static Map<");
        CharSequence _compileType = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)", ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)"> identifierMap = new HashMap<");
        CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_1, "\t");
        _builder.append((Object)", ");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)">();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" value : ");
        String _name_5 = e.getName();
        _builder.append((Object)_name_5, "\t\t");
        _builder.append((Object)".values()) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"identifierMap.put(value.getValue(), value);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_2, "\t");
        _builder.append((Object)" ");
        String _name_6 = ea.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)"(");
        CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_3, "\t");
        _builder.append((Object)" value) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        String _name_8 = ea.getName();
        _builder.append((Object)_name_8, "\t\t");
        _builder.append((Object)" = value;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static ");
        String _name_9 = e.getName();
        _builder.append((Object)_name_9, "\t");
        _builder.append((Object)" fromValue(");
        CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_4, "\t");
        _builder.append((Object)" value) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _name_10 = e.getName();
        _builder.append((Object)_name_10, "\t\t");
        _builder.append((Object)" result = identifierMap.get(value);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (result == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"No ");
        String _name_11 = e.getName();
        _builder.append((Object)_name_11, "\t\t\t");
        _builder.append((Object)" for value: \" + value);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_5, "\t");
        _builder.append((Object)" getValue() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_12 = ea.getName();
        _builder.append((Object)_name_12, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getName() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return name();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compile(PojoEntity e, AnnotatedEntity ae) {
        PojoAnnotatedProperty _hasToInit;
        boolean _notEquals_3;
        boolean _notEquals_2;
        List<PojoAnnotatedProperty> _listFeatures;
        boolean _isEmpty_1;
        boolean _not_1;
        String _sernum;
        boolean _notEquals_1;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        ImportManager im = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        this.addImplements(e, im);
        _builder.newLineIfNotEmpty();
        this.addExtends(e, im);
        _builder.newLineIfNotEmpty();
        CharSequence classBody = this.compile(e, ae, im);
        _builder.newLineIfNotEmpty();
        EObject _eContainer = e.eContainer();
        boolean bl = _notEquals = !Objects.equal((Object)_eContainer, null);
        if (_notEquals) {
            _builder.append((Object)"package ");
            EObject _eContainer_1 = e.eContainer();
            EObject _eContainer_2 = _eContainer_1.eContainer();
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_2);
            _builder.append((Object)_fullyQualifiedName, "");
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        List<String> _imports = im.getImports();
        boolean _isEmpty = _imports.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"\t");
            _builder.newLine();
            List<String> _imports_1 = im.getImports();
            for (String i : _imports_1) {
                _builder.append((Object)"import ");
                _builder.append((Object)i, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)(_sernum = Utils.getSernum(e)), null);
        if (_notEquals_1) {
            _builder.newLine();
            _builder.append((Object)"import java.io.Serializable;");
            _builder.newLine();
        }
        boolean bl4 = _not_1 = !(_isEmpty_1 = (_listFeatures = this.listFeatures(e)).isEmpty());
        if (_not_1) {
            _builder.append((Object)"import java.util.ArrayList;");
            _builder.newLine();
        }
        boolean _or = false;
        PojoAnnotatedProperty _hasIsDef = this.hasIsDef(e);
        boolean bl5 = _notEquals_2 = !Objects.equal((Object)_hasIsDef, null);
        _or = _notEquals_2 ? true : (_notEquals_3 = !Objects.equal((Object)(_hasToInit = this.hasToInit(e)), null));
        if (_or) {
            _builder.append((Object)"import java.util.Set;");
            _builder.newLine();
            _builder.append((Object)"import java.util.HashSet;");
            _builder.newLine();
            _builder.append((Object)"import java.lang.reflect.InvocationTargetException;");
            _builder.newLine();
            _builder.append((Object)"import org.apache.commons.beanutils.MethodUtils;");
            _builder.newLine();
        }
        boolean _and = false;
        boolean _hasOperators = Utils.hasOperators(e);
        if (!_hasOperators) {
            _and = false;
        } else {
            boolean _equals;
            String _operatorsSuffix = Utils.getOperatorsSuffix(e);
            _and = _equals = Objects.equal((Object)_operatorsSuffix, null);
        }
        if (_and) {
            _builder.append((Object)"import java.util.Map;");
            _builder.newLine();
            _builder.append((Object)"import java.util.HashMap;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)classBody, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compile(PojoEntity e, AnnotatedEntity ae, ImportManager im) {
        boolean _not_4;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        EList<Annotation> _annotations = ae.getAnnotations();
        for (Annotation a : _annotations) {
            boolean _not;
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements = false;
                for (Object f : _features_1) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty((AnnotationProperty)f, im);
                    _builder.append((Object)_compileAnnotationProperty, "");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public ");
        boolean _isAbstract = Utils.isAbstract(e);
        if (_isAbstract) {
            _builder.append((Object)"abstract ");
        }
        _builder.append((Object)"class ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" ");
        CharSequence _compileExtends = this.compileExtends(e, im);
        _builder.append((Object)_compileExtends, "");
        CharSequence _compileImplements = this.compileImplements(e);
        _builder.append((Object)_compileImplements, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        String _sernum = Utils.getSernum(e);
        boolean bl = _notEquals = !Objects.equal((Object)_sernum, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private static final long serialVersionUID = ");
            String _sernum_1 = Utils.getSernum(e);
            _builder.append((Object)_sernum_1, "\t");
            _builder.append((Object)"L;");
            _builder.newLineIfNotEmpty();
        }
        EList<PojoAnnotatedProperty> _features_2 = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                String _index = Utils.getIndex(_feature);
                return !Objects.equal((Object)_index, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features_2, (Functions.Function1)_function);
        for (PojoAnnotatedProperty f_1 : _filter) {
            EList<Annotation> _staticAnnotations = ae.getStaticAnnotations();
            for (Annotation a_1 : _staticAnnotations) {
                boolean _not_1;
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                JvmType _type_1 = a_1.getType();
                CharSequence _serialize_1 = im.serialize(_type_1);
                _builder.append((Object)_serialize_1, "\t");
                EList<AnnotationProperty> _features_3 = a_1.getFeatures();
                boolean _isEmpty_1 = _features_3.isEmpty();
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    _builder.append((Object)"(");
                    EList<AnnotationProperty> _features_4 = a_1.getFeatures();
                    boolean _hasElements_1 = false;
                    for (AnnotationProperty ff : _features_4) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "\t");
                        }
                        CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(ff, im);
                        _builder.append((Object)_compileAnnotationProperty_1, "\t");
                    }
                    _builder.append((Object)")");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"public static final int ORDER_BY_");
            PojoProperty _feature = f_1.getFeature();
            String _constName = Utils.constName(_feature);
            _builder.append((Object)_constName, "\t");
            _builder.append((Object)" = ");
            PojoProperty _feature_1 = f_1.getFeature();
            String _index = Utils.getIndex(_feature_1);
            _builder.append((Object)_index, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        EList<PojoAnnotatedProperty> _features_5 = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function_1 = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                String _name = _feature.getName();
                return _name.startsWith("index=");
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(_features_5, (Functions.Function1)_function_1);
        Iterator _not = _filter_1.iterator();
        while (_not.hasNext()) {
            PojoAnnotatedProperty f_2 = (PojoAnnotatedProperty)_not.next();
            EList<Annotation> _staticAnnotations_1 = ae.getStaticAnnotations();
            for (Annotation a_2 : _staticAnnotations_1) {
                boolean _not_2;
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                JvmType _type_2 = a_2.getType();
                CharSequence _serialize_2 = im.serialize(_type_2);
                _builder.append((Object)_serialize_2, "\t");
                EList<AnnotationProperty> _features_6 = a_2.getFeatures();
                boolean _isEmpty_2 = _features_6.isEmpty();
                boolean bl3 = _not_2 = !_isEmpty_2;
                if (_not_2) {
                    _builder.append((Object)"(");
                    EList<AnnotationProperty> _features_7 = a_2.getFeatures();
                    boolean _hasElements_2 = false;
                    for (Object ff_1 : _features_7) {
                        if (!_hasElements_2) {
                            _hasElements_2 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "\t");
                        }
                        CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty((AnnotationProperty)ff_1, im);
                        _builder.append((Object)_compileAnnotationProperty_2, "\t");
                    }
                    _builder.append((Object)")");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"public static final int ORDER_BY_");
            PojoProperty _feature_2 = f_2.getFeature();
            String _constName2 = Utils.constName2(_feature_2);
            _builder.append((Object)_constName2, "\t");
            _builder.append((Object)" = ");
            PojoProperty _feature_3 = f_2.getFeature();
            String _name_1 = _feature_3.getName();
            String _substring = _name_1.substring(6);
            _builder.append((Object)_substring, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        EList<Annotation> _constructorAnnotations = ae.getConstructorAnnotations();
        for (Annotation a_3 : _constructorAnnotations) {
            boolean _not_3;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_3 = a_3.getType();
            CharSequence _serialize_3 = im.serialize(_type_3);
            _builder.append((Object)_serialize_3, "\t");
            EList<AnnotationProperty> _features_8 = a_3.getFeatures();
            boolean _isEmpty_3 = _features_8.isEmpty();
            boolean bl4 = _not_3 = !_isEmpty_3;
            if (_not_3) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_9 = a_3.getFeatures();
                boolean _hasElements_3 = false;
                for (AnnotationProperty f_3 : _features_9) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_3 = this.compileAnnotationProperty(f_3, im);
                    _builder.append((Object)_compileAnnotationProperty_3, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        List<PojoAnnotatedProperty> _requiredFeatures = this.requiredFeatures(e);
        boolean _isEmpty_4 = _requiredFeatures.isEmpty();
        boolean bl5 = _not_4 = !_isEmpty_4;
        if (_not_4) {
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            EList<Annotation> _constructorAnnotations_1 = ae.getConstructorAnnotations();
            for (Annotation a_4 : _constructorAnnotations_1) {
                boolean _not_5;
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                JvmType _type_4 = a_4.getType();
                Iterator<PojoAnnotatedProperty> _serialize_4 = im.serialize(_type_4);
                _builder.append((Object)_serialize_4, "\t");
                EList<AnnotationProperty> _features_10 = a_4.getFeatures();
                boolean _isEmpty_5 = _features_10.isEmpty();
                boolean bl6 = _not_5 = !_isEmpty_5;
                if (_not_5) {
                    _builder.append((Object)"(");
                    EList<AnnotationProperty> _features_11 = a_4.getFeatures();
                    boolean _hasElements_4 = false;
                    for (AnnotationProperty f_4 : _features_11) {
                        if (!_hasElements_4) {
                            _hasElements_4 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "\t");
                        }
                        CharSequence _compileAnnotationProperty_4 = this.compileAnnotationProperty(f_4, im);
                        _builder.append((Object)_compileAnnotationProperty_4, "\t");
                    }
                    _builder.append((Object)")");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_3 = e.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)"(");
            List<PojoAnnotatedProperty> _requiredFeatures_1 = this.requiredFeatures(e);
            boolean _hasElements_5 = false;
            for (PojoAnnotatedProperty f_5 : _requiredFeatures_1) {
                if (!_hasElements_5) {
                    _hasElements_5 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoProperty _feature_4 = f_5.getFeature();
                CharSequence _compileType = this._processorGeneratorUtils.compileType(_feature_4, im);
                CharSequence _fullName = Utils.getFullName(e, f_5, _compileType, im);
                _builder.append((Object)_fullName, "\t");
                _builder.append((Object)" ");
                PojoProperty _feature_5 = f_5.getFeature();
                String _name_4 = _feature_5.getName();
                _builder.append((Object)_name_4, "\t");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            ArrayList<PojoAnnotatedProperty> _requiredSuperFeatures = this.requiredSuperFeatures(e);
            boolean _hasElements_6 = false;
            for (PojoAnnotatedProperty f_6 : _requiredSuperFeatures) {
                if (!_hasElements_6) {
                    _hasElements_6 = true;
                    _builder.append((Object)"super(", "\t\t");
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                PojoProperty _feature_6 = f_6.getFeature();
                String _name_5 = _feature_6.getName();
                _builder.append((Object)_name_5, "\t\t");
            }
            if (_hasElements_6) {
                _builder.append((Object)");", "\t\t");
            }
            _builder.newLineIfNotEmpty();
            List<PojoAnnotatedProperty> _requiredFeatures1 = this.requiredFeatures1(e);
            for (PojoAnnotatedProperty f_7 : _requiredFeatures1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"this.");
                PojoProperty _feature_7 = f_7.getFeature();
                String _name_6 = _feature_7.getName();
                _builder.append((Object)_name_6, "\t\t");
                _builder.append((Object)" = ");
                PojoProperty _feature_8 = f_7.getFeature();
                String _name_7 = _feature_8.getName();
                _builder.append((Object)_name_7, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        EList<PojoAnnotatedProperty> _features_12 = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function_2 = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                return ProcessorPojoGenerator.this.isAttribute(_feature);
            }
        };
        Iterable _filter_2 = IterableExtensions.filter(_features_12, (Functions.Function1)_function_2);
        for (PojoAnnotatedProperty f_8 : _filter_2) {
            PojoProperty _feature_9 = f_8.getFeature();
            String _operatorsSuffix = Utils.getOperatorsSuffix(e);
            CharSequence _compile = this.compile(_feature_9, f_8, im, e, ae, _operatorsSuffix);
            _builder.append((Object)_compile, "");
            _builder.newLineIfNotEmpty();
        }
        EList<PojoAnnotatedProperty> _features_13 = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function_3 = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                boolean _isAttribute = ProcessorPojoGenerator.this.isAttribute(_feature);
                return !_isAttribute;
            }
        };
        Iterable _filter_3 = IterableExtensions.filter(_features_13, (Functions.Function1)_function_3);
        for (PojoAnnotatedProperty f_9 : _filter_3) {
            PojoProperty _feature_10 = f_9.getFeature();
            String _name_8 = _feature_10.getName();
            boolean _equalsIgnoreCase = _name_8.equalsIgnoreCase("hashCode");
            if (_equalsIgnoreCase) {
                PojoProperty _feature_11 = f_9.getFeature();
                CharSequence _compileHashCode = this.compileHashCode(_feature_11, f_9, im, e, ae);
                _builder.append((Object)_compileHashCode, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            PojoProperty _feature_12 = f_9.getFeature();
            String _name_9 = _feature_12.getName();
            boolean _equalsIgnoreCase_1 = _name_9.equalsIgnoreCase("equals");
            if (_equalsIgnoreCase_1) {
                PojoProperty _feature_13 = f_9.getFeature();
                CharSequence _compileEquals = this.compileEquals(_feature_13, f_9, im, e, ae);
                _builder.append((Object)_compileEquals, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            PojoProperty _feature_14 = f_9.getFeature();
            String _name_10 = _feature_14.getName();
            boolean _equalsIgnoreCase_2 = _name_10.equalsIgnoreCase("toInit");
            if (_equalsIgnoreCase_2) {
                PojoProperty _feature_15 = f_9.getFeature();
                CharSequence _compileToInit = this.compileToInit(_feature_15, f_9, im, e, ae);
                _builder.append((Object)_compileToInit, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            PojoProperty _feature_16 = f_9.getFeature();
            String _name_11 = _feature_16.getName();
            boolean _equalsIgnoreCase_3 = _name_11.equalsIgnoreCase("enumInit");
            if (_equalsIgnoreCase_3) {
                PojoProperty _feature_17 = f_9.getFeature();
                CharSequence _compileEnumInit = this.compileEnumInit(_feature_17, f_9, im, e, ae);
                _builder.append((Object)_compileEnumInit, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            PojoProperty _feature_18 = f_9.getFeature();
            String _name_12 = _feature_18.getName();
            boolean _equalsIgnoreCase_4 = _name_12.equalsIgnoreCase("isDef");
            if (_equalsIgnoreCase_4) {
                PojoProperty _feature_19 = f_9.getFeature();
                CharSequence _compileIsDef = this.compileIsDef(_feature_19, f_9, im, e, ae);
                _builder.append((Object)_compileIsDef, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            PojoProperty _feature_20 = f_9.getFeature();
            String _name_13 = _feature_20.getName();
            boolean _equalsIgnoreCase_5 = _name_13.equalsIgnoreCase("enumDef");
            if (_equalsIgnoreCase_5) {
                PojoProperty _feature_21 = f_9.getFeature();
                CharSequence _compileEnumDef = this.compileEnumDef(_feature_21, f_9, im, e, ae);
                _builder.append((Object)_compileEnumDef, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            PojoProperty _feature_22 = f_9.getFeature();
            String _name_14 = _feature_22.getName();
            boolean _equalsIgnoreCase_6 = _name_14.equalsIgnoreCase("toString");
            if (!_equalsIgnoreCase_6) continue;
            PojoProperty _feature_23 = f_9.getFeature();
            CharSequence _compileToString = this.compileToString(_feature_23, f_9, im, e, ae);
            _builder.append((Object)_compileToString, "");
        }
        boolean _and = false;
        boolean _hasOperators = Utils.hasOperators(e);
        if (!_hasOperators) {
            _and = false;
        } else {
            boolean _equals;
            String _operatorsSuffix_1 = Utils.getOperatorsSuffix(e);
            _and = _equals = Objects.equal((Object)_operatorsSuffix_1, null);
        }
        if (_and) {
            _builder.newLineIfNotEmpty();
            CharSequence _compileOperators = this.compileOperators(im, e, ae);
            _builder.append((Object)_compileOperators, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileAnnotationProperty(AnnotationProperty f, ImportManager im) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = f.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" = ");
        JvmType _type = f.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (_notEquals) {
            JvmType _type_1 = f.getType();
            CharSequence _serialize = im.serialize(_type_1);
            _builder.append((Object)_serialize, "");
        } else {
            boolean _notEquals_1;
            PojoEntity _ref = f.getRef();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_ref, null);
            if (_notEquals_1) {
                PojoEntity _ref_1 = f.getRef();
                QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)_ref_1);
                _builder.append((Object)_fullyQualifiedName, "");
            }
        }
        String _annotationValue = Utils.getAnnotationValue(f);
        _builder.append((Object)_annotationValue, "");
        return _builder;
    }

    public CharSequence compile(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae, String operatorSuffix) {
        boolean _notEquals_4;
        String _createColumn1_5;
        boolean _notEquals_3;
        boolean _notEquals_2;
        String _createColumn1;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations = aaf.getAttributeAnnotations();
        for (Annotation a : _attributeAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements = false;
                for (AnnotationProperty af : _features_1) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(af, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        CharSequence _compileType = this._processorGeneratorUtils.compileType(f, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)" ");
        String _name = f.getName();
        _builder.append((Object)_name, "\t");
        boolean _isList = Utils.isList(f);
        if (_isList) {
            _builder.append((Object)" = new Array");
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(f, im);
            _builder.append((Object)_compileType_1, "\t");
            _builder.append((Object)"()");
        } else {
            boolean _isOptLock = Utils.isOptLock(f);
            if (_isOptLock) {
                _builder.append((Object)" = 0");
            }
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<Annotation> _getterAnnotations = aaf.getGetterAnnotations();
        for (Annotation a_1 : _getterAnnotations) {
            boolean _not_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_1 = a_1.getType();
            CharSequence _serialize_1 = im.serialize(_type_1);
            _builder.append((Object)_serialize_1, "\t");
            EList<AnnotationProperty> _features_2 = a_1.getFeatures();
            boolean _isEmpty_1 = _features_2.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_3 = a_1.getFeatures();
                boolean _hasElements_1 = false;
                for (AnnotationProperty af_1 : _features_3) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(af_1, im);
                    _builder.append((Object)_compileAnnotationProperty_1, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(f, im);
        _builder.append((Object)_compileType_2, "\t");
        _builder.append((Object)" get");
        String _name_1 = f.getName();
        String __toFirstUpper = Utils._toFirstUpper(_name_1);
        _builder.append((Object)__toFirstUpper, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_2 = f.getName();
        _builder.append((Object)_name_2, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _setterAnnotations = aaf.getSetterAnnotations();
        for (Annotation a_2 : _setterAnnotations) {
            boolean _not_2;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_2 = a_2.getType();
            CharSequence _serialize_2 = im.serialize(_type_2);
            _builder.append((Object)_serialize_2, "\t");
            EList<AnnotationProperty> _features_4 = a_2.getFeatures();
            boolean _isEmpty_2 = _features_4.isEmpty();
            boolean bl = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_5 = a_2.getFeatures();
                boolean _hasElements_2 = false;
                for (AnnotationProperty af_2 : _features_5) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty(af_2, im);
                    _builder.append((Object)_compileAnnotationProperty_2, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void set");
        String _name_3 = f.getName();
        String __toFirstUpper_1 = Utils._toFirstUpper(_name_3);
        _builder.append((Object)__toFirstUpper_1, "\t");
        _builder.append((Object)"(");
        CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(f, im);
        _builder.append((Object)_compileType_3, "\t");
        _builder.append((Object)" ");
        String _name_4 = f.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        String _name_5 = f.getName();
        _builder.append((Object)_name_5, "\t\t");
        _builder.append((Object)" = ");
        String _name_6 = f.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _updateColumn1 = Utils.getUpdateColumn1(f);
        boolean bl = _notEquals = !Objects.equal((Object)_updateColumn1, null);
        if (_notEquals) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (this.");
            String _name_7 = f.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)" != null)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _updateColumn2 = Utils.getUpdateColumn2(f);
            _builder.append((Object)_updateColumn2, "\t\t\t");
            _builder.append((Object)" = this.");
            String _name_8 = f.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)".get");
            String _updateColumn1_1 = Utils.getUpdateColumn1(f);
            String __toFirstUpper_2 = Utils._toFirstUpper(_updateColumn1_1);
            _builder.append((Object)__toFirstUpper_2, "\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_createColumn1 = Utils.getCreateColumn1(f)), null);
        if (_notEquals_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (this.");
            String _createColumn1_1 = Utils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_1, "\t\t");
            _builder.append((Object)" == null)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _createColumn1_2 = Utils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_2, "\t\t\t");
            _builder.append((Object)" = new ");
            String _createColumn1_3 = Utils.getCreateColumn1(f);
            PojoProperty _attribute = Utils.getAttribute(e, _createColumn1_3);
            CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_attribute, im);
            _builder.append((Object)_compileType_4, "\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.");
            String _createColumn1_4 = Utils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_4, "\t\t");
            _builder.append((Object)".set");
            String _createColumn2 = Utils.getCreateColumn2(f);
            String __toFirstUpper_3 = Utils._toFirstUpper(_createColumn2);
            _builder.append((Object)__toFirstUpper_3, "\t\t");
            _builder.append((Object)"(");
            String _name_9 = f.getName();
            _builder.append((Object)_name_9, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_10 = e.getName();
        _builder.append((Object)_name_10, "\t");
        _builder.append((Object)" _set");
        String _name_11 = f.getName();
        String __toFirstUpper_4 = Utils._toFirstUpper(_name_11);
        _builder.append((Object)__toFirstUpper_4, "\t");
        _builder.append((Object)"(");
        CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(f, im);
        _builder.append((Object)_compileType_5, "\t");
        _builder.append((Object)" ");
        String _name_12 = f.getName();
        _builder.append((Object)_name_12, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        String _name_13 = f.getName();
        _builder.append((Object)_name_13, "\t\t");
        _builder.append((Object)" = ");
        String _name_14 = f.getName();
        _builder.append((Object)_name_14, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _updateColumn1_2 = Utils.getUpdateColumn1(f);
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_updateColumn1_2, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (this.");
            String _name_15 = f.getName();
            _builder.append((Object)_name_15, "\t\t");
            _builder.append((Object)" != null)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _updateColumn2_1 = Utils.getUpdateColumn2(f);
            _builder.append((Object)_updateColumn2_1, "\t\t\t");
            _builder.append((Object)" = this.");
            String _name_16 = f.getName();
            _builder.append((Object)_name_16, "\t\t\t");
            _builder.append((Object)".get");
            String _updateColumn1_3 = Utils.getUpdateColumn1(f);
            String __toFirstUpper_5 = Utils._toFirstUpper(_updateColumn1_3);
            _builder.append((Object)__toFirstUpper_5, "\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)(_createColumn1_5 = Utils.getCreateColumn1(f)), null);
        if (_notEquals_3) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (this.");
            String _createColumn1_6 = Utils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_6, "\t\t");
            _builder.append((Object)" == null)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _createColumn1_7 = Utils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_7, "\t\t\t");
            _builder.append((Object)" = new ");
            String _createColumn1_8 = Utils.getCreateColumn1(f);
            PojoProperty _attribute_1 = Utils.getAttribute(e, _createColumn1_8);
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_attribute_1, im);
            _builder.append((Object)_compileType_6, "\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.");
            String _createColumn1_9 = Utils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_9, "\t\t");
            _builder.append((Object)".set");
            String _createColumn2_1 = Utils.getCreateColumn2(f);
            String __toFirstUpper_6 = Utils._toFirstUpper(_createColumn2_1);
            _builder.append((Object)__toFirstUpper_6, "\t\t");
            _builder.append((Object)"(");
            String _name_17 = f.getName();
            _builder.append((Object)_name_17, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        boolean _and = false;
        boolean _hasOperators = Utils.hasOperators(e);
        _and = !_hasOperators ? false : (_notEquals_4 = !Objects.equal((Object)operatorSuffix, null));
        if (_and) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String ");
            String _name_18 = f.getName();
            _builder.append((Object)_name_18, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public String get");
            String _name_19 = f.getName();
            String __toFirstUpper_7 = Utils._toFirstUpper(_name_19);
            _builder.append((Object)__toFirstUpper_7, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_20 = f.getName();
            _builder.append((Object)_name_20, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void set");
            String _name_21 = f.getName();
            String __toFirstUpper_8 = Utils._toFirstUpper(_name_21);
            _builder.append((Object)__toFirstUpper_8, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)"(String ");
            String _name_22 = f.getName();
            _builder.append((Object)_name_22, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _name_23 = f.getName();
            _builder.append((Object)_name_23, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)" = ");
            String _name_24 = f.getName();
            _builder.append((Object)_name_24, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_25 = e.getName();
            _builder.append((Object)_name_25, "\t");
            _builder.append((Object)" _set");
            String _name_26 = f.getName();
            String __toFirstUpper_9 = Utils._toFirstUpper(_name_26);
            _builder.append((Object)__toFirstUpper_9, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)"(String ");
            String _name_27 = f.getName();
            _builder.append((Object)_name_27, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _name_28 = f.getName();
            _builder.append((Object)_name_28, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)" = ");
            String _name_29 = f.getName();
            _builder.append((Object)_name_29, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compileHashCode(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        EList<Annotation> _attributeAnnotations = aaf.getAttributeAnnotations();
        for (Annotation a : _attributeAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements = false;
                for (AnnotationProperty af : _features_1) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(af, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int hashCode() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final int prime = 31;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int result = 1;");
        _builder.newLine();
        EList<PojoProperty> _attrs = f.getAttrs();
        for (PojoProperty f2 : _attrs) {
            boolean _notEquals;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"result = prime * result + ");
            String _native = f2.getNative();
            boolean bl = _notEquals = !Objects.equal((Object)_native, null);
            if (_notEquals) {
                _builder.append((Object)"(int) (");
                String _name = f2.getName();
                _builder.append((Object)_name, "\t\t");
                _builder.append((Object)" ^ (");
                String _name_1 = f2.getName();
                _builder.append((Object)_name_1, "\t\t");
                _builder.append((Object)" >>> 32))");
            } else {
                _builder.append((Object)"((");
                String _name_2 = f2.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)" != null) ? ");
                String _name_3 = f2.getName();
                _builder.append((Object)_name_3, "\t\t");
                _builder.append((Object)".hashCode() : 0)");
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileEquals(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        EList<Annotation> _attributeAnnotations = aaf.getAttributeAnnotations();
        for (Annotation a : _attributeAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements = false;
                for (AnnotationProperty af : _features_1) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(af, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean equals(Object obj) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this == obj)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (obj == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (getClass() != obj.getClass())");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _name = e.getName();
        _builder.append((Object)_name, "\t\t");
        _builder.append((Object)" other = (");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t\t");
        _builder.append((Object)") obj;");
        _builder.newLineIfNotEmpty();
        EList<PojoProperty> _attrs = f.getAttrs();
        for (PojoProperty f2 : _attrs) {
            boolean _notEquals;
            _builder.append((Object)"\t\t");
            String _native = f2.getNative();
            boolean bl = _notEquals = !Objects.equal((Object)_native, null);
            if (_notEquals) {
                _builder.append((Object)"if (");
                String _name_2 = f2.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)" != other.");
                String _name_3 = f2.getName();
                _builder.append((Object)_name_3, "\t\t");
                _builder.append((Object)")");
            } else {
                _builder.append((Object)"if (");
                String _name_4 = f2.getName();
                _builder.append((Object)_name_4, "\t\t");
                _builder.append((Object)" == null || !");
                String _name_5 = f2.getName();
                _builder.append((Object)_name_5, "\t\t");
                _builder.append((Object)".equals(other.");
                String _name_6 = f2.getName();
                _builder.append((Object)_name_6, "\t\t");
                _builder.append((Object)"))");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return false;");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileToString(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        EList<Annotation> _attributeAnnotations = aaf.getAttributeAnnotations();
        for (Annotation a : _attributeAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements = false;
                for (AnnotationProperty af : _features_1) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(af, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toString() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return \"");
        String _name = e.getName();
        _builder.append((Object)_name, "\t\t");
        _builder.append((Object)" [");
        EList<PojoProperty> _attrs = f.getAttrs();
        boolean _hasElements_1 = false;
        for (Object f2 : _attrs) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \", ", "\t\t");
            }
            String _name_1 = f2.getName();
            _builder.append((Object)_name_1, "\t\t");
            _builder.append((Object)"=\" + ");
            String _name_2 = f2.getName();
            _builder.append((Object)_name_2, "\t\t");
        }
        PojoEntity _superType = Utils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            _builder.append((Object)" + super.toString()");
        }
        _builder.append((Object)" + \"]\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_1 = aaf.getAttributeAnnotations();
        for (Annotation a_1 : _attributeAnnotations_1) {
            boolean _not_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_1 = a_1.getType();
            CharSequence _serialize_1 = im.serialize(_type_1);
            _builder.append((Object)_serialize_1, "\t");
            EList<AnnotationProperty> _features_2 = a_1.getFeatures();
            boolean _isEmpty_1 = _features_2.isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_3 = a_1.getFeatures();
                boolean _hasElements_2 = false;
                for (AnnotationProperty af_1 : _features_3) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(af_1, im);
                    _builder.append((Object)_compileAnnotationProperty_1, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toStringFull() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return \"");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t\t");
        _builder.append((Object)" [");
        EList<PojoAnnotatedProperty> _features_4 = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                return ProcessorPojoGenerator.this.isAttribute(_feature);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features_4, (Functions.Function1)_function);
        boolean _hasElements_3 = false;
        for (PojoAnnotatedProperty f2_1 : _filter) {
            if (!_hasElements_3) {
                _hasElements_3 = true;
            } else {
                _builder.appendImmediate((Object)" + \", ", "\t\t");
            }
            PojoProperty _feature = f2_1.getFeature();
            String _name_4 = _feature.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)"=\" + ");
            PojoProperty _feature_1 = f2_1.getFeature();
            String _name_5 = _feature_1.getName();
            _builder.append((Object)_name_5, "\t\t");
        }
        PojoEntity _superType_1 = Utils.getSuperType(e);
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_superType_1, null);
        if (_notEquals_1) {
            _builder.append((Object)" + super.toString()");
        }
        _builder.append((Object)" + \"]\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileIsDef(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum Attribute {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList<PojoProperty> _attrs = f.getAttrs();
        boolean _hasElements = false;
        for (Object f2 : _attrs) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name = f2.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations = aaf.getAttributeAnnotations();
        for (Annotation a : _attributeAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements_1 = false;
                for (AnnotationProperty af : _features_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(af, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"private Set<String> nullValues = new HashSet<String>();");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_1 = aaf.getAttributeAnnotations();
        for (Annotation a_1 : _attributeAnnotations_1) {
            boolean _not_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_1 = a_1.getType();
            CharSequence _serialize_1 = im.serialize(_type_1);
            _builder.append((Object)_serialize_1, "\t");
            EList<AnnotationProperty> _features_2 = a_1.getFeatures();
            boolean _isEmpty_1 = _features_2.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_3 = a_1.getFeatures();
                boolean _hasElements_2 = false;
                for (AnnotationProperty af_1 : _features_3) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(af_1, im);
                    _builder.append((Object)_compileAnnotationProperty_1, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        EList<Annotation> _conflictAnnotations = ae.getConflictAnnotations();
        for (Annotation a_2 : _conflictAnnotations) {
            boolean _not_2;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_2 = a_2.getType();
            CharSequence _serialize_2 = im.serialize(_type_2);
            _builder.append((Object)_serialize_2, "\t");
            EList<AnnotationProperty> _features_4 = a_2.getFeatures();
            boolean _isEmpty_2 = _features_4.isEmpty();
            boolean bl = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_5 = a_2.getFeatures();
                boolean _hasElements_3 = false;
                for (AnnotationProperty ff : _features_5) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty(ff, im);
                    _builder.append((Object)_compileAnnotationProperty_2, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setNull(Attribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (Attribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"nullValues.add(attribute.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_2 = aaf.getAttributeAnnotations();
        for (Annotation a_3 : _attributeAnnotations_2) {
            boolean _not_3;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_3 = a_3.getType();
            CharSequence _serialize_3 = im.serialize(_type_3);
            _builder.append((Object)_serialize_3, "\t");
            EList<AnnotationProperty> _features_6 = a_3.getFeatures();
            boolean _isEmpty_3 = _features_6.isEmpty();
            boolean bl = _not_3 = !_isEmpty_3;
            if (_not_3) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_7 = a_3.getFeatures();
                boolean _hasElements_4 = false;
                for (AnnotationProperty af_2 : _features_7) {
                    if (!_hasElements_4) {
                        _hasElements_4 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_3 = this.compileAnnotationProperty(af_2, im);
                    _builder.append((Object)_compileAnnotationProperty_3, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        EList<Annotation> _conflictAnnotations_1 = ae.getConflictAnnotations();
        for (Annotation a_4 : _conflictAnnotations_1) {
            boolean _not_4;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_4 = a_4.getType();
            CharSequence _serialize_4 = im.serialize(_type_4);
            _builder.append((Object)_serialize_4, "\t");
            EList<AnnotationProperty> _features_8 = a_4.getFeatures();
            boolean _isEmpty_4 = _features_8.isEmpty();
            boolean bl = _not_4 = !_isEmpty_4;
            if (_not_4) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_9 = a_4.getFeatures();
                boolean _hasElements_5 = false;
                for (AnnotationProperty ff_1 : _features_9) {
                    if (!_hasElements_5) {
                        _hasElements_5 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_4 = this.compileAnnotationProperty(ff_1, im);
                    _builder.append((Object)_compileAnnotationProperty_4, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" _setNull(Attribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setNull(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_3 = aaf.getAttributeAnnotations();
        for (Annotation a_5 : _attributeAnnotations_3) {
            boolean _not_5;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_5 = a_5.getType();
            CharSequence _serialize_5 = im.serialize(_type_5);
            _builder.append((Object)_serialize_5, "\t");
            EList<AnnotationProperty> _features_10 = a_5.getFeatures();
            boolean _isEmpty_5 = _features_10.isEmpty();
            boolean bl = _not_5 = !_isEmpty_5;
            if (_not_5) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_11 = a_5.getFeatures();
                boolean _hasElements_6 = false;
                for (AnnotationProperty af_3 : _features_11) {
                    if (!_hasElements_6) {
                        _hasElements_6 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_5 = this.compileAnnotationProperty(af_3, im);
                    _builder.append((Object)_compileAnnotationProperty_5, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        EList<Annotation> _conflictAnnotations_2 = ae.getConflictAnnotations();
        for (Annotation a_6 : _conflictAnnotations_2) {
            boolean _not_6;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_6 = a_6.getType();
            CharSequence _serialize_6 = im.serialize(_type_6);
            _builder.append((Object)_serialize_6, "\t");
            EList<AnnotationProperty> _features_12 = a_6.getFeatures();
            boolean _isEmpty_6 = _features_12.isEmpty();
            boolean bl = _not_6 = !_isEmpty_6;
            if (_not_6) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_13 = a_6.getFeatures();
                boolean _hasElements_7 = false;
                for (AnnotationProperty ff_2 : _features_13) {
                    if (!_hasElements_7) {
                        _hasElements_7 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_6 = this.compileAnnotationProperty(ff_2, im);
                    _builder.append((Object)_compileAnnotationProperty_6, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearNull(Attribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (Attribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"nullValues.remove(attribute.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_4 = aaf.getAttributeAnnotations();
        for (Annotation a_7 : _attributeAnnotations_4) {
            boolean _not_7;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_7 = a_7.getType();
            CharSequence _serialize_7 = im.serialize(_type_7);
            _builder.append((Object)_serialize_7, "\t");
            EList<AnnotationProperty> _features_14 = a_7.getFeatures();
            boolean _isEmpty_7 = _features_14.isEmpty();
            boolean bl = _not_7 = !_isEmpty_7;
            if (_not_7) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_15 = a_7.getFeatures();
                boolean _hasElements_8 = false;
                for (AnnotationProperty af_4 : _features_15) {
                    if (!_hasElements_8) {
                        _hasElements_8 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_7 = this.compileAnnotationProperty(af_4, im);
                    _builder.append((Object)_compileAnnotationProperty_7, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        EList<Annotation> _conflictAnnotations_3 = ae.getConflictAnnotations();
        for (Annotation a_8 : _conflictAnnotations_3) {
            boolean _not_8;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_8 = a_8.getType();
            CharSequence _serialize_8 = im.serialize(_type_8);
            _builder.append((Object)_serialize_8, "\t");
            EList<AnnotationProperty> _features_16 = a_8.getFeatures();
            boolean _isEmpty_8 = _features_16.isEmpty();
            boolean bl = _not_8 = !_isEmpty_8;
            if (_not_8) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_17 = a_8.getFeatures();
                boolean _hasElements_9 = false;
                for (AnnotationProperty ff_3 : _features_17) {
                    if (!_hasElements_9) {
                        _hasElements_9 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_8 = this.compileAnnotationProperty(ff_3, im);
                    _builder.append((Object)_compileAnnotationProperty_8, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)" _clearNull(Attribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearNull(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_5 = aaf.getAttributeAnnotations();
        for (Annotation a_9 : _attributeAnnotations_5) {
            boolean _not_9;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_9 = a_9.getType();
            CharSequence _serialize_9 = im.serialize(_type_9);
            _builder.append((Object)_serialize_9, "\t");
            EList<AnnotationProperty> _features_18 = a_9.getFeatures();
            boolean _isEmpty_9 = _features_18.isEmpty();
            boolean bl = _not_9 = !_isEmpty_9;
            if (_not_9) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_19 = a_9.getFeatures();
                boolean _hasElements_10 = false;
                for (AnnotationProperty af_5 : _features_19) {
                    if (!_hasElements_10) {
                        _hasElements_10 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_9 = this.compileAnnotationProperty(af_5, im);
                    _builder.append((Object)_compileAnnotationProperty_9, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setNull(String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"nullValues.add(attribute);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_6 = aaf.getAttributeAnnotations();
        for (Annotation a_10 : _attributeAnnotations_6) {
            boolean _not_10;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_10 = a_10.getType();
            CharSequence _serialize_10 = im.serialize(_type_10);
            _builder.append((Object)_serialize_10, "\t");
            EList<AnnotationProperty> _features_20 = a_10.getFeatures();
            boolean _isEmpty_10 = _features_20.isEmpty();
            boolean bl = _not_10 = !_isEmpty_10;
            if (_not_10) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_21 = a_10.getFeatures();
                boolean _hasElements_11 = false;
                for (AnnotationProperty af_6 : _features_21) {
                    if (!_hasElements_11) {
                        _hasElements_11 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_10 = this.compileAnnotationProperty(af_6, im);
                    _builder.append((Object)_compileAnnotationProperty_10, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)" _setNull(String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setNull(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_7 = aaf.getAttributeAnnotations();
        for (Annotation a_11 : _attributeAnnotations_7) {
            boolean _not_11;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_11 = a_11.getType();
            CharSequence _serialize_11 = im.serialize(_type_11);
            _builder.append((Object)_serialize_11, "\t");
            EList<AnnotationProperty> _features_22 = a_11.getFeatures();
            boolean _isEmpty_11 = _features_22.isEmpty();
            boolean bl = _not_11 = !_isEmpty_11;
            if (_not_11) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_23 = a_11.getFeatures();
                boolean _hasElements_12 = false;
                for (AnnotationProperty af_7 : _features_23) {
                    if (!_hasElements_12) {
                        _hasElements_12 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_11 = this.compileAnnotationProperty(af_7, im);
                    _builder.append((Object)_compileAnnotationProperty_11, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearNull(String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"nullValues.remove(attribute);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_8 = aaf.getAttributeAnnotations();
        for (Annotation a_12 : _attributeAnnotations_8) {
            boolean _not_12;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_12 = a_12.getType();
            CharSequence _serialize_12 = im.serialize(_type_12);
            _builder.append((Object)_serialize_12, "\t");
            EList<AnnotationProperty> _features_24 = a_12.getFeatures();
            boolean _isEmpty_12 = _features_24.isEmpty();
            boolean bl = _not_12 = !_isEmpty_12;
            if (_not_12) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_25 = a_12.getFeatures();
                boolean _hasElements_13 = false;
                for (AnnotationProperty af_8 : _features_25) {
                    if (!_hasElements_13) {
                        _hasElements_13 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_12 = this.compileAnnotationProperty(af_8, im);
                    _builder.append((Object)_compileAnnotationProperty_12, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" _clearNull(String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearNull(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_9 = aaf.getAttributeAnnotations();
        for (Annotation a_13 : _attributeAnnotations_9) {
            boolean _not_13;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_13 = a_13.getType();
            CharSequence _serialize_13 = im.serialize(_type_13);
            _builder.append((Object)_serialize_13, "\t");
            EList<AnnotationProperty> _features_26 = a_13.getFeatures();
            boolean _isEmpty_13 = _features_26.isEmpty();
            boolean bl = _not_13 = !_isEmpty_13;
            if (_not_13) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_27 = a_13.getFeatures();
                boolean _hasElements_14 = false;
                for (AnnotationProperty af_9 : _features_27) {
                    if (!_hasElements_14) {
                        _hasElements_14 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_13 = this.compileAnnotationProperty(af_9, im);
                    _builder.append((Object)_compileAnnotationProperty_13, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public Boolean isNull(String attrName) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attrName == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return nullValues.contains(attrName);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_10 = aaf.getAttributeAnnotations();
        for (Annotation a_14 : _attributeAnnotations_10) {
            boolean _not_14;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_14 = a_14.getType();
            CharSequence _serialize_14 = im.serialize(_type_14);
            _builder.append((Object)_serialize_14, "\t");
            EList<AnnotationProperty> _features_28 = a_14.getFeatures();
            boolean _isEmpty_14 = _features_28.isEmpty();
            boolean bl = _not_14 = !_isEmpty_14;
            if (_not_14) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_29 = a_14.getFeatures();
                boolean _hasElements_15 = false;
                for (AnnotationProperty af_10 : _features_29) {
                    if (!_hasElements_15) {
                        _hasElements_15 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_14 = this.compileAnnotationProperty(af_10, im);
                    _builder.append((Object)_compileAnnotationProperty_14, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        EList<Annotation> _conflictAnnotations_4 = ae.getConflictAnnotations();
        for (Annotation a_15 : _conflictAnnotations_4) {
            boolean _not_15;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_15 = a_15.getType();
            CharSequence _serialize_15 = im.serialize(_type_15);
            _builder.append((Object)_serialize_15, "\t");
            EList<AnnotationProperty> _features_30 = a_15.getFeatures();
            boolean _isEmpty_15 = _features_30.isEmpty();
            boolean bl = _not_15 = !_isEmpty_15;
            if (_not_15) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_31 = a_15.getFeatures();
                boolean _hasElements_16 = false;
                for (AnnotationProperty ff_4 : _features_31) {
                    if (!_hasElements_16) {
                        _hasElements_16 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_15 = this.compileAnnotationProperty(ff_4, im);
                    _builder.append((Object)_compileAnnotationProperty_15, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public Boolean isNull(Attribute attribute) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attribute == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return nullValues.contains(attribute.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_11 = aaf.getAttributeAnnotations();
        for (Annotation a_16 : _attributeAnnotations_11) {
            boolean _not_16;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_16 = a_16.getType();
            CharSequence _serialize_16 = im.serialize(_type_16);
            _builder.append((Object)_serialize_16, "\t");
            EList<AnnotationProperty> _features_32 = a_16.getFeatures();
            boolean _isEmpty_16 = _features_32.isEmpty();
            boolean bl = _not_16 = !_isEmpty_16;
            if (_not_16) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_33 = a_16.getFeatures();
                boolean _hasElements_17 = false;
                for (AnnotationProperty af_11 : _features_33) {
                    if (!_hasElements_17) {
                        _hasElements_17 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_16 = this.compileAnnotationProperty(af_11, im);
                    _builder.append((Object)_compileAnnotationProperty_16, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public Boolean isDef(String attrName) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attrName == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (nullValues.contains(attrName))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Object result = MethodUtils.invokeMethod(this, \"get\" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1, attrName.length()), null);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return (result != null) ? true : false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (NoSuchMethodException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (IllegalAccessException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (InvocationTargetException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Object result = MethodUtils.invokeMethod(this, \"is\" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1, attrName.length()), null);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return (result != null) ? true : false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (NoSuchMethodException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (IllegalAccessException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (InvocationTargetException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_12 = aaf.getAttributeAnnotations();
        for (Annotation a_17 : _attributeAnnotations_12) {
            boolean _not_17;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_17 = a_17.getType();
            CharSequence _serialize_17 = im.serialize(_type_17);
            _builder.append((Object)_serialize_17, "\t");
            EList<AnnotationProperty> _features_34 = a_17.getFeatures();
            boolean _isEmpty_17 = _features_34.isEmpty();
            boolean bl = _not_17 = !_isEmpty_17;
            if (_not_17) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_35 = a_17.getFeatures();
                boolean _hasElements_18 = false;
                for (AnnotationProperty af_12 : _features_35) {
                    if (!_hasElements_18) {
                        _hasElements_18 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_17 = this.compileAnnotationProperty(af_12, im);
                    _builder.append((Object)_compileAnnotationProperty_17, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearAllNull() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"nullValues = new HashSet<String>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileEnumDef(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum Attribute {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList<PojoProperty> _attrs = f.getAttrs();
        boolean _hasElements = false;
        for (PojoProperty f2 : _attrs) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name = f2.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileToInit(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum Association {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList<PojoProperty> _attrs = f.getAttrs();
        boolean _hasElements = false;
        for (Object f2 : _attrs) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name = f2.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations = aaf.getAttributeAnnotations();
        for (Annotation a : _attributeAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements_1 = false;
                for (AnnotationProperty af : _features_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(af, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"private Set<String> initAssociations = new HashSet<String>();");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_1 = aaf.getAttributeAnnotations();
        for (Annotation a_1 : _attributeAnnotations_1) {
            boolean _not_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_1 = a_1.getType();
            CharSequence _serialize_1 = im.serialize(_type_1);
            _builder.append((Object)_serialize_1, "\t");
            EList<AnnotationProperty> _features_2 = a_1.getFeatures();
            boolean _isEmpty_1 = _features_2.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_3 = a_1.getFeatures();
                boolean _hasElements_2 = false;
                for (AnnotationProperty af_1 : _features_3) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(af_1, im);
                    _builder.append((Object)_compileAnnotationProperty_1, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        EList<Annotation> _conflictAnnotations = ae.getConflictAnnotations();
        for (Annotation a_2 : _conflictAnnotations) {
            boolean _not_2;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_2 = a_2.getType();
            CharSequence _serialize_2 = im.serialize(_type_2);
            _builder.append((Object)_serialize_2, "\t");
            EList<AnnotationProperty> _features_4 = a_2.getFeatures();
            boolean _isEmpty_2 = _features_4.isEmpty();
            boolean bl = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_5 = a_2.getFeatures();
                boolean _hasElements_3 = false;
                for (AnnotationProperty ff : _features_5) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty(ff, im);
                    _builder.append((Object)_compileAnnotationProperty_2, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setInit(Association... associations) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (associations == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (Association association : associations)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"initAssociations.add(association.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_2 = aaf.getAttributeAnnotations();
        for (Annotation a_3 : _attributeAnnotations_2) {
            boolean _not_3;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_3 = a_3.getType();
            CharSequence _serialize_3 = im.serialize(_type_3);
            _builder.append((Object)_serialize_3, "\t");
            EList<AnnotationProperty> _features_6 = a_3.getFeatures();
            boolean _isEmpty_3 = _features_6.isEmpty();
            boolean bl = _not_3 = !_isEmpty_3;
            if (_not_3) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_7 = a_3.getFeatures();
                boolean _hasElements_4 = false;
                for (AnnotationProperty af_2 : _features_7) {
                    if (!_hasElements_4) {
                        _hasElements_4 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_3 = this.compileAnnotationProperty(af_2, im);
                    _builder.append((Object)_compileAnnotationProperty_3, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        EList<Annotation> _conflictAnnotations_1 = ae.getConflictAnnotations();
        for (Annotation a_4 : _conflictAnnotations_1) {
            boolean _not_4;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_4 = a_4.getType();
            CharSequence _serialize_4 = im.serialize(_type_4);
            _builder.append((Object)_serialize_4, "\t");
            EList<AnnotationProperty> _features_8 = a_4.getFeatures();
            boolean _isEmpty_4 = _features_8.isEmpty();
            boolean bl = _not_4 = !_isEmpty_4;
            if (_not_4) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_9 = a_4.getFeatures();
                boolean _hasElements_5 = false;
                for (AnnotationProperty ff_1 : _features_9) {
                    if (!_hasElements_5) {
                        _hasElements_5 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_4 = this.compileAnnotationProperty(ff_1, im);
                    _builder.append((Object)_compileAnnotationProperty_4, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)"\t_setInit(Association... associations) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setInit(associations);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_3 = aaf.getAttributeAnnotations();
        for (Annotation a_5 : _attributeAnnotations_3) {
            boolean _not_5;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_5 = a_5.getType();
            CharSequence _serialize_5 = im.serialize(_type_5);
            _builder.append((Object)_serialize_5, "\t");
            EList<AnnotationProperty> _features_10 = a_5.getFeatures();
            boolean _isEmpty_5 = _features_10.isEmpty();
            boolean bl = _not_5 = !_isEmpty_5;
            if (_not_5) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_11 = a_5.getFeatures();
                boolean _hasElements_6 = false;
                for (AnnotationProperty af_3 : _features_11) {
                    if (!_hasElements_6) {
                        _hasElements_6 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_5 = this.compileAnnotationProperty(af_3, im);
                    _builder.append((Object)_compileAnnotationProperty_5, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        EList<Annotation> _conflictAnnotations_2 = ae.getConflictAnnotations();
        for (Annotation a_6 : _conflictAnnotations_2) {
            boolean _not_6;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_6 = a_6.getType();
            CharSequence _serialize_6 = im.serialize(_type_6);
            _builder.append((Object)_serialize_6, "\t");
            EList<AnnotationProperty> _features_12 = a_6.getFeatures();
            boolean _isEmpty_6 = _features_12.isEmpty();
            boolean bl = _not_6 = !_isEmpty_6;
            if (_not_6) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_13 = a_6.getFeatures();
                boolean _hasElements_7 = false;
                for (AnnotationProperty ff_2 : _features_13) {
                    if (!_hasElements_7) {
                        _hasElements_7 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_6 = this.compileAnnotationProperty(ff_2, im);
                    _builder.append((Object)_compileAnnotationProperty_6, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearInit(Association... associations) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (associations == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (Association association : associations)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"initAssociations.remove(association.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_4 = aaf.getAttributeAnnotations();
        for (Annotation a_7 : _attributeAnnotations_4) {
            boolean _not_7;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_7 = a_7.getType();
            CharSequence _serialize_7 = im.serialize(_type_7);
            _builder.append((Object)_serialize_7, "\t");
            EList<AnnotationProperty> _features_14 = a_7.getFeatures();
            boolean _isEmpty_7 = _features_14.isEmpty();
            boolean bl = _not_7 = !_isEmpty_7;
            if (_not_7) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_15 = a_7.getFeatures();
                boolean _hasElements_8 = false;
                for (AnnotationProperty af_4 : _features_15) {
                    if (!_hasElements_8) {
                        _hasElements_8 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_7 = this.compileAnnotationProperty(af_4, im);
                    _builder.append((Object)_compileAnnotationProperty_7, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        EList<Annotation> _conflictAnnotations_3 = ae.getConflictAnnotations();
        for (Annotation a_8 : _conflictAnnotations_3) {
            boolean _not_8;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_8 = a_8.getType();
            CharSequence _serialize_8 = im.serialize(_type_8);
            _builder.append((Object)_serialize_8, "\t");
            EList<AnnotationProperty> _features_16 = a_8.getFeatures();
            boolean _isEmpty_8 = _features_16.isEmpty();
            boolean bl = _not_8 = !_isEmpty_8;
            if (_not_8) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_17 = a_8.getFeatures();
                boolean _hasElements_9 = false;
                for (AnnotationProperty ff_3 : _features_17) {
                    if (!_hasElements_9) {
                        _hasElements_9 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_8 = this.compileAnnotationProperty(ff_3, im);
                    _builder.append((Object)_compileAnnotationProperty_8, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)" _clearInit(Association... associations) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearInit(associations);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_5 = aaf.getAttributeAnnotations();
        for (Annotation a_9 : _attributeAnnotations_5) {
            boolean _not_9;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_9 = a_9.getType();
            CharSequence _serialize_9 = im.serialize(_type_9);
            _builder.append((Object)_serialize_9, "\t");
            EList<AnnotationProperty> _features_18 = a_9.getFeatures();
            boolean _isEmpty_9 = _features_18.isEmpty();
            boolean bl = _not_9 = !_isEmpty_9;
            if (_not_9) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_19 = a_9.getFeatures();
                boolean _hasElements_10 = false;
                for (AnnotationProperty af_5 : _features_19) {
                    if (!_hasElements_10) {
                        _hasElements_10 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_9 = this.compileAnnotationProperty(af_5, im);
                    _builder.append((Object)_compileAnnotationProperty_9, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setInit(String... associations) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (associations == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String association : associations)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"initAssociations.add(association);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_6 = aaf.getAttributeAnnotations();
        for (Annotation a_10 : _attributeAnnotations_6) {
            boolean _not_10;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_10 = a_10.getType();
            CharSequence _serialize_10 = im.serialize(_type_10);
            _builder.append((Object)_serialize_10, "\t");
            EList<AnnotationProperty> _features_20 = a_10.getFeatures();
            boolean _isEmpty_10 = _features_20.isEmpty();
            boolean bl = _not_10 = !_isEmpty_10;
            if (_not_10) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_21 = a_10.getFeatures();
                boolean _hasElements_11 = false;
                for (AnnotationProperty af_6 : _features_21) {
                    if (!_hasElements_11) {
                        _hasElements_11 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_10 = this.compileAnnotationProperty(af_6, im);
                    _builder.append((Object)_compileAnnotationProperty_10, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)" _setInit(String... associations) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setInit(associations);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_7 = aaf.getAttributeAnnotations();
        for (Annotation a_11 : _attributeAnnotations_7) {
            boolean _not_11;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_11 = a_11.getType();
            CharSequence _serialize_11 = im.serialize(_type_11);
            _builder.append((Object)_serialize_11, "\t");
            EList<AnnotationProperty> _features_22 = a_11.getFeatures();
            boolean _isEmpty_11 = _features_22.isEmpty();
            boolean bl = _not_11 = !_isEmpty_11;
            if (_not_11) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_23 = a_11.getFeatures();
                boolean _hasElements_12 = false;
                for (AnnotationProperty af_7 : _features_23) {
                    if (!_hasElements_12) {
                        _hasElements_12 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_11 = this.compileAnnotationProperty(af_7, im);
                    _builder.append((Object)_compileAnnotationProperty_11, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearInit(String... associations) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (associations == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String association : associations)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"initAssociations.remove(association);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_8 = aaf.getAttributeAnnotations();
        for (Annotation a_12 : _attributeAnnotations_8) {
            boolean _not_12;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_12 = a_12.getType();
            CharSequence _serialize_12 = im.serialize(_type_12);
            _builder.append((Object)_serialize_12, "\t");
            EList<AnnotationProperty> _features_24 = a_12.getFeatures();
            boolean _isEmpty_12 = _features_24.isEmpty();
            boolean bl = _not_12 = !_isEmpty_12;
            if (_not_12) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_25 = a_12.getFeatures();
                boolean _hasElements_13 = false;
                for (AnnotationProperty af_8 : _features_25) {
                    if (!_hasElements_13) {
                        _hasElements_13 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_12 = this.compileAnnotationProperty(af_8, im);
                    _builder.append((Object)_compileAnnotationProperty_12, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" _clearInit(String... associations) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearInit(associations);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_9 = aaf.getAttributeAnnotations();
        for (Annotation a_13 : _attributeAnnotations_9) {
            boolean _not_13;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_13 = a_13.getType();
            CharSequence _serialize_13 = im.serialize(_type_13);
            _builder.append((Object)_serialize_13, "\t");
            EList<AnnotationProperty> _features_26 = a_13.getFeatures();
            boolean _isEmpty_13 = _features_26.isEmpty();
            boolean bl = _not_13 = !_isEmpty_13;
            if (_not_13) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_27 = a_13.getFeatures();
                boolean _hasElements_14 = false;
                for (AnnotationProperty af_9 : _features_27) {
                    if (!_hasElements_14) {
                        _hasElements_14 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_13 = this.compileAnnotationProperty(af_9, im);
                    _builder.append((Object)_compileAnnotationProperty_13, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public Boolean toInit(String association) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (association == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return initAssociations.contains(association);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _attributeAnnotations_10 = aaf.getAttributeAnnotations();
        for (Annotation a_14 : _attributeAnnotations_10) {
            boolean _not_14;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_14 = a_14.getType();
            CharSequence _serialize_14 = im.serialize(_type_14);
            _builder.append((Object)_serialize_14, "\t");
            EList<AnnotationProperty> _features_28 = a_14.getFeatures();
            boolean _isEmpty_14 = _features_28.isEmpty();
            boolean bl = _not_14 = !_isEmpty_14;
            if (_not_14) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_29 = a_14.getFeatures();
                boolean _hasElements_15 = false;
                for (AnnotationProperty af_10 : _features_29) {
                    if (!_hasElements_15) {
                        _hasElements_15 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_14 = this.compileAnnotationProperty(af_10, im);
                    _builder.append((Object)_compileAnnotationProperty_14, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearAllInit() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"initAssociations = new HashSet<String>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileEnumInit(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum Association {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList<PojoProperty> _attrs = f.getAttrs();
        boolean _hasElements = false;
        for (PojoProperty f2 : _attrs) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name = f2.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileOperators(ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum OpAttribute {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList<PojoAnnotatedProperty> _features = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                return ProcessorPojoGenerator.this.isAttribute(_feature);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features, (Functions.Function1)_function);
        boolean _hasElements = false;
        Iterator iterator = _filter.iterator();
        while (iterator.hasNext()) {
            PojoAnnotatedProperty f = (PojoAnnotatedProperty)iterator.next();
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            PojoProperty _feature = f.getFeature();
            String _name = _feature.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _conflictAnnotations = ae.getConflictAnnotations();
        for (Annotation a : _conflictAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features_1 = a.getFeatures();
            boolean _isEmpty = _features_1.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_2 = a.getFeatures();
                boolean _hasElements_1 = false;
                for (AnnotationProperty ff : _features_2) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(ff, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"private Map<String, String> operators = new HashMap<String, String>();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Map<String, String> getOperators() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return operators;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _conflictAnnotations_1 = ae.getConflictAnnotations();
        for (Annotation a_1 : _conflictAnnotations_1) {
            boolean _not_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_1 = a_1.getType();
            CharSequence _serialize_1 = im.serialize(_type_1);
            _builder.append((Object)_serialize_1, "\t");
            EList<AnnotationProperty> _features_3 = a_1.getFeatures();
            boolean _isEmpty_1 = _features_3.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_4 = a_1.getFeatures();
                boolean _hasElements_2 = false;
                for (AnnotationProperty ff_1 : _features_4) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(ff_1, im);
                    _builder.append((Object)_compileAnnotationProperty_1, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setOp(String operator, OpAttribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (OpAttribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.put(attribute.name(), operator);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _conflictAnnotations_2 = ae.getConflictAnnotations();
        for (Annotation a_2 : _conflictAnnotations_2) {
            boolean _not_2;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_2 = a_2.getType();
            CharSequence _serialize_2 = im.serialize(_type_2);
            _builder.append((Object)_serialize_2, "\t");
            EList<AnnotationProperty> _features_5 = a_2.getFeatures();
            boolean _isEmpty_2 = _features_5.isEmpty();
            boolean bl = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_6 = a_2.getFeatures();
                boolean _hasElements_3 = false;
                for (AnnotationProperty ff_2 : _features_6) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty(ff_2, im);
                    _builder.append((Object)_compileAnnotationProperty_2, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" _setOp(String operator, OpAttribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setOp(operator, attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _conflictAnnotations_3 = ae.getConflictAnnotations();
        for (Annotation a_3 : _conflictAnnotations_3) {
            boolean _not_3;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_3 = a_3.getType();
            CharSequence _serialize_3 = im.serialize(_type_3);
            _builder.append((Object)_serialize_3, "\t");
            EList<AnnotationProperty> _features_7 = a_3.getFeatures();
            boolean _isEmpty_3 = _features_7.isEmpty();
            boolean bl = _not_3 = !_isEmpty_3;
            if (_not_3) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_8 = a_3.getFeatures();
                boolean _hasElements_4 = false;
                for (AnnotationProperty ff_3 : _features_8) {
                    if (!_hasElements_4) {
                        _hasElements_4 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_3 = this.compileAnnotationProperty(ff_3, im);
                    _builder.append((Object)_compileAnnotationProperty_3, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearOp(OpAttribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (OpAttribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.remove(attribute.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _conflictAnnotations_4 = ae.getConflictAnnotations();
        for (Annotation a_4 : _conflictAnnotations_4) {
            boolean _not_4;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_4 = a_4.getType();
            CharSequence _serialize_4 = im.serialize(_type_4);
            _builder.append((Object)_serialize_4, "\t");
            EList<AnnotationProperty> _features_9 = a_4.getFeatures();
            boolean _isEmpty_4 = _features_9.isEmpty();
            boolean bl = _not_4 = !_isEmpty_4;
            if (_not_4) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_10 = a_4.getFeatures();
                boolean _hasElements_5 = false;
                for (AnnotationProperty ff_4 : _features_10) {
                    if (!_hasElements_5) {
                        _hasElements_5 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_4 = this.compileAnnotationProperty(ff_4, im);
                    _builder.append((Object)_compileAnnotationProperty_4, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)" _clearOp(OpAttribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearOp(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setOp(String operator, String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.put(attribute, operator);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)" _setOp(String operator, String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setOp(operator, attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearOp(String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.remove(attribute);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" _clearOp(String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearOp(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _conflictAnnotations_5 = ae.getConflictAnnotations();
        for (Annotation a_5 : _conflictAnnotations_5) {
            boolean _not_5;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_5 = a_5.getType();
            CharSequence _serialize_5 = im.serialize(_type_5);
            _builder.append((Object)_serialize_5, "\t");
            EList<AnnotationProperty> _features_11 = a_5.getFeatures();
            boolean _isEmpty_5 = _features_11.isEmpty();
            boolean bl = _not_5 = !_isEmpty_5;
            if (_not_5) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_12 = a_5.getFeatures();
                boolean _hasElements_6 = false;
                for (AnnotationProperty ff_5 : _features_12) {
                    if (!_hasElements_6) {
                        _hasElements_6 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_5 = this.compileAnnotationProperty(ff_5, im);
                    _builder.append((Object)_compileAnnotationProperty_5, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setNullOp(OpAttribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (OpAttribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.put(attribute.name(), \"is null\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<Annotation> _conflictAnnotations_6 = ae.getConflictAnnotations();
        for (Annotation a_6 : _conflictAnnotations_6) {
            boolean _not_6;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_6 = a_6.getType();
            CharSequence _serialize_6 = im.serialize(_type_6);
            _builder.append((Object)_serialize_6, "\t");
            EList<AnnotationProperty> _features_13 = a_6.getFeatures();
            boolean _isEmpty_6 = _features_13.isEmpty();
            boolean bl = _not_6 = !_isEmpty_6;
            if (_not_6) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_14 = a_6.getFeatures();
                boolean _hasElements_7 = false;
                for (AnnotationProperty ff_6 : _features_14) {
                    if (!_hasElements_7) {
                        _hasElements_7 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_6 = this.compileAnnotationProperty(ff_6, im);
                    _builder.append((Object)_compileAnnotationProperty_6, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_5 = e.getName();
        _builder.append((Object)_name_5, "\t");
        _builder.append((Object)" _setNullOp(OpAttribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setNullOp(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setNullOp(String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.put(attribute, \"is null\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)" _setNullOp(String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setNullOp(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearAllOps() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"operators = new HashMap<String, String>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public List<PojoAnnotatedProperty> listFeatures(PojoEntity e) {
        boolean _notEquals;
        ArrayList<PojoAnnotatedProperty> list = new ArrayList<PojoAnnotatedProperty>();
        PojoEntity _superType = Utils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            PojoEntity _superType_1 = Utils.getSuperType(e);
            List<PojoAnnotatedProperty> _listFeatures = this.listFeatures(_superType_1);
            list.addAll(_listFeatures);
        }
        List<PojoAnnotatedProperty> _listFeatures1 = this.listFeatures1(e);
        list.addAll(_listFeatures1);
        return list;
    }

    public List<PojoAnnotatedProperty> listFeatures1(PojoEntity e) {
        EList<PojoAnnotatedProperty> _features = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty f) {
                PojoProperty _feature = f.getFeature();
                return Utils.isList(_feature);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_filter);
    }

    public List<PojoAnnotatedProperty> requiredFeatures(PojoEntity e) {
        boolean _notEquals;
        ArrayList<PojoAnnotatedProperty> list = new ArrayList<PojoAnnotatedProperty>();
        PojoEntity _superType = Utils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            PojoEntity _superType_1 = Utils.getSuperType(e);
            List<PojoAnnotatedProperty> _requiredFeatures = this.requiredFeatures(_superType_1);
            list.addAll(_requiredFeatures);
        }
        List<PojoAnnotatedProperty> _requiredFeatures1 = this.requiredFeatures1(e);
        list.addAll(_requiredFeatures1);
        return list;
    }

    public ArrayList<PojoAnnotatedProperty> requiredSuperFeatures(PojoEntity e) {
        boolean _notEquals;
        ArrayList<PojoAnnotatedProperty> list = new ArrayList<PojoAnnotatedProperty>();
        PojoEntity _superType = Utils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            PojoEntity _superType_1 = Utils.getSuperType(e);
            List<PojoAnnotatedProperty> _requiredFeatures = this.requiredFeatures(_superType_1);
            list.addAll(_requiredFeatures);
        }
        return list;
    }

    public List<PojoAnnotatedProperty> requiredFeatures1(PojoEntity e) {
        EList<PojoAnnotatedProperty> _features = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty f) {
                PojoProperty _feature = f.getFeature();
                return Utils.isRequired(_feature);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_filter);
    }

    public PojoAnnotatedProperty hasIsDef(PojoEntity e) {
        EList<PojoAnnotatedProperty> _features = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty f) {
                PojoProperty _feature = f.getFeature();
                String _name = _feature.getName();
                return Objects.equal((Object)_name, (Object)"isDef");
            }
        };
        return (PojoAnnotatedProperty)IterableExtensions.findFirst(_features, (Functions.Function1)_function);
    }

    public PojoAnnotatedProperty hasToInit(PojoEntity e) {
        EList<PojoAnnotatedProperty> _features = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty f) {
                PojoProperty _feature = f.getFeature();
                String _name = _feature.getName();
                return Objects.equal((Object)_name, (Object)"toInit");
            }
        };
        return (PojoAnnotatedProperty)IterableExtensions.findFirst(_features, (Functions.Function1)_function);
    }

    public boolean isAttribute(PojoProperty f) {
        JvmType _type;
        boolean _notEquals_2;
        Entity _ref;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _or = false;
        boolean _or_1 = false;
        String _native = f.getNative();
        boolean bl = _notEquals = !Objects.equal((Object)_native, null);
        _or_1 = _notEquals ? true : (_notEquals_1 = !Objects.equal((Object)(_ref = f.getRef()), null));
        _or = _or_1 ? true : (_notEquals_2 = !Objects.equal((Object)(_type = f.getType()), null));
        return _or;
    }

    public List<PojoProperty> simplAttrs(PojoProperty f) {
        EList<PojoProperty> _attrs = f.getAttrs();
        Functions.Function1<PojoProperty, Boolean> _function = new Functions.Function1<PojoProperty, Boolean>(){

            public Boolean apply(PojoProperty f2) {
                JvmType _type;
                boolean _notEquals_1;
                boolean _notEquals;
                boolean _or = false;
                String _native = f2.getNative();
                boolean bl = _notEquals = !Objects.equal((Object)_native, null);
                _or = _notEquals ? true : (_notEquals_1 = !Objects.equal((Object)(_type = f2.getType()), null));
                return _or;
            }
        };
        Iterable _filter = IterableExtensions.filter(_attrs, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_filter);
    }

    public CharSequence compileImplements(EnumEntity e) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _sernum = Utils.getSernum(e);
        boolean bl = _notEquals = !Objects.equal((Object)_sernum, null);
        if (_notEquals) {
            _builder.append((Object)"implements Serializable");
        }
        _builder.append((Object)" ");
        return _builder;
    }

    public CharSequence compileExtends(PojoEntity e, ImportManager im) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        PojoEntity _superType = Utils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            _builder.append((Object)"extends ");
            PojoEntity _superType_1 = Utils.getSuperType(e);
            PojoEntity _superType_2 = Utils.getSuperType(e);
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)_superType_2);
            String _fullName = Utils.getFullName(e, _superType_1, _fullyQualifiedName, im);
            _builder.append((Object)_fullName, "");
            _builder.append((Object)" ");
        } else {
            boolean _notEquals_1;
            String _extends = this.getExtends(e);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_extends, (Object)"");
            if (_notEquals_1) {
                _builder.append((Object)"extends ");
                String _extends_1 = this.getExtends(e);
                _builder.append((Object)_extends_1, "");
                _builder.append((Object)" ");
            }
        }
        return _builder;
    }

    public CharSequence compileImplements(PojoEntity e) {
        String _sernum;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _or = false;
        boolean _isImplements = this.isImplements(e);
        _or = _isImplements ? true : (_notEquals = !Objects.equal((Object)(_sernum = Utils.getSernum(e)), null));
        if (_or) {
            boolean _notEquals_1;
            _builder.append((Object)"implements ");
            ArrayList<Implements> _implements = this.getImplements(e);
            boolean _hasElements = false;
            for (Implements f : _implements) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                JvmType _implements_1 = f.getImplements();
                String _simpleName = _implements_1.getSimpleName();
                _builder.append((Object)_simpleName, "");
            }
            String _sernum_1 = Utils.getSernum(e);
            boolean bl = _notEquals_1 = !Objects.equal((Object)_sernum_1, null);
            if (_notEquals_1) {
                boolean _isImplements_1 = this.isImplements(e);
                if (_isImplements_1) {
                    _builder.append((Object)", ");
                }
                _builder.append((Object)"Serializable");
            }
            _builder.append((Object)" ");
        }
        return _builder;
    }

    public boolean compile(Extends e, ImportManager im) {
        JvmType _extends = e.getExtends();
        return im.addImportFor(_extends);
    }

    public void addImplements(EnumEntity e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements impl : _filter) {
            JvmType _implements = impl.getImplements();
            im.addImportFor(_implements);
        }
    }

    public void addExtends(EnumEntity e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            JvmType _extends = ext.getExtends();
            im.addImportFor(_extends);
        }
    }

    public void addImplements(PojoEntity e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements impl : _filter) {
            JvmType _implements = impl.getImplements();
            im.addImportFor(_implements);
        }
    }

    public void addExtends(PojoEntity e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            JvmType _extends = ext.getExtends();
            im.addImportFor(_extends);
        }
    }

    public void addAnnotations(List<Annotation> annotations, ImportManager im) {
        for (Annotation a : annotations) {
            JvmType _type = a.getType();
            im.serialize(_type);
        }
    }

    public String getExtends(EnumEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            Extends ext = (Extends)iterator.next();
            JvmType _extends = ext.getExtends();
            return _extends.getSimpleName();
        }
        return "";
    }

    public boolean isImplements(EnumEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            Implements ext = (Implements)iterator.next();
            return true;
        }
        return false;
    }

    public boolean isExtends(PojoEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            boolean _not;
            Extends ext = (Extends)iterator.next();
            EList<PojoEntity> _onlyPojos = ext.getOnlyPojos();
            boolean _isEmpty = _onlyPojos.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                EList<PojoEntity> _onlyPojos_1 = ext.getOnlyPojos();
                for (PojoEntity ee : _onlyPojos_1) {
                    String _name_1;
                    String _name = ee.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                    if (!_equals) continue;
                    return true;
                }
                return false;
            }
            EList<PojoEntity> _exceptPojos = ext.getExceptPojos();
            for (PojoEntity ee_1 : _exceptPojos) {
                String _name_3;
                String _name_2 = ee_1.getName();
                boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
                if (!_equals_1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isExtends(PojoEntity e, Extends ext) {
        boolean _not;
        EList<PojoEntity> _onlyPojos = ext.getOnlyPojos();
        boolean _isEmpty = _onlyPojos.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<PojoEntity> _onlyPojos_1 = ext.getOnlyPojos();
            for (PojoEntity ee : _onlyPojos_1) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return true;
            }
            return false;
        }
        EList<PojoEntity> _exceptPojos = ext.getExceptPojos();
        for (PojoEntity ee_1 : _exceptPojos) {
            String _name_3;
            String _name_2 = ee_1.getName();
            boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
            if (!_equals_1) continue;
            return false;
        }
        return true;
    }

    public String getExtends(PojoEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            boolean _isExtends = this.isExtends(e, ext);
            if (!_isExtends) continue;
            JvmType _extends = ext.getExtends();
            return _extends.getSimpleName();
        }
        return "";
    }

    public boolean isImplements(PojoEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements ext : _filter) {
            boolean _not;
            EList<PojoEntity> _exceptPojos = ext.getExceptPojos();
            for (PojoEntity ee : _exceptPojos) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return false;
            }
            EList<PojoEntity> _onlyPojos = ext.getOnlyPojos();
            boolean _isEmpty = _onlyPojos.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                EList<PojoEntity> _onlyPojos_1 = ext.getOnlyPojos();
                for (PojoEntity ee_1 : _onlyPojos_1) {
                    String _name_3;
                    String _name_2 = ee_1.getName();
                    boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
                    if (!_equals_1) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean isImplements(PojoEntity e, Implements ext) {
        boolean _not;
        EList<PojoEntity> _onlyPojos = ext.getOnlyPojos();
        boolean _isEmpty = _onlyPojos.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<PojoEntity> _onlyPojos_1 = ext.getOnlyPojos();
            for (PojoEntity ee : _onlyPojos_1) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return true;
            }
            return false;
        }
        EList<PojoEntity> _exceptPojos = ext.getExceptPojos();
        for (PojoEntity ee_1 : _exceptPojos) {
            String _name_3;
            String _name_2 = ee_1.getName();
            boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
            if (!_equals_1) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Implements> getImplements(PojoEntity e) {
        ArrayList<Implements> list = new ArrayList<Implements>();
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements ext : _filter) {
            boolean _isImplements = this.isImplements(e, ext);
            if (!_isImplements) continue;
            list.add(ext);
        }
        return list;
    }
}

