/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.sqlproc.dsl.ImportManager;
import org.sqlproc.dsl.generator.ProcessorGeneratorUtils;
import org.sqlproc.dsl.processorDsl.Extends;
import org.sqlproc.dsl.processorDsl.ImplPackage;
import org.sqlproc.dsl.processorDsl.Implements;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoMethod;
import org.sqlproc.dsl.processorDsl.PojoMethodArg;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.processorDsl.PojoType;
import org.sqlproc.dsl.util.Utils;

public class ProcessorDaoGenerator {
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private ProcessorGeneratorUtils _processorGeneratorUtils;

    public CharSequence compile(PojoDao d) {
        boolean _notEquals_4;
        String _sernum;
        boolean _notEquals_3;
        List<String> _imports;
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals_2;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        ImportManager im = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        this.addImplements(d, im);
        _builder.newLineIfNotEmpty();
        this.addExtends(d, im);
        _builder.newLineIfNotEmpty();
        Map<String, List<PojoMethodArg>> toInits = Utils.getToInits(d);
        _builder.newLineIfNotEmpty();
        PojoEntity _pojo = d.getPojo();
        CharSequence classBody = this.compile(d, _pojo, toInits, im);
        _builder.newLineIfNotEmpty();
        EObject _eContainer = d.eContainer();
        boolean bl = _notEquals = !Objects.equal((Object)_eContainer, null);
        if (_notEquals) {
            boolean _notEquals_1;
            _builder.append((Object)"package ");
            EObject _eContainer_1 = d.eContainer();
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_1);
            _builder.append((Object)_fullyQualifiedName, "");
            String _implPackage = this.getImplPackage(d);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_implPackage, null);
            if (_notEquals_1) {
                _builder.append((Object)".");
                String _implPackage_1 = this.getImplPackage(d);
                _builder.append((Object)_implPackage_1, "");
            }
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        String _implPackage_2 = this.getImplPackage(d);
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_implPackage_2, null);
        if (_notEquals_2) {
            _builder.newLine();
            _builder.append((Object)"import ");
            EObject _eContainer_2 = d.eContainer();
            QualifiedName _fullyQualifiedName_1 = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_2);
            _builder.append((Object)_fullyQualifiedName_1, "");
            _builder.append((Object)".");
            String _name = d.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        boolean bl4 = _not = !(_isEmpty = (_imports = im.getImports()).isEmpty());
        if (_not) {
            _builder.append((Object)"\t");
            _builder.newLine();
            List<String> _imports_1 = im.getImports();
            for (String i : _imports_1) {
                _builder.append((Object)"import ");
                _builder.append((Object)i, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl5 = _notEquals_3 = !Objects.equal((Object)(_sernum = Utils.getSernum(d)), null);
        if (_notEquals_3) {
            _builder.newLine();
            _builder.append((Object)"import java.io.Serializable;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"import java.util.HashMap;");
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Map;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlControl;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlCrudEngine;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlEngineFactory;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlQueryEngine;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlProcedureEngine;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlSession;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlSessionFactory;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.impl.SqlStandardControl;");
        _builder.newLine();
        PojoEntity _pojo_1 = d.getPojo();
        boolean bl6 = _notEquals_4 = !Objects.equal((Object)_pojo_1, null);
        if (_notEquals_4) {
            _builder.append((Object)"import ");
            PojoEntity _pojo_2 = d.getPojo();
            String _completeName = this._processorGeneratorUtils.completeName(_pojo_2);
            _builder.append((Object)_completeName, "");
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        Set<Map.Entry<String, List<PojoMethodArg>>> _entrySet = toInits.entrySet();
        for (Map.Entry<String, List<PojoMethodArg>> f : _entrySet) {
            List<PojoMethodArg> _value = f.getValue();
            boolean _hasElements = false;
            for (PojoMethodArg a : _value) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n\t\t", "");
                }
                _builder.append((Object)"import ");
                PojoType _type = a.getType();
                PojoEntity _ref = _type.getRef();
                String _completeName_1 = this._processorGeneratorUtils.completeName(_ref);
                _builder.append((Object)_completeName_1, "");
                _builder.append((Object)";");
            }
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)classBody, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compile(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im) {
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        boolean _isAbstract = Utils.isAbstract(d);
        if (_isAbstract) {
            _builder.append((Object)"abstract ");
        }
        _builder.append((Object)"class ");
        String _name = d.getName();
        _builder.append((Object)_name, "");
        String _implPackage = this.getImplPackage(d);
        boolean bl = _notEquals = !Objects.equal((Object)_implPackage, null);
        if (_notEquals) {
            _builder.append((Object)"Impl");
        }
        _builder.append((Object)" ");
        CharSequence _compileExtends = this.compileExtends(d, im);
        _builder.append((Object)_compileExtends, "");
        CharSequence _compileImplements = this.compileImplements(d);
        _builder.append((Object)_compileImplements, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        String _sernum = Utils.getSernum(d);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_sernum, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private static final long serialVersionUID = ");
            String _sernum_1 = Utils.getSernum(d);
            _builder.append((Object)_sernum_1, "\t");
            _builder.append((Object)"L;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"protected final Logger logger = LoggerFactory.getLogger(getClass());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected SqlEngineFactory sqlEngineFactory;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected SqlSessionFactory sqlSessionFactory;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = d.getName();
        _builder.append((Object)_name_1, "\t");
        String _implPackage_1 = this.getImplPackage(d);
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_implPackage_1, null);
        if (_notEquals_2) {
            _builder.append((Object)"Impl");
        }
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = d.getName();
        _builder.append((Object)_name_2, "\t");
        String _implPackage_2 = this.getImplPackage(d);
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_implPackage_2, null);
        if (_notEquals_3) {
            _builder.append((Object)"Impl");
        }
        _builder.append((Object)"(SqlEngineFactory sqlEngineFactory) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.sqlEngineFactory = sqlEngineFactory;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = d.getName();
        _builder.append((Object)_name_3, "\t");
        String _implPackage_3 = this.getImplPackage(d);
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_implPackage_3, null);
        if (_notEquals_4) {
            _builder.append((Object)"Impl");
        }
        _builder.append((Object)"(SqlEngineFactory sqlEngineFactory, SqlSessionFactory sqlSessionFactory) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.sqlEngineFactory = sqlEngineFactory;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.sqlSessionFactory = sqlSessionFactory;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList<PojoMethod> _methods = d.getMethods();
        for (PojoMethod m : _methods) {
            boolean _isCallQueryFunction;
            boolean _or = false;
            String _name_4 = m.getName();
            boolean _equals = Objects.equal((Object)_name_4, (Object)"scaffold");
            if (_equals) {
                _or = true;
            } else {
                boolean _equals_1;
                String _name_5 = m.getName();
                _or = _equals_1 = Objects.equal((Object)_name_5, (Object)"scaffold0");
            }
            if (_or) {
                boolean _not;
                PojoEntity _parent = Utils.getParent(e);
                String _name_6 = m.getName();
                boolean _equals_2 = Objects.equal((Object)_name_6, (Object)"scaffold");
                CharSequence _compileInsert = this.compileInsert(d, e, _parent, im, _equals_2);
                _builder.append((Object)_compileInsert, "");
                _builder.newLineIfNotEmpty();
                String _name_7 = m.getName();
                boolean _equals_3 = Objects.equal((Object)_name_7, (Object)"scaffold");
                CharSequence _compileGet = this.compileGet(d, e, toInits, im, _equals_3);
                _builder.append((Object)_compileGet, "");
                _builder.newLineIfNotEmpty();
                PojoEntity _parent_1 = Utils.getParent(e);
                String _name_8 = m.getName();
                boolean _equals_4 = Objects.equal((Object)_name_8, (Object)"scaffold");
                CharSequence _compileUpdate = this.compileUpdate(d, e, _parent_1, im, _equals_4);
                _builder.append((Object)_compileUpdate, "");
                _builder.newLineIfNotEmpty();
                PojoEntity _parent_2 = Utils.getParent(e);
                String _name_9 = m.getName();
                boolean _equals_5 = Objects.equal((Object)_name_9, (Object)"scaffold");
                CharSequence _compileDelete = this.compileDelete(d, e, _parent_2, im, _equals_5);
                _builder.append((Object)_compileDelete, "");
                _builder.newLineIfNotEmpty();
                String _name_10 = m.getName();
                boolean _equals_6 = Objects.equal((Object)_name_10, (Object)"scaffold");
                CharSequence _compileList = this.compileList(d, e, toInits, im, _equals_6);
                _builder.append((Object)_compileList, "");
                _builder.newLineIfNotEmpty();
                String _name_11 = m.getName();
                boolean _equals_7 = Objects.equal((Object)_name_11, (Object)"scaffold");
                CharSequence _compileCount = this.compileCount(d, e, toInits, im, _equals_7);
                _builder.append((Object)_compileCount, "");
                _builder.newLineIfNotEmpty();
                boolean _isEmpty = toInits.isEmpty();
                boolean bl6 = _not = !_isEmpty;
                if (!_not) continue;
                CharSequence _compileMoreResultClasses = this.compileMoreResultClasses(d, e, toInits, im);
                _builder.append((Object)_compileMoreResultClasses, "");
                continue;
            }
            boolean _isCallUpdate = Utils.isCallUpdate(m);
            if (_isCallUpdate) {
                _builder.newLineIfNotEmpty();
                CharSequence _compileCallUpdate = this.compileCallUpdate(d, m, im, true);
                _builder.append((Object)_compileCallUpdate, "");
                continue;
            }
            boolean _isCallFunction = Utils.isCallFunction(m);
            if (_isCallFunction) {
                CharSequence _compileCallFunction = this.compileCallFunction(d, m, im, true);
                _builder.append((Object)_compileCallFunction, "");
                continue;
            }
            boolean _or_1 = false;
            boolean _isCallQuery = Utils.isCallQuery(m);
            _or_1 = _isCallQuery ? true : (_isCallQueryFunction = Utils.isCallQueryFunction(m));
            if (_or_1) {
                boolean _isCallQueryFunction_1 = Utils.isCallQueryFunction(m);
                CharSequence _compileCallQuery = this.compileCallQuery(d, m, im, _isCallQueryFunction_1, true);
                _builder.append((Object)_compileCallQuery, "");
                continue;
            }
            boolean _isCallSelectFunction = Utils.isCallSelectFunction(m);
            if (!_isCallSelectFunction) continue;
            CharSequence _compileCallSelectFunction = this.compileCallSelectFunction(d, m, im, true);
            _builder.append((Object)_compileCallSelectFunction, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileCallQuery(PojoDao d, PojoMethod m, ImportManager im, boolean isFunction, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type = m.getType();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_type, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)" ");
        String _name = m.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args = m.getArgs();
        boolean _hasElements = false;
        for (PojoMethodArg ma : _args) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_1 = ma.getType();
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(_type_1, im);
            _builder.append((Object)_compileType_1, "\t");
            _builder.append((Object)" ");
            String _name_1 = ma.getName();
            _builder.append((Object)_name_1, "\t");
        }
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"");
        String _name_2 = m.getName();
        _builder.append((Object)_name_2, "\t\t\t");
        _builder.append((Object)": \" + ");
        EList<PojoMethodArg> _args_1 = m.getArgs();
        boolean _hasElements_1 = false;
        for (PojoMethodArg ma_1 : _args_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \" \" ", "\t\t\t");
            }
            String _name_3 = ma_1.getName();
            _builder.append((Object)_name_3, "\t\t\t");
        }
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlProcedureEngine sqlProc");
        String _name_4 = m.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_4);
        _builder.append((Object)_firstUpper, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"");
        if (isFunction) {
            _builder.append((Object)"FUN");
        } else {
            _builder.append((Object)"PROC");
        }
        _builder.append((Object)"_");
        String _dbName = Utils.dbName(m);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        PojoType _type_2 = m.getType();
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_type_2, im);
        _builder.append((Object)_compileType_2, "\t\t");
        _builder.append((Object)" list = sqlProc");
        String _name_5 = m.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_5);
        _builder.append((Object)_firstUpper_1, "\t\t");
        _builder.append((Object)".callQuery(sqlSession, ");
        PojoType _type_3 = m.getType();
        PojoEntity _gref = _type_3.getGref();
        String _name_6 = _gref.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)".class, ");
        EList<PojoMethodArg> _args_2 = m.getArgs();
        boolean _hasElements_2 = false;
        for (PojoMethodArg ma_2 : _args_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name_7 = ma_2.getName();
            _builder.append((Object)_name_7, "\t\t");
        }
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"");
        String _name_8 = m.getName();
        _builder.append((Object)_name_8, "\t\t\t");
        _builder.append((Object)" result: \" + list);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return list;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_4 = m.getType();
            CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_type_4, im);
            _builder.append((Object)_compileType_3, "\t");
            _builder.append((Object)" ");
            String _name_9 = m.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_3 = m.getArgs();
            boolean _hasElements_3 = false;
            for (PojoMethodArg ma_3 : _args_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_5 = ma_3.getType();
                CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_type_5, im);
                _builder.append((Object)_compileType_4, "\t");
                _builder.append((Object)" ");
                String _name_10 = ma_3.getName();
                _builder.append((Object)_name_10, "\t");
            }
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_11 = m.getName();
            _builder.append((Object)_name_11, "\t\t");
            _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
            EList<PojoMethodArg> _args_4 = m.getArgs();
            boolean _hasElements_4 = false;
            for (Object ma_4 : _args_4) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                String _name_12 = ma_4.getName();
                _builder.append((Object)_name_12, "\t\t");
            }
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type_6 = m.getType();
        CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(_type_6, im);
        _builder.append((Object)_compileType_5, "\t");
        _builder.append((Object)" ");
        String _name_13 = m.getName();
        _builder.append((Object)_name_13, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args_5 = m.getArgs();
        boolean _hasElements_5 = false;
        for (PojoMethodArg ma_5 : _args_5) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_7 = ma_5.getType();
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_type_7, im);
            _builder.append((Object)_compileType_6, "\t");
            _builder.append((Object)" ");
            String _name_14 = ma_5.getName();
            _builder.append((Object)_name_14, "\t");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_15 = m.getName();
        _builder.append((Object)_name_15, "\t\t");
        _builder.append((Object)"(sqlSession, ");
        EList<PojoMethodArg> _args_6 = m.getArgs();
        boolean _hasElements_6 = false;
        for (PojoMethodArg ma_6 : _args_6) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name_16 = ma_6.getName();
            _builder.append((Object)_name_16, "\t\t");
        }
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_8 = m.getType();
            CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(_type_8, im);
            _builder.append((Object)_compileType_7, "\t");
            _builder.append((Object)" ");
            String _name_17 = m.getName();
            _builder.append((Object)_name_17, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_7 = m.getArgs();
            boolean _hasElements_7 = false;
            for (PojoMethodArg ma_7 : _args_7) {
                if (!_hasElements_7) {
                    _hasElements_7 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_9 = ma_7.getType();
                CharSequence _compileType_8 = this._processorGeneratorUtils.compileType(_type_9, im);
                _builder.append((Object)_compileType_8, "\t");
                _builder.append((Object)" ");
                String _name_18 = ma_7.getName();
                _builder.append((Object)_name_18, "\t");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_19 = m.getName();
            _builder.append((Object)_name_19, "\t\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_8 = m.getArgs();
            boolean _hasElements_8 = false;
            for (PojoMethodArg ma_8 : _args_8) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                String _name_20 = ma_8.getName();
                _builder.append((Object)_name_20, "\t\t");
            }
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileCallFunction(PojoDao d, PojoMethod m, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type = m.getType();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_type, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)" ");
        String _name = m.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args = m.getArgs();
        boolean _hasElements = false;
        for (PojoMethodArg ma : _args) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_1 = ma.getType();
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(_type_1, im);
            _builder.append((Object)_compileType_1, "\t");
            _builder.append((Object)" ");
            String _name_1 = ma.getName();
            _builder.append((Object)_name_1, "\t");
        }
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"");
        String _name_2 = m.getName();
        _builder.append((Object)_name_2, "\t\t\t");
        _builder.append((Object)": \" + ");
        EList<PojoMethodArg> _args_1 = m.getArgs();
        boolean _hasElements_1 = false;
        for (PojoMethodArg ma_1 : _args_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \" \" ", "\t\t\t");
            }
            String _name_3 = ma_1.getName();
            _builder.append((Object)_name_3, "\t\t\t");
        }
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlProcedureEngine sqlFun");
        String _name_4 = m.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_4);
        _builder.append((Object)_firstUpper, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"FUN_");
        String _dbName = Utils.dbName(m);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Object result = sqlFun");
        String _name_5 = m.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_5);
        _builder.append((Object)_firstUpper_1, "\t\t");
        _builder.append((Object)".callFunction(sqlSession, ");
        EList<PojoMethodArg> _args_2 = m.getArgs();
        boolean _hasElements_2 = false;
        for (PojoMethodArg ma_2 : _args_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name_6 = ma_2.getName();
            _builder.append((Object)_name_6, "\t\t");
        }
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"");
        String _name_7 = m.getName();
        _builder.append((Object)_name_7, "\t\t\t");
        _builder.append((Object)" result: \" + result);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return (");
        PojoType _type_2 = m.getType();
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_type_2, im);
        _builder.append((Object)_compileType_2, "\t\t");
        _builder.append((Object)") result;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_3 = m.getType();
            CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_type_3, im);
            _builder.append((Object)_compileType_3, "\t");
            _builder.append((Object)" ");
            String _name_8 = m.getName();
            _builder.append((Object)_name_8, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_3 = m.getArgs();
            boolean _hasElements_3 = false;
            for (PojoMethodArg ma_3 : _args_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_4 = ma_3.getType();
                CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_type_4, im);
                _builder.append((Object)_compileType_4, "\t");
                _builder.append((Object)" ");
                String _name_9 = ma_3.getName();
                _builder.append((Object)_name_9, "\t");
            }
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_10 = m.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
            EList<PojoMethodArg> _args_4 = m.getArgs();
            boolean _hasElements_4 = false;
            for (Object ma_4 : _args_4) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                String _name_11 = ma_4.getName();
                _builder.append((Object)_name_11, "\t\t");
            }
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type_5 = m.getType();
        CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(_type_5, im);
        _builder.append((Object)_compileType_5, "\t");
        _builder.append((Object)" ");
        String _name_12 = m.getName();
        _builder.append((Object)_name_12, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args_5 = m.getArgs();
        boolean _hasElements_5 = false;
        for (PojoMethodArg ma_5 : _args_5) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_6 = ma_5.getType();
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_type_6, im);
            _builder.append((Object)_compileType_6, "\t");
            _builder.append((Object)" ");
            String _name_13 = ma_5.getName();
            _builder.append((Object)_name_13, "\t");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_14 = m.getName();
        _builder.append((Object)_name_14, "\t\t");
        _builder.append((Object)"(sqlSession, ");
        EList<PojoMethodArg> _args_6 = m.getArgs();
        boolean _hasElements_6 = false;
        for (PojoMethodArg ma_6 : _args_6) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name_15 = ma_6.getName();
            _builder.append((Object)_name_15, "\t\t");
        }
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_7 = m.getType();
            CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(_type_7, im);
            _builder.append((Object)_compileType_7, "\t");
            _builder.append((Object)" ");
            String _name_16 = m.getName();
            _builder.append((Object)_name_16, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_7 = m.getArgs();
            boolean _hasElements_7 = false;
            for (PojoMethodArg ma_7 : _args_7) {
                if (!_hasElements_7) {
                    _hasElements_7 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_8 = ma_7.getType();
                CharSequence _compileType_8 = this._processorGeneratorUtils.compileType(_type_8, im);
                _builder.append((Object)_compileType_8, "\t");
                _builder.append((Object)" ");
                String _name_17 = ma_7.getName();
                _builder.append((Object)_name_17, "\t");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_18 = m.getName();
            _builder.append((Object)_name_18, "\t\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_8 = m.getArgs();
            boolean _hasElements_8 = false;
            for (PojoMethodArg ma_8 : _args_8) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                String _name_19 = ma_8.getName();
                _builder.append((Object)_name_19, "\t\t");
            }
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileCallUpdate(PojoDao d, PojoMethod m, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int ");
        String _name = m.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args = m.getArgs();
        boolean _hasElements = false;
        for (PojoMethodArg ma : _args) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type = ma.getType();
            CharSequence _compileType = this._processorGeneratorUtils.compileType(_type, im);
            _builder.append((Object)_compileType, "\t");
            _builder.append((Object)" ");
            String _name_1 = ma.getName();
            _builder.append((Object)_name_1, "\t");
        }
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"");
        String _name_2 = m.getName();
        _builder.append((Object)_name_2, "\t\t\t");
        _builder.append((Object)": \" + ");
        EList<PojoMethodArg> _args_1 = m.getArgs();
        boolean _hasElements_1 = false;
        for (PojoMethodArg ma_1 : _args_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \" \" ", "\t\t\t");
            }
            String _name_3 = ma_1.getName();
            _builder.append((Object)_name_3, "\t\t\t");
        }
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlProcedureEngine sqlProc");
        String _name_4 = m.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_4);
        _builder.append((Object)_firstUpper, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"PROC_");
        String _dbName = Utils.dbName(m);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int count = sqlProc");
        String _name_5 = m.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_5);
        _builder.append((Object)_firstUpper_1, "\t\t");
        _builder.append((Object)".callUpdate(sqlSession, ");
        EList<PojoMethodArg> _args_2 = m.getArgs();
        boolean _hasElements_2 = false;
        for (PojoMethodArg ma_2 : _args_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name_6 = ma_2.getName();
            _builder.append((Object)_name_6, "\t\t");
        }
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"");
        String _name_7 = m.getName();
        _builder.append((Object)_name_7, "\t\t\t");
        _builder.append((Object)" result: \" + count);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return count;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int ");
            String _name_8 = m.getName();
            _builder.append((Object)_name_8, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_3 = m.getArgs();
            boolean _hasElements_3 = false;
            for (PojoMethodArg ma_3 : _args_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_1 = ma_3.getType();
                CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(_type_1, im);
                _builder.append((Object)_compileType_1, "\t");
                _builder.append((Object)" ");
                String _name_9 = ma_3.getName();
                _builder.append((Object)_name_9, "\t");
            }
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_10 = m.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
            EList<PojoMethodArg> _args_4 = m.getArgs();
            boolean _hasElements_4 = false;
            for (Object ma_4 : _args_4) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                String _name_11 = ma_4.getName();
                _builder.append((Object)_name_11, "\t\t");
            }
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int ");
        String _name_12 = m.getName();
        _builder.append((Object)_name_12, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args_5 = m.getArgs();
        boolean _hasElements_5 = false;
        for (PojoMethodArg ma_5 : _args_5) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_2 = ma_5.getType();
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_type_2, im);
            _builder.append((Object)_compileType_2, "\t");
            _builder.append((Object)" ");
            String _name_13 = ma_5.getName();
            _builder.append((Object)_name_13, "\t");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_14 = m.getName();
        _builder.append((Object)_name_14, "\t\t");
        _builder.append((Object)"(sqlSession, ");
        EList<PojoMethodArg> _args_6 = m.getArgs();
        boolean _hasElements_6 = false;
        for (PojoMethodArg ma_6 : _args_6) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name_15 = ma_6.getName();
            _builder.append((Object)_name_15, "\t\t");
        }
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int ");
            String _name_16 = m.getName();
            _builder.append((Object)_name_16, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_7 = m.getArgs();
            boolean _hasElements_7 = false;
            for (PojoMethodArg ma_7 : _args_7) {
                if (!_hasElements_7) {
                    _hasElements_7 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_3 = ma_7.getType();
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_type_3, im);
                _builder.append((Object)_compileType_3, "\t");
                _builder.append((Object)" ");
                String _name_17 = ma_7.getName();
                _builder.append((Object)_name_17, "\t");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_18 = m.getName();
            _builder.append((Object)_name_18, "\t\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_8 = m.getArgs();
            boolean _hasElements_8 = false;
            for (PojoMethodArg ma_8 : _args_8) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                String _name_19 = ma_8.getName();
                _builder.append((Object)_name_19, "\t\t");
            }
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileCallSelectFunction(PojoDao d, PojoMethod m, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type = m.getType();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_type, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)" ");
        String _name = m.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args = m.getArgs();
        boolean _hasElements = false;
        for (PojoMethodArg ma : _args) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_1 = ma.getType();
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(_type_1, im);
            _builder.append((Object)_compileType_1, "\t");
            _builder.append((Object)" ");
            String _name_1 = ma.getName();
            _builder.append((Object)_name_1, "\t");
        }
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"");
        String _name_2 = m.getName();
        _builder.append((Object)_name_2, "\t\t\t");
        _builder.append((Object)": \" + ");
        EList<PojoMethodArg> _args_1 = m.getArgs();
        boolean _hasElements_1 = false;
        for (PojoMethodArg ma_1 : _args_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \" \" ", "\t\t\t");
            }
            String _name_3 = ma_1.getName();
            _builder.append((Object)_name_3, "\t\t\t");
        }
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlQueryEngine sqlFun");
        String _name_4 = m.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_4);
        _builder.append((Object)_firstUpper, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"FUN_");
        String _dbName = Utils.dbName(m);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.List<");
        EList<PojoMethodArg> _args_2 = m.getArgs();
        PojoMethodArg _get = (PojoMethodArg)_args_2.get(0);
        PojoType _type_2 = _get.getType();
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_type_2, im);
        _builder.append((Object)_compileType_2, "\t\t");
        _builder.append((Object)"> list = sqlFun");
        String _name_5 = m.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_5);
        _builder.append((Object)_firstUpper_1, "\t\t");
        _builder.append((Object)".query(sqlSession, ");
        EList<PojoMethodArg> _args_3 = m.getArgs();
        PojoMethodArg _get_1 = (PojoMethodArg)_args_3.get(0);
        PojoType _type_3 = _get_1.getType();
        CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_type_3, im);
        _builder.append((Object)_compileType_3, "\t\t");
        _builder.append((Object)".class, ");
        EList<PojoMethodArg> _args_4 = m.getArgs();
        boolean _hasElements_2 = false;
        for (PojoMethodArg ma_2 : _args_4) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name_6 = ma_2.getName();
            _builder.append((Object)_name_6, "\t\t");
        }
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"");
        String _name_7 = m.getName();
        _builder.append((Object)_name_7, "\t\t\t");
        _builder.append((Object)" result: \" + list);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return (list != null && !list.isEmpty()) ? list.get(0).getResult() : null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_4 = m.getType();
            CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_type_4, im);
            _builder.append((Object)_compileType_4, "\t");
            _builder.append((Object)" ");
            String _name_8 = m.getName();
            _builder.append((Object)_name_8, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_5 = m.getArgs();
            boolean _hasElements_3 = false;
            for (PojoMethodArg ma_3 : _args_5) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_5 = ma_3.getType();
                CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(_type_5, im);
                _builder.append((Object)_compileType_5, "\t");
                _builder.append((Object)" ");
                String _name_9 = ma_3.getName();
                _builder.append((Object)_name_9, "\t");
            }
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_10 = m.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
            EList<PojoMethodArg> _args_6 = m.getArgs();
            boolean _hasElements_4 = false;
            for (Object ma_4 : _args_6) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                String _name_11 = ma_4.getName();
                _builder.append((Object)_name_11, "\t\t");
            }
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type_6 = m.getType();
        CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_type_6, im);
        _builder.append((Object)_compileType_6, "\t");
        _builder.append((Object)" ");
        String _name_12 = m.getName();
        _builder.append((Object)_name_12, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args_7 = m.getArgs();
        boolean _hasElements_5 = false;
        for (PojoMethodArg ma_5 : _args_7) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_7 = ma_5.getType();
            CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(_type_7, im);
            _builder.append((Object)_compileType_7, "\t");
            _builder.append((Object)" ");
            String _name_13 = ma_5.getName();
            _builder.append((Object)_name_13, "\t");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_14 = m.getName();
        _builder.append((Object)_name_14, "\t\t");
        _builder.append((Object)"(sqlSession, ");
        EList<PojoMethodArg> _args_8 = m.getArgs();
        boolean _hasElements_6 = false;
        for (PojoMethodArg ma_6 : _args_8) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name_15 = ma_6.getName();
            _builder.append((Object)_name_15, "\t\t");
        }
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_8 = m.getType();
            CharSequence _compileType_8 = this._processorGeneratorUtils.compileType(_type_8, im);
            _builder.append((Object)_compileType_8, "\t");
            _builder.append((Object)" ");
            String _name_16 = m.getName();
            _builder.append((Object)_name_16, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_9 = m.getArgs();
            boolean _hasElements_7 = false;
            for (PojoMethodArg ma_7 : _args_9) {
                if (!_hasElements_7) {
                    _hasElements_7 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_9 = ma_7.getType();
                CharSequence _compileType_9 = this._processorGeneratorUtils.compileType(_type_9, im);
                _builder.append((Object)_compileType_9, "\t");
                _builder.append((Object)" ");
                String _name_17 = ma_7.getName();
                _builder.append((Object)_name_17, "\t");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_18 = m.getName();
            _builder.append((Object)_name_18, "\t\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_10 = m.getArgs();
            boolean _hasElements_8 = false;
            for (PojoMethodArg ma_8 : _args_10) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                String _name_19 = ma_8.getName();
                _builder.append((Object)_name_19, "\t\t");
            }
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileInsert(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im, boolean all) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" insert(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"insert ");
        String _name_3 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_4 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_4);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlCrudEngine sqlInsert");
        String _name_5 = e.getName();
        _builder.append((Object)_name_5, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"INSERT_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        boolean bl = _notEquals = !Objects.equal((Object)pe, null);
        if (_notEquals) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"SqlCrudEngine sqlInsert");
            String _name_6 = pe.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"INSERT_");
            String _dbName_1 = Utils.dbName(pe);
            _builder.append((Object)_dbName_1, "\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"int count = sqlInsert");
            String _name_7 = pe.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)".insert(sqlSession, ");
            String _name_8 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_8);
            _builder.append((Object)_firstLower_3, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"sqlInsert");
            String _name_9 = e.getName();
            _builder.append((Object)_name_9, "\t\t\t");
            _builder.append((Object)".insert(sqlSession, ");
            String _name_10 = e.getName();
            String _firstLower_4 = StringExtensions.toFirstLower((String)_name_10);
            _builder.append((Object)_firstLower_4, "\t\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        } else {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"int count = sqlInsert");
            String _name_11 = e.getName();
            _builder.append((Object)_name_11, "\t\t");
            _builder.append((Object)".insert(sqlSession, ");
            String _name_12 = e.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_12);
            _builder.append((Object)_firstLower_5, "\t\t");
            _builder.append((Object)", sqlControl);");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"insert ");
        String _name_13 = e.getName();
        String _firstLower_6 = StringExtensions.toFirstLower((String)_name_13);
        _builder.append((Object)_firstLower_6, "\t\t\t");
        _builder.append((Object)" result: \" + count + \" \" + ");
        String _name_14 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_14);
        _builder.append((Object)_firstLower_7, "\t\t\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return (count > 0) ? ");
        String _name_15 = e.getName();
        String _firstLower_8 = StringExtensions.toFirstLower((String)_name_15);
        _builder.append((Object)_firstLower_8, "\t\t");
        _builder.append((Object)" : null;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_16 = e.getName();
            _builder.append((Object)_name_16, "\t");
            _builder.append((Object)" insert(");
            String _name_17 = e.getName();
            _builder.append((Object)_name_17, "\t");
            _builder.append((Object)" ");
            String _name_18 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_18);
            _builder.append((Object)_firstLower_9, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return insert(sqlSessionFactory.getSqlSession(), ");
            String _name_19 = e.getName();
            String _firstLower_10 = StringExtensions.toFirstLower((String)_name_19);
            _builder.append((Object)_firstLower_10, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_20 = e.getName();
        _builder.append((Object)_name_20, "\t");
        _builder.append((Object)" insert(SqlSession sqlSession, ");
        String _name_21 = e.getName();
        _builder.append((Object)_name_21, "\t");
        _builder.append((Object)" ");
        String _name_22 = e.getName();
        String _firstLower_11 = StringExtensions.toFirstLower((String)_name_22);
        _builder.append((Object)_firstLower_11, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return insert(sqlSession, ");
        String _name_23 = e.getName();
        String _firstLower_12 = StringExtensions.toFirstLower((String)_name_23);
        _builder.append((Object)_firstLower_12, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_24 = e.getName();
            _builder.append((Object)_name_24, "\t");
            _builder.append((Object)" insert(");
            String _name_25 = e.getName();
            _builder.append((Object)_name_25, "\t");
            _builder.append((Object)" ");
            String _name_26 = e.getName();
            String _firstLower_13 = StringExtensions.toFirstLower((String)_name_26);
            _builder.append((Object)_firstLower_13, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return insert(");
            String _name_27 = e.getName();
            String _firstLower_14 = StringExtensions.toFirstLower((String)_name_27);
            _builder.append((Object)_firstLower_14, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileGet(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" get(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"get get: \" + ");
        String _name_3 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlCrudEngine sqlGetEngine");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"GET_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        boolean _isEmpty = toInits.isEmpty();
        if (_isEmpty) {
            _builder.append((Object)"//");
        }
        _builder.append((Object)"sqlControl = getMoreResultClasses(");
        String _name_5 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)" ");
        String _name_7 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)"Got = sqlGetEngine");
        String _name_8 = e.getName();
        _builder.append((Object)_name_8, "\t\t");
        _builder.append((Object)".get(sqlSession, ");
        String _name_9 = e.getName();
        _builder.append((Object)_name_9, "\t\t");
        _builder.append((Object)".class, ");
        String _name_10 = e.getName();
        String _firstLower_4 = StringExtensions.toFirstLower((String)_name_10);
        _builder.append((Object)_firstLower_4, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"get ");
        String _name_11 = e.getName();
        String _firstLower_5 = StringExtensions.toFirstLower((String)_name_11);
        _builder.append((Object)_firstLower_5, "\t\t\t");
        _builder.append((Object)" result: \" + ");
        String _name_12 = e.getName();
        String _firstLower_6 = StringExtensions.toFirstLower((String)_name_12);
        _builder.append((Object)_firstLower_6, "\t\t\t");
        _builder.append((Object)"Got);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_13 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_13);
        _builder.append((Object)_firstLower_7, "\t\t");
        _builder.append((Object)"Got;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_14 = e.getName();
            _builder.append((Object)_name_14, "\t");
            _builder.append((Object)" get(");
            String _name_15 = e.getName();
            _builder.append((Object)_name_15, "\t");
            _builder.append((Object)" ");
            String _name_16 = e.getName();
            String _firstLower_8 = StringExtensions.toFirstLower((String)_name_16);
            _builder.append((Object)_firstLower_8, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return get(sqlSessionFactory.getSqlSession(), ");
            String _name_17 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_17);
            _builder.append((Object)_firstLower_9, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_18 = e.getName();
        _builder.append((Object)_name_18, "\t");
        _builder.append((Object)" get(SqlSession sqlSession, ");
        String _name_19 = e.getName();
        _builder.append((Object)_name_19, "\t");
        _builder.append((Object)" ");
        String _name_20 = e.getName();
        String _firstLower_10 = StringExtensions.toFirstLower((String)_name_20);
        _builder.append((Object)_firstLower_10, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return get(sqlSession, ");
        String _name_21 = e.getName();
        String _firstLower_11 = StringExtensions.toFirstLower((String)_name_21);
        _builder.append((Object)_firstLower_11, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_22 = e.getName();
            _builder.append((Object)_name_22, "\t");
            _builder.append((Object)" get(");
            String _name_23 = e.getName();
            _builder.append((Object)_name_23, "\t");
            _builder.append((Object)" ");
            String _name_24 = e.getName();
            String _firstLower_12 = StringExtensions.toFirstLower((String)_name_24);
            _builder.append((Object)_firstLower_12, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return get(");
            String _name_25 = e.getName();
            String _firstLower_13 = StringExtensions.toFirstLower((String)_name_25);
            _builder.append((Object)_firstLower_13, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileUpdate(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im, boolean all) {
        PojoProperty f;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int update(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"update ");
        String _name_2 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_3 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlCrudEngine sqlUpdateEngine");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"UPDATE_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        boolean bl = _notEquals = !Objects.equal((Object)pe, null);
        if (_notEquals) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"SqlCrudEngine sqlUpdate");
            String _name_5 = pe.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"UPDATE_");
            String _dbName_1 = Utils.dbName(pe);
            _builder.append((Object)_dbName_1, "\t\t");
            _builder.append((Object)"\");");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int count = sqlUpdateEngine");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)".update(sqlSession, ");
        String _name_7 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)", sqlControl);");
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pe, null);
        if (_notEquals_1) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"sqlUpdate");
            String _name_8 = pe.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)".update(sqlSession, ");
            String _name_9 = e.getName();
            String _firstLower_4 = StringExtensions.toFirstLower((String)_name_9);
            _builder.append((Object)_firstLower_4, "\t\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        }
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)(f = Utils.getOptLock(e)), null);
        if (_notEquals_2) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _name_10 = e.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_10);
            _builder.append((Object)_firstLower_5, "\t\t\t");
            _builder.append((Object)".set");
            String _name_11 = f.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_11);
            _builder.append((Object)_firstUpper, "\t\t\t");
            _builder.append((Object)"(");
            String _name_12 = e.getName();
            String _firstLower_6 = StringExtensions.toFirstLower((String)_name_12);
            _builder.append((Object)_firstLower_6, "\t\t\t");
            _builder.append((Object)".get");
            String _name_13 = f.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_13);
            _builder.append((Object)_firstUpper_1, "\t\t\t");
            _builder.append((Object)"() + 1);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"update ");
        String _name_14 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_14);
        _builder.append((Object)_firstLower_7, "\t\t\t");
        _builder.append((Object)" result count: \" + count);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return count;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int update(");
            String _name_15 = e.getName();
            _builder.append((Object)_name_15, "\t");
            _builder.append((Object)" ");
            String _name_16 = e.getName();
            String _firstLower_8 = StringExtensions.toFirstLower((String)_name_16);
            _builder.append((Object)_firstLower_8, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return update(sqlSessionFactory.getSqlSession(), ");
            String _name_17 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_17);
            _builder.append((Object)_firstLower_9, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int update(SqlSession sqlSession, ");
        String _name_18 = e.getName();
        _builder.append((Object)_name_18, "\t");
        _builder.append((Object)" ");
        String _name_19 = e.getName();
        String _firstLower_10 = StringExtensions.toFirstLower((String)_name_19);
        _builder.append((Object)_firstLower_10, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return update(sqlSession, ");
        String _name_20 = e.getName();
        String _firstLower_11 = StringExtensions.toFirstLower((String)_name_20);
        _builder.append((Object)_firstLower_11, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int update(");
            String _name_21 = e.getName();
            _builder.append((Object)_name_21, "\t");
            _builder.append((Object)" ");
            String _name_22 = e.getName();
            String _firstLower_12 = StringExtensions.toFirstLower((String)_name_22);
            _builder.append((Object)_firstLower_12, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return update(");
            String _name_23 = e.getName();
            String _firstLower_13 = StringExtensions.toFirstLower((String)_name_23);
            _builder.append((Object)_firstLower_13, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileDelete(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im, boolean all) {
        PojoProperty f;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int delete(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"delete ");
        String _name_2 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_3 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlCrudEngine sqlDeleteEngine");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"DELETE_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        boolean bl = _notEquals = !Objects.equal((Object)pe, null);
        if (_notEquals) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"SqlCrudEngine sqlDelete");
            String _name_5 = pe.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"DELETE_");
            String _dbName_1 = Utils.dbName(pe);
            _builder.append((Object)_dbName_1, "\t\t");
            _builder.append((Object)"\");");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int count = sqlDeleteEngine");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)".delete(sqlSession, ");
        String _name_7 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)", sqlControl);");
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pe, null);
        if (_notEquals_1) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"sqlDelete");
            String _name_8 = pe.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)".delete(sqlSession, ");
            String _name_9 = e.getName();
            String _firstLower_4 = StringExtensions.toFirstLower((String)_name_9);
            _builder.append((Object)_firstLower_4, "\t\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        }
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)(f = Utils.getOptLock(e)), null);
        if (_notEquals_2) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (count > 0) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _name_10 = e.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_10);
            _builder.append((Object)_firstLower_5, "\t\t\t");
            _builder.append((Object)".set");
            String _name_11 = f.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_11);
            _builder.append((Object)_firstUpper, "\t\t\t");
            _builder.append((Object)"(");
            String _name_12 = e.getName();
            String _firstLower_6 = StringExtensions.toFirstLower((String)_name_12);
            _builder.append((Object)_firstLower_6, "\t\t\t");
            _builder.append((Object)".get");
            String _name_13 = f.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_13);
            _builder.append((Object)_firstUpper_1, "\t\t\t");
            _builder.append((Object)"() + 1);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"delete ");
        String _name_14 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_14);
        _builder.append((Object)_firstLower_7, "\t\t\t");
        _builder.append((Object)" result count: \" + count);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return count;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int delete(");
            String _name_15 = e.getName();
            _builder.append((Object)_name_15, "\t");
            _builder.append((Object)" ");
            String _name_16 = e.getName();
            String _firstLower_8 = StringExtensions.toFirstLower((String)_name_16);
            _builder.append((Object)_firstLower_8, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return delete(sqlSessionFactory.getSqlSession(), ");
            String _name_17 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_17);
            _builder.append((Object)_firstLower_9, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int delete(SqlSession sqlSession, ");
        String _name_18 = e.getName();
        _builder.append((Object)_name_18, "\t");
        _builder.append((Object)" ");
        String _name_19 = e.getName();
        String _firstLower_10 = StringExtensions.toFirstLower((String)_name_19);
        _builder.append((Object)_firstLower_10, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return delete(sqlSession, ");
        String _name_20 = e.getName();
        String _firstLower_11 = StringExtensions.toFirstLower((String)_name_20);
        _builder.append((Object)_firstLower_11, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int delete(");
            String _name_21 = e.getName();
            _builder.append((Object)_name_21, "\t");
            _builder.append((Object)" ");
            String _name_22 = e.getName();
            String _firstLower_12 = StringExtensions.toFirstLower((String)_name_22);
            _builder.append((Object)_firstLower_12, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return delete(");
            String _name_23 = e.getName();
            String _firstLower_13 = StringExtensions.toFirstLower((String)_name_23);
            _builder.append((Object)_firstLower_13, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileList(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"> list(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"list ");
        String _name_3 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_4 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_4);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlQueryEngine sqlEngine");
        String _name_5 = e.getName();
        _builder.append((Object)_name_5, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"SELECT_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        boolean _isEmpty = toInits.isEmpty();
        if (_isEmpty) {
            _builder.append((Object)"//");
        }
        _builder.append((Object)"sqlControl = getMoreResultClasses(");
        String _name_6 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_6);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"List<");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "\t\t");
        _builder.append((Object)"> ");
        String _name_8 = e.getName();
        String _firstLower_4 = StringExtensions.toFirstLower((String)_name_8);
        _builder.append((Object)_firstLower_4, "\t\t");
        _builder.append((Object)"List = sqlEngine");
        String _name_9 = e.getName();
        _builder.append((Object)_name_9, "\t\t");
        _builder.append((Object)".query(sqlSession, ");
        String _name_10 = e.getName();
        _builder.append((Object)_name_10, "\t\t");
        _builder.append((Object)".class, ");
        String _name_11 = e.getName();
        String _firstLower_5 = StringExtensions.toFirstLower((String)_name_11);
        _builder.append((Object)_firstLower_5, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"list ");
        String _name_12 = e.getName();
        String _firstLower_6 = StringExtensions.toFirstLower((String)_name_12);
        _builder.append((Object)_firstLower_6, "\t\t\t");
        _builder.append((Object)" size: \" + ((");
        String _name_13 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_13);
        _builder.append((Object)_firstLower_7, "\t\t\t");
        _builder.append((Object)"List != null) ? ");
        String _name_14 = e.getName();
        String _firstLower_8 = StringExtensions.toFirstLower((String)_name_14);
        _builder.append((Object)_firstLower_8, "\t\t\t");
        _builder.append((Object)"List.size() : \"null\"));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_15 = e.getName();
        String _firstLower_9 = StringExtensions.toFirstLower((String)_name_15);
        _builder.append((Object)_firstLower_9, "\t\t");
        _builder.append((Object)"List;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<");
            String _name_16 = e.getName();
            _builder.append((Object)_name_16, "\t");
            _builder.append((Object)"> list(");
            String _name_17 = e.getName();
            _builder.append((Object)_name_17, "\t");
            _builder.append((Object)" ");
            String _name_18 = e.getName();
            String _firstLower_10 = StringExtensions.toFirstLower((String)_name_18);
            _builder.append((Object)_firstLower_10, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return list(sqlSessionFactory.getSqlSession(), ");
            String _name_19 = e.getName();
            String _firstLower_11 = StringExtensions.toFirstLower((String)_name_19);
            _builder.append((Object)_firstLower_11, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<");
        String _name_20 = e.getName();
        _builder.append((Object)_name_20, "\t");
        _builder.append((Object)"> list(SqlSession sqlSession, ");
        String _name_21 = e.getName();
        _builder.append((Object)_name_21, "\t");
        _builder.append((Object)" ");
        String _name_22 = e.getName();
        String _firstLower_12 = StringExtensions.toFirstLower((String)_name_22);
        _builder.append((Object)_firstLower_12, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return list(sqlSession, ");
        String _name_23 = e.getName();
        String _firstLower_13 = StringExtensions.toFirstLower((String)_name_23);
        _builder.append((Object)_firstLower_13, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<");
            String _name_24 = e.getName();
            _builder.append((Object)_name_24, "\t");
            _builder.append((Object)"> list(");
            String _name_25 = e.getName();
            _builder.append((Object)_name_25, "\t");
            _builder.append((Object)" ");
            String _name_26 = e.getName();
            String _firstLower_14 = StringExtensions.toFirstLower((String)_name_26);
            _builder.append((Object)_firstLower_14, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return list(");
            String _name_27 = e.getName();
            String _firstLower_15 = StringExtensions.toFirstLower((String)_name_27);
            _builder.append((Object)_firstLower_15, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileCount(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int count(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"count ");
        String _name_2 = e.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower_1, "\t\t\t");
        _builder.append((Object)": \" + ");
        String _name_3 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_2, "\t\t\t");
        _builder.append((Object)" + \" \" + sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SqlQueryEngine sqlEngine");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"SELECT_");
        String _dbName = Utils.dbName(e);
        _builder.append((Object)_dbName, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        boolean _isEmpty = toInits.isEmpty();
        if (_isEmpty) {
            _builder.append((Object)"//");
        }
        _builder.append((Object)"sqlControl = getMoreResultClasses(");
        String _name_5 = e.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_3, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int count = sqlEngine");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)".queryCount(sqlSession, ");
        String _name_7 = e.getName();
        String _firstLower_4 = StringExtensions.toFirstLower((String)_name_7);
        _builder.append((Object)_firstLower_4, "\t\t");
        _builder.append((Object)", sqlControl);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (logger.isTraceEnabled()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.trace(\"count: \" + count);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return count;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int count(");
            String _name_8 = e.getName();
            _builder.append((Object)_name_8, "\t");
            _builder.append((Object)" ");
            String _name_9 = e.getName();
            String _firstLower_5 = StringExtensions.toFirstLower((String)_name_9);
            _builder.append((Object)_firstLower_5, "\t");
            _builder.append((Object)", SqlControl sqlControl) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return count(sqlSessionFactory.getSqlSession(), ");
            String _name_10 = e.getName();
            String _firstLower_6 = StringExtensions.toFirstLower((String)_name_10);
            _builder.append((Object)_firstLower_6, "\t\t");
            _builder.append((Object)", sqlControl);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int count(SqlSession sqlSession, ");
        String _name_11 = e.getName();
        _builder.append((Object)_name_11, "\t");
        _builder.append((Object)" ");
        String _name_12 = e.getName();
        String _firstLower_7 = StringExtensions.toFirstLower((String)_name_12);
        _builder.append((Object)_firstLower_7, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return count(sqlSession, ");
        String _name_13 = e.getName();
        String _firstLower_8 = StringExtensions.toFirstLower((String)_name_13);
        _builder.append((Object)_firstLower_8, "\t\t");
        _builder.append((Object)", null);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int count(");
            String _name_14 = e.getName();
            _builder.append((Object)_name_14, "\t");
            _builder.append((Object)" ");
            String _name_15 = e.getName();
            String _firstLower_9 = StringExtensions.toFirstLower((String)_name_15);
            _builder.append((Object)_firstLower_9, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return count(");
            String _name_16 = e.getName();
            String _firstLower_10 = StringExtensions.toFirstLower((String)_name_16);
            _builder.append((Object)_firstLower_10, "\t\t");
            _builder.append((Object)", null);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileMoreResultClasses(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"SqlControl getMoreResultClasses(");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (sqlControl != null && sqlControl.getMoreResultClasses() != null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return sqlControl;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Map<String, Class<?>> moreResultClasses = null;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        Set<Map.Entry<String, List<PojoMethodArg>>> _entrySet = toInits.entrySet();
        boolean _hasElements = false;
        for (Map.Entry<String, List<PojoMethodArg>> f : _entrySet) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n\t", "\t\t");
            }
            _builder.append((Object)"\t\tif (");
            String _name_2 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
            _builder.append((Object)_firstLower_1, "\t\t");
            _builder.append((Object)" != null && ");
            String _name_3 = e.getName();
            String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
            _builder.append((Object)_firstLower_2, "\t\t");
            _builder.append((Object)".toInit(");
            String _name_4 = e.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)".Association.");
            String _key = f.getKey();
            _builder.append((Object)_key, "\t\t");
            _builder.append((Object)".name())) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if (moreResultClasses == null)");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"moreResultClasses = new HashMap<String, Class<?>>();");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            List<PojoMethodArg> _value = f.getValue();
            boolean _hasElements_1 = false;
            for (PojoMethodArg a : _value) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)"\n\t", "\t\t");
                }
                _builder.append((Object)"\t\tmoreResultClasses.put(\"");
                String _name_5 = a.getName();
                _builder.append((Object)_name_5, "\t\t");
                _builder.append((Object)"\", ");
                PojoType _type = a.getType();
                PojoEntity _ref = _type.getRef();
                QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)_ref);
                _builder.append((Object)_fullyQualifiedName, "\t\t");
                _builder.append((Object)".class);");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (moreResultClasses != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"sqlControl = new SqlStandardControl(sqlControl);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"((SqlStandardControl) sqlControl).setMoreResultClasses(moreResultClasses);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return sqlControl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileIfx(PojoDao d) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        ImportManager im = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        this.addImplements(d, im);
        _builder.newLineIfNotEmpty();
        this.addExtends(d, im);
        _builder.newLineIfNotEmpty();
        PojoEntity _pojo = d.getPojo();
        CharSequence classBody = this.compileIfx(d, _pojo, im);
        _builder.newLineIfNotEmpty();
        EObject _eContainer = d.eContainer();
        boolean bl = _notEquals = !Objects.equal((Object)_eContainer, null);
        if (_notEquals) {
            _builder.append((Object)"package ");
            EObject _eContainer_1 = d.eContainer();
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_1);
            _builder.append((Object)_fullyQualifiedName, "");
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlSession;");
        _builder.newLine();
        _builder.append((Object)"import org.sqlproc.engine.SqlControl;");
        _builder.newLine();
        _builder.append((Object)"import ");
        PojoEntity _pojo_1 = d.getPojo();
        String _completeName = this._processorGeneratorUtils.completeName(_pojo_1);
        _builder.append((Object)_completeName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)classBody, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compileIfx(PojoDao d, PojoEntity e, ImportManager im) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public interface ");
        String _name = d.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        EList<PojoMethod> _methods = d.getMethods();
        for (PojoMethod m : _methods) {
            boolean _isCallQueryFunction;
            boolean _or = false;
            String _name_1 = m.getName();
            boolean _equals = Objects.equal((Object)_name_1, (Object)"scaffold");
            if (_equals) {
                _or = true;
            } else {
                boolean _equals_1;
                String _name_2 = m.getName();
                _or = _equals_1 = Objects.equal((Object)_name_2, (Object)"scaffold0");
            }
            if (_or) {
                String _name_3 = m.getName();
                boolean _equals_2 = Objects.equal((Object)_name_3, (Object)"scaffold");
                CharSequence _compileInsertIfx = this.compileInsertIfx(d, e, im, _equals_2);
                _builder.append((Object)_compileInsertIfx, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                String _name_4 = m.getName();
                boolean _equals_3 = Objects.equal((Object)_name_4, (Object)"scaffold");
                CharSequence _compileGetIfx = this.compileGetIfx(d, e, im, _equals_3);
                _builder.append((Object)_compileGetIfx, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                String _name_5 = m.getName();
                boolean _equals_4 = Objects.equal((Object)_name_5, (Object)"scaffold");
                CharSequence _compileUpdateIfx = this.compileUpdateIfx(d, e, im, _equals_4);
                _builder.append((Object)_compileUpdateIfx, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                String _name_6 = m.getName();
                boolean _equals_5 = Objects.equal((Object)_name_6, (Object)"scaffold");
                CharSequence _compileDeleteIfx = this.compileDeleteIfx(d, e, im, _equals_5);
                _builder.append((Object)_compileDeleteIfx, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                String _name_7 = m.getName();
                boolean _equals_6 = Objects.equal((Object)_name_7, (Object)"scaffold");
                CharSequence _compileListIfx = this.compileListIfx(d, e, im, _equals_6);
                _builder.append((Object)_compileListIfx, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                String _name_8 = m.getName();
                boolean _equals_7 = Objects.equal((Object)_name_8, (Object)"scaffold");
                CharSequence _compileCountIfx = this.compileCountIfx(d, e, im, _equals_7);
                _builder.append((Object)_compileCountIfx, "\t");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _isCallUpdate = Utils.isCallUpdate(m);
            if (_isCallUpdate) {
                _builder.append((Object)"\t");
                CharSequence _compileCallUpdateIfx = this.compileCallUpdateIfx(d, m, im, true);
                _builder.append((Object)_compileCallUpdateIfx, "\t");
                continue;
            }
            boolean _isCallFunction = Utils.isCallFunction(m);
            if (_isCallFunction) {
                CharSequence _compileCallFunctionIfx = this.compileCallFunctionIfx(d, m, im, true);
                _builder.append((Object)_compileCallFunctionIfx, "\t");
                continue;
            }
            boolean _or_1 = false;
            boolean _isCallQuery = Utils.isCallQuery(m);
            _or_1 = _isCallQuery ? true : (_isCallQueryFunction = Utils.isCallQueryFunction(m));
            if (_or_1) {
                boolean _isCallQueryFunction_1 = Utils.isCallQueryFunction(m);
                CharSequence _compileCallQueryIfx = this.compileCallQueryIfx(d, m, im, _isCallQueryFunction_1, true);
                _builder.append((Object)_compileCallQueryIfx, "\t");
                continue;
            }
            boolean _isCallSelectFunction = Utils.isCallSelectFunction(m);
            if (!_isCallSelectFunction) continue;
            CharSequence _compileCallSelectFunctionIfx = this.compileCallSelectFunctionIfx(d, m, im, true);
            _builder.append((Object)_compileCallSelectFunctionIfx, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileCallQueryIfx(PojoDao d, PojoMethod m, ImportManager im, boolean isFunction, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type = m.getType();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_type, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)" ");
        String _name = m.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args = m.getArgs();
        boolean _hasElements = false;
        for (PojoMethodArg ma : _args) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_1 = ma.getType();
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(_type_1, im);
            _builder.append((Object)_compileType_1, "\t");
            _builder.append((Object)" ");
            String _name_1 = ma.getName();
            _builder.append((Object)_name_1, "\t");
        }
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_2 = m.getType();
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_type_2, im);
            _builder.append((Object)_compileType_2, "\t");
            _builder.append((Object)" ");
            String _name_2 = m.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_1 = m.getArgs();
            boolean _hasElements_1 = false;
            for (PojoMethodArg ma_1 : _args_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_3 = ma_1.getType();
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_type_3, im);
                _builder.append((Object)_compileType_3, "\t");
                _builder.append((Object)" ");
                String _name_3 = ma_1.getName();
                _builder.append((Object)_name_3, "\t");
            }
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type_4 = m.getType();
        CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_type_4, im);
        _builder.append((Object)_compileType_4, "\t");
        _builder.append((Object)" ");
        String _name_4 = m.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args_2 = m.getArgs();
        boolean _hasElements_2 = false;
        for (PojoMethodArg ma_2 : _args_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_5 = ma_2.getType();
            CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(_type_5, im);
            _builder.append((Object)_compileType_5, "\t");
            _builder.append((Object)" ");
            String _name_5 = ma_2.getName();
            _builder.append((Object)_name_5, "\t");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_6 = m.getType();
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_type_6, im);
            _builder.append((Object)_compileType_6, "\t");
            _builder.append((Object)" ");
            String _name_6 = m.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_3 = m.getArgs();
            boolean _hasElements_3 = false;
            for (PojoMethodArg ma_3 : _args_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_7 = ma_3.getType();
                CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(_type_7, im);
                _builder.append((Object)_compileType_7, "\t");
                _builder.append((Object)" ");
                String _name_7 = ma_3.getName();
                _builder.append((Object)_name_7, "\t");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileCallFunctionIfx(PojoDao d, PojoMethod m, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type = m.getType();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_type, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)" ");
        String _name = m.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args = m.getArgs();
        boolean _hasElements = false;
        for (PojoMethodArg ma : _args) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_1 = ma.getType();
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(_type_1, im);
            _builder.append((Object)_compileType_1, "\t");
            _builder.append((Object)" ");
            String _name_1 = ma.getName();
            _builder.append((Object)_name_1, "\t");
        }
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_2 = m.getType();
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_type_2, im);
            _builder.append((Object)_compileType_2, "\t");
            _builder.append((Object)" ");
            String _name_2 = m.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_1 = m.getArgs();
            boolean _hasElements_1 = false;
            for (PojoMethodArg ma_1 : _args_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_3 = ma_1.getType();
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_type_3, im);
                _builder.append((Object)_compileType_3, "\t");
                _builder.append((Object)" ");
                String _name_3 = ma_1.getName();
                _builder.append((Object)_name_3, "\t");
            }
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type_4 = m.getType();
        CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_type_4, im);
        _builder.append((Object)_compileType_4, "\t");
        _builder.append((Object)" ");
        String _name_4 = m.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args_2 = m.getArgs();
        boolean _hasElements_2 = false;
        for (PojoMethodArg ma_2 : _args_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_5 = ma_2.getType();
            CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(_type_5, im);
            _builder.append((Object)_compileType_5, "\t");
            _builder.append((Object)" ");
            String _name_5 = ma_2.getName();
            _builder.append((Object)_name_5, "\t");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_6 = m.getType();
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_type_6, im);
            _builder.append((Object)_compileType_6, "\t");
            _builder.append((Object)" ");
            String _name_6 = m.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_3 = m.getArgs();
            boolean _hasElements_3 = false;
            for (PojoMethodArg ma_3 : _args_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_7 = ma_3.getType();
                CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(_type_7, im);
                _builder.append((Object)_compileType_7, "\t");
                _builder.append((Object)" ");
                String _name_7 = ma_3.getName();
                _builder.append((Object)_name_7, "\t");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileCallUpdateIfx(PojoDao d, PojoMethod m, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int ");
        String _name = m.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args = m.getArgs();
        boolean _hasElements = false;
        for (PojoMethodArg ma : _args) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type = ma.getType();
            CharSequence _compileType = this._processorGeneratorUtils.compileType(_type, im);
            _builder.append((Object)_compileType, "\t");
            _builder.append((Object)" ");
            String _name_1 = ma.getName();
            _builder.append((Object)_name_1, "\t");
        }
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int ");
            String _name_2 = m.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_1 = m.getArgs();
            boolean _hasElements_1 = false;
            for (PojoMethodArg ma_1 : _args_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_1 = ma_1.getType();
                CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(_type_1, im);
                _builder.append((Object)_compileType_1, "\t");
                _builder.append((Object)" ");
                String _name_3 = ma_1.getName();
                _builder.append((Object)_name_3, "\t");
            }
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int ");
        String _name_4 = m.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args_2 = m.getArgs();
        boolean _hasElements_2 = false;
        for (PojoMethodArg ma_2 : _args_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_2 = ma_2.getType();
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_type_2, im);
            _builder.append((Object)_compileType_2, "\t");
            _builder.append((Object)" ");
            String _name_5 = ma_2.getName();
            _builder.append((Object)_name_5, "\t");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int ");
            String _name_6 = m.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_3 = m.getArgs();
            boolean _hasElements_3 = false;
            for (PojoMethodArg ma_3 : _args_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_3 = ma_3.getType();
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_type_3, im);
                _builder.append((Object)_compileType_3, "\t");
                _builder.append((Object)" ");
                String _name_7 = ma_3.getName();
                _builder.append((Object)_name_7, "\t");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileCallSelectFunctionIfx(PojoDao d, PojoMethod m, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type = m.getType();
        CharSequence _compileType = this._processorGeneratorUtils.compileType(_type, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)" ");
        String _name = m.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args = m.getArgs();
        boolean _hasElements = false;
        for (PojoMethodArg ma : _args) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_1 = ma.getType();
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(_type_1, im);
            _builder.append((Object)_compileType_1, "\t");
            _builder.append((Object)" ");
            String _name_1 = ma.getName();
            _builder.append((Object)_name_1, "\t");
        }
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_2 = m.getType();
            CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(_type_2, im);
            _builder.append((Object)_compileType_2, "\t");
            _builder.append((Object)" ");
            String _name_2 = m.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_1 = m.getArgs();
            boolean _hasElements_1 = false;
            for (PojoMethodArg ma_1 : _args_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_3 = ma_1.getType();
                CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(_type_3, im);
                _builder.append((Object)_compileType_3, "\t");
                _builder.append((Object)" ");
                String _name_3 = ma_1.getName();
                _builder.append((Object)_name_3, "\t");
            }
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        PojoType _type_4 = m.getType();
        CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_type_4, im);
        _builder.append((Object)_compileType_4, "\t");
        _builder.append((Object)" ");
        String _name_4 = m.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"(SqlSession sqlSession, ");
        EList<PojoMethodArg> _args_2 = m.getArgs();
        boolean _hasElements_2 = false;
        for (PojoMethodArg ma_2 : _args_2) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            PojoType _type_5 = ma_2.getType();
            CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(_type_5, im);
            _builder.append((Object)_compileType_5, "\t");
            _builder.append((Object)" ");
            String _name_5 = ma_2.getName();
            _builder.append((Object)_name_5, "\t");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            PojoType _type_6 = m.getType();
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_type_6, im);
            _builder.append((Object)_compileType_6, "\t");
            _builder.append((Object)" ");
            String _name_6 = m.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)"(");
            EList<PojoMethodArg> _args_3 = m.getArgs();
            boolean _hasElements_3 = false;
            for (PojoMethodArg ma_3 : _args_3) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoType _type_7 = ma_3.getType();
                CharSequence _compileType_7 = this._processorGeneratorUtils.compileType(_type_7, im);
                _builder.append((Object)_compileType_7, "\t");
                _builder.append((Object)" ");
                String _name_7 = ma_3.getName();
                _builder.append((Object)_name_7, "\t");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileInsertIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" insert(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_3 = e.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)" insert(");
            String _name_4 = e.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)" ");
            String _name_5 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_1, "\t");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)" insert(SqlSession sqlSession, ");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)" ");
        String _name_8 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_8);
        _builder.append((Object)_firstLower_2, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_9 = e.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)" insert(");
            String _name_10 = e.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)" ");
            String _name_11 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_11);
            _builder.append((Object)_firstLower_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileGetIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" get(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_3 = e.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)" get(");
            String _name_4 = e.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)" ");
            String _name_5 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_1, "\t");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public ");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)" get(SqlSession sqlSession, ");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "\t\t");
        _builder.append((Object)" ");
        String _name_8 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_8);
        _builder.append((Object)_firstLower_2, "\t\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_9 = e.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)" get(");
            String _name_10 = e.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)" ");
            String _name_11 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_11);
            _builder.append((Object)_firstLower_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileUpdateIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int update(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int update(");
            String _name_2 = e.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)" ");
            String _name_3 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
            _builder.append((Object)_firstLower_1, "\t");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int update(SqlSession sqlSession, ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" ");
        String _name_5 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int update(");
            String _name_6 = e.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)" ");
            String _name_7 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
            _builder.append((Object)_firstLower_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileDeleteIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int delete(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int delete(");
            String _name_2 = e.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)" ");
            String _name_3 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
            _builder.append((Object)_firstLower_1, "\t");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int delete(SqlSession sqlSession, ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" ");
        String _name_5 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int delete(");
            String _name_6 = e.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)" ");
            String _name_7 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
            _builder.append((Object)_firstLower_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileListIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"> list(SqlSession sqlSession, ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" ");
        String _name_2 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<");
            String _name_3 = e.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)"> list(");
            String _name_4 = e.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)" ");
            String _name_5 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_1, "\t");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)"> list(SqlSession sqlSession, ");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)" ");
        String _name_8 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_8);
        _builder.append((Object)_firstLower_2, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<");
            String _name_9 = e.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)"> list(");
            String _name_10 = e.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)" ");
            String _name_11 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_11);
            _builder.append((Object)_firstLower_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileCountIfx(PojoDao d, PojoEntity e, ImportManager im, boolean all) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int count(SqlSession sqlSession, ");
        String _name = e.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)" ");
        String _name_1 = e.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)", SqlControl sqlControl);");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int count(");
            String _name_2 = e.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)" ");
            String _name_3 = e.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
            _builder.append((Object)_firstLower_1, "\t");
            _builder.append((Object)", SqlControl sqlControl);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public int count(SqlSession sqlSession, ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" ");
        String _name_5 = e.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        if (all) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public int count(");
            String _name_6 = e.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)" ");
            String _name_7 = e.getName();
            String _firstLower_3 = StringExtensions.toFirstLower((String)_name_7);
            _builder.append((Object)_firstLower_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence compileExtends(PojoDao e, ImportManager im) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        PojoDao _superType = Utils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            _builder.append((Object)"extends ");
            PojoDao _superType_1 = Utils.getSuperType(e);
            PojoDao _superType_2 = Utils.getSuperType(e);
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)_superType_2);
            String _fullName = Utils.getFullName(e, _superType_1, _fullyQualifiedName, im);
            _builder.append((Object)_fullName, "");
            _builder.append((Object)" ");
        } else {
            boolean _notEquals_1;
            String _extends = this.getExtends(e);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_extends, (Object)"");
            if (_notEquals_1) {
                _builder.append((Object)"extends ");
                String _extends_1 = this.getExtends(e);
                _builder.append((Object)_extends_1, "");
                _builder.append((Object)" ");
            }
        }
        return _builder;
    }

    public CharSequence compileImplements(PojoDao d) {
        String _implPackage;
        boolean _notEquals_1;
        String _sernum;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _or = false;
        boolean _or_1 = false;
        boolean _isImplements = this.isImplements(d);
        _or_1 = _isImplements ? true : (_notEquals = !Objects.equal((Object)(_sernum = Utils.getSernum(d)), null));
        _or = _or_1 ? true : (_notEquals_1 = !Objects.equal((Object)(_implPackage = this.getImplPackage(d)), null));
        if (_or) {
            String _implPackage_1;
            boolean _notEquals_3;
            boolean _notEquals_2;
            _builder.append((Object)"implements ");
            ArrayList<Implements> _implements = this.getImplements(d);
            boolean _hasElements = false;
            for (Implements f : _implements) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _daoImplements = Utils.getDaoImplements(d, f);
                _builder.append((Object)_daoImplements, "");
            }
            String _sernum_1 = Utils.getSernum(d);
            boolean bl = _notEquals_2 = !Objects.equal((Object)_sernum_1, null);
            if (_notEquals_2) {
                boolean _isImplements_1 = this.isImplements(d);
                if (_isImplements_1) {
                    _builder.append((Object)", ");
                }
                _builder.append((Object)"Serializable");
            }
            boolean bl2 = _notEquals_3 = !Objects.equal((Object)(_implPackage_1 = this.getImplPackage(d)), null);
            if (_notEquals_3) {
                String _sernum_2;
                boolean _notEquals_4;
                boolean _or_2 = false;
                boolean _isImplements_2 = this.isImplements(d);
                _or_2 = _isImplements_2 ? true : (_notEquals_4 = !Objects.equal((Object)(_sernum_2 = Utils.getSernum(d)), null));
                if (_or_2) {
                    _builder.append((Object)", ");
                }
                String _name = d.getName();
                _builder.append((Object)_name, "");
            }
            _builder.append((Object)" ");
        }
        return _builder;
    }

    public void addImplements(PojoDao e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements impl : _filter) {
            JvmType _implements = impl.getImplements();
            im.addImportFor(_implements);
        }
    }

    public void addExtends(PojoDao e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            JvmType _extends = ext.getExtends();
            im.addImportFor(_extends);
        }
    }

    public boolean isExtends(PojoDao e) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            boolean _not;
            Extends ext = (Extends)iterator.next();
            EList<PojoDao> _onlyDaos = ext.getOnlyDaos();
            boolean _isEmpty = _onlyDaos.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                EList<PojoDao> _onlyDaos_1 = ext.getOnlyDaos();
                for (PojoDao ee : _onlyDaos_1) {
                    String _name_1;
                    String _name = ee.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                    if (!_equals) continue;
                    return true;
                }
                return false;
            }
            EList<PojoDao> _exceptDaos = ext.getExceptDaos();
            for (PojoDao ee_1 : _exceptDaos) {
                String _name_3;
                String _name_2 = ee_1.getName();
                boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
                if (!_equals_1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isExtends(PojoDao e, Extends ext) {
        boolean _not;
        EList<PojoDao> _onlyDaos = ext.getOnlyDaos();
        boolean _isEmpty = _onlyDaos.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<PojoDao> _onlyDaos_1 = ext.getOnlyDaos();
            for (PojoDao ee : _onlyDaos_1) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return true;
            }
            return false;
        }
        EList<PojoDao> _exceptDaos = ext.getExceptDaos();
        for (PojoDao ee_1 : _exceptDaos) {
            String _name_3;
            String _name_2 = ee_1.getName();
            boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
            if (!_equals_1) continue;
            return false;
        }
        return true;
    }

    public String getExtends(PojoDao e) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            boolean _isExtends = this.isExtends(e, ext);
            if (!_isExtends) continue;
            JvmType _extends = ext.getExtends();
            return _extends.getSimpleName();
        }
        return "";
    }

    public boolean isImplements(PojoDao e) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements ext : _filter) {
            boolean _not;
            EList<PojoDao> _exceptDaos = ext.getExceptDaos();
            for (PojoDao ee : _exceptDaos) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return false;
            }
            EList<PojoDao> _onlyDaos = ext.getOnlyDaos();
            boolean _isEmpty = _onlyDaos.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                EList<PojoDao> _onlyDaos_1 = ext.getOnlyDaos();
                for (PojoDao ee_1 : _onlyDaos_1) {
                    String _name_3;
                    String _name_2 = ee_1.getName();
                    boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
                    if (!_equals_1) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean isImplements(PojoDao e, Implements ext) {
        boolean _not;
        EList<PojoDao> _onlyDaos = ext.getOnlyDaos();
        boolean _isEmpty = _onlyDaos.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<PojoDao> _onlyDaos_1 = ext.getOnlyDaos();
            for (PojoDao ee : _onlyDaos_1) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return true;
            }
            return false;
        }
        EList<PojoDao> _exceptDaos = ext.getExceptDaos();
        for (PojoDao ee_1 : _exceptDaos) {
            String _name_3;
            String _name_2 = ee_1.getName();
            boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
            if (!_equals_1) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Implements> getImplements(PojoDao e) {
        ArrayList<Implements> list = new ArrayList<Implements>();
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements ext : _filter) {
            boolean _isImplements = this.isImplements(e, ext);
            if (!_isImplements) continue;
            list.add(ext);
        }
        return list;
    }

    public String getImplPackage(PojoDao e) {
        EObject _eContainer = e.eContainer();
        EList _eContents = _eContainer.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, ImplPackage.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            ImplPackage ext = (ImplPackage)iterator.next();
            return ext.getName();
        }
        return null;
    }
}

