/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.generator;

import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.sqlproc.dsl.ProcessorDslStandaloneSetup;
import org.sqlproc.dsl.generator.IGenerator2;
import org.sqlproc.dsl.generator.TableDaoGenerator;
import org.sqlproc.dsl.generator.TableMetaGenerator;
import org.sqlproc.dsl.generator.TablePojoGenerator;
import org.sqlproc.dsl.processorDsl.AbstractPojoEntity;
import org.sqlproc.dsl.processorDsl.AnnotatedEntity;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.Entity;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.PackageDeclaration;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.property.ModelPropertyBean;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.DbResolverBean;
import org.sqlproc.dsl.util.Annotations;
import org.sqlproc.dsl.util.Utils;

public class Main {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    @Inject
    private IGenerator2 generator;
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    IScopeProvider scopeProvider;

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String models = null;
        String target = null;
        String source = null;
        String control = null;
        String pojo = null;
        String dao = null;
        String sql = null;
        String ddl = null;
        boolean merge = true;
        boolean generate = true;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if ("-models".equals(arg) && i < args.length - 1) {
                models = args[++i];
            } else if ("-target".equals(arg) && i < args.length - 1) {
                target = args[++i];
            } else if ("-source".equals(arg) && i < args.length - 1) {
                source = args[++i];
            } else if ("-control".equals(arg) && i < args.length - 1) {
                control = args[++i];
            } else if ("-pojo".equals(arg) && i < args.length - 1) {
                pojo = args[++i];
            } else if ("-dao".equals(arg) && i < args.length - 1) {
                dao = args[++i];
            } else if ("-sql".equals(arg) && i < args.length - 1) {
                sql = args[++i];
            } else if ("-ddl".equals(arg) && i < args.length - 1) {
                ddl = args[++i];
            } else if ("-nomerge".equals(arg)) {
                merge = false;
            } else if ("-verify".equals(arg)) {
                generate = false;
            } else {
                Main.usage(arg);
                return;
            }
            ++i;
        }
        if (models == null && (control == null || pojo == null || dao == null || sql == null)) {
            Main.usage(null);
            return;
        }
        Injector injector = new ProcessorDslStandaloneSetup().createInjectorAndDoEMFRegistration();
        Main main = (Main)injector.getInstance(Main.class);
        if (target == null) {
            target = models != null ? "src-gen/" : "./";
        } else if (!target.endsWith("/")) {
            target = String.valueOf(target) + "/";
        }
        if (source == null) {
            source = "";
        } else if (!source.endsWith("/")) {
            source = String.valueOf(source) + "/";
        }
        if (models != null) {
            main.runGenerator(models, source, target, generate);
        } else if (control != null) {
            main.runGenerator(control, pojo, dao, sql, ddl, source, target, merge);
        }
    }

    private static void usage(String arg) {
        System.out.println();
        if (arg != null) {
            System.out.println("Incorrect argument '" + arg + "'. Two modes are supported.");
        } else {
            System.out.println("Incorrect usage. Two modes are supported.");
        }
        System.out.println("Mode 1: POJO & DAO Java source files generation using model files:");
        System.out.println("  java -jar sqlep.jar -models modelsFile1,modelsFile2... [-source sourceDir] [-target targetDir] [-verify]");
        System.out.println("For example:");
        System.out.println("  java -jar sqlep.jar -models pojo.qry,dao.qry -target src-gen");
        System.out.println("Mode 2: POJO, DAO and META SQL models generation using control directives:");
        System.out.println("  java -jar sqlep.jar -control controlDirectivesFile -pojo pojoModelsFile -dao daoModelsFile -sql metaSqlsFile [-ddl ddlsFile] [-source sourceDir] [-target targetDir] [-nomerge]");
        System.out.println("For example:");
        System.out.println("  java -jar sqlep.jar -control definitions.qry -pojo pojo.qry -dao dao.qry -sql statements.qry");
        System.out.println();
        System.out.println("Arguments:");
        System.out.println("  -models filename[.filename] - comma separated list of model files names (eg. pojo.qry,dao.qry)");
        System.out.println("  -target dirname - a target directory (eg. src-gen)");
        System.out.println("  -source dirname - a source directory (eg. src/main/resources)");
        System.out.println("  -control filename - a control directives file name");
        System.out.println("  -pojo filename - a POJO models file name");
        System.out.println("  -dao filename - a DAO models file name");
        System.out.println("  -sql filename - a META SQLs file name");
        System.out.println("  -ddl filename - a DDLs file name");
        System.out.println("  -nomerge - do not merge generated artefacts with existing ones");
        System.out.println("  -verify - do not generate Java source files, only verify models files");
        System.out.println();
    }

    protected void runGenerator(String models, String source, String target, boolean generate) throws IOException, ClassNotFoundException {
        String[] sResources = models.split(",");
        ResourceSet set = (ResourceSet)this.resourceSetProvider.get();
        ArrayList<Resource> set2 = new ArrayList<Resource>();
        String[] stringArray = sResources;
        int n = sResources.length;
        int n2 = 0;
        while (n2 < n) {
            String sResource = stringArray[n2];
            Resource resource = set.getResource(URI.createURI((String)this.getFile(source, sResource)), true);
            set.getResources().add((Object)resource);
            set2.add(resource);
            ++n2;
        }
        for (Resource resource : set2) {
            if (this.isValid(resource)) continue;
            return;
        }
        System.out.println("Resource(s) validation finished.");
        if (generate) {
            this.fileAccess.setOutputPath(target);
            this.generator.doGenerate(set, (IFileSystemAccess)this.fileAccess);
            System.out.println("Java code generation finished.");
        }
    }

    protected void runGenerator(String control, String pojo, String dao, String sql, String ddl, String source, String target, boolean merge) throws IOException, ClassNotFoundException {
        ResourceSet set = (ResourceSet)this.resourceSetProvider.get();
        Resource controlResource = set.getResource(URI.createURI((String)this.getFile(source, control)), true);
        set.getResources().add((Object)controlResource);
        Resource pojoResource = null;
        File pojoFile = new File(URI.createURI((String)this.getFile(source, pojo)).toFileString());
        if (pojoFile.canRead()) {
            pojoResource = set.getResource(URI.createURI((String)this.getFile(source, pojo)), true);
            set.getResources().add((Object)pojoResource);
        }
        Resource daoResource = null;
        File daoFile = new File(URI.createURI((String)this.getFile(source, dao)).toFileString());
        if (daoFile.canRead()) {
            daoResource = set.getResource(URI.createURI((String)this.getFile(source, dao)), true);
            set.getResources().add((Object)daoResource);
        }
        Resource sqlResource = null;
        File sqlFile = new File(URI.createURI((String)this.getFile(source, sql)).toFileString());
        if (sqlFile.canRead()) {
            sqlResource = set.getResource(URI.createURI((String)this.getFile(source, sql)), true);
            set.getResources().add((Object)sqlResource);
        }
        if (!this.isValid(controlResource) || merge && pojoResource != null && !this.isValid(pojoResource) || merge && daoResource != null && !this.isValid(daoResource) || merge && sqlResource != null && !this.isValid(sqlResource)) {
            return;
        }
        System.out.println("Resource(s) validation finished.");
        Artifacts definitions = (Artifacts)controlResource.getContents().get(0);
        if (definitions.getProperties().isEmpty()) {
            System.err.println("No control directive.");
            return;
        }
        this.fileAccess.setOutputPath(target);
        ModelPropertyBean.ModelValues modelValues = ModelPropertyBean.loadModel(null, definitions);
        modelValues.doResolveDb = true;
        ModelPropertyBean modelProperty = new ModelPropertyBean(modelValues);
        String sDbDriver = modelProperty.getModelValues(null).dbDriver;
        Class<?> driverClass = this.getClass().getClassLoader().loadClass(sDbDriver);
        String dbSqlsBefore = null;
        if (ddl != null) {
            File file = new File(this.getFile(source, ddl));
            dbSqlsBefore = new String(Files.toByteArray((File)file));
        }
        DbResolverBean dbResolver = new DbResolverBean(modelProperty, driverClass, dbSqlsBefore, null);
        Artifacts pojos = null;
        PackageDeclaration pojoPackage = null;
        String pojoPackageName = null;
        if (!merge) {
            pojoPackageName = modelProperty.getPackage(null);
        } else if (pojoResource != null) {
            pojos = (Artifacts)pojoResource.getContents().get(0);
            if (!pojos.getPojoPackages().isEmpty()) {
                pojoPackage = (PackageDeclaration)pojos.getPojoPackages().get(0);
                pojoPackageName = pojoPackage.getName();
            }
        } else {
            pojoPackageName = modelProperty.getPackage(null);
        }
        if (pojoPackage == null && pojoPackageName == null) {
            System.err.println("Missing POJO package.");
            return;
        }
        Artifacts daos = null;
        PackageDeclaration daoPackage = null;
        String daoPackageName = null;
        if (!merge) {
            daoPackageName = modelProperty.getDaoPackage(null);
        } else if (daoResource != null) {
            daos = (Artifacts)daoResource.getContents().get(0);
            if (!daos.getPojoPackages().isEmpty()) {
                daoPackage = (PackageDeclaration)daos.getPojoPackages().get(0);
                daoPackageName = daoPackage.getName();
            }
        } else {
            daoPackageName = modelProperty.getDaoPackage(null);
        }
        if (daoPackage == null && daoPackageName == null) {
            System.err.println("Missing DAO package.");
            return;
        }
        Artifacts sqls = null;
        ArrayList<MetaStatement> statements = null;
        if (!merge) {
            statements = new ArrayList<MetaStatement>();
        } else if (sqlResource != null) {
            sqls = (Artifacts)sqlResource.getContents().get(0);
            statements = sqls.getStatements();
        }
        String pojoDefinitions = this.getPojoDefinitions(modelProperty, dbResolver, definitions, pojoPackage, ((XtextResource)controlResource).getSerializer());
        this.fileAccess.generateFile(pojo, (CharSequence)("package " + pojoPackageName + " {\n" + pojoDefinitions + "}"));
        System.out.println(String.valueOf(pojo) + " generation finished.");
        String daoDefinitions = this.getDaoDefinitions(modelProperty, dbResolver, definitions, daoPackage, ((XtextResource)controlResource).getSerializer());
        this.fileAccess.generateFile(dao, (CharSequence)("package " + daoPackageName + " {\n" + daoDefinitions + "}"));
        System.out.println(String.valueOf(dao) + " generation finished.");
        String metaDefinitions = this.getMetaDefinitions(modelProperty, dbResolver, definitions, statements, ((XtextResource)controlResource).getSerializer());
        this.fileAccess.generateFile(sql, (CharSequence)metaDefinitions);
        System.out.println(String.valueOf(sql) + " generation finished.");
    }

    protected String getFile(String source, String file) {
        if (file.startsWith("/")) {
            return file;
        }
        return String.valueOf(source) + file;
    }

    protected boolean isValid(Resource resource) throws IOException {
        resource.load(null);
        List list = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        if (!list.isEmpty()) {
            for (Issue issue : list) {
                System.err.println(issue);
            }
            return false;
        }
        return true;
    }

    protected String getPojoDefinitions(ModelPropertyBean modelProperty, DbResolver dbResolver, Artifacts artifacts, PackageDeclaration packagex, ISerializer serializer) {
        if (artifacts != null && dbResolver.isResolveDb(artifacts)) {
            DbResolver.DbType dbType;
            List<String> dbSequences;
            TablePojoGenerator generator;
            HashMap<String, String> finalEntities = new HashMap<String, String>();
            Annotations annotations = new Annotations();
            String suffix = null;
            if (packagex != null) {
                suffix = packagex.getSuffix();
                for (AbstractPojoEntity ape : packagex.getElements()) {
                    Entity pojo;
                    if (!(ape instanceof AnnotatedEntity)) continue;
                    AnnotatedEntity apojo = (AnnotatedEntity)ape;
                    if (apojo.getEntity() != null && apojo.getEntity() instanceof PojoEntity) {
                        pojo = (PojoEntity)apojo.getEntity();
                        Annotations.grabAnnotations(apojo, (PojoEntity)pojo, annotations);
                        if (!Utils.isFinal((PojoEntity)pojo)) continue;
                        finalEntities.put(pojo.getName(), serializer.serialize((EObject)pojo));
                        continue;
                    }
                    if (apojo.getEntity() == null || !(apojo.getEntity() instanceof EnumEntity) || !Utils.isFinal((EnumEntity)(pojo = (EnumEntity)apojo.getEntity()))) continue;
                    finalEntities.put(pojo.getName(), serializer.serialize((EObject)pojo));
                }
            }
            if (TablePojoGenerator.addDefinitions(this.scopeProvider, dbResolver, generator = new TablePojoGenerator(modelProperty, artifacts, suffix, finalEntities, annotations, dbSequences = dbResolver.getSequences(artifacts), dbType = Utils.getDbType(dbResolver, artifacts)), artifacts)) {
                return generator.getPojoDefinitions(modelProperty, artifacts);
            }
        }
        return null;
    }

    protected String getDaoDefinitions(ModelPropertyBean modelProperty, DbResolver dbResolver, Artifacts artifacts, PackageDeclaration packagex, ISerializer serializer) {
        if (artifacts != null && dbResolver.isResolveDb(artifacts)) {
            DbResolver.DbType dbType;
            List<String> dbSequences;
            TableDaoGenerator generator;
            HashMap<String, String> finalDaos = new HashMap<String, String>();
            String suffix = null;
            if (packagex != null) {
                suffix = packagex.getSuffix();
                for (AbstractPojoEntity ape : packagex.getElements()) {
                    PojoDao dao;
                    if (!(ape instanceof PojoDao) || !Utils.isFinal(dao = (PojoDao)ape)) continue;
                    finalDaos.put(dao.getName(), serializer.serialize((EObject)dao));
                }
            }
            if (TablePojoGenerator.addDefinitions(this.scopeProvider, dbResolver, generator = new TableDaoGenerator((ModelProperty)modelProperty, artifacts, suffix, this.scopeProvider, finalDaos, dbSequences = dbResolver.getSequences(artifacts), dbType = Utils.getDbType(dbResolver, artifacts)), artifacts)) {
                return generator.getDaoDefinitions(modelProperty, artifacts);
            }
        }
        return null;
    }

    protected String getMetaDefinitions(ModelPropertyBean modelProperty, DbResolver dbResolver, Artifacts artifacts, List<MetaStatement> statements, ISerializer serializer) {
        if (artifacts != null && dbResolver.isResolveDb(artifacts)) {
            DbResolver.DbType dbType;
            HashMap<String, String> finalMetas = new HashMap<String, String>();
            for (MetaStatement meta : statements) {
                if (!Utils.isFinal(meta)) continue;
                finalMetas.put(meta.getName(), serializer.serialize((EObject)meta));
            }
            List<String> dbSequences = dbResolver.getSequences(artifacts);
            TableMetaGenerator generator = new TableMetaGenerator(modelProperty, artifacts, this.scopeProvider, finalMetas, dbSequences, dbType = Utils.getDbType(dbResolver, artifacts));
            if (TablePojoGenerator.addDefinitions(this.scopeProvider, dbResolver, generator, artifacts)) {
                return generator.getMetaDefinitions(modelProperty, artifacts);
            }
        }
        return null;
    }
}

