/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.sqlproc.dsl.processorDsl.AbstractPojoEntity;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.Column;
import org.sqlproc.dsl.processorDsl.Constant;
import org.sqlproc.dsl.processorDsl.DatabaseColumn;
import org.sqlproc.dsl.processorDsl.DatabaseTable;
import org.sqlproc.dsl.processorDsl.Entity;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.EnumProperty;
import org.sqlproc.dsl.processorDsl.FunctionDefinition;
import org.sqlproc.dsl.processorDsl.Identifier;
import org.sqlproc.dsl.processorDsl.MappingColumn;
import org.sqlproc.dsl.processorDsl.MappingRule;
import org.sqlproc.dsl.processorDsl.MetaSql;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.OptionalFeature;
import org.sqlproc.dsl.processorDsl.PackageDeclaration;
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoDefinition;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.processorDsl.ProcedureDefinition;
import org.sqlproc.dsl.processorDsl.ProcessorDslPackage;
import org.sqlproc.dsl.processorDsl.Property;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.PojoResolver;
import org.sqlproc.dsl.resolver.PojoResolverFactory;
import org.sqlproc.dsl.util.Utils;
import org.sqlproc.dsl.validation.AbstractProcessorDslValidator;
import org.sqlproc.dsl.validation.ValidationResult;

public class ProcessorDslValidator
extends AbstractProcessorDslValidator {
    @Inject
    private PojoResolverFactory pojoResolverFactory;
    @Inject
    private DbResolver dbResolver;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private ModelProperty modelProperty;
    private final ArrayList<String> F_TYPES = CollectionLiterals.newArrayList((Object[])new String[]{"set", "update", "values", "where", "columns", "set=opt", "where=opt"});

    @Check
    public void checkMetaSqlFtype(MetaSql metaSql) {
        boolean _not;
        String _ftype = metaSql.getFtype();
        boolean _equals = Objects.equal((Object)_ftype, null);
        if (_equals) {
            return;
        }
        String _ftype_1 = metaSql.getFtype();
        boolean _findInListIgnoreCase = this.findInListIgnoreCase(this.F_TYPES, _ftype_1);
        boolean bl = _not = !_findInListIgnoreCase;
        if (_not) {
            String _ftype_2 = metaSql.getFtype();
            String _plus = "Invalid ftype : " + _ftype_2;
            this.error(_plus, (EStructuralFeature)ProcessorDslPackage.Literals.META_SQL__FTYPE);
        }
    }

    public boolean findInListIgnoreCase(List<String> list, String value) {
        boolean _equals = Objects.equal(list, null);
        if (_equals) {
            return false;
        }
        for (String item : list) {
            boolean _equalsIgnoreCase = item.equalsIgnoreCase(value);
            if (!_equalsIgnoreCase) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkUniqueMetaStatement(MetaStatement metaStatement) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)metaStatement);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)metaStatement);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<MetaStatement> _statements = artifacts.getStatements();
        for (MetaStatement metaStmt : _statements) {
            boolean _equalsStatement;
            boolean _tripleNotEquals;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)metaStmt, null);
            _and = !_notEquals ? false : (_tripleNotEquals = metaStmt != metaStatement);
            if (!_and || !(_equalsStatement = this.equalsStatement(metaStatement, metaStmt))) continue;
            String _name = metaStatement.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _type = metaStatement.getType();
            String _plus_2 = String.valueOf(_plus_1) + _type;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorDslPackage.Literals.META_STATEMENT__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueMappingRule(MappingRule mappingRule) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)mappingRule);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)mappingRule);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<MappingRule> _mappings = artifacts.getMappings();
        for (MappingRule rule : _mappings) {
            boolean _equalsRule;
            boolean _tripleNotEquals;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)rule, null);
            _and = !_notEquals ? false : (_tripleNotEquals = rule != mappingRule);
            if (!_and || !(_equalsRule = this.equalsRule(mappingRule, rule))) continue;
            String _name = mappingRule.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _type = mappingRule.getType();
            String _plus_2 = String.valueOf(_plus_1) + _type;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorDslPackage.Literals.MAPPING_RULE__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueOptionalFeature(OptionalFeature optionalFeature) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)optionalFeature);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)optionalFeature);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<OptionalFeature> _features = artifacts.getFeatures();
        for (OptionalFeature feature : _features) {
            boolean _equalsFeature;
            boolean _notEquals_1;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)feature, null);
            _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)feature, (Object)optionalFeature));
            if (!_and || !(_equalsFeature = this.equalsFeature(optionalFeature, feature))) continue;
            String _name = optionalFeature.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _type = optionalFeature.getType();
            String _plus_2 = String.valueOf(_plus_1) + _type;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorDslPackage.Literals.OPTIONAL_FEATURE__NAME);
            return;
        }
    }

    @Check
    public void checkUniquePojoDefinition(PojoDefinition pojoDefinition) {
        EObject _rootContainer;
        String _class;
        boolean _checkClass;
        boolean _not;
        boolean _and = false;
        boolean _isResolvePojo = this.isResolvePojo(pojoDefinition);
        _and = !_isResolvePojo ? false : (_not = !(_checkClass = this.checkClass(_class = this.getClass(pojoDefinition))));
        if (_and) {
            String _class_1 = this.getClass(pojoDefinition);
            String _plus = "Class name : " + _class_1;
            String _plus_1 = String.valueOf(_plus) + " not exists";
            this.error(_plus_1, (EStructuralFeature)ProcessorDslPackage.Literals.POJO_DEFINITION__NAME);
        }
        if (!((_rootContainer = EcoreUtil.getRootContainer((EObject)pojoDefinition)) instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)pojoDefinition);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<PojoDefinition> _pojos = artifacts.getPojos();
        for (PojoDefinition definition : _pojos) {
            String _name_1;
            String _name;
            boolean _equals;
            boolean _tripleNotEquals;
            boolean _notEquals;
            boolean _and_1 = false;
            boolean bl = _notEquals = !Objects.equal((Object)definition, null);
            _and_1 = !_notEquals ? false : (_tripleNotEquals = definition != pojoDefinition);
            if (!_and_1 || !(_equals = (_name = pojoDefinition.getName()).equals(_name_1 = definition.getName()))) continue;
            String _name_2 = pojoDefinition.getName();
            String _plus_2 = "Duplicate name : " + _name_2;
            this.error(_plus_2, (EStructuralFeature)ProcessorDslPackage.Literals.POJO_DEFINITION__NAME);
            return;
        }
    }

    public boolean equalsStatement(MetaStatement statement1, MetaStatement statement2) {
        String _name_3;
        boolean _equals_1;
        boolean _and = false;
        boolean _equals = Objects.equal((Object)statement1, null);
        _and = !_equals ? false : (_equals_1 = Objects.equal((Object)statement2, null));
        if (_and) {
            return true;
        }
        boolean _or = false;
        boolean _equals_2 = Objects.equal((Object)statement1, null);
        if (_equals_2) {
            _or = true;
        } else {
            boolean _equals_3;
            String _name = statement1.getName();
            _or = _equals_3 = Objects.equal((Object)_name, null);
        }
        if (_or) {
            return false;
        }
        boolean _or_1 = false;
        boolean _equals_4 = Objects.equal((Object)statement2, null);
        if (_equals_4) {
            _or_1 = true;
        } else {
            boolean _equals_5;
            String _name_1 = statement2.getName();
            _or_1 = _equals_5 = Objects.equal((Object)_name_1, null);
        }
        if (_or_1) {
            return false;
        }
        boolean _and_1 = false;
        String _name_2 = statement1.getName();
        boolean _equals_6 = _name_2.equals(_name_3 = statement2.getName());
        if (!_equals_6) {
            _and_1 = false;
        } else {
            boolean _equals_7;
            String _type = statement1.getType();
            String _type_1 = statement2.getType();
            _and_1 = _equals_7 = _type.equals(_type_1);
        }
        if (_and_1) {
            EList<String> _modifiers = statement1.getModifiers();
            EList<String> _modifiers_1 = statement2.getModifiers();
            return this.equalsModifiers((List<String>)_modifiers, (List<String>)_modifiers_1);
        }
        return false;
    }

    public boolean equalsRule(MappingRule rule1, MappingRule rule2) {
        String _name_3;
        boolean _equals_1;
        boolean _and = false;
        boolean _equals = Objects.equal((Object)rule1, null);
        _and = !_equals ? false : (_equals_1 = Objects.equal((Object)rule2, null));
        if (_and) {
            return true;
        }
        boolean _or = false;
        boolean _equals_2 = Objects.equal((Object)rule1, null);
        if (_equals_2) {
            _or = true;
        } else {
            boolean _equals_3;
            String _name = rule1.getName();
            _or = _equals_3 = Objects.equal((Object)_name, null);
        }
        if (_or) {
            return false;
        }
        boolean _or_1 = false;
        boolean _equals_4 = Objects.equal((Object)rule2, null);
        if (_equals_4) {
            _or_1 = true;
        } else {
            boolean _equals_5;
            String _name_1 = rule2.getName();
            _or_1 = _equals_5 = Objects.equal((Object)_name_1, null);
        }
        if (_or_1) {
            return false;
        }
        boolean _and_1 = false;
        String _name_2 = rule1.getName();
        boolean _equals_6 = _name_2.equals(_name_3 = rule2.getName());
        if (!_equals_6) {
            _and_1 = false;
        } else {
            boolean _equals_7;
            String _type = rule1.getType();
            String _type_1 = rule2.getType();
            _and_1 = _equals_7 = _type.equals(_type_1);
        }
        if (_and_1) {
            EList<String> _modifiers = rule1.getModifiers();
            EList<String> _modifiers_1 = rule2.getModifiers();
            return this.equalsModifiers((List<String>)_modifiers, (List<String>)_modifiers_1);
        }
        return false;
    }

    public boolean equalsFeature(OptionalFeature feature1, OptionalFeature feature2) {
        String _name_3;
        boolean _equals_1;
        boolean _and = false;
        boolean _equals = Objects.equal((Object)feature1, null);
        _and = !_equals ? false : (_equals_1 = Objects.equal((Object)feature2, null));
        if (_and) {
            return true;
        }
        boolean _or = false;
        boolean _equals_2 = Objects.equal((Object)feature1, null);
        if (_equals_2) {
            _or = true;
        } else {
            boolean _equals_3;
            String _name = feature1.getName();
            _or = _equals_3 = Objects.equal((Object)_name, null);
        }
        if (_or) {
            return false;
        }
        boolean _or_1 = false;
        boolean _equals_4 = Objects.equal((Object)feature2, null);
        if (_equals_4) {
            _or_1 = true;
        } else {
            boolean _equals_5;
            String _name_1 = feature2.getName();
            _or_1 = _equals_5 = Objects.equal((Object)_name_1, null);
        }
        if (_or_1) {
            return false;
        }
        boolean _and_1 = false;
        String _name_2 = feature1.getName();
        boolean _equals_6 = _name_2.equals(_name_3 = feature2.getName());
        if (!_equals_6) {
            _and_1 = false;
        } else {
            boolean _equals_7;
            String _type = feature1.getType();
            String _type_1 = feature2.getType();
            _and_1 = _equals_7 = _type.equals(_type_1);
        }
        if (_and_1) {
            EList<String> _modifiers = feature1.getModifiers();
            EList<String> _modifiers_1 = feature2.getModifiers();
            return this.equalsModifiers((List<String>)_modifiers, (List<String>)_modifiers_1);
        }
        return false;
    }

    public boolean equalsModifiers(List<String> modifiers1, List<String> modifiers2) {
        boolean _isEmpty_1;
        boolean _equals_1;
        List<String> filteredModifiers1 = this.filteredModifiers(modifiers1);
        List<String> filteredModifiers2 = this.filteredModifiers(modifiers2);
        boolean _and = false;
        boolean _equals = Objects.equal(filteredModifiers1, null);
        _and = !_equals ? false : (_equals_1 = Objects.equal(filteredModifiers2, null));
        if (_and) {
            return true;
        }
        boolean _equals_2 = Objects.equal(filteredModifiers1, null);
        if (_equals_2) {
            return false;
        }
        boolean _equals_3 = Objects.equal(filteredModifiers2, null);
        if (_equals_3) {
            return false;
        }
        boolean _and_1 = false;
        boolean _isEmpty = filteredModifiers1.isEmpty();
        _and_1 = !_isEmpty ? false : (_isEmpty_1 = filteredModifiers2.isEmpty());
        if (_and_1) {
            return true;
        }
        for (String modifier1 : filteredModifiers1) {
            for (String modifier2 : filteredModifiers2) {
                boolean _equals_4 = modifier1.equals(modifier2);
                if (!_equals_4) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> filteredModifiers(List<String> modifiers) {
        boolean _equals = Objects.equal(modifiers, null);
        if (_equals) {
            return null;
        }
        final ArrayList filteredModifiers = CollectionLiterals.newArrayList((Object[])new String[0]);
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String modifier) {
                boolean _lessThan;
                int _indexOf = modifier.indexOf("=");
                boolean bl = _lessThan = _indexOf < 0;
                if (_lessThan) {
                    filteredModifiers.add(modifier);
                }
            }
        };
        IterableExtensions.forEach(modifiers, (Procedures.Procedure1)_function);
        return filteredModifiers;
    }

    public boolean checkClass(String className) {
        boolean _or = false;
        boolean _equals = Objects.equal((Object)className, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _equals_1;
            PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
            _or = _equals_1 = Objects.equal((Object)_pojoResolver, null);
        }
        if (_or) {
            return true;
        }
        PojoResolver _pojoResolver_1 = this.pojoResolverFactory.getPojoResolver();
        Class<?> clazz = _pojoResolver_1.loadClass(className);
        return !Objects.equal(clazz, null);
    }

    public boolean isResolvePojo(EObject model) {
        PojoResolver _pojoResolver_1;
        boolean _isResolvePojo;
        boolean _not;
        boolean _or = false;
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean _equals = Objects.equal((Object)_pojoResolver, null);
        _or = _equals ? true : (_not = !(_isResolvePojo = (_pojoResolver_1 = this.pojoResolverFactory.getPojoResolver()).isResolvePojo(model)));
        return !_or;
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    public String getClass(PojoDefinition pojo) {
        boolean _notEquals;
        JvmType _classx = pojo.getClassx();
        boolean bl = _notEquals = !Objects.equal((Object)_classx, null);
        if (_notEquals) {
            JvmType _classx_1 = pojo.getClassx();
            return _classx_1.getQualifiedName();
        }
        return pojo.getClass_();
    }

    @Check
    public void checkColumn(Column column) {
        boolean _notEquals_5;
        String columnUsageClass;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        PojoEntity entity;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(column);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String columnName = Utils.getName(column);
        boolean _isNumber = Utils.isNumber(columnName);
        if (_isNumber) {
            return;
        }
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)column, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)statement, Artifacts.class);
        String entityName = Utils.getTokenFromModifier(statement, "outx");
        PojoEntity _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)entityName, null);
        if (_notEquals) {
            IScope _scope = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES);
            _xifexpression = Utils.findEntity(this.qualifiedNameConverter, artifacts, _scope, entityName);
        }
        boolean bl3 = _notEquals_1 = !Objects.equal(entity = _xifexpression, null);
        if (_notEquals_1) {
            ValidationResult _checkEntityProperty = this.checkEntityProperty(entity, columnName);
            if (_checkEntityProperty != null) {
                switch (_checkEntityProperty) {
                    case WARNING: {
                        String _name = entity.getName();
                        String _plus = "Problem property : " + columnName + "[" + _name;
                        String _plus_1 = String.valueOf(_plus) + "]";
                        this.warning(_plus_1, (EStructuralFeature)ProcessorDslPackage.Literals.COLUMN__COLUMNS);
                        break;
                    }
                    case ERROR: {
                        String _name_1 = entity.getName();
                        String _plus_2 = "Cannot find property : " + columnName + "[" + _name_1;
                        String _plus_3 = String.valueOf(_plus_2) + "]";
                        this.error(_plus_3, (EStructuralFeature)ProcessorDslPackage.Literals.COLUMN__COLUMNS);
                        break;
                    }
                }
            }
            return;
        }
        String pojoName = Utils.getTokenFromModifier(statement, "out");
        PojoDefinition _xifexpression_1 = null;
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)pojoName, null);
        if (_notEquals_2) {
            IScope _scope_1 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS);
            _xifexpression_1 = Utils.findPojo(this.qualifiedNameConverter, artifacts, _scope_1, pojoName);
        }
        PojoDefinition pojo = _xifexpression_1;
        String _xifexpression_2 = null;
        boolean bl5 = _notEquals_3 = !Objects.equal(pojo, null);
        if (_notEquals_3) {
            _xifexpression_2 = this.getClass(pojo);
        }
        boolean bl6 = _notEquals_4 = !Objects.equal((Object)(columnUsageClass = _xifexpression_2), null);
        if (_notEquals_4) {
            ValidationResult _checkClassProperty = this.checkClassProperty(columnUsageClass, columnName);
            if (_checkClassProperty != null) {
                switch (_checkClassProperty) {
                    case WARNING: {
                        this.warning("Problem property : " + columnName + "[" + columnUsageClass + "]", (EStructuralFeature)ProcessorDslPackage.Literals.COLUMN__COLUMNS);
                        break;
                    }
                    case ERROR: {
                        this.error("Cannot find property : " + columnName + "[" + columnUsageClass + "]", (EStructuralFeature)ProcessorDslPackage.Literals.COLUMN__COLUMNS);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl7 = _notEquals_5 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_5) {
            this.error("Cannot check result class attribute : " + columnName, (EStructuralFeature)ProcessorDslPackage.Literals.COLUMN__COLUMNS);
        }
    }

    @Check
    public void checkIdentifier(Identifier identifier) {
        boolean _notEquals_5;
        String identifierUsageClass;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        PojoEntity entity;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(identifier);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String identifierName = identifier.getName();
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)identifier, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)statement, Artifacts.class);
        String entityName = Utils.getTokenFromModifier(statement, "inx");
        PojoEntity _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)entityName, null);
        if (_notEquals) {
            IScope _scope = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES);
            _xifexpression = Utils.findEntity(this.qualifiedNameConverter, artifacts, _scope, entityName);
        }
        boolean bl3 = _notEquals_1 = !Objects.equal(entity = _xifexpression, null);
        if (_notEquals_1) {
            ValidationResult _checkEntityProperty = this.checkEntityProperty(entity, identifierName);
            if (_checkEntityProperty != null) {
                switch (_checkEntityProperty) {
                    case WARNING: {
                        String _name = entity.getName();
                        String _plus = "Problem property : " + identifierName + "[" + _name;
                        String _plus_1 = String.valueOf(_plus) + "]";
                        this.warning(_plus_1, (EStructuralFeature)ProcessorDslPackage.Literals.IDENTIFIER__NAME);
                        break;
                    }
                    case ERROR: {
                        String _name_1 = entity.getName();
                        String _plus_2 = "Cannot find property : " + identifierName + "[" + _name_1;
                        String _plus_3 = String.valueOf(_plus_2) + "]";
                        this.error(_plus_3, (EStructuralFeature)ProcessorDslPackage.Literals.IDENTIFIER__NAME);
                        break;
                    }
                }
            }
            return;
        }
        String pojoName = Utils.getTokenFromModifier(statement, "in");
        PojoDefinition _xifexpression_1 = null;
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)pojoName, null);
        if (_notEquals_2) {
            IScope _scope_1 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS);
            _xifexpression_1 = Utils.findPojo(this.qualifiedNameConverter, artifacts, _scope_1, pojoName);
        }
        PojoDefinition pojo = _xifexpression_1;
        String _xifexpression_2 = null;
        boolean bl5 = _notEquals_3 = !Objects.equal(pojo, null);
        if (_notEquals_3) {
            _xifexpression_2 = this.getClass(pojo);
        }
        boolean bl6 = _notEquals_4 = !Objects.equal((Object)(identifierUsageClass = _xifexpression_2), null);
        if (_notEquals_4) {
            ValidationResult _checkClassProperty = this.checkClassProperty(identifierUsageClass, identifierName);
            if (_checkClassProperty != null) {
                switch (_checkClassProperty) {
                    case WARNING: {
                        this.warning("Problem property : " + identifierName + "[" + identifierUsageClass + "]", (EStructuralFeature)ProcessorDslPackage.Literals.IDENTIFIER__NAME);
                        break;
                    }
                    case ERROR: {
                        this.error("Cannot find property : " + identifierName + "[" + identifierUsageClass + "]", (EStructuralFeature)ProcessorDslPackage.Literals.IDENTIFIER__NAME);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl7 = _notEquals_5 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_5) {
            this.error("Cannot check input form attribute : " + identifierName, (EStructuralFeature)ProcessorDslPackage.Literals.IDENTIFIER__NAME);
        }
    }

    @Check
    public void checkConstant(Constant constant) {
        boolean _notEquals_5;
        String constantUsageClass;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        PojoEntity entity;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(constant);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)constant, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)statement, Artifacts.class);
        String entityName = Utils.getTokenFromModifier(statement, "constx");
        PojoEntity _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)entityName, null);
        if (_notEquals) {
            IScope _scope = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES);
            _xifexpression = Utils.findEntity(this.qualifiedNameConverter, artifacts, _scope, entityName);
        }
        boolean bl3 = _notEquals_1 = !Objects.equal(entity = _xifexpression, null);
        if (_notEquals_1) {
            String _name = constant.getName();
            ValidationResult _checkEntityProperty = this.checkEntityProperty(entity, _name);
            if (_checkEntityProperty != null) {
                switch (_checkEntityProperty) {
                    case WARNING: {
                        String _name_1 = constant.getName();
                        String _plus = "Problem property : " + _name_1;
                        String _plus_1 = String.valueOf(_plus) + "[";
                        String _name_2 = entity.getName();
                        String _plus_2 = String.valueOf(_plus_1) + _name_2;
                        String _plus_3 = String.valueOf(_plus_2) + "]";
                        this.warning(_plus_3, (EStructuralFeature)ProcessorDslPackage.Literals.CONSTANT__NAME);
                        break;
                    }
                    case ERROR: {
                        String _name_3 = constant.getName();
                        String _plus_4 = "Cannot find property : " + _name_3;
                        String _plus_5 = String.valueOf(_plus_4) + "[";
                        String _name_4 = entity.getName();
                        String _plus_6 = String.valueOf(_plus_5) + _name_4;
                        String _plus_7 = String.valueOf(_plus_6) + "]";
                        this.error(_plus_7, (EStructuralFeature)ProcessorDslPackage.Literals.CONSTANT__NAME);
                        break;
                    }
                }
            }
            return;
        }
        String pojoName = Utils.getTokenFromModifier(statement, "const");
        PojoDefinition _xifexpression_1 = null;
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)pojoName, null);
        if (_notEquals_2) {
            IScope _scope_1 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS);
            _xifexpression_1 = Utils.findPojo(this.qualifiedNameConverter, artifacts, _scope_1, pojoName);
        }
        PojoDefinition pojo = _xifexpression_1;
        String _xifexpression_2 = null;
        boolean bl5 = _notEquals_3 = !Objects.equal(pojo, null);
        if (_notEquals_3) {
            _xifexpression_2 = this.getClass(pojo);
        }
        boolean bl6 = _notEquals_4 = !Objects.equal((Object)(constantUsageClass = _xifexpression_2), null);
        if (_notEquals_4) {
            String _name_5 = constant.getName();
            ValidationResult _checkClassProperty = this.checkClassProperty(constantUsageClass, _name_5);
            if (_checkClassProperty != null) {
                switch (_checkClassProperty) {
                    case WARNING: {
                        String _name_6 = constant.getName();
                        String _plus_8 = "Problem property : " + _name_6;
                        String _plus_9 = String.valueOf(_plus_8) + "[";
                        String _plus_10 = String.valueOf(_plus_9) + constantUsageClass;
                        String _plus_11 = String.valueOf(_plus_10) + "]";
                        this.warning(_plus_11, (EStructuralFeature)ProcessorDslPackage.Literals.CONSTANT__NAME);
                        break;
                    }
                    case ERROR: {
                        String _name_7 = constant.getName();
                        String _plus_12 = "Cannot find property : " + _name_7;
                        String _plus_13 = String.valueOf(_plus_12) + "[";
                        String _plus_14 = String.valueOf(_plus_13) + constantUsageClass;
                        String _plus_15 = String.valueOf(_plus_14) + "]";
                        this.error(_plus_15, (EStructuralFeature)ProcessorDslPackage.Literals.CONSTANT__NAME);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl7 = _notEquals_5 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_5) {
            String _name_8 = constant.getName();
            String _plus_16 = "Cannot check constant form attribute : " + _name_8;
            this.error(_plus_16, (EStructuralFeature)ProcessorDslPackage.Literals.CONSTANT__NAME);
        }
    }

    @Check
    public void checkMappingColumn(MappingColumn column) {
        boolean _notEquals_5;
        String mappingUsageClass;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        PojoEntity entity;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(column);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String columnName = Utils.getName(column);
        boolean _isNumber = Utils.isNumber(columnName);
        if (_isNumber) {
            return;
        }
        MetaStatement rule = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)column, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)rule, Artifacts.class);
        String entityName = Utils.getTokenFromModifier(rule, "outx");
        PojoEntity _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)entityName, null);
        if (_notEquals) {
            IScope _scope = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES);
            _xifexpression = Utils.findEntity(this.qualifiedNameConverter, artifacts, _scope, entityName);
        }
        boolean bl3 = _notEquals_1 = !Objects.equal(entity = _xifexpression, null);
        if (_notEquals_1) {
            ValidationResult _checkEntityProperty = this.checkEntityProperty(entity, columnName);
            if (_checkEntityProperty != null) {
                switch (_checkEntityProperty) {
                    case WARNING: {
                        String _name = entity.getName();
                        String _plus = "Problem property : " + columnName + "[" + _name;
                        String _plus_1 = String.valueOf(_plus) + "]";
                        this.warning(_plus_1, (EStructuralFeature)ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS);
                        break;
                    }
                    case ERROR: {
                        String _name_1 = entity.getName();
                        String _plus_2 = "Cannot find property : " + columnName + "[" + _name_1;
                        String _plus_3 = String.valueOf(_plus_2) + "]";
                        this.error(_plus_3, (EStructuralFeature)ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS);
                        break;
                    }
                }
            }
            return;
        }
        String pojoName = Utils.getTokenFromModifier(rule, "out");
        PojoDefinition _xifexpression_1 = null;
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)pojoName, null);
        if (_notEquals_2) {
            IScope _scope_1 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS);
            _xifexpression_1 = Utils.findPojo(this.qualifiedNameConverter, artifacts, _scope_1, pojoName);
        }
        PojoDefinition pojo = _xifexpression_1;
        String _xifexpression_2 = null;
        boolean bl5 = _notEquals_3 = !Objects.equal(pojo, null);
        if (_notEquals_3) {
            _xifexpression_2 = this.getClass(pojo);
        }
        boolean bl6 = _notEquals_4 = !Objects.equal((Object)(mappingUsageClass = _xifexpression_2), null);
        if (_notEquals_4) {
            ValidationResult _checkClassProperty = this.checkClassProperty(mappingUsageClass, columnName);
            if (_checkClassProperty != null) {
                switch (_checkClassProperty) {
                    case WARNING: {
                        this.warning("Problem property : " + columnName + "[" + mappingUsageClass + "]", (EStructuralFeature)ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS);
                        break;
                    }
                    case ERROR: {
                        this.error("Cannot find property : " + columnName + "[" + mappingUsageClass + "]", (EStructuralFeature)ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl7 = _notEquals_5 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_5) {
            this.error("Cannot check result class attribute : " + columnName, (EStructuralFeature)ProcessorDslPackage.Literals.MAPPING_COLUMN__ITEMS);
        }
    }

    @Check
    public void checkMetaStatement(MetaStatement statement) {
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)statement, Artifacts.class);
        boolean _or = false;
        EList<String> _modifiers = statement.getModifiers();
        boolean _equals = Objects.equal(_modifiers, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _isEmpty;
            EList<String> _modifiers_1 = statement.getModifiers();
            _or = _isEmpty = _modifiers_1.isEmpty();
        }
        if (_or) {
            return;
        }
        int index = 0;
        EList<String> _modifiers_2 = statement.getModifiers();
        for (String modifier : _modifiers_2) {
            int ix = modifier.indexOf("=");
            if (ix <= 0) continue;
            String key = modifier.substring(0, ix);
            String value = modifier.substring(ix + 1);
            boolean _equals_1 = "inx".equals(key);
            if (_equals_1) {
                IScope _scope = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES);
                PojoEntity entity = Utils.findEntity(this.qualifiedNameConverter, artifacts, _scope, value);
                boolean _equals_2 = Objects.equal((Object)entity, null);
                if (_equals_2) {
                    this.error("Cannot find entity : " + value + "[" + "inx" + "]", (EStructuralFeature)ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index);
                }
            } else {
                boolean _equals_3 = "in".equals(key);
                if (_equals_3) {
                    IScope _scope_1 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS);
                    PojoDefinition pojo = Utils.findPojo(this.qualifiedNameConverter, artifacts, _scope_1, value);
                    boolean _equals_4 = Objects.equal((Object)pojo, null);
                    if (_equals_4) {
                        this.error("Cannot find pojo : " + value + "[" + "in" + "]", (EStructuralFeature)ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index);
                    }
                } else {
                    boolean _equals_5 = "outx".equals(key);
                    if (_equals_5) {
                        IScope _scope_2 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES);
                        PojoEntity entity_1 = Utils.findEntity(this.qualifiedNameConverter, artifacts, _scope_2, value);
                        boolean _equals_6 = Objects.equal((Object)entity_1, null);
                        if (_equals_6) {
                            this.error("Cannot find entity : " + value + "[" + "outx" + "]", (EStructuralFeature)ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index);
                        }
                    } else {
                        boolean _equals_7 = "out".equals(key);
                        if (_equals_7) {
                            IScope _scope_3 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS);
                            PojoDefinition pojo_1 = Utils.findPojo(this.qualifiedNameConverter, artifacts, _scope_3, value);
                            boolean _equals_8 = Objects.equal((Object)pojo_1, null);
                            if (_equals_8) {
                                this.error("Cannot find pojo : " + value + "[" + "out" + "]", (EStructuralFeature)ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index);
                            }
                        } else {
                            boolean _equals_9 = "constx".equals(key);
                            if (_equals_9) {
                                IScope _scope_4 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES);
                                PojoEntity entity_2 = Utils.findEntity(this.qualifiedNameConverter, artifacts, _scope_4, value);
                                boolean _equals_10 = Objects.equal((Object)entity_2, null);
                                if (_equals_10) {
                                    this.error("Cannot find entity : " + value + "[" + "constx" + "]", (EStructuralFeature)ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index);
                                }
                            } else {
                                boolean _equals_11 = "const".equals(key);
                                if (_equals_11) {
                                    IScope _scope_5 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS);
                                    PojoDefinition pojo_2 = Utils.findPojo(this.qualifiedNameConverter, artifacts, _scope_5, value);
                                    boolean _equals_12 = Objects.equal((Object)pojo_2, null);
                                    if (_equals_12) {
                                        this.error("Cannot find pojo : " + value + "[" + "const" + "]", (EStructuralFeature)ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index);
                                    }
                                } else {
                                    boolean _equals_13 = "tab".equals(key);
                                    if (_equals_13) {
                                        IScope _scope_6;
                                        TableDefinition table;
                                        boolean _equals_14;
                                        int ix1 = value.indexOf("=");
                                        if (ix1 >= 0) {
                                            String _substring;
                                            value = _substring = value.substring(0, ix1);
                                        }
                                        if (_equals_14 = Objects.equal((Object)(table = Utils.findTable(this.qualifiedNameConverter, artifacts, _scope_6 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES), value)), null)) {
                                            this.error("Cannot find table : " + value + "[" + "tab" + "]", (EStructuralFeature)ProcessorDslPackage.Literals.META_STATEMENT__MODIFIERS, index);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++index;
        }
    }

    @Check
    public void checkMappingRule(MappingRule rule) {
        boolean _or = false;
        EList<String> _modifiers = rule.getModifiers();
        boolean _equals = Objects.equal(_modifiers, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _isEmpty;
            EList<String> _modifiers_1 = rule.getModifiers();
            _or = _isEmpty = _modifiers_1.isEmpty();
        }
        if (_or) {
            return;
        }
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)rule, Artifacts.class);
        int index = 0;
        EList<String> _modifiers_2 = rule.getModifiers();
        for (String modifier : _modifiers_2) {
            int ix = modifier.indexOf("=");
            if (ix <= 0) continue;
            String key = modifier.substring(0, ix);
            String value = modifier.substring(ix + 1);
            boolean _equals_1 = "outx".equals(key);
            if (_equals_1) {
                IScope _scope = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES);
                PojoEntity entity = Utils.findEntity(this.qualifiedNameConverter, artifacts, _scope, value);
                boolean _equals_2 = Objects.equal((Object)entity, null);
                if (_equals_2) {
                    this.error("Cannot find entity : " + value + "[" + "outx" + "]", (EStructuralFeature)ProcessorDslPackage.Literals.MAPPING_RULE__MODIFIERS, index);
                }
            } else {
                IScope _scope_1;
                PojoDefinition pojo;
                boolean _equals_4;
                boolean _equals_3 = "out".equals(key);
                if (_equals_3 && (_equals_4 = Objects.equal((Object)(pojo = Utils.findPojo(this.qualifiedNameConverter, artifacts, _scope_1 = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), value)), null))) {
                    this.error("Cannot find pojo : " + value + "[" + "out" + "]", (EStructuralFeature)ProcessorDslPackage.Literals.MAPPING_RULE__MODIFIERS, index);
                }
            }
            ++index;
        }
    }

    public boolean isNumber(String param) {
        boolean _equals = Objects.equal((Object)param, null);
        if (_equals) {
            return false;
        }
        int _length = param.length();
        int i = _length - 1;
        boolean _while = i >= 0;
        while (_while) {
            boolean _not;
            char _charAt = param.charAt(i);
            boolean _isDigit = Character.isDigit(_charAt);
            boolean bl = _not = !_isDigit;
            if (_not) {
                return false;
            }
            boolean bl2 = _while = --i >= 0;
        }
        return true;
    }

    public boolean isPrimitive(Class<?> clazz) {
        boolean _equals = Objects.equal(clazz, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal(clazz, String.class);
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal(clazz, java.util.Date.class);
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal(clazz, Date.class);
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal(clazz, Time.class);
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal(clazz, Timestamp.class);
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal(clazz, Blob.class);
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal(clazz, Clob.class);
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal(clazz, BigDecimal.class);
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal(clazz, BigInteger.class);
        return _equals_9;
    }

    public ValidationResult checkClassProperty(String className, String property) {
        boolean _notEquals_1;
        int pos2;
        boolean _isNumber;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _equals = Objects.equal((Object)property, null);
        _or_1 = _equals ? true : (_isNumber = this.isNumber(property));
        if (_or_1) {
            _or = true;
        } else {
            boolean _equals_1;
            PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
            _or = _equals_1 = Objects.equal((Object)_pojoResolver, null);
        }
        if (_or) {
            return ValidationResult.OK;
        }
        boolean _equals_2 = Objects.equal((Object)className, null);
        if (_equals_2) {
            return ValidationResult.ERROR;
        }
        PojoResolver _pojoResolver_1 = this.pojoResolverFactory.getPojoResolver();
        PropertyDescriptor[] descriptors = _pojoResolver_1.getPropertyDescriptors(className);
        boolean _equals_3 = Objects.equal((Object)descriptors, null);
        if (_equals_3) {
            return ValidationResult.WARNING;
        }
        String checkProperty = property;
        int pos1 = checkProperty.indexOf("=");
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(".", pos1)) > pos1) {
            String _plus;
            String _substring = checkProperty.substring(0, pos1);
            String _substring_1 = checkProperty.substring(pos2);
            checkProperty = _plus = String.valueOf(_substring) + _substring_1;
        }
        String innerProperty = null;
        int _indexOf = checkProperty.indexOf(".");
        pos1 = _indexOf;
        if (pos1 > 0) {
            String _substring_3;
            String _substring_2;
            innerProperty = _substring_2 = checkProperty.substring(pos1 + 1);
            checkProperty = _substring_3 = checkProperty.substring(0, pos1);
        }
        final String _checkProperty = checkProperty;
        PropertyDescriptor[] _converted_descriptors = descriptors;
        Functions.Function1<PropertyDescriptor, Boolean> _function = new Functions.Function1<PropertyDescriptor, Boolean>(){

            public Boolean apply(PropertyDescriptor descriptor) {
                String _name = descriptor.getName();
                return Objects.equal((Object)_name, (Object)_checkProperty);
            }
        };
        PropertyDescriptor innerDesriptor = (PropertyDescriptor)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_descriptors)), (Functions.Function1)_function);
        boolean _equals_4 = Objects.equal((Object)innerDesriptor, null);
        if (_equals_4) {
            boolean _notEquals;
            PojoResolver _pojoResolver_2 = this.pojoResolverFactory.getPojoResolver();
            Class<?> clazz = _pojoResolver_2.loadClass(className);
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal(clazz, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _isAbstract;
                int _modifiers = clazz.getModifiers();
                _and = _isAbstract = Modifier.isAbstract(_modifiers);
            }
            if (_and) {
                return ValidationResult.WARNING;
            }
            return ValidationResult.ERROR;
        }
        boolean bl = _notEquals_1 = !Objects.equal((Object)innerProperty, null);
        if (_notEquals_1) {
            Class innerClass = innerDesriptor.getPropertyType();
            boolean _isArray = innerClass.isArray();
            if (_isArray) {
                Type[] _actualTypeArguments_1;
                int _length;
                boolean _equals_6;
                Method _readMethod = innerDesriptor.getReadMethod();
                Type _genericReturnType = _readMethod.getGenericReturnType();
                ParameterizedType type = (ParameterizedType)_genericReturnType;
                boolean _or_2 = false;
                Type[] _actualTypeArguments = type.getActualTypeArguments();
                boolean _equals_5 = Objects.equal((Object)_actualTypeArguments, null);
                _or_2 = _equals_5 ? true : (_equals_6 = (_length = (_actualTypeArguments_1 = type.getActualTypeArguments()).length) == 0);
                if (_or_2) {
                    return ValidationResult.WARNING;
                }
                Type[] _actualTypeArguments_2 = type.getActualTypeArguments();
                Type _head = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_actualTypeArguments_2)));
                innerClass = (Class)_head;
                boolean _isPrimitive = this.isPrimitive(innerClass);
                if (_isPrimitive) {
                    return ValidationResult.ERROR;
                }
                String _name = innerClass.getName();
                return this.checkClassProperty(_name, innerProperty);
            }
            boolean _isAssignableFrom = Collection.class.isAssignableFrom(innerClass);
            if (_isAssignableFrom) {
                Type[] _actualTypeArguments_4;
                int _length_1;
                boolean _equals_8;
                Method _readMethod_1 = innerDesriptor.getReadMethod();
                Type _genericReturnType_1 = _readMethod_1.getGenericReturnType();
                ParameterizedType type_1 = (ParameterizedType)_genericReturnType_1;
                boolean _or_3 = false;
                Type[] _actualTypeArguments_3 = type_1.getActualTypeArguments();
                boolean _equals_7 = Objects.equal((Object)_actualTypeArguments_3, null);
                _or_3 = _equals_7 ? true : (_equals_8 = (_length_1 = (_actualTypeArguments_4 = type_1.getActualTypeArguments()).length) == 0);
                if (_or_3) {
                    return ValidationResult.WARNING;
                }
                Type[] _actualTypeArguments_5 = type_1.getActualTypeArguments();
                Type _head_1 = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_actualTypeArguments_5)));
                innerClass = (Class)_head_1;
                boolean _isPrimitive_1 = this.isPrimitive(innerClass);
                if (_isPrimitive_1) {
                    return ValidationResult.ERROR;
                }
                String _name_1 = innerClass.getName();
                return this.checkClassProperty(_name_1, innerProperty);
            }
            boolean _isPrimitive_2 = this.isPrimitive(innerClass);
            if (_isPrimitive_2) {
                return ValidationResult.ERROR;
            }
            String _name_2 = innerClass.getName();
            return this.checkClassProperty(_name_2, innerProperty);
        }
        return ValidationResult.OK;
    }

    public ValidationResult checkEntityProperty(PojoEntity entity, String property) {
        boolean _notEquals_1;
        boolean _isAbstract;
        boolean _notEquals;
        boolean _equals_1;
        int pos2;
        boolean _isNumber;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)property, null);
        _or = _equals ? true : (_isNumber = this.isNumber(property));
        if (_or) {
            return ValidationResult.OK;
        }
        String checkProperty = property;
        int pos1 = checkProperty.indexOf("=");
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(".", pos1)) > pos1) {
            String _plus;
            String _substring = checkProperty.substring(0, pos1);
            String _substring_1 = checkProperty.substring(pos2);
            checkProperty = _plus = String.valueOf(_substring) + _substring_1;
        }
        String innerProperty = null;
        int _indexOf = checkProperty.indexOf(".");
        pos1 = _indexOf;
        if (pos1 > 0) {
            String _substring_3;
            String _substring_2;
            innerProperty = _substring_2 = checkProperty.substring(pos1 + 1);
            checkProperty = _substring_3 = checkProperty.substring(0, pos1);
        }
        EList<PojoAnnotatedProperty> _features = entity.getFeatures();
        for (PojoAnnotatedProperty apojoProperty : _features) {
            boolean _notEquals_12;
            boolean _notEquals2;
            PojoProperty pojoProperty = apojoProperty.getFeature();
            String _name = pojoProperty.getName();
            _equals_1 = _name.equals(checkProperty);
            if (!_equals_1) continue;
            boolean _equals_2 = Objects.equal((Object)innerProperty, null);
            if (_equals_2) {
                return ValidationResult.OK;
            }
            Entity _ref = pojoProperty.getRef();
            boolean bl = _notEquals2 = !Objects.equal((Object)_ref, null);
            if (_notEquals2) {
                Entity _ref_1 = pojoProperty.getRef();
                if (_ref_1 instanceof PojoEntity) {
                    Entity _ref_2 = pojoProperty.getRef();
                    return this.checkEntityProperty((PojoEntity)_ref_2, innerProperty);
                }
                return ValidationResult.OK;
            }
            PojoEntity _gref = pojoProperty.getGref();
            boolean bl2 = _notEquals_12 = !Objects.equal((Object)_gref, null);
            if (_notEquals_12) {
                PojoEntity _gref_1 = pojoProperty.getGref();
                return this.checkEntityProperty(_gref_1, innerProperty);
            }
            return ValidationResult.ERROR;
        }
        PojoEntity superType = Utils.getSuperType(entity);
        boolean bl = _notEquals = !Objects.equal((Object)superType, null);
        if (_notEquals) {
            boolean _equals_2;
            ValidationResult result = this.checkEntityProperty(superType, property);
            boolean _or_1 = false;
            _equals_1 = Objects.equal((Object)((Object)result), (Object)((Object)ValidationResult.WARNING));
            _or_1 = _equals_1 ? true : (_equals_2 = Objects.equal((Object)((Object)result), (Object)((Object)ValidationResult.OK)));
            if (_or_1) {
                return result;
            }
        }
        if (_isAbstract = Utils.isAbstract(entity)) {
            return ValidationResult.WARNING;
        }
        Set<String> suppressedAbstracts = this.modelProperty.getNotAbstractTables(entity);
        boolean _and = false;
        boolean bl3 = _notEquals_1 = !Objects.equal(suppressedAbstracts, null);
        if (!_notEquals_1) {
            _and = false;
        } else {
            boolean _contains;
            String _dbName = Utils.dbName(entity);
            _and = _contains = suppressedAbstracts.contains(_dbName);
        }
        if (_and) {
            return ValidationResult.WARNING;
        }
        return ValidationResult.ERROR;
    }

    @Check
    public void checkUniqueProperty(Property property) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)property);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)property);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<Property> _properties = artifacts.getProperties();
        for (Property prop : _properties) {
            String _name_6;
            boolean _startsWith_4;
            boolean _not_4;
            String _name_5;
            boolean _startsWith_3;
            boolean _not_3;
            String _name_4;
            boolean _startsWith_2;
            boolean _not_2;
            String _name_3;
            boolean _startsWith_1;
            boolean _not_1;
            String _name_2;
            boolean _startsWith;
            boolean _not;
            String _name_1;
            boolean _tripleNotEquals;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)prop, null);
            _and = !_notEquals ? false : (_tripleNotEquals = prop != property);
            if (!_and) continue;
            boolean _and_1 = false;
            boolean _and_2 = false;
            boolean _and_3 = false;
            boolean _and_4 = false;
            boolean _and_5 = false;
            String _name = prop.getName();
            boolean _equals = _name.equals(_name_1 = property.getName());
            _and_5 = !_equals ? false : (_not = !(_startsWith = (_name_2 = prop.getName()).startsWith("pojogen")));
            _and_4 = !_and_5 ? false : (_not_1 = !(_startsWith_1 = (_name_3 = prop.getName()).startsWith("database")));
            _and_3 = !_and_4 ? false : (_not_2 = !(_startsWith_2 = (_name_4 = prop.getName()).startsWith("metagen")));
            _and_2 = !_and_3 ? false : (_not_3 = !(_startsWith_3 = (_name_5 = prop.getName()).startsWith("daogen")));
            _and_1 = !_and_2 ? false : (_not_4 = !(_startsWith_4 = (_name_6 = prop.getName()).startsWith("replace-all")));
            if (!_and_1) continue;
            String _name_7 = property.getName();
            String _plus = "Duplicate name : " + _name_7;
            this.error(_plus, (EStructuralFeature)ProcessorDslPackage.Literals.PROPERTY__NAME);
            return;
        }
    }

    @Check
    public void checkTableDefinition(TableDefinition tableDefinition) {
        String _table;
        boolean _checkTable;
        boolean _not;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)tableDefinition);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)tableDefinition);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<TableDefinition> _tables = artifacts.getTables();
        for (TableDefinition table : _tables) {
            String _name_1;
            String _name;
            boolean _equals;
            boolean _tripleNotEquals;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)table, null);
            _and = !_notEquals ? false : (_tripleNotEquals = table != tableDefinition);
            if (!_and || !(_equals = (_name = tableDefinition.getName()).equals(_name_1 = table.getName()))) continue;
            String _name_2 = tableDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            String _plus_1 = String.valueOf(_plus) + "[table]";
            this.error(_plus_1, (EStructuralFeature)ProcessorDslPackage.Literals.TABLE_DEFINITION__NAME);
            return;
        }
        boolean _and_1 = false;
        boolean _isResolveDb = this.isResolveDb(tableDefinition);
        _and_1 = !_isResolveDb ? false : (_not = !(_checkTable = this.dbResolver.checkTable(tableDefinition, _table = tableDefinition.getTable())));
        if (_and_1) {
            String _table_1 = tableDefinition.getTable();
            String _plus_2 = "Cannot find table in DB : " + _table_1;
            this.error(_plus_2, (EStructuralFeature)ProcessorDslPackage.Literals.TABLE_DEFINITION__TABLE);
        }
    }

    @Check
    public void checkProcedureDefinition(ProcedureDefinition procedureDefinition) {
        String _table;
        boolean _checkProcedure;
        boolean _not;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)procedureDefinition);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)procedureDefinition);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<ProcedureDefinition> _procedures = artifacts.getProcedures();
        for (ProcedureDefinition procedure : _procedures) {
            String _name_1;
            String _name;
            boolean _equals;
            boolean _tripleNotEquals;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)procedure, null);
            _and = !_notEquals ? false : (_tripleNotEquals = procedure != procedureDefinition);
            if (!_and || !(_equals = (_name = procedureDefinition.getName()).equals(_name_1 = procedure.getName()))) continue;
            String _name_2 = procedureDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            String _plus_1 = String.valueOf(_plus) + "[procedure]";
            this.error(_plus_1, (EStructuralFeature)ProcessorDslPackage.Literals.PROCEDURE_DEFINITION__NAME);
            return;
        }
        boolean _and_1 = false;
        boolean _isResolveDb = this.isResolveDb(procedureDefinition);
        _and_1 = !_isResolveDb ? false : (_not = !(_checkProcedure = this.dbResolver.checkProcedure(procedureDefinition, _table = procedureDefinition.getTable())));
        if (_and_1) {
            String _table_1 = procedureDefinition.getTable();
            String _plus_2 = "Cannot find procedure in DB : " + _table_1;
            this.error(_plus_2, (EStructuralFeature)ProcessorDslPackage.Literals.PROCEDURE_DEFINITION__NAME);
        }
    }

    @Check
    public void checkFunctionDefinition(FunctionDefinition functionDefinition) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)functionDefinition);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)functionDefinition);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<FunctionDefinition> _functions = artifacts.getFunctions();
        for (FunctionDefinition function : _functions) {
            String _name_1;
            String _name;
            boolean _equals;
            boolean _tripleNotEquals;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)function, null);
            _and = !_notEquals ? false : (_tripleNotEquals = function != functionDefinition);
            if (!_and || !(_equals = (_name = functionDefinition.getName()).equals(_name_1 = function.getName()))) continue;
            String _name_2 = functionDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            String _plus_1 = String.valueOf(_plus) + "[function]";
            this.error(_plus_1, (EStructuralFeature)ProcessorDslPackage.Literals.FUNCTION_DEFINITION__NAME);
            return;
        }
    }

    @Check
    public void checkDatabaseColumn(DatabaseColumn databaseColumn) {
        boolean _checkColumn;
        boolean _not_1;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(databaseColumn);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            return;
        }
        String prefix = databaseColumn.getName();
        String columnName = null;
        int pos = prefix.indexOf(".");
        if (pos > 0) {
            String _substring_1;
            String _substring;
            String _name = databaseColumn.getName();
            prefix = _substring = _name.substring(0, pos);
            String _name_1 = databaseColumn.getName();
            columnName = _substring_1 = _name_1.substring(pos + 1);
        } else {
            String _name_2;
            prefix = null;
            columnName = _name_2 = databaseColumn.getName();
        }
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)databaseColumn, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)statement, Artifacts.class);
        String value = Utils.getTokenFromModifier(statement, "tab", prefix);
        TableDefinition _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)value, null);
        if (_notEquals) {
            IScope _scope = this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES);
            _xifexpression = Utils.findTable(this.qualifiedNameConverter, artifacts, _scope, value);
        }
        TableDefinition tableDefinition = _xifexpression;
        String _xifexpression_1 = null;
        boolean bl3 = _notEquals_1 = !Objects.equal(tableDefinition, null);
        if (_notEquals_1) {
            _xifexpression_1 = tableDefinition.getTable();
        }
        String tableName = _xifexpression_1;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)tableName, null);
        _or = _equals ? true : (_not_1 = !(_checkColumn = this.dbResolver.checkColumn(databaseColumn, tableName, columnName)));
        if (_or) {
            String _name_3 = databaseColumn.getName();
            String _plus = "Cannot find column in DB : " + _name_3;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _plus_2 = String.valueOf(_plus_1) + tableName;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorDslPackage.Literals.DATABASE_COLUMN__NAME);
        }
    }

    @Check
    public void checkDatabaseTable(DatabaseTable databaseTable) {
        boolean _checkTable;
        boolean _not_1;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(databaseTable);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            return;
        }
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)databaseTable, MetaStatement.class);
        final Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)statement, Artifacts.class);
        String tableName = databaseTable.getName();
        List<String> _tokensFromModifier = Utils.getTokensFromModifier(statement, "tab");
        Functions.Function1<String, TableDefinition> _function = new Functions.Function1<String, TableDefinition>(){

            public TableDefinition apply(String value) {
                IScope _scope = ProcessorDslValidator.this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES);
                return Utils.findTable(ProcessorDslValidator.this.qualifiedNameConverter, artifacts, _scope, value);
            }
        };
        List tableDefinitions = ListExtensions.map(_tokensFromModifier, (Functions.Function1)_function);
        Functions.Function1<TableDefinition, Boolean> _function_1 = new Functions.Function1<TableDefinition, Boolean>(){

            public Boolean apply(TableDefinition it) {
                return !Objects.equal((Object)it, null);
            }
        };
        TableDefinition tableDefinition = (TableDefinition)IterableExtensions.findFirst((Iterable)tableDefinitions, (Functions.Function1)_function_1);
        boolean _or = false;
        boolean _equals = Objects.equal((Object)tableDefinition, null);
        _or = _equals ? true : (_not_1 = !(_checkTable = this.dbResolver.checkTable(databaseTable, tableName)));
        if (_or) {
            this.error("Cannot find table in DB : " + tableName, (EStructuralFeature)ProcessorDslPackage.Literals.DATABASE_TABLE__NAME);
        }
    }

    @Check
    public void checkUniquePojoEntity(PojoEntity pojoEntity) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)pojoEntity);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)pojoEntity);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<PackageDeclaration> _pojoPackages = artifacts.getPojoPackages();
        for (PackageDeclaration pkg : _pojoPackages) {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)pkg, null);
            if (!_notEquals) continue;
            EList<AbstractPojoEntity> _elements = pkg.getElements();
            for (AbstractPojoEntity entity : _elements) {
                String _name_1;
                String _name;
                boolean _equals;
                boolean _tripleNotEquals;
                boolean _and = false;
                boolean _notEquals_1 = !Objects.equal((Object)entity, null);
                _and = !_notEquals_1 ? false : entity instanceof PojoEntity;
                if (!_and) continue;
                PojoEntity pentity = (PojoEntity)((Object)entity);
                boolean bl2 = _tripleNotEquals = pentity != pojoEntity;
                if (!_tripleNotEquals || !(_equals = (_name = pojoEntity.getName()).equals(_name_1 = pentity.getName()))) continue;
                String _name_2 = pojoEntity.getName();
                String _plus = "Duplicate name : " + _name_2;
                this.error(_plus, (EStructuralFeature)ProcessorDslPackage.Literals.ENTITY__NAME);
                return;
            }
        }
    }

    @Check
    public void checkUniquePojoProperty(PojoProperty pojoProperty) {
        PojoEntity entity = (PojoEntity)EcoreUtil2.getContainerOfType((EObject)pojoProperty, PojoEntity.class);
        EList<PojoAnnotatedProperty> _features = entity.getFeatures();
        for (PojoAnnotatedProperty aproperty : _features) {
            String _name_1;
            String _name;
            boolean _equals;
            boolean _tripleNotEquals;
            boolean _notEquals;
            PojoProperty property = aproperty.getFeature();
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)property, null);
            _and = !_notEquals ? false : (_tripleNotEquals = property != pojoProperty);
            if (!_and || !(_equals = (_name = pojoProperty.getName()).equals(_name_1 = property.getName()))) continue;
            String _name_2 = pojoProperty.getName();
            String _plus = "Duplicate name : " + _name_2;
            this.error(_plus, (EStructuralFeature)ProcessorDslPackage.Literals.POJO_PROPERTY__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueEnumEntity(EnumEntity enumEntity) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)enumEntity);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)enumEntity);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<PackageDeclaration> _pojoPackages = artifacts.getPojoPackages();
        for (PackageDeclaration pkg : _pojoPackages) {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)pkg, null);
            if (!_notEquals) continue;
            EList<AbstractPojoEntity> _elements = pkg.getElements();
            for (AbstractPojoEntity entity : _elements) {
                String _name_1;
                String _name;
                boolean _equals;
                boolean _notEquals_2;
                boolean _and = false;
                boolean _notEquals_1 = !Objects.equal((Object)entity, null);
                _and = !_notEquals_1 ? false : entity instanceof EnumEntity;
                if (!_and) continue;
                EnumEntity pentity = (EnumEntity)((Object)entity);
                boolean bl2 = _notEquals_2 = !Objects.equal((Object)pentity, (Object)enumEntity);
                if (!_notEquals_2 || !(_equals = (_name = enumEntity.getName()).equals(_name_1 = pentity.getName()))) continue;
                String _name_2 = enumEntity.getName();
                String _plus = "Duplicate name : " + _name_2;
                this.error(_plus, (EStructuralFeature)ProcessorDslPackage.Literals.ENTITY__NAME);
                return;
            }
        }
    }

    @Check
    public void checkUniqueEnumProperty(EnumProperty enumProperty) {
        EnumEntity entity = (EnumEntity)EcoreUtil2.getContainerOfType((EObject)enumProperty, EnumEntity.class);
        EList<EnumProperty> _features = entity.getFeatures();
        for (EnumProperty property : _features) {
            String _name_1;
            String _name;
            boolean _equals;
            boolean _tripleNotEquals;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)property, null);
            _and = !_notEquals ? false : (_tripleNotEquals = property != enumProperty);
            if (!_and || !(_equals = (_name = enumProperty.getName()).equals(_name_1 = property.getName()))) continue;
            String _name_2 = enumProperty.getName();
            String _plus = "Duplicate name : " + _name_2;
            this.error(_plus, (EStructuralFeature)ProcessorDslPackage.Literals.ENUM_PROPERTY__NAME);
            return;
        }
    }

    @Check
    public void checkUniquePojoDao(PojoDao pojoDao) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)pojoDao);
        if (!(_rootContainer instanceof Artifacts)) {
            return;
        }
        EObject _rootContainer_1 = EcoreUtil.getRootContainer((EObject)pojoDao);
        Artifacts artifacts = (Artifacts)_rootContainer_1;
        EList<PackageDeclaration> _pojoPackages = artifacts.getPojoPackages();
        for (PackageDeclaration pkg : _pojoPackages) {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)pkg, null);
            if (!_notEquals) continue;
            EList<AbstractPojoEntity> _elements = pkg.getElements();
            for (AbstractPojoEntity dao : _elements) {
                String _name_1;
                String _name;
                boolean _equals;
                boolean _notEquals_2;
                boolean _and = false;
                boolean _notEquals_1 = !Objects.equal((Object)dao, null);
                _and = !_notEquals_1 ? false : dao instanceof PojoDao;
                if (!_and) continue;
                PojoDao pdao = (PojoDao)dao;
                boolean bl2 = _notEquals_2 = !Objects.equal((Object)pdao, (Object)pojoDao);
                if (!_notEquals_2 || !(_equals = (_name = pojoDao.getName()).equals(_name_1 = pdao.getName()))) continue;
                String _name_2 = pojoDao.getName();
                String _plus = "Duplicate name : " + _name_2;
                this.error(_plus, (EStructuralFeature)ProcessorDslPackage.Literals.POJO_DAO__NAME);
                return;
            }
        }
    }
}

