/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.util;

import org.apache.log4j.Logger;

public class Debug {
    public boolean debug = false;
    public boolean trace = false;
    public boolean info = false;
    public String logScope = null;
    public Logger LOGGER = null;

    public Debug(Logger LOGGER) {
        this.LOGGER = LOGGER;
    }

    public Debug(String debugLevel, String debugScope, Logger LOGGER) {
        this.debug = "DEBUG".equalsIgnoreCase(debugLevel);
        this.trace = "TRACE".equalsIgnoreCase(debugLevel);
        this.info = "INFO".equalsIgnoreCase(debugLevel);
        this.logScope = debugScope != null ? debugScope.toUpperCase() : null;
        this.LOGGER = LOGGER;
    }

    public void trace(String m, String msg) {
        if (!this.isScopeActive(m)) {
            return;
        }
        if (this.trace || this.debug || this.info) {
            System.out.println(String.valueOf(m) + " " + msg);
        } else if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace((Object)(String.valueOf(m) + " " + msg));
        }
    }

    public void trace(String m, String msg, Object object) {
        if (!this.isScopeActive(m)) {
            return;
        }
        if (this.trace || this.debug || this.info) {
            System.out.println(String.valueOf(m) + " " + msg + " " + object);
        } else if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace((Object)(String.valueOf(m) + " " + msg + " " + object));
        }
    }

    public void debug(String m, String msg) {
        if (!this.isScopeActive(m)) {
            return;
        }
        if (this.debug || this.info) {
            System.out.println(String.valueOf(m) + " " + msg);
        } else if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)(String.valueOf(m) + " " + msg));
        }
    }

    public void debug(String m, String msg, Object object) {
        if (!this.isScopeActive(m)) {
            return;
        }
        if (this.debug || this.info) {
            System.out.println(String.valueOf(m) + " " + msg + " " + object);
        } else if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)(String.valueOf(m) + " " + msg + " " + object));
        }
    }

    public void info(String m, String msg) {
        if (!this.isScopeActive(m)) {
            return;
        }
        if (this.info) {
            System.out.println(msg);
        } else if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info((Object)msg);
        }
    }

    public void error(String msg, Exception e) {
        System.out.println(msg);
        e.printStackTrace();
        this.LOGGER.error((Object)msg, (Throwable)e);
    }

    private boolean isScopeActive(String m) {
        if (this.logScope == null || m == null) {
            return true;
        }
        return this.logScope.indexOf(m.toUpperCase()) >= 0;
    }
}

