/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sqlproc.dsl.processorDsl.AnnotatedEntity;
import org.sqlproc.dsl.processorDsl.Annotation;
import org.sqlproc.dsl.processorDsl.AnnotationProperty;
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty;
import org.sqlproc.dsl.processorDsl.PojoEntity;

public class Annotations {
    Map<String, List<Annotation>> entityAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, List<Annotation>> constructorAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, List<Annotation>> staticAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, List<Annotation>> conflictAnnotations = new HashMap<String, List<Annotation>>();
    Map<String, Map<String, List<Annotation>>> setterAnnotations = new HashMap<String, Map<String, List<Annotation>>>();
    Map<String, Map<String, List<Annotation>>> getterAnnotations = new HashMap<String, Map<String, List<Annotation>>>();
    Map<String, Map<String, List<Annotation>>> attributeAnnotations = new HashMap<String, Map<String, List<Annotation>>>();

    public void addEntityAnnotations(String pojoName, List<Annotation> annotations) {
        this.entityAnnotations.put(pojoName, new ArrayList());
        this.entityAnnotations.get(pojoName).addAll(annotations);
    }

    public void addConstructorAnnotations(String pojoName, List<Annotation> annotations) {
        this.constructorAnnotations.put(pojoName, new ArrayList());
        this.constructorAnnotations.get(pojoName).addAll(annotations);
    }

    public void addStaticAnnotations(String pojoName, List<Annotation> annotations) {
        this.staticAnnotations.put(pojoName, new ArrayList());
        this.staticAnnotations.get(pojoName).addAll(annotations);
    }

    public void addConflictAnnotations(String pojoName, List<Annotation> annotations) {
        this.conflictAnnotations.put(pojoName, new ArrayList());
        this.conflictAnnotations.get(pojoName).addAll(annotations);
    }

    public void addGetterAnnotations(String pojoName, String featureName, List<Annotation> annotations) {
        List<Annotation> list;
        if (!this.getterAnnotations.containsKey(pojoName)) {
            this.getterAnnotations.put(pojoName, new HashMap());
        }
        if ((list = this.getterAnnotations.get(pojoName).get(featureName)) == null) {
            list = new ArrayList<Annotation>();
            this.getterAnnotations.get(pojoName).put(featureName, list);
        }
        list.addAll(annotations);
    }

    public void addSetterAnnotations(String pojoName, String featureName, List<Annotation> annotations) {
        List<Annotation> list;
        if (!this.setterAnnotations.containsKey(pojoName)) {
            this.setterAnnotations.put(pojoName, new HashMap());
        }
        if ((list = this.setterAnnotations.get(pojoName).get(featureName)) == null) {
            list = new ArrayList<Annotation>();
            this.setterAnnotations.get(pojoName).put(featureName, list);
        }
        list.addAll(annotations);
    }

    public void addAttributeAnnotations(String pojoName, String featureName, List<Annotation> annotations) {
        List<Annotation> list;
        if (!this.attributeAnnotations.containsKey(pojoName)) {
            this.attributeAnnotations.put(pojoName, new HashMap());
        }
        if ((list = this.attributeAnnotations.get(pojoName).get(featureName)) == null) {
            list = new ArrayList<Annotation>();
            this.attributeAnnotations.get(pojoName).put(featureName, list);
        }
        list.addAll(annotations);
    }

    public StringBuilder getEntityAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.entityAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.entityAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  @", simpleNames);
        }
        return sb;
    }

    public StringBuilder getConstructorAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.constructorAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.constructorAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  @@", simpleNames);
        }
        return sb;
    }

    public StringBuilder getStaticAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.staticAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.staticAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  @@@", simpleNames);
        }
        return sb;
    }

    public StringBuilder getConflictAnnotationsDefinitions(String pojoName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.conflictAnnotations.containsKey(pojoName)) {
            return sb;
        }
        for (Annotation a : this.conflictAnnotations.get(pojoName)) {
            this.getAnnotationDefinition(sb, a, "\n  @@@@", simpleNames);
        }
        return sb;
    }

    public StringBuilder getGetterAnnotationsDefinitions(String pojoName, String featureName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.getterAnnotations.containsKey(pojoName) || !this.getterAnnotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (Annotation a : this.getterAnnotations.get(pojoName).get(featureName)) {
            this.getAnnotationDefinition(sb, a, "\n    @@", simpleNames);
        }
        return sb;
    }

    public StringBuilder getSetterAnnotationsDefinitions(String pojoName, String featureName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.setterAnnotations.containsKey(pojoName) || !this.setterAnnotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (Annotation a : this.setterAnnotations.get(pojoName).get(featureName)) {
            this.getAnnotationDefinition(sb, a, "\n    @@@", simpleNames);
        }
        return sb;
    }

    public StringBuilder getAttributeAnnotationsDefinitions(String pojoName, String featureName, boolean simpleNames) {
        StringBuilder sb = new StringBuilder();
        if (!this.attributeAnnotations.containsKey(pojoName) || !this.attributeAnnotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (Annotation a : this.attributeAnnotations.get(pojoName).get(featureName)) {
            this.getAnnotationDefinition(sb, a, "\n    @", simpleNames);
        }
        return sb;
    }

    public boolean hasAttributeAnnotationsDefinitions(String pojoName, String featureName, String annotationName) {
        if (this.attributeAnnotations == null) {
            return false;
        }
        if (!this.attributeAnnotations.containsKey(pojoName) || !this.attributeAnnotations.get(pojoName).containsKey(featureName)) {
            return false;
        }
        for (Annotation a : this.attributeAnnotations.get(pojoName).get(featureName)) {
            String aName = a.getType().getQualifiedName();
            if (!annotationName.equals(aName)) continue;
            return true;
        }
        return false;
    }

    public void getAnnotationDefinition(StringBuilder sb, Annotation a, String prefix, boolean simpleNames) {
        sb.append(prefix).append(simpleNames ? a.getType().getSimpleName() : a.getType().getQualifiedName());
        if (a.getFeatures() != null && !a.getFeatures().isEmpty()) {
            sb.append(" ::: ");
            boolean first = true;
            for (AnnotationProperty ap : a.getFeatures()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                this.getAnnotationPropertyDefinition(sb, ap, simpleNames);
            }
        }
    }

    public void getAnnotationPropertyDefinition(StringBuilder sb, AnnotationProperty ap, boolean simpleNames) {
        sb.append(ap.getName());
        if (ap.getType() != null) {
            sb.append(" :").append(simpleNames ? ap.getType().getSimpleName() : ap.getType().getQualifiedName());
        } else if (ap.getRef() != null) {
            sb.append(" ::").append(ap.getRef().getName());
        }
        sb.append(" ");
        if (ap.getValue() != null) {
            sb.append(ap.getValue());
        } else if (ap.getNumber() != null) {
            sb.append(ap.getNumber());
        } else {
            sb.append(ap.getConstant());
        }
    }

    public Set<String> getImports() {
        HashSet<String> imports = new HashSet<String>();
        for (List<Annotation> list : this.entityAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (List<Annotation> list : this.constructorAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (List<Annotation> list : this.staticAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (List<Annotation> list : this.conflictAnnotations.values()) {
            this.getImports(imports, list);
        }
        for (Map map : this.attributeAnnotations.values()) {
            for (List al : map.values()) {
                this.getImports(imports, al);
            }
        }
        for (Map map : this.getterAnnotations.values()) {
            for (List al : map.values()) {
                this.getImports(imports, al);
            }
        }
        for (Map map : this.setterAnnotations.values()) {
            for (List al : map.values()) {
                this.getImports(imports, al);
            }
        }
        return imports;
    }

    public void getImports(Set<String> imports, List<Annotation> al) {
        for (Annotation a : al) {
            if (a.getType() != null) {
                imports.add(a.getType().getQualifiedName());
            }
            for (AnnotationProperty ap : a.getFeatures()) {
                if (ap.getType() == null) continue;
                imports.add(ap.getType().getQualifiedName());
            }
        }
    }

    public static void grabAnnotations(AnnotatedEntity apojo, PojoEntity pojo, Annotations as) {
        String pojoName = pojo.getName();
        as.addEntityAnnotations(pojoName, (List<Annotation>)apojo.getAnnotations());
        as.addConstructorAnnotations(pojoName, (List<Annotation>)apojo.getConstructorAnnotations());
        as.addStaticAnnotations(pojoName, (List<Annotation>)apojo.getStaticAnnotations());
        as.addConflictAnnotations(pojoName, (List<Annotation>)apojo.getConflictAnnotations());
        for (PojoAnnotatedProperty feature : pojo.getFeatures()) {
            if (feature.getFeature() == null) continue;
            if (feature.getAttributeAnnotations() != null) {
                as.addAttributeAnnotations(pojoName, feature.getFeature().getName(), (List<Annotation>)feature.getAttributeAnnotations());
            }
            if (feature.getSetterAnnotations() != null) {
                as.addSetterAnnotations(pojoName, feature.getFeature().getName(), (List<Annotation>)feature.getSetterAnnotations());
            }
            if (feature.getGetterAnnotations() == null) continue;
            as.addGetterAnnotations(pojoName, feature.getFeature().getName(), (List<Annotation>)feature.getGetterAnnotations());
        }
    }

    public String toString() {
        return "Annotations [entityAnnotations=" + this.entityAnnotations + ", constructorAnnotations=" + this.constructorAnnotations + ", staticAnnotations=" + this.staticAnnotations + ", conflictAnnotations=" + this.conflictAnnotations + ", setterAnnotations=" + this.setterAnnotations + ", getterAnnotations=" + this.getterAnnotations + ", attributeAnnotations=" + this.attributeAnnotations + "]";
    }
}

