/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.resolver;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.StringInputStream;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.property.ModelPropertyBean;
import org.sqlproc.dsl.resolver.DbCheckConstraint;
import org.sqlproc.dsl.resolver.DbColumn;
import org.sqlproc.dsl.resolver.DbExport;
import org.sqlproc.dsl.resolver.DbImport;
import org.sqlproc.dsl.resolver.DbIndex;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.DbTable;
import org.sqlproc.dsl.resolver.PojoResolverFactory;
import org.sqlproc.dsl.util.Debug;

@Singleton
public class DbResolverBean
implements DbResolver {
    protected Logger LOGGER = Logger.getLogger(DbResolverBean.class);
    private Debug debug = new Debug(this.LOGGER);
    @Inject
    ModelProperty modelProperty;
    @Inject
    PojoResolverFactory pojoResolverFactory;
    private Class<?> driverClass = null;
    private String dbSqlsBefore = null;
    private String dbSqlsAfter = null;
    private final Object sync = new Object();
    private final Map<String, DatabaseDirectives> connections = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<String>> catalogs = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<String>> schemas = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<String>> tables = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<String>> procedures = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<String>> functions = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<String>> checkConstraints = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<String>>> columns = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<String>>> checkColumns = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<String>>> procColumns = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<String>>> funColumns = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbTable>>> dbTables = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbColumn>>> dbColumns = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbTable>>> dbProcedures = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbColumn>>> dbProcColumns = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbTable>>> dbFunctions = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbColumn>>> dbFunColumns = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<String>>> dbPrimaryKeys = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbExport>>> dbExports = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbImport>>> dbImports = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbIndex>>> dbIndexes = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<String>> dbSequences = Collections.synchronizedMap(new HashMap());
    private final Map<String, SortedSet<String>> driverMethods = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, List<DbCheckConstraint>>> dbChecksConstraints = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, String>> dbOriginalNames = Collections.synchronizedMap(new HashMap());

    public DbResolverBean() {
    }

    public DbResolverBean(ModelProperty modelProperty, Class<?> driverClass, String dbSqlsBefore, String dbSqlsAfter) {
        this.modelProperty = modelProperty;
        this.driverClass = driverClass;
        this.dbSqlsBefore = dbSqlsBefore;
        this.dbSqlsAfter = dbSqlsAfter;
    }

    private DatabaseDirectives checkReconnect(EObject model) {
        String m = "checkReconnect";
        this.debug.trace(m, ">>>");
        if (model == null) {
            return null;
        }
        ModelPropertyBean.ModelValues modelModelValues = this.modelProperty.getModelValues(model);
        DatabaseDirectives modelDatabaseValues = this.connections.get(modelModelValues.dir);
        if (modelDatabaseValues == null) {
            modelDatabaseValues = new DatabaseDirectives();
            modelDatabaseValues.dir = modelModelValues.dir;
            this.connections.put(modelModelValues.dir, modelDatabaseValues);
        }
        if (!modelModelValues.doResolveDb) {
            this.debug.trace(m, "DB CLOSE");
            this.closeConnection(modelDatabaseValues);
            return null;
        }
        modelDatabaseValues.doReconnect = modelDatabaseValues.connection == null;
        this.debug = new Debug(modelModelValues.dbDebugLevel, modelModelValues.dbDebugScope, this.LOGGER);
        if (modelModelValues.dbDriver != null) {
            if (!modelModelValues.dbDriver.equals(modelDatabaseValues.dbDriver)) {
                modelDatabaseValues.dbDriver = modelModelValues.dbDriver;
                modelDatabaseValues.doReconnect = true;
            }
        } else {
            modelDatabaseValues.dbDriver = null;
            this.closeConnection(modelDatabaseValues);
            return null;
        }
        if (modelModelValues.dbUrl != null) {
            if (!modelModelValues.dbUrl.equals(modelDatabaseValues.dbUrl)) {
                modelDatabaseValues.dbUrl = modelModelValues.dbUrl;
                modelDatabaseValues.doReconnect = true;
            }
        } else {
            modelDatabaseValues.dbUrl = null;
            this.closeConnection(modelDatabaseValues);
            return null;
        }
        if (modelModelValues.dbUsername != null) {
            if (!modelModelValues.dbUsername.equals(modelDatabaseValues.dbUsername)) {
                modelDatabaseValues.dbUsername = modelModelValues.dbUsername;
                modelDatabaseValues.doReconnect = true;
            }
        } else {
            modelDatabaseValues.dbUsername = null;
            this.closeConnection(modelDatabaseValues);
            return null;
        }
        if (modelModelValues.dbPassword != null) {
            if (!modelModelValues.dbPassword.equals(modelDatabaseValues.dbPassword)) {
                modelDatabaseValues.dbPassword = modelModelValues.dbPassword;
                modelDatabaseValues.doReconnect = true;
            }
        } else {
            modelDatabaseValues.dbPassword = null;
            this.closeConnection(modelDatabaseValues);
            return null;
        }
        if (modelModelValues.dbCatalog != null) {
            if (!modelModelValues.dbCatalog.equals(modelDatabaseValues.dbCatalog)) {
                modelDatabaseValues.dbCatalog = modelModelValues.dbCatalog;
                modelDatabaseValues.doReconnect = true;
            }
        } else {
            modelDatabaseValues.dbCatalog = null;
        }
        if (modelModelValues.dbSchema != null) {
            if (!modelModelValues.dbSchema.equals(modelDatabaseValues.dbSchema)) {
                modelDatabaseValues.dbSchema = modelModelValues.dbSchema;
                modelDatabaseValues.doReconnect = true;
            }
        } else {
            modelDatabaseValues.dbSchema = null;
        }
        if (modelModelValues.dbSqlsBefore != null) {
            if (!modelModelValues.dbSqlsBefore.equals(modelDatabaseValues.dbSqlsBefore)) {
                modelDatabaseValues.dbSqlsBefore = modelModelValues.dbSqlsBefore;
            }
        } else {
            modelDatabaseValues.dbSqlsBefore = null;
        }
        if (modelModelValues.dbSqlsAfter != null) {
            if (!modelModelValues.dbSqlsAfter.equals(modelDatabaseValues.dbSqlsAfter)) {
                modelDatabaseValues.dbSqlsAfter = modelModelValues.dbSqlsAfter;
            }
        } else {
            modelDatabaseValues.dbSqlsAfter = null;
        }
        if (modelModelValues.dbIndexTypes != null) {
            if (!modelModelValues.dbIndexTypes.equals(modelDatabaseValues.dbIndexTypes)) {
                modelDatabaseValues.dbIndexTypes = modelModelValues.dbIndexTypes;
                String[] ss = modelModelValues.dbIndexTypes.split(",");
                modelDatabaseValues.indexTypes = new HashSet<Short>();
                String[] stringArray = ss;
                int n = ss.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.trim().length() > 0) {
                        try {
                            Short type = Short.parseShort(s.trim());
                            modelDatabaseValues.indexTypes.add(type);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    ++n2;
                }
            }
        } else {
            modelDatabaseValues.dbIndexTypes = null;
            modelDatabaseValues.indexTypes = new HashSet<Short>();
            modelDatabaseValues.indexTypes.add((short)1);
            modelDatabaseValues.indexTypes.add((short)3);
        }
        if (modelModelValues.dbSkipIndexes != modelDatabaseValues.dbSkipIndexes) {
            modelDatabaseValues.dbSkipIndexes = modelModelValues.dbSkipIndexes;
        }
        if (modelModelValues.dbSkipCheckConstraints != modelDatabaseValues.dbSkipCheckConstraints) {
            modelDatabaseValues.dbSkipCheckConstraints = modelModelValues.dbSkipCheckConstraints;
        }
        if (modelModelValues.dbSkipProcedures != modelDatabaseValues.dbSkipProcedures) {
            modelDatabaseValues.dbSkipProcedures = modelModelValues.dbSkipProcedures;
        }
        if (modelModelValues.dbTakeComments != modelDatabaseValues.dbTakeComments) {
            modelDatabaseValues.dbTakeComments = modelModelValues.dbTakeComments;
        }
        if (modelModelValues.dbLowercaseNames != modelDatabaseValues.dbLowercaseNames) {
            modelDatabaseValues.dbLowercaseNames = modelModelValues.dbLowercaseNames;
        }
        if (modelModelValues.dbUppercaseNames != modelDatabaseValues.dbUppercaseNames) {
            modelDatabaseValues.dbUppercaseNames = modelModelValues.dbUppercaseNames;
        }
        if (modelModelValues.dbType != null) {
            if (modelDatabaseValues.dbType == null || !modelModelValues.dbType.equals(modelDatabaseValues.dbType.getValue())) {
                modelDatabaseValues.dbType = DbResolver.DbType.fromValue(modelModelValues.dbType);
            }
        } else {
            modelDatabaseValues.dbType = null;
        }
        this.debug.trace(m, "<<<DB RECONNECT " + modelDatabaseValues.doReconnect);
        return modelDatabaseValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseDirectives getConnection(EObject model) {
        String m = "getConnection";
        this.debug.trace(m, ">>>");
        DatabaseDirectives modelDatabaseValues = this.checkReconnect(model);
        if (modelDatabaseValues == null) {
            return null;
        }
        if (!modelDatabaseValues.doReconnect) {
            return modelDatabaseValues;
        }
        this.closeConnection(modelDatabaseValues);
        this.debug.trace(m, "DB OPEN");
        Object object = this.sync;
        synchronized (object) {
            this.debug.trace(m, "DATA START FOR " + modelDatabaseValues.dir);
            Class<?> driverClass = this.driverClass != null ? this.driverClass : this.pojoResolverFactory.getPojoResolver().loadClass(modelDatabaseValues.dbDriver);
            this.debug.trace(m, "DATA DRIVER " + driverClass);
            if (driverClass != null && Driver.class.isAssignableFrom(driverClass)) {
                try {
                    Driver driver = (Driver)driverClass.newInstance();
                    Properties props = new Properties();
                    props.setProperty("user", modelDatabaseValues.dbUsername);
                    props.setProperty("password", modelDatabaseValues.dbPassword);
                    String dbUrl = modelDatabaseValues.dbUrl.replaceAll("\\\\/", "/").replaceAll("\\\\/", "/").replaceAll("\\\\;", ";").replaceAll("\\\\.", ".");
                    modelDatabaseValues.connection = driver.connect(dbUrl, props);
                    this.debug.trace(m, "DB URL " + dbUrl);
                    this.debug.trace(m, "DATA CONNECTION " + modelDatabaseValues.connection);
                    Object is = null;
                    if (this.dbSqlsBefore != null) {
                        is = new StringInputStream(this.dbSqlsBefore);
                    } else if (this.driverClass == null && modelDatabaseValues.dbSqlsBefore != null && modelDatabaseValues.dbSqlsBefore.trim().length() > 0) {
                        is = this.pojoResolverFactory.getPojoResolver().getFile(model, modelDatabaseValues.dbSqlsBefore.trim());
                    }
                    if (is != null) {
                        List<String> ddls = this.loadDDL((InputStream)is);
                        modelDatabaseValues.ddlsBefore0 = new ArrayList<String>();
                        modelDatabaseValues.ddlsBefore1 = new ArrayList<String>();
                        boolean inDrop = true;
                        for (String ddl : ddls) {
                            if (inDrop && !ddl.toUpperCase().trim().startsWith("DROP")) {
                                inDrop = false;
                            }
                            if (inDrop) {
                                modelDatabaseValues.ddlsBefore0.add(ddl);
                                continue;
                            }
                            modelDatabaseValues.ddlsBefore1.add(ddl);
                        }
                        try {
                            this.runDDLs(modelDatabaseValues.connection, modelDatabaseValues.ddlsBefore0, "BEFORE");
                        }
                        catch (SQLException e) {
                            this.debug.error("getConnection error " + e, e);
                        }
                        this.runDDLs(modelDatabaseValues.connection, modelDatabaseValues.ddlsBefore1, "BEFORE");
                    }
                    Object is2 = null;
                    if (this.dbSqlsAfter != null) {
                        is2 = new StringInputStream(this.dbSqlsBefore);
                    } else if (this.driverClass == null && modelDatabaseValues.dbSqlsAfter != null && modelDatabaseValues.dbSqlsAfter.trim().length() > 0) {
                        is2 = this.pojoResolverFactory.getPojoResolver().getFile(model, modelDatabaseValues.dbSqlsAfter.trim());
                    }
                    if (is2 != null) {
                        modelDatabaseValues.ddlsAfter = this.loadDDL((InputStream)is);
                    }
                }
                catch (InstantiationException e) {
                    this.debug.error("getConnection error " + e, e);
                }
                catch (IllegalAccessException e) {
                    this.debug.error("getConnection error " + e, e);
                }
                catch (SQLException e) {
                    this.debug.error("getConnection error " + e, e);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            this.debug.trace(m, "<<<");
            return modelDatabaseValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(DatabaseDirectives modelDatabaseValues) {
        String m = "closeConnection";
        this.debug.trace(m, ">>>");
        Object object = this.sync;
        synchronized (object) {
            try {
                if (modelDatabaseValues.connection != null) {
                    if (modelDatabaseValues.ddlsAfter != null) {
                        this.runDDLs(modelDatabaseValues.connection, modelDatabaseValues.ddlsAfter, "AFTER");
                    }
                    this.debug.trace(m, "DATA STOP FOR " + modelDatabaseValues.dir);
                    modelDatabaseValues.connection.close();
                }
            }
            catch (SQLException e) {
                this.debug.error("closeConnection error " + e, e);
            }
            modelDatabaseValues.connection = null;
            modelDatabaseValues.ddlsBefore0 = null;
            modelDatabaseValues.ddlsBefore1 = null;
            modelDatabaseValues.ddlsAfter = null;
            this.catalogs.remove(modelDatabaseValues.dir);
            this.schemas.remove(modelDatabaseValues.dir);
            this.tables.remove(modelDatabaseValues.dir);
            this.columns.remove(modelDatabaseValues.dir);
            this.procColumns.remove(modelDatabaseValues.dir);
            this.funColumns.remove(modelDatabaseValues.dir);
            this.dbTables.remove(modelDatabaseValues.dir);
            this.dbColumns.remove(modelDatabaseValues.dir);
            this.dbProcedures.remove(modelDatabaseValues.dir);
            this.dbProcColumns.remove(modelDatabaseValues.dir);
            this.dbFunctions.remove(modelDatabaseValues.dir);
            this.dbFunColumns.remove(modelDatabaseValues.dir);
            this.dbPrimaryKeys.remove(modelDatabaseValues.dir);
            this.dbExports.remove(modelDatabaseValues.dir);
            this.dbImports.remove(modelDatabaseValues.dir);
            this.dbIndexes.remove(modelDatabaseValues.dir);
            this.dbSequences.remove(modelDatabaseValues.dir);
            this.driverMethods.remove(modelDatabaseValues.dir);
            this.procedures.remove(modelDatabaseValues.dir);
            this.functions.remove(modelDatabaseValues.dir);
            this.dbChecksConstraints.remove(modelDatabaseValues.dir);
        }
        this.debug.trace(m, "<<<");
    }

    private void runDDLs(Connection connection, List<String> ddls, String msg) throws SQLException {
        int[] result;
        String m;
        block11: {
            m = "runDDLs";
            this.debug.trace(m, ">>>");
            if (ddls == null || ddls.isEmpty()) {
                return;
            }
            this.debug.trace(m, "Run DDLs " + msg + ", number of statements is " + ddls.size());
            Statement stmt = null;
            result = null;
            try {
                try {
                    stmt = connection.createStatement();
                    int i = 0;
                    int n = ddls.size();
                    while (i < n) {
                        String ddl = ddls.get(i);
                        if (ddl != null) {
                            this.debug.trace(m, "DB DDL " + ddl);
                            stmt.addBatch(ddl);
                        }
                        ++i;
                    }
                    result = stmt.executeBatch();
                }
                catch (BatchUpdateException e) {
                    this.debug.error("Run DDLs chyba " + e, e);
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        this.debug.trace(m, "Run DDLs OK for " + (result != null ? result.length : -1));
        this.debug.trace(m, "<<<");
    }

    /*
     * Loose catch block
     */
    private List<String> loadDDL(InputStream is) {
        ArrayList<String> arrayList;
        ArrayList<String> ddls;
        BufferedReader bfr;
        block20: {
            String line;
            String m = "loadDDL";
            this.debug.trace(m, ">>>");
            bfr = null;
            ddls = new ArrayList<String>();
            if (is == null) {
                return ddls;
            }
            bfr = new BufferedReader(new InputStreamReader(is));
            StringBuilder completeLine = new StringBuilder("");
            boolean inFuncOrProc = false;
            while ((line = bfr.readLine()) != null) {
                if (line.startsWith("--")) continue;
                if (line.trim().length() > 0) {
                    completeLine.append(" ").append(line);
                }
                if (!inFuncOrProc && line.trim().toUpperCase().startsWith("CREATE") && (line.indexOf("FUNCTION") >= 0 || line.indexOf("PROCEDURE") >= 0)) {
                    inFuncOrProc = true;
                }
                boolean finishedDdl = false;
                if (!inFuncOrProc && line.trim().endsWith(";")) {
                    finishedDdl = true;
                } else if (line.trim().length() == 0) {
                    finishedDdl = true;
                }
                if (!finishedDdl) continue;
                if (completeLine.length() > 0) {
                    ddls.add(completeLine.toString());
                }
                completeLine = new StringBuilder("");
                inFuncOrProc = false;
            }
            if (completeLine.length() > 0) {
                ddls.add(completeLine.toString());
            }
            this.debug.trace(m, "<<<");
            arrayList = ddls;
            if (bfr == null) break block20;
            try {
                bfr.close();
            }
            catch (Exception exception) {}
        }
        return arrayList;
        catch (Exception ex) {
            ArrayList<String> arrayList2;
            block21: {
                try {
                    this.debug.error("loadDDL error", ex);
                    arrayList2 = ddls;
                    if (bfr == null) break block21;
                }
                catch (Throwable throwable) {
                    if (bfr != null) {
                        try {
                            bfr.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                try {
                    bfr.close();
                }
                catch (Exception exception) {}
            }
            return arrayList2;
        }
    }

    @Override
    public boolean isResolveDb(EObject model) {
        String m = "isResolveDb";
        this.debug.trace(m, ">>><<<");
        return this.getConnection(model) != null;
    }

    @Override
    public DatabaseDirectives getDatabaseDirectives(EObject model) {
        String m = "getDatabaseDirectives";
        this.debug.trace(m, ">>><<<");
        return this.getConnection(model);
    }

    @Override
    public List<String> getCatalogs(EObject model) {
        List<String> catalogsForModel;
        String m;
        block18: {
            m = "getCatalogs";
            this.debug.debug(m, ">>>");
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            catalogsForModel = this.catalogs.get(modelDatabaseValues.dir);
            if (catalogsForModel != null) {
                this.debug.debug(m, "<<<", catalogsForModel);
                return catalogsForModel;
            }
            catalogsForModel = Collections.synchronizedList(new ArrayList());
            this.catalogs.put(modelDatabaseValues.dir, catalogsForModel);
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getCatalogs();
                        while (result.next()) {
                            catalogsForModel.add(this.name(modelDatabaseValues, result.getString("TABLE_CAT")));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getCatalogs error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block18;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getCatalogs error " + e2, e2);
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getCatalogs error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getCatalogs error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", catalogsForModel);
        return catalogsForModel;
    }

    @Override
    public List<String> getSchemas(EObject model) {
        List<String> schemasForModel;
        String m;
        block18: {
            m = "getSchemas";
            this.debug.debug(m, ">>>");
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            schemasForModel = this.schemas.get(modelDatabaseValues.dir);
            if (schemasForModel != null) {
                this.debug.debug(m, "<<<", schemasForModel);
                return schemasForModel;
            }
            schemasForModel = Collections.synchronizedList(new ArrayList());
            this.schemas.put(modelDatabaseValues.dir, schemasForModel);
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getSchemas(modelDatabaseValues.dbCatalog, null);
                        while (result.next()) {
                            schemasForModel.add(this.name(modelDatabaseValues, result.getString("TABLE_SCHEM")));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getCatalogs error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block18;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getCatalogs error " + e2, e2);
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getCatalogs error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getCatalogs error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", schemasForModel);
        return schemasForModel;
    }

    @Override
    public List<String> getTables(EObject model) {
        List<String> tablesForModel;
        String m;
        block18: {
            m = "getTables";
            this.debug.debug(m, ">>>");
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            tablesForModel = this.tables.get(modelDatabaseValues.dir);
            if (tablesForModel != null) {
                this.debug.debug(m, "<<<", tablesForModel);
                return tablesForModel;
            }
            tablesForModel = Collections.synchronizedList(new ArrayList());
            this.tables.put(modelDatabaseValues.dir, tablesForModel);
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getTables(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, null, new String[]{"TABLE", "VIEW"});
                        while (result.next()) {
                            tablesForModel.add(this.name(modelDatabaseValues, result.getString("TABLE_NAME")));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getTables error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block18;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getTables error " + e2, e2);
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getTables error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getTables error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", tablesForModel);
        return tablesForModel;
    }

    @Override
    public List<String> getProcedures(EObject model) {
        List<String> proceduresForModel;
        String m;
        block19: {
            m = "getProcedures";
            this.debug.debug(m, ">>>");
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null || modelDatabaseValues.dbSkipProcedures) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            proceduresForModel = this.procedures.get(modelDatabaseValues.dir);
            if (proceduresForModel != null) {
                this.debug.debug(m, "<<<", proceduresForModel);
                return proceduresForModel;
            }
            proceduresForModel = Collections.synchronizedList(new ArrayList());
            this.procedures.put(modelDatabaseValues.dir, proceduresForModel);
            if (modelDatabaseValues.connection != null) {
                DbResolver.DbType dbType = this.getDbType(model);
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getProcedures(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, null);
                        while (result.next()) {
                            int ix;
                            String name = result.getString("PROCEDURE_NAME");
                            if (dbType == DbResolver.DbType.MS_SQL && (ix = name.lastIndexOf(";")) >= 0) {
                                name = name.substring(0, ix);
                            }
                            proceduresForModel.add(this.name(modelDatabaseValues, name));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getProcedures error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block19;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getProcedures error " + e2, e2);
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getProcedures error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getProcedures error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", proceduresForModel);
        return proceduresForModel;
    }

    @Override
    public List<String> getFunctions(EObject model) {
        List<String> functionsForModel;
        String m;
        block20: {
            m = "getFunctions";
            this.debug.debug(m, ">>>");
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null || modelDatabaseValues.dbSkipProcedures) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            functionsForModel = this.functions.get(modelDatabaseValues.dir);
            if (functionsForModel != null) {
                this.debug.debug(m, "<<<", functionsForModel);
                return functionsForModel;
            }
            functionsForModel = Collections.synchronizedList(new ArrayList());
            this.functions.put(modelDatabaseValues.dir, functionsForModel);
            if (modelDatabaseValues.connection != null) {
                DbResolver.DbType dbType = this.getDbType(model);
                if (dbType == DbResolver.DbType.POSTGRESQL || dbType == DbResolver.DbType.INFORMIX) {
                    return functionsForModel;
                }
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getFunctions(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, null);
                        while (result.next()) {
                            int ix;
                            String name = result.getString("FUNCTION_NAME");
                            if (dbType == DbResolver.DbType.MS_SQL && (ix = name.lastIndexOf(";")) >= 0) {
                                name = name.substring(0, ix);
                            }
                            functionsForModel.add(this.name(modelDatabaseValues, name));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getFunctions error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block20;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getFunctions error " + e2, e2);
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getFunctions error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getFunctions error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", functionsForModel);
        return functionsForModel;
    }

    @Override
    public boolean checkTable(EObject model, String table) {
        if (table == null) {
            return false;
        }
        return this.getTables(model).contains(table);
    }

    @Override
    public boolean checkTableName(EObject model, String table) {
        if (table == null) {
            return false;
        }
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        String origName = this.origName(model, modelDatabaseValues, table);
        System.out.println(String.valueOf(table) + " -> " + origName);
        return origName != null;
    }

    @Override
    public boolean checkProcedure(EObject model, String procedure) {
        if (procedure == null) {
            return false;
        }
        return this.getProcedures(model).contains(procedure);
    }

    @Override
    public boolean checkFunction(EObject model, String function) {
        if (function == null) {
            return false;
        }
        return this.getFunctions(model).contains(function);
    }

    @Override
    public List<String> getColumns(EObject model, String table) {
        List<String> columnsForModel;
        String m;
        block21: {
            m = "getColumns";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<String>> allColumnsForModel = this.columns.get(modelDatabaseValues.dir);
            if (allColumnsForModel == null) {
                allColumnsForModel = Collections.synchronizedMap(new HashMap());
                this.columns.put(modelDatabaseValues.dir, allColumnsForModel);
                doInit = true;
            }
            if ((columnsForModel = allColumnsForModel.get(table)) == null) {
                columnsForModel = Collections.synchronizedList(new ArrayList());
                allColumnsForModel.put(table, columnsForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", columnsForModel);
                return columnsForModel;
            }
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getColumns(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table), null);
                        while (result.next()) {
                            columnsForModel.add(this.name(modelDatabaseValues, result.getString("COLUMN_NAME")));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getColumns error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block21;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getColumns error " + e2, e2);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getColumns error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getColumns error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", columnsForModel);
        return columnsForModel;
    }

    @Override
    public boolean checkColumn(EObject model, String table, String column) {
        if (table == null || column == null) {
            return false;
        }
        return this.getColumns(model, table).contains(column);
    }

    @Override
    public List<String> getProcColumns(EObject model, String table) {
        List<String> columnsForModel;
        String m;
        block22: {
            m = "getProcColumns";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null || modelDatabaseValues.dbSkipProcedures) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<String>> allColumnsForModel = this.procColumns.get(modelDatabaseValues.dir);
            if (allColumnsForModel == null) {
                allColumnsForModel = Collections.synchronizedMap(new HashMap());
                this.procColumns.put(modelDatabaseValues.dir, allColumnsForModel);
                doInit = true;
            }
            if ((columnsForModel = allColumnsForModel.get(table)) == null) {
                columnsForModel = Collections.synchronizedList(new ArrayList());
                allColumnsForModel.put(table, columnsForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", columnsForModel);
                return columnsForModel;
            }
            if (modelDatabaseValues.connection != null) {
                DbResolver.DbType dbType = this.getDbType(model);
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getProcedureColumns(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table), null);
                        while (result.next()) {
                            String name = result.getString("COLUMN_NAME");
                            if (dbType == DbResolver.DbType.MS_SQL && name.startsWith("@")) {
                                name = name.substring(1);
                            }
                            columnsForModel.add(this.name(modelDatabaseValues, name));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getProcColumns error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block22;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getProcColumns error " + e2, e2);
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getProcColumns error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getProcColumns error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", columnsForModel);
        return columnsForModel;
    }

    @Override
    public boolean checkProcColumn(EObject model, String table, String column) {
        if (this.doSkipProcedures(model)) {
            return true;
        }
        if (table == null || column == null) {
            return false;
        }
        return this.getProcColumns(model, table).contains(column);
    }

    @Override
    public List<String> getFunColumns(EObject model, String table) {
        List<String> columnsForModel;
        String m;
        block22: {
            m = "getFunColumns";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null || modelDatabaseValues.dbSkipProcedures) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<String>> allColumnsForModel = this.funColumns.get(modelDatabaseValues.dir);
            if (allColumnsForModel == null) {
                allColumnsForModel = Collections.synchronizedMap(new HashMap());
                this.funColumns.put(modelDatabaseValues.dir, allColumnsForModel);
                doInit = true;
            }
            if ((columnsForModel = allColumnsForModel.get(table)) == null) {
                columnsForModel = Collections.synchronizedList(new ArrayList());
                allColumnsForModel.put(table, columnsForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", columnsForModel);
                return columnsForModel;
            }
            if (modelDatabaseValues.connection != null) {
                DbResolver.DbType dbType = this.getDbType(model);
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getFunctionColumns(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table), null);
                        while (result.next()) {
                            String name = result.getString("COLUMN_NAME");
                            if (dbType == DbResolver.DbType.MS_SQL && name.startsWith("@")) {
                                name = name.substring(1);
                            }
                            columnsForModel.add(this.name(modelDatabaseValues, name));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getFunColumns error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block22;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getFunColumns error " + e2, e2);
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getFunColumns error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getFunColumns error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", columnsForModel);
        return columnsForModel;
    }

    @Override
    public boolean checkFunColumn(EObject model, String table, String column) {
        if (this.doSkipProcedures(model)) {
            return true;
        }
        if (table == null || column == null) {
            return false;
        }
        return this.getFunColumns(model, table).contains(column);
    }

    protected boolean doSkipProcedures(EObject model) {
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        return modelDatabaseValues == null || modelDatabaseValues.dbSkipProcedures;
    }

    @Override
    public List<DbTable> getDbTables(EObject model, String table) {
        List<DbTable> tablesForModel;
        String m;
        block22: {
            m = "getDbTables";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<DbTable>> allTablesForModel = this.dbTables.get(modelDatabaseValues.dir);
            if (allTablesForModel == null) {
                allTablesForModel = Collections.synchronizedMap(new HashMap());
                this.dbTables.put(modelDatabaseValues.dir, allTablesForModel);
                doInit = true;
            }
            if ((tablesForModel = allTablesForModel.get(table)) == null) {
                tablesForModel = Collections.synchronizedList(new ArrayList());
                allTablesForModel.put(table, tablesForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", tablesForModel);
                return tablesForModel;
            }
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getTables(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table), null);
                        while (result.next()) {
                            DbTable dbTable = new DbTable();
                            dbTable.setName(this.name(modelDatabaseValues, result.getString("TABLE_NAME")));
                            dbTable.setType(result.getString("TABLE_TYPE"));
                            if (modelDatabaseValues.dbTakeComments) {
                                dbTable.setComment(result.getString("REMARKS"));
                            }
                            tablesForModel.add(dbTable);
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbTables error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block22;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbTables error " + e2, e2);
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbTables error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbTables error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", tablesForModel);
        return tablesForModel;
    }

    @Override
    public List<DbColumn> getDbColumns(EObject model, String table) {
        List<DbColumn> columnsForModel;
        String m;
        block27: {
            m = "getDbColumns";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<DbColumn>> allColumnsForModel = this.dbColumns.get(modelDatabaseValues.dir);
            if (allColumnsForModel == null) {
                allColumnsForModel = Collections.synchronizedMap(new HashMap());
                this.dbColumns.put(modelDatabaseValues.dir, allColumnsForModel);
                doInit = true;
            }
            if ((columnsForModel = allColumnsForModel.get(table)) == null) {
                columnsForModel = Collections.synchronizedList(new ArrayList());
                allColumnsForModel.put(table, columnsForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", columnsForModel);
                return columnsForModel;
            }
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getColumns(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table), null);
                        while (result.next()) {
                            DbColumn dbColumn = new DbColumn();
                            dbColumn.setName(this.name(modelDatabaseValues, result.getString("COLUMN_NAME")));
                            dbColumn.setType(result.getString("TYPE_NAME"));
                            int ix = dbColumn.getType().indexOf(40);
                            if (ix > 0) {
                                String size = dbColumn.getType().substring(ix + 1);
                                dbColumn.setType(dbColumn.getType().substring(0, ix));
                                ix = size.indexOf(41);
                                if (ix > 0) {
                                    size = size.substring(0, ix);
                                }
                                try {
                                    dbColumn.setSize(Integer.parseInt(size));
                                }
                                catch (Exception exception) {}
                            } else {
                                dbColumn.setSize(result.getInt("COLUMN_SIZE"));
                            }
                            dbColumn.setSqlType(result.getInt("DATA_TYPE"));
                            dbColumn.setNullable(result.getInt("NULLABLE") != 0);
                            if (modelDatabaseValues.dbTakeComments) {
                                dbColumn.setComment(result.getString("REMARKS"));
                            }
                            columnsForModel.add(dbColumn);
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbColumns error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block27;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbColumns error " + e2, e2);
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbColumns error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbColumns error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", columnsForModel);
        return columnsForModel;
    }

    @Override
    public List<DbTable> getDbProcedures(EObject model, String table) {
        List<DbTable> tablesForModel;
        String m;
        block23: {
            m = "getDbProcedures";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null || modelDatabaseValues.dbSkipProcedures) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<DbTable>> allTablesForModel = this.dbProcedures.get(modelDatabaseValues.dir);
            if (allTablesForModel == null) {
                allTablesForModel = Collections.synchronizedMap(new HashMap());
                this.dbProcedures.put(modelDatabaseValues.dir, allTablesForModel);
                doInit = true;
            }
            if ((tablesForModel = allTablesForModel.get(table)) == null) {
                tablesForModel = Collections.synchronizedList(new ArrayList());
                allTablesForModel.put(table, tablesForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", tablesForModel);
                return tablesForModel;
            }
            if (modelDatabaseValues.connection != null) {
                DbResolver.DbType dbType = this.getDbType(model);
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getProcedures(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table));
                        while (result.next()) {
                            int ix;
                            String name = result.getString("PROCEDURE_NAME");
                            if (dbType == DbResolver.DbType.MS_SQL && (ix = name.lastIndexOf(";")) >= 0) {
                                name = name.substring(0, ix);
                            }
                            DbTable dbTable = new DbTable();
                            dbTable.setName(this.name(modelDatabaseValues, name));
                            dbTable.setPtype(result.getShort("PROCEDURE_TYPE"));
                            if (modelDatabaseValues.dbTakeComments) {
                                dbTable.setComment(result.getString("REMARKS"));
                            }
                            tablesForModel.add(dbTable);
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbProcedures error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block23;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbProcedures error " + e2, e2);
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbProcedures error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbProcedures error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", tablesForModel);
        return tablesForModel;
    }

    @Override
    public List<DbColumn> getDbProcColumns(EObject model, String procedure) {
        List<DbColumn> columnsForModel;
        String m;
        block28: {
            m = "getDbProcColumns";
            this.debug.debug(m, ">>> " + procedure);
            if (procedure == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null || modelDatabaseValues.dbSkipProcedures) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<DbColumn>> allColumnsForModel = this.dbProcColumns.get(modelDatabaseValues.dir);
            if (allColumnsForModel == null) {
                allColumnsForModel = Collections.synchronizedMap(new HashMap());
                this.dbProcColumns.put(modelDatabaseValues.dir, allColumnsForModel);
                doInit = true;
            }
            if ((columnsForModel = allColumnsForModel.get(procedure)) == null) {
                columnsForModel = Collections.synchronizedList(new ArrayList());
                allColumnsForModel.put(procedure, columnsForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", columnsForModel);
                return columnsForModel;
            }
            if (modelDatabaseValues.connection != null) {
                DbResolver.DbType dbType = this.getDbType(model);
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getProcedureColumns(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, procedure), null);
                        while (result.next()) {
                            DbColumn dbColumn = new DbColumn();
                            String name = result.getString("COLUMN_NAME");
                            if (dbType == DbResolver.DbType.MS_SQL && name.startsWith("@")) {
                                name = name.substring(1);
                            }
                            dbColumn.setName(this.name(modelDatabaseValues, name));
                            dbColumn.setType(result.getString("TYPE_NAME"));
                            dbColumn.setColumnType(result.getShort("COLUMN_TYPE"));
                            int ix = dbColumn.getType().indexOf(40);
                            if (ix > 0) {
                                String size = dbColumn.getType().substring(ix + 1);
                                dbColumn.setType(dbColumn.getType().substring(0, ix));
                                ix = size.indexOf(41);
                                if (ix > 0) {
                                    size = size.substring(0, ix);
                                }
                                try {
                                    dbColumn.setSize(Integer.parseInt(size));
                                }
                                catch (Exception exception) {}
                            } else {
                                dbColumn.setSize(result.getInt("LENGTH"));
                            }
                            dbColumn.setSqlType(result.getInt("DATA_TYPE"));
                            dbColumn.setNullable(result.getInt("NULLABLE") != 0);
                            if (modelDatabaseValues.dbTakeComments) {
                                dbColumn.setComment(result.getString("REMARKS"));
                            }
                            columnsForModel.add(dbColumn);
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbProcColumns error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block28;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbProcColumns error " + e2, e2);
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbProcColumns error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbProcColumns error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", columnsForModel);
        return columnsForModel;
    }

    @Override
    public List<DbTable> getDbFunctions(EObject model, String table) {
        List<DbTable> tablesForModel;
        String m;
        block25: {
            m = "getDbFunctions";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null || modelDatabaseValues.dbSkipProcedures) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<DbTable>> allTablesForModel = this.dbFunctions.get(modelDatabaseValues.dir);
            if (allTablesForModel == null) {
                allTablesForModel = Collections.synchronizedMap(new HashMap());
                this.dbFunctions.put(modelDatabaseValues.dir, allTablesForModel);
                doInit = true;
            }
            if ((tablesForModel = allTablesForModel.get(table)) == null) {
                tablesForModel = Collections.synchronizedList(new ArrayList());
                allTablesForModel.put(table, tablesForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", tablesForModel);
                return tablesForModel;
            }
            if (modelDatabaseValues.connection != null) {
                DbResolver.DbType dbType = this.getDbType(model);
                if (dbType == DbResolver.DbType.POSTGRESQL || dbType == DbResolver.DbType.INFORMIX) {
                    return tablesForModel;
                }
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getFunctions(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table));
                        while (result.next()) {
                            int ix;
                            String name = result.getString("FUNCTION_NAME");
                            if (dbType == DbResolver.DbType.MS_SQL && (ix = name.lastIndexOf(";")) >= 0) {
                                name = name.substring(0, ix);
                            }
                            DbTable dbTable = new DbTable();
                            dbTable.setName(this.name(modelDatabaseValues, name));
                            if (dbType != DbResolver.DbType.DB2 && dbType != DbResolver.DbType.ORACLE) {
                                dbTable.setFtype(result.getShort("FUNCTION_TYPE"));
                            }
                            if (modelDatabaseValues.dbTakeComments) {
                                dbTable.setComment(result.getString("REMARKS"));
                            }
                            tablesForModel.add(dbTable);
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbFunctions error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block25;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbFunctions error " + e2, e2);
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbFunctions error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbFunctions error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", tablesForModel);
        return tablesForModel;
    }

    @Override
    public List<DbColumn> getDbFunColumns(EObject model, String function) {
        List<DbColumn> columnsForModel;
        String m;
        block28: {
            m = "getDbFunColumns";
            this.debug.debug(m, ">>> " + function);
            if (function == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null || modelDatabaseValues.dbSkipProcedures) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<DbColumn>> allColumnsForModel = this.dbFunColumns.get(modelDatabaseValues.dir);
            if (allColumnsForModel == null) {
                allColumnsForModel = Collections.synchronizedMap(new HashMap());
                this.dbFunColumns.put(modelDatabaseValues.dir, allColumnsForModel);
                doInit = true;
            }
            if ((columnsForModel = allColumnsForModel.get(function)) == null) {
                columnsForModel = Collections.synchronizedList(new ArrayList());
                allColumnsForModel.put(function, columnsForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", columnsForModel);
                return columnsForModel;
            }
            if (modelDatabaseValues.connection != null) {
                DbResolver.DbType dbType = this.getDbType(model);
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getFunctionColumns(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, function), null);
                        while (result.next()) {
                            String name = result.getString(dbType == DbResolver.DbType.DB2 ? "PARAMETER_NAME" : "COLUMN_NAME");
                            if (dbType == DbResolver.DbType.MS_SQL && name.startsWith("@")) {
                                name = name.substring(1);
                            }
                            DbColumn dbColumn = new DbColumn();
                            dbColumn.setName(this.name(modelDatabaseValues, name));
                            dbColumn.setType(result.getString("TYPE_NAME"));
                            dbColumn.setColumnType(result.getShort(dbType == DbResolver.DbType.DB2 ? "PARAMETER_TYPE" : "COLUMN_TYPE"));
                            int ix = dbColumn.getType().indexOf(40);
                            if (ix > 0) {
                                String size = dbColumn.getType().substring(ix + 1);
                                dbColumn.setType(dbColumn.getType().substring(0, ix));
                                ix = size.indexOf(41);
                                if (ix > 0) {
                                    size = size.substring(0, ix);
                                }
                                try {
                                    dbColumn.setSize(Integer.parseInt(size));
                                }
                                catch (Exception exception) {}
                            } else {
                                dbColumn.setSize(result.getInt("LENGTH"));
                            }
                            dbColumn.setSqlType(result.getInt("DATA_TYPE"));
                            dbColumn.setNullable(result.getInt("NULLABLE") != 0);
                            if (modelDatabaseValues.dbTakeComments) {
                                dbColumn.setComment(result.getString("REMARKS"));
                            }
                            columnsForModel.add(dbColumn);
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbFunColumns error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block28;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbFunColumns error " + e2, e2);
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbFunColumns error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbFunColumns error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", columnsForModel);
        return columnsForModel;
    }

    @Override
    public List<String> getDbPrimaryKeys(EObject model, String table) {
        List<String> primaryKeysForModel;
        String m;
        block21: {
            m = "getDbPrimaryKeys";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<String>> allPrimaryKeysForModel = this.dbPrimaryKeys.get(modelDatabaseValues.dir);
            if (allPrimaryKeysForModel == null) {
                allPrimaryKeysForModel = Collections.synchronizedMap(new HashMap());
                this.dbPrimaryKeys.put(modelDatabaseValues.dir, allPrimaryKeysForModel);
                doInit = true;
            }
            if ((primaryKeysForModel = allPrimaryKeysForModel.get(table)) == null) {
                primaryKeysForModel = Collections.synchronizedList(new ArrayList());
                allPrimaryKeysForModel.put(table, primaryKeysForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", primaryKeysForModel);
                return primaryKeysForModel;
            }
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getPrimaryKeys(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table));
                        while (result.next()) {
                            primaryKeysForModel.add(this.name(modelDatabaseValues, result.getString("COLUMN_NAME")));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbPrimaryKeys error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block21;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbPrimaryKeys error " + e2, e2);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbPrimaryKeys error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbPrimaryKeys error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", primaryKeysForModel);
        return primaryKeysForModel;
    }

    @Override
    public List<DbExport> getDbExports(EObject model, String table) {
        List<DbExport> exportsForModel;
        String m;
        block21: {
            m = "getDbExports";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<DbExport>> allExportsForModel = this.dbExports.get(modelDatabaseValues.dir);
            if (allExportsForModel == null) {
                allExportsForModel = Collections.synchronizedMap(new HashMap());
                this.dbExports.put(modelDatabaseValues.dir, allExportsForModel);
                doInit = true;
            }
            if ((exportsForModel = allExportsForModel.get(table)) == null) {
                exportsForModel = Collections.synchronizedList(new ArrayList());
                allExportsForModel.put(table, exportsForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", exportsForModel);
                return exportsForModel;
            }
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getExportedKeys(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table));
                        while (result.next()) {
                            DbExport dbExport = new DbExport();
                            dbExport.setPkTable(this.name(modelDatabaseValues, result.getString("PKTABLE_NAME")));
                            dbExport.setPkColumn(this.name(modelDatabaseValues, result.getString("PKCOLUMN_NAME")));
                            dbExport.setFkTable(this.name(modelDatabaseValues, result.getString("FKTABLE_NAME")));
                            dbExport.setFkColumn(this.name(modelDatabaseValues, result.getString("FKCOLUMN_NAME")));
                            dbExport.setFkName(this.name(modelDatabaseValues, result.getString("FK_NAME")));
                            dbExport.setPkName(this.name(modelDatabaseValues, result.getString("PK_NAME")));
                            exportsForModel.add(dbExport);
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbExports error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block21;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbExports error " + e2, e2);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbExports error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbExports error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", exportsForModel);
        return exportsForModel;
    }

    @Override
    public List<DbImport> getDbImports(EObject model, String table) {
        List<DbImport> importsForModel;
        String m;
        block21: {
            m = "getDbImports";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<DbImport>> allImportsForModel = this.dbImports.get(modelDatabaseValues.dir);
            if (allImportsForModel == null) {
                allImportsForModel = Collections.synchronizedMap(new HashMap());
                this.dbImports.put(modelDatabaseValues.dir, allImportsForModel);
                doInit = true;
            }
            if ((importsForModel = allImportsForModel.get(table)) == null) {
                importsForModel = Collections.synchronizedList(new ArrayList());
                allImportsForModel.put(table, importsForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", importsForModel);
                return importsForModel;
            }
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getImportedKeys(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table));
                        while (result.next()) {
                            DbImport dbImport = new DbImport();
                            dbImport.setPkTable(this.name(modelDatabaseValues, result.getString("PKTABLE_NAME")));
                            dbImport.setPkColumn(this.name(modelDatabaseValues, result.getString("PKCOLUMN_NAME")));
                            dbImport.setFkTable(this.name(modelDatabaseValues, result.getString("FKTABLE_NAME")));
                            dbImport.setFkColumn(this.name(modelDatabaseValues, result.getString("FKCOLUMN_NAME")));
                            dbImport.setFkName(this.name(modelDatabaseValues, result.getString("FK_NAME")));
                            dbImport.setPkName(this.name(modelDatabaseValues, result.getString("PK_NAME")));
                            importsForModel.add(dbImport);
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbImports error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block21;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbImports error " + e2, e2);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbImports error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbImports error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", importsForModel);
        return importsForModel;
    }

    @Override
    public String getType(EObject model, String table, String column) {
        int typeSize;
        String type;
        String m;
        block22: {
            m = "getType";
            this.debug.trace(m, ">>> " + table + " " + column);
            if (table == null || column == null) {
                this.debug.trace(m, "<<<");
                return "";
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.trace(m, "<<<");
                return "";
            }
            ResultSet result = null;
            type = null;
            typeSize = 0;
            try {
                try {
                    DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                    result = meta.getColumns(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table), null);
                    while (result.next()) {
                        if (!this.name(modelDatabaseValues, result.getString("COLUMN_NAME")).equals(column)) continue;
                        type = result.getString("TYPE_NAME");
                        int ix = type.indexOf(40);
                        if (ix > 0) {
                            String size = type.substring(ix + 1);
                            type = type.substring(0, ix);
                            ix = size.indexOf(41);
                            if (ix > 0) {
                                size = size.substring(0, ix);
                            }
                            try {
                                typeSize = Integer.parseInt(size);
                            }
                            catch (Exception exception) {}
                        } else {
                            typeSize = result.getInt("COLUMN_SIZE");
                        }
                        break;
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getType error " + e, e);
                    try {
                        if (result != null) {
                            result.close();
                        }
                        break block22;
                    }
                    catch (SQLException e2) {
                        this.debug.error("getType error " + e2, e2);
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getType error " + e, e);
                }
                throw throwable;
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException e) {
                this.debug.error("getType error " + e, e);
            }
        }
        this.debug.trace(m, "<<<", String.valueOf(type) + "(" + typeSize + ")");
        return String.valueOf(type) + "(" + typeSize + ")";
    }

    @Override
    public String getProcType(EObject model, String procedure, String column) {
        int typeSize;
        String type;
        String m;
        block22: {
            m = "getProcType";
            this.debug.trace(m, ">>> " + procedure + " " + column);
            if (procedure == null || column == null) {
                this.debug.trace(m, "<<<");
                return "";
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.trace(m, "<<<");
                return "";
            }
            ResultSet result = null;
            type = null;
            typeSize = 0;
            try {
                try {
                    DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                    result = meta.getProcedureColumns(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, procedure), null);
                    while (result.next()) {
                        if (!column.equals(this.name(modelDatabaseValues, result.getString("COLUMN_NAME")))) continue;
                        type = result.getString("TYPE_NAME");
                        int ix = type.indexOf(40);
                        if (ix > 0) {
                            String size = type.substring(ix + 1);
                            type = type.substring(0, ix);
                            ix = size.indexOf(41);
                            if (ix > 0) {
                                size = size.substring(0, ix);
                            }
                            try {
                                typeSize = Integer.parseInt(size);
                            }
                            catch (Exception exception) {}
                        } else {
                            typeSize = result.getInt("LENGTH");
                        }
                        break;
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbProcType error " + e, e);
                    try {
                        if (result != null) {
                            result.close();
                        }
                        break block22;
                    }
                    catch (SQLException e2) {
                        this.debug.error("getDbProcType error " + e2, e2);
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbProcType error " + e, e);
                }
                throw throwable;
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException e) {
                this.debug.error("getDbProcType error " + e, e);
            }
        }
        this.debug.trace(m, "<<<", String.valueOf(type) + "(" + typeSize + ")");
        return String.valueOf(type) + "(" + typeSize + ")";
    }

    @Override
    public String getFunType(EObject model, String function, String column) {
        int typeSize;
        String type;
        String m;
        block22: {
            m = "getFunType";
            this.debug.trace(m, ">>> " + function + " " + column);
            if (function == null || column == null) {
                this.debug.trace(m, "<<<");
                return "";
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.trace(m, "<<<");
                return "";
            }
            DbResolver.DbType dbType = this.getDbType(model);
            ResultSet result = null;
            type = null;
            typeSize = 0;
            try {
                try {
                    DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                    result = meta.getFunctionColumns(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, function), null);
                    while (result.next()) {
                        if (!column.equals(this.name(modelDatabaseValues, result.getString(dbType == DbResolver.DbType.DB2 ? "PARAMETER_NAME" : "COLUMN_NAME")))) continue;
                        type = result.getString("TYPE_NAME");
                        int ix = type.indexOf(40);
                        if (ix > 0) {
                            String size = type.substring(ix + 1);
                            type = type.substring(0, ix);
                            ix = size.indexOf(41);
                            if (ix > 0) {
                                size = size.substring(0, ix);
                            }
                            try {
                                typeSize = Integer.parseInt(size);
                            }
                            catch (Exception exception) {}
                        } else {
                            typeSize = result.getInt("LENGTH");
                        }
                        break;
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbFunType error " + e, e);
                    try {
                        if (result != null) {
                            result.close();
                        }
                        break block22;
                    }
                    catch (SQLException e2) {
                        this.debug.error("getDbFunType error " + e2, e2);
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbFunType error " + e, e);
                }
                throw throwable;
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException e) {
                this.debug.error("getDbFunType error " + e, e);
            }
        }
        this.debug.trace(m, "<<<", String.valueOf(type) + "(" + typeSize + ")");
        return String.valueOf(type) + "(" + typeSize + ")";
    }

    @Override
    public List<DbIndex> getDbIndexes(EObject model, String table) {
        List<DbIndex> indexesForModel;
        String m;
        block24: {
            m = "getDbIndexes";
            this.debug.debug(m, ">>> " + table);
            if (table == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null || modelDatabaseValues.indexTypes == null || modelDatabaseValues.indexTypes.isEmpty() || modelDatabaseValues.dbSkipIndexes) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            boolean doInit = false;
            Map<String, List<DbIndex>> allIndexesForModel = this.dbIndexes.get(modelDatabaseValues.dir);
            if (allIndexesForModel == null) {
                allIndexesForModel = Collections.synchronizedMap(new HashMap());
                this.dbIndexes.put(modelDatabaseValues.dir, allIndexesForModel);
                doInit = true;
            }
            if ((indexesForModel = allIndexesForModel.get(table)) == null) {
                indexesForModel = Collections.synchronizedList(new ArrayList());
                allIndexesForModel.put(table, indexesForModel);
                doInit = true;
            }
            if (!doInit) {
                this.debug.debug(m, "<<<", indexesForModel);
                return indexesForModel;
            }
            if (modelDatabaseValues.connection != null) {
                DbResolver.DbType dbType = this.getDbType(model);
                ResultSet result = null;
                try {
                    try {
                        LinkedHashMap<String, DbIndex> mapOfIndexes = new LinkedHashMap<String, DbIndex>();
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getIndexInfo(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, this.origName(model, modelDatabaseValues, table), false, true);
                        int addToPosition = 0;
                        while (result.next()) {
                            if (dbType == DbResolver.DbType.INFORMIX && result.getShort("ORDINAL_POSITION") == 0) continue;
                            String name = this.name(modelDatabaseValues, result.getString("INDEX_NAME"));
                            if (!modelDatabaseValues.indexTypes.contains(result.getShort("TYPE"))) {
                                this.LOGGER.warn((Object)("INDEX TYPE " + result.getShort("TYPE") + " for " + name));
                                continue;
                            }
                            DbIndex dbIndex = (DbIndex)mapOfIndexes.get(name);
                            if (dbIndex == null) {
                                dbIndex = new DbIndex();
                                dbIndex.setName(name);
                                mapOfIndexes.put(name, dbIndex);
                            }
                            DbIndex.DbIndexDetail detail = new DbIndex.DbIndexDetail();
                            short position = result.getShort("ORDINAL_POSITION");
                            detail.setColname(this.name(modelDatabaseValues, result.getString("COLUMN_NAME")));
                            detail.setDesc("D".equalsIgnoreCase(result.getString("ASC_OR_DESC")));
                            if (position == 0) {
                                addToPosition = 1;
                            }
                            dbIndex.getColumns().add(position - 1 + addToPosition, detail);
                        }
                        indexesForModel.addAll(mapOfIndexes.values());
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbIndexes error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block24;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getDbIndexes error " + e2, e2);
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getDbIndexes error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getDbIndexes error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", indexesForModel);
        return indexesForModel;
    }

    @Override
    public List<String> getSequences(EObject model) {
        List<String> sequencesForModel;
        String m;
        block18: {
            m = "getSequences";
            this.debug.debug(m, ">>>");
            DatabaseDirectives modelDatabaseValues = this.getConnection(model);
            if (modelDatabaseValues == null) {
                this.debug.debug(m, "<<<");
                return Collections.emptyList();
            }
            sequencesForModel = this.dbSequences.get(modelDatabaseValues.dir);
            if (sequencesForModel != null) {
                this.debug.debug(m, "<<<");
                return sequencesForModel;
            }
            sequencesForModel = Collections.synchronizedList(new ArrayList());
            this.dbSequences.put(modelDatabaseValues.dir, sequencesForModel);
            if (modelDatabaseValues.connection != null) {
                ResultSet result = null;
                try {
                    try {
                        DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                        result = meta.getTables(modelDatabaseValues.dbCatalog, modelDatabaseValues.dbSchema, null, new String[]{"SEQUENCE"});
                        while (result.next()) {
                            String name;
                            String type = result.getString("TABLE_TYPE");
                            if (type != null && (type.toUpperCase().indexOf("TABLE") >= 0 || type.toUpperCase().indexOf("VIEW") >= 0) || (name = result.getString("TABLE_NAME")).startsWith(" ")) continue;
                            sequencesForModel.add(this.name(modelDatabaseValues, name));
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getSequences error " + e, e);
                        try {
                            if (result != null) {
                                result.close();
                            }
                            break block18;
                        }
                        catch (SQLException e2) {
                            this.debug.error("getSequences error " + e2, e2);
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    catch (SQLException e) {
                        this.debug.error("getSequences error " + e, e);
                    }
                    throw throwable;
                }
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    this.debug.error("getSequences error " + e, e);
                }
            }
        }
        this.debug.debug(m, "<<<", sequencesForModel);
        return sequencesForModel;
    }

    @Override
    public String getDbMetaInfo(EObject model) {
        String m = "getDbMetaInfo";
        this.debug.trace(m, ">>>");
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        if (modelDatabaseValues == null) {
            this.debug.trace(m, "<<<");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
            sb.append(meta.getDatabaseProductName());
            sb.append(",").append(meta.getDatabaseProductVersion());
            sb.append(",").append(meta.getDatabaseMajorVersion());
            sb.append(",").append(meta.getDatabaseMinorVersion());
        }
        catch (SQLException e) {
            this.debug.error("getDbMetaInfo error " + e, e);
        }
        this.debug.trace(m, "<<<", sb);
        return sb.toString();
    }

    @Override
    public String getDbDriverInfo(EObject model) {
        String m = "getDbDriverInfo";
        this.debug.trace(m, ">>>");
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        if (modelDatabaseValues == null) {
            this.debug.trace(m, "<<<");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
            sb.append(meta.getDriverName());
            sb.append(",").append(meta.getDriverVersion());
            sb.append(",").append(meta.getDriverMajorVersion());
            sb.append(",").append(meta.getDriverMinorVersion());
        }
        catch (SQLException e) {
            this.debug.error("getDbDriverInfo error " + e, e);
        }
        this.debug.trace(m, "<<<", sb);
        return sb.toString();
    }

    @Override
    public String getDbJdbcInfo(EObject model) {
        String m = "getDbJdbcInfo";
        this.debug.trace(m, ">>>");
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        if (modelDatabaseValues == null) {
            this.debug.trace(m, "<<<");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
            sb.append(meta.getJDBCMajorVersion());
            sb.append(",").append(meta.getJDBCMinorVersion());
        }
        catch (SQLException e) {
            this.debug.error("getDbJdbcInfo error " + e, e);
        }
        this.debug.trace(m, "<<<", sb);
        return sb.toString();
    }

    @Override
    public Set<String> getDriverMethods(EObject model) {
        String m = "getDriverMethods";
        this.debug.trace(m, ">>>");
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        if (modelDatabaseValues == null) {
            this.debug.trace(m, "<<<");
            return Collections.emptySet();
        }
        SortedSet<String> driverMethodsForModel = this.driverMethods.get(modelDatabaseValues.dir);
        if (driverMethodsForModel != null) {
            this.debug.trace(m, "<<<");
            return driverMethodsForModel;
        }
        driverMethodsForModel = Collections.synchronizedSortedSet(new TreeSet());
        this.driverMethods.put(modelDatabaseValues.dir, driverMethodsForModel);
        if (modelDatabaseValues.connection != null) {
            try {
                DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                Method[] methodArray = meta.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method mm = methodArray[n2];
                    if (!(mm.getParameterTypes().length > 0 || mm.getReturnType() != null && mm.getReturnType().equals(ResultSet.class) || mm.getReturnType() != null && mm.getReturnType().equals(Connection.class))) {
                        driverMethodsForModel.add(mm.getName());
                    }
                    ++n2;
                }
            }
            catch (SQLException e) {
                this.debug.error("getDriverMethods error " + e, e);
            }
            catch (SecurityException e) {
                this.debug.error("getDriverMethods error " + e, e);
            }
        }
        this.debug.trace(m, "<<<", driverMethodsForModel);
        driverMethodsForModel.add("getCatalogs");
        driverMethodsForModel.add("getSchemas");
        driverMethodsForModel.add("getTables");
        driverMethodsForModel.add("getProcedures");
        driverMethodsForModel.add("getFunctions");
        return driverMethodsForModel;
    }

    @Override
    public Object getDriverMethodOutput(EObject model, String methodName) {
        String m = "getDriverMethodOutput";
        this.debug.trace(m, ">>> " + methodName);
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        if (modelDatabaseValues == null) {
            this.debug.trace(m, "<<<");
            return null;
        }
        Object methodCallOutput = null;
        if ("getCatalogs".equals(methodName)) {
            methodCallOutput = this.getCatalogs(model);
        } else if ("getSchemas".equals(methodName)) {
            methodCallOutput = this.getSchemas(model);
        } else if ("getTables".equals(methodName)) {
            methodCallOutput = this.getTables(model);
        } else if ("getProcedures".equals(methodName)) {
            methodCallOutput = this.getProcedures(model);
        } else if ("getFunctions".equals(methodName)) {
            methodCallOutput = this.getFunctions(model);
        } else {
            try {
                DatabaseMetaData meta = modelDatabaseValues.connection.getMetaData();
                Method mm = meta.getClass().getMethod(methodName, new Class[0]);
                methodCallOutput = mm.invoke((Object)meta, new Object[0]);
            }
            catch (SQLException e) {
                this.debug.error("getDriverMethodOutput error " + e, e);
            }
            catch (NoSuchMethodException e) {
                this.debug.error("getDriverMethodOutput error " + e, e);
            }
            catch (SecurityException e) {
                this.debug.error("getDriverMethodOutput error " + e, e);
            }
            catch (IllegalAccessException e) {
                this.debug.error("getDriverMethodOutput error " + e, e);
            }
            catch (IllegalArgumentException e) {
                this.debug.error("getDriverMethodOutput error " + e, e);
            }
            catch (InvocationTargetException e) {
                this.debug.error("getDriverMethodOutput error " + e, e);
            }
        }
        this.debug.trace(m, "<<<", methodCallOutput);
        return methodCallOutput;
    }

    @Override
    public List<String> getCheckConstraints(EObject model) {
        String m = "getCheckConstraints";
        this.debug.debug(m, ">>>");
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        if (modelDatabaseValues == null) {
            this.debug.debug(m, "<<<");
            return Collections.emptyList();
        }
        List<String> checkConstraintsForModel = this.checkConstraints.get(modelDatabaseValues.dir);
        if (checkConstraintsForModel != null) {
            this.debug.debug(m, "<<<");
            return checkConstraintsForModel;
        }
        checkConstraintsForModel = Collections.synchronizedList(new ArrayList());
        this.checkConstraints.put(modelDatabaseValues.dir, checkConstraintsForModel);
        if (modelDatabaseValues.connection != null) {
            try {
                DbResolver.DbType dbType = this.getDbType(model);
                Map<String, DbCheckConstraint> mapOfCheckConstraints = this.getCheckConstraints(modelDatabaseValues, null, dbType);
                for (DbCheckConstraint check : mapOfCheckConstraints.values()) {
                    checkConstraintsForModel.add(this.name(modelDatabaseValues, check.getEnumName()));
                }
            }
            catch (SQLException e) {
                this.debug.error("getCheckConstraints error " + e, e);
            }
        }
        this.debug.debug(m, "<<<", checkConstraintsForModel);
        return checkConstraintsForModel;
    }

    @Override
    public List<String> getCheckColumns(EObject model, String table) {
        List<String> checkColumnsForModel;
        String m = "getCheckColumns";
        this.debug.debug(m, ">>> " + table);
        if (table == null) {
            this.debug.debug(m, "<<<");
            return Collections.emptyList();
        }
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        if (modelDatabaseValues == null) {
            this.debug.debug(m, "<<<");
            return Collections.emptyList();
        }
        boolean doInit = false;
        Map<String, List<String>> allCheckColumnsForModel = this.checkColumns.get(modelDatabaseValues.dir);
        if (allCheckColumnsForModel == null) {
            allCheckColumnsForModel = Collections.synchronizedMap(new HashMap());
            this.checkColumns.put(modelDatabaseValues.dir, allCheckColumnsForModel);
            doInit = true;
        }
        if ((checkColumnsForModel = allCheckColumnsForModel.get(table)) == null) {
            checkColumnsForModel = Collections.synchronizedList(new ArrayList());
            allCheckColumnsForModel.put(table, checkColumnsForModel);
            doInit = true;
        }
        if (!doInit) {
            this.debug.debug(m, "<<<", checkColumnsForModel);
            return checkColumnsForModel;
        }
        if (modelDatabaseValues.connection != null) {
            try {
                DbResolver.DbType dbType = this.getDbType(model);
                Map<String, DbCheckConstraint> mapOfCheckConstraints = this.getCheckConstraints(modelDatabaseValues, null, dbType);
                for (DbCheckConstraint check : mapOfCheckConstraints.values()) {
                    if (!table.equals(check.getEnumName())) continue;
                    for (String val : check.getValues()) {
                        if (val.isEmpty()) continue;
                        if (Character.isDigit(val.charAt(0))) {
                            checkColumnsForModel.add("I" + val);
                            continue;
                        }
                        checkColumnsForModel.add(val);
                    }
                    break;
                }
            }
            catch (SQLException e) {
                this.debug.error("getCheckColumns error " + e, e);
            }
        }
        this.debug.debug(m, "<<<", checkColumnsForModel);
        return checkColumnsForModel;
    }

    @Override
    public List<DbCheckConstraint> getDbCheckConstraints(EObject model, String table) {
        List<DbCheckConstraint> checkConstraintsForModel;
        String m = "getDbCheckConstraints";
        this.debug.debug(m, ">>> " + table);
        if (table == null) {
            this.debug.debug(m, "<<<");
            return Collections.emptyList();
        }
        DatabaseDirectives modelDatabaseValues = this.getConnection(model);
        if (modelDatabaseValues == null || modelDatabaseValues.dbSkipCheckConstraints) {
            this.debug.debug(m, "<<<");
            return Collections.emptyList();
        }
        boolean doInit = false;
        Map<String, List<DbCheckConstraint>> allCheckConstraintsForModel = this.dbChecksConstraints.get(modelDatabaseValues.dir);
        if (allCheckConstraintsForModel == null) {
            allCheckConstraintsForModel = Collections.synchronizedMap(new HashMap());
            this.dbChecksConstraints.put(modelDatabaseValues.dir, allCheckConstraintsForModel);
            doInit = true;
        }
        if ((checkConstraintsForModel = allCheckConstraintsForModel.get(table)) == null) {
            checkConstraintsForModel = Collections.synchronizedList(new ArrayList());
            allCheckConstraintsForModel.put(table, checkConstraintsForModel);
            doInit = true;
        }
        if (!doInit) {
            this.debug.debug(m, "<<<", checkConstraintsForModel);
            return checkConstraintsForModel;
        }
        if (modelDatabaseValues.connection != null) {
            try {
                DbResolver.DbType dbType = this.getDbType(model);
                Map<String, DbCheckConstraint> mapOfCheckConstraints = this.getCheckConstraints(modelDatabaseValues, this.origName(model, modelDatabaseValues, table), dbType);
                for (DbCheckConstraint check : mapOfCheckConstraints.values()) {
                    check.setTable(this.name(modelDatabaseValues, check.getTable()));
                    check.setColumn(this.name(modelDatabaseValues, check.getColumn()));
                }
                checkConstraintsForModel.addAll(mapOfCheckConstraints.values());
            }
            catch (SQLException e) {
                this.debug.error("getDbCheckConstraints error " + e, e);
            }
        }
        this.debug.debug(m, "<<<", checkConstraintsForModel);
        return checkConstraintsForModel;
    }

    private Map<String, DbCheckConstraint> getCheckConstraints(DatabaseDirectives modelDatabaseValues, String table, DbResolver.DbType dbType) throws SQLException {
        LinkedHashMap<String, DbCheckConstraint> mapOfCheckConstraints = new LinkedHashMap<String, DbCheckConstraint>();
        if (dbType == DbResolver.DbType.HSQLDB) {
            String query = "select tc.TABLE_NAME, tc.CONSTRAINT_NAME, cc.CHECK_CLAUSE from INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc, INFORMATION_SCHEMA.CHECK_CONSTRAINTS cc where tc.CONSTRAINT_NAME = cc.CONSTRAINT_NAME and tc.CONSTRAINT_TYPE = 'CHECK' and tc.TABLE_NAME = ?";
            String query2 = "select tc.TABLE_NAME, tc.CONSTRAINT_NAME, cc.CHECK_CLAUSE from INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc, INFORMATION_SCHEMA.CHECK_CONSTRAINTS cc where tc.CONSTRAINT_NAME = cc.CONSTRAINT_NAME and tc.CONSTRAINT_TYPE = 'CHECK'";
            Map<String, List<String>> map = this.getCheckConstraints(modelDatabaseValues, table, query, query2, false);
            for (String constraintName : map.keySet()) {
                DbCheckConstraint check = DbCheckConstraint.parseHsqldb(constraintName, map.get(constraintName).get(0));
                if (check == null) continue;
                mapOfCheckConstraints.put(constraintName, check);
            }
        } else if (dbType == DbResolver.DbType.ORACLE) {
            String query = "select TABLE_NAME, CONSTRAINT_NAME, SEARCH_CONDITION from USER_CONSTRAINTS where TABLE_NAME not like 'BIN%' and CONSTRAINT_TYPE = 'C' and TABLE_NAME = ?";
            String query2 = "select TABLE_NAME, CONSTRAINT_NAME, SEARCH_CONDITION from USER_CONSTRAINTS where TABLE_NAME not like 'BIN%' and CONSTRAINT_TYPE = 'C'";
            Map<String, List<String>> map = this.getCheckConstraints(modelDatabaseValues, table, query, query2, false);
            for (String constraintName : map.keySet()) {
                DbCheckConstraint check = DbCheckConstraint.parseOracle(constraintName, map.get(constraintName).get(0), map.get(constraintName).get(1));
                if (check == null) continue;
                mapOfCheckConstraints.put(constraintName, check);
            }
        } else if (dbType == DbResolver.DbType.INFORMIX) {
            String query = "select st.tabname, ss.constrname, sc.checktext from systables st, sysconstraints ss, syschecks sc where st.tabid = ss.tabid and ss.constrid = sc.constrid and ss.constrtype = 'C' and sc.type = 'T' and st.tabname = ?";
            String query2 = "select st.tabname, ss.constrname, sc.checktext from systables st, sysconstraints ss, syschecks sc where st.tabid = ss.tabid and ss.constrid = sc.constrid and ss.constrtype = 'C' and sc.type = 'T'";
            Map<String, List<String>> map = this.getCheckConstraints(modelDatabaseValues, table, query, query2, false);
            for (String constraintName : map.keySet()) {
                DbCheckConstraint check = DbCheckConstraint.parseInformix(constraintName, map.get(constraintName).get(0), map.get(constraintName).get(1));
                if (check == null) continue;
                mapOfCheckConstraints.put(constraintName, check);
            }
        } else if (dbType == DbResolver.DbType.MY_SQL) {
            String query = "select TABLE_NAME,COLUMN_NAME,COLUMN_TYPE from information_schema.COLUMNS where DATA_TYPE = \"enum\" and TABLE_NAME = ?";
            String query2 = "select TABLE_NAME,COLUMN_NAME,COLUMN_TYPE from information_schema.COLUMNS where DATA_TYPE = \"enum\"";
            Map<String, List<String>> map = this.getCheckConstraints(modelDatabaseValues, table, query, query2, true);
            for (String constraintName : map.keySet()) {
                DbCheckConstraint check = DbCheckConstraint.parseMysql(map.get(constraintName).get(2), map.get(constraintName).get(0), map.get(constraintName).get(1));
                if (check == null) continue;
                mapOfCheckConstraints.put(constraintName, check);
            }
        } else if (dbType == DbResolver.DbType.POSTGRESQL) {
            String query = "select ccu.table_name, ccu.column_name, cc.check_clause from information_schema.constraint_column_usage ccu, information_schema.check_constraints cc where ccu.constraint_name = cc.constraint_name and ccu.table_name = ?";
            String query2 = "select ccu.table_name, ccu.column_name, cc.check_clause from information_schema.constraint_column_usage ccu, information_schema.check_constraints cc where ccu.constraint_name = cc.constraint_name";
            Map<String, List<String>> map = this.getCheckConstraints(modelDatabaseValues, table, query, query2, true);
            for (String constraintName : map.keySet()) {
                DbCheckConstraint check = DbCheckConstraint.parsePostgresql(map.get(constraintName).get(2), map.get(constraintName).get(0), map.get(constraintName).get(1));
                if (check == null) continue;
                mapOfCheckConstraints.put(constraintName, check);
            }
        } else if (dbType == DbResolver.DbType.DB2) {
            String query = "select cc.TABNAME, cc.COLNAME, ch.TEXT from SYSCAT.COLCHECKS cc, SYSCAT.CHECKS ch where cc.TABNAME = ch.TABNAME and cc.CONSTNAME = ch.CONSTNAME and ch.TYPE = 'C' and cc.TABNAME = ?";
            String query2 = "select cc.TABNAME, cc.COLNAME, ch.TEXT from SYSCAT.COLCHECKS cc, SYSCAT.CHECKS ch where cc.TABNAME = ch.TABNAME and cc.CONSTNAME = ch.CONSTNAME and ch.TYPE = 'C'";
            Map<String, List<String>> map = this.getCheckConstraints(modelDatabaseValues, table, query, query2, true);
            for (String constraintName : map.keySet()) {
                DbCheckConstraint check = DbCheckConstraint.parseDb2(map.get(constraintName).get(2), map.get(constraintName).get(0), map.get(constraintName).get(1));
                if (check == null) continue;
                mapOfCheckConstraints.put(constraintName, check);
            }
        } else if (dbType == DbResolver.DbType.MS_SQL) {
            String query = "select t.name, cc.name, cc.definition  from sys.tables t inner join sys.check_constraints cc on t.object_id = cc.parent_object_id where cc.type = 'C' and t.name = ?";
            String query2 = "select t.name, cc.name, cc.definition  from sys.tables t inner join sys.check_constraints cc on t.object_id = cc.parent_object_id where cc.type = 'C'";
            Map<String, List<String>> map = this.getCheckConstraints(modelDatabaseValues, table, query, query2, false);
            for (String constraintName : map.keySet()) {
                DbCheckConstraint check = DbCheckConstraint.parseMssql(constraintName, map.get(constraintName).get(0), map.get(constraintName).get(1));
                if (check == null) continue;
                mapOfCheckConstraints.put(constraintName, check);
            }
        } else {
            mapOfCheckConstraints = new LinkedHashMap();
        }
        return mapOfCheckConstraints;
    }

    private Map<String, List<String>> getCheckConstraints(DatabaseDirectives modelDatabaseValues, String table, String query, String query2, boolean combine) throws SQLException {
        LinkedHashMap<String, List<String>> mapOfCheckConstraints = new LinkedHashMap<String, List<String>>();
        ResultSet result = null;
        try {
            Statement stmt;
            if (table != null) {
                stmt = modelDatabaseValues.connection.prepareStatement(query);
                stmt.setString(1, table);
                result = stmt.executeQuery();
            } else {
                stmt = modelDatabaseValues.connection.createStatement();
                result = stmt.executeQuery(query2);
            }
            String lastTableName = null;
            String lastConstraintName = null;
            String lastCheckClause = null;
            while (result.next()) {
                String tableName = this.name(modelDatabaseValues, result.getString(1));
                String constraintName = result.getString(2);
                String checkClause = result.getString(3);
                if (lastConstraintName == null) {
                    lastTableName = tableName;
                    lastConstraintName = constraintName;
                    lastCheckClause = checkClause;
                    continue;
                }
                if (lastConstraintName.equals(constraintName)) {
                    lastCheckClause = String.valueOf(lastCheckClause) + checkClause;
                    continue;
                }
                this.addCheckConstraints(mapOfCheckConstraints, lastTableName, lastConstraintName, lastCheckClause, combine);
                lastTableName = tableName;
                lastConstraintName = constraintName;
                lastCheckClause = checkClause;
            }
            if (lastConstraintName != null) {
                this.addCheckConstraints(mapOfCheckConstraints, lastTableName, lastConstraintName, lastCheckClause, combine);
            }
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException e) {
                this.debug.error("getHsqldbCheckConstraints error " + e, e);
            }
        }
        return mapOfCheckConstraints;
    }

    private void addCheckConstraints(Map<String, List<String>> mapOfCheckConstraints, String tableName, String constraintName, String checkClause, boolean combine) {
        String m = "addCheckConstraints";
        this.debug.debug(m, String.valueOf(tableName) + " constraintName " + constraintName + ", " + " checkClause " + checkClause);
        ArrayList<String> list = new ArrayList<String>();
        list.add(checkClause);
        list.add(tableName);
        list.add(constraintName);
        if (combine) {
            mapOfCheckConstraints.put(String.valueOf(tableName) + constraintName, list);
        } else {
            mapOfCheckConstraints.put(constraintName, list);
        }
    }

    private DbResolver.DbType getDbType(EObject model) {
        DbResolver.DbType[] dbTypes;
        DbResolver.DbType dbType = this.getDatabaseDirectives((EObject)model).dbType;
        if (dbType == null && (dbTypes = DbResolver.DbType.fromDbMetaInfo(this.getDbMetaInfo(model))) != null && dbTypes.length > 0) {
            dbType = dbTypes[0];
        }
        return dbType;
    }

    private String name(DatabaseDirectives modelDatabaseValues, String s) {
        if (s == null) {
            return null;
        }
        String ss = s;
        if (this.dbOriginalNames.get(modelDatabaseValues.dir) == null) {
            this.dbOriginalNames.put(modelDatabaseValues.dir, Collections.synchronizedMap(new HashMap()));
        }
        if (modelDatabaseValues.dbUppercaseNames) {
            ss = s.toUpperCase();
        } else if (modelDatabaseValues.dbLowercaseNames) {
            ss = s.toLowerCase();
        }
        this.dbOriginalNames.get(modelDatabaseValues.dir).put(ss, s);
        return ss;
    }

    private String origName(EObject model, DatabaseDirectives modelDatabaseValues, String s) {
        String ss = s;
        if (s != null) {
            if (this.dbOriginalNames.get(modelDatabaseValues.dir) == null) {
                this.getTables(model);
                this.getProcedures(model);
                this.getFunctions(model);
                this.getCheckConstraints(model);
            }
            ss = this.dbOriginalNames.get(modelDatabaseValues.dir).get(s);
        }
        return ss;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public static class DatabaseDirectives {
        public String dbDriver;
        public String dbUrl;
        public String dbUsername;
        public String dbPassword;
        public String dbCatalog;
        public String dbSchema;
        public String dbSqlsBefore;
        public String dbSqlsAfter;
        public String dbIndexTypes;
        public boolean dbSkipIndexes;
        public boolean dbSkipProcedures;
        public boolean dbSkipCheckConstraints;
        public boolean dbTakeComments;
        public boolean dbLowercaseNames;
        public boolean dbUppercaseNames;
        public DbResolver.DbType dbType;
        public String dir;
        public Connection connection;
        boolean doReconnect;
        public List<String> ddlsBefore0;
        public List<String> ddlsBefore1;
        public List<String> ddlsAfter;
        public Set<Short> indexTypes;

        public String toString() {
            return "DatabaseValues [dbDriver=" + this.dbDriver + ", dbUrl=" + this.dbUrl + ", dbUsername=" + this.dbUsername + ", dbPassword=" + this.dbPassword + ", dbCatalog=" + this.dbCatalog + ", dbSchema=" + this.dbSchema + ", dbSqlsBefore=" + this.dbSqlsBefore + ", dbSqlsAfter=" + this.dbSqlsAfter + ", connection=" + this.connection + ", dbIndexTypes=" + this.dbIndexTypes + ", dbSkipIndexes=" + this.dbSkipIndexes + ", dbSkipProcedures=" + this.dbSkipProcedures + ", dbSkipCheckConstraints=" + this.dbSkipCheckConstraints + ", dbTakeComments=" + this.dbTakeComments + ", dbLowercaseNames=" + this.dbLowercaseNames + ", dbUppercaseNames=" + this.dbUppercaseNames + ", dbType=" + (Object)((Object)this.dbType) + ", dir=" + this.dir + "]";
        }
    }
}

