/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DbCheckConstraint {
    String constraintName;
    String checkClause;
    String enumName;
    List<String> values;
    String table;
    String column;
    static final Pattern HSQLDB_CHECK = Pattern.compile("(?i)\\(([^\\)]*)\\)\\s*IN\\s*\\(\\(('?.*?'?,'?.*?'?)\\)\\)*");
    static final Pattern ORACLE_CHECK = Pattern.compile("(?i)(.*\\s*IS NULL OR\\s*\\()?([^\\)]*)\\s*IN\\s*\\(('?.*?'?,'?.*?'?)\\)\\)*");
    static final Pattern INFORMIX_CHECK = Pattern.compile("(?i)\\((.*)\\s*IN\\s*\\(('?.*?'?\\s*,'?.*?'?\\s*)\\)*");
    static final Pattern DB2_CHECK = Pattern.compile("(?i).*IN\\s*\\(('?.*?'?\\s*,'?.*?'?\\s*)\\)*");
    static final Pattern MYSQL_CHECK = Pattern.compile("(?i)\\s*enum\\((.*)\\)\\s*");
    static final Pattern POSTGRESQL_CHECK = Pattern.compile("(?i).*ARRAY\\[(.*?)\\].*");
    static final Pattern MSSQL_CHECK = Pattern.compile("(?i)\\s*\\((.*)\\)\\s*");

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getCheckClause() {
        return this.checkClause;
    }

    public void setCheckClause(String checkClause) {
        this.checkClause = checkClause;
    }

    public String getEnumName() {
        return this.enumName;
    }

    public void setEnumName(String enumName) {
        this.enumName = enumName;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public static DbCheckConstraint parseHsqldb(String name, String clause) {
        Matcher matcher = HSQLDB_CHECK.matcher(clause);
        if (matcher.matches()) {
            String[] names = matcher.group(1).trim().split("\\.");
            String relTable = names[names.length - 2];
            String relCol = names[names.length - 1];
            String enumName = String.valueOf(relTable) + "_" + relCol;
            String[] constraintValues = matcher.group(2).trim().split(",");
            ArrayList<String> values = new ArrayList<String>();
            int j = 0;
            while (j < constraintValues.length) {
                String value = constraintValues[j].trim();
                value = value.replaceAll("'|\\(|\\)", "");
                values.add(value);
                ++j;
            }
            DbCheckConstraint dbCheckConstraint = new DbCheckConstraint();
            dbCheckConstraint.setConstraintName(name);
            dbCheckConstraint.setCheckClause(clause);
            dbCheckConstraint.setEnumName(enumName);
            dbCheckConstraint.setValues(values);
            dbCheckConstraint.setTable(relTable);
            dbCheckConstraint.setColumn(relCol);
            return dbCheckConstraint;
        }
        return null;
    }

    public static DbCheckConstraint parseOracle(String name, String clause, String relTable) {
        Matcher matcher = ORACLE_CHECK.matcher(clause);
        if (matcher.matches()) {
            String relCol = matcher.group(2).trim();
            String enumName = String.valueOf(relTable) + "_" + relCol;
            String[] constraintValues = matcher.group(3).trim().split(",");
            ArrayList<String> values = new ArrayList<String>();
            int j = 0;
            while (j < constraintValues.length) {
                String value = constraintValues[j].trim();
                value = value.replaceAll("'", "");
                values.add(value);
                ++j;
            }
            DbCheckConstraint dbCheckConstraint = new DbCheckConstraint();
            dbCheckConstraint.setConstraintName(name);
            dbCheckConstraint.setCheckClause(clause);
            dbCheckConstraint.setEnumName(enumName);
            dbCheckConstraint.setValues(values);
            dbCheckConstraint.setTable(relTable);
            dbCheckConstraint.setColumn(relCol);
            return dbCheckConstraint;
        }
        return null;
    }

    public static DbCheckConstraint parseInformix(String name, String clause, String relTable) {
        Matcher matcher = INFORMIX_CHECK.matcher(clause.trim());
        if (matcher.matches()) {
            String relCol = matcher.group(1).trim();
            String enumName = String.valueOf(relTable) + "_" + relCol;
            String[] constraintValues = matcher.group(2).trim().split(",");
            ArrayList<String> values = new ArrayList<String>();
            int j = 0;
            while (j < constraintValues.length) {
                String value = constraintValues[j].trim();
                value = value.replaceAll("'", "");
                values.add(value);
                ++j;
            }
            DbCheckConstraint dbCheckConstraint = new DbCheckConstraint();
            dbCheckConstraint.setConstraintName(name);
            dbCheckConstraint.setCheckClause(clause);
            dbCheckConstraint.setEnumName(enumName);
            dbCheckConstraint.setValues(values);
            dbCheckConstraint.setTable(relTable);
            dbCheckConstraint.setColumn(relCol);
            return dbCheckConstraint;
        }
        return null;
    }

    public static DbCheckConstraint parseDb2(String relCol, String clause, String relTable) {
        Matcher matcher = DB2_CHECK.matcher(clause.trim());
        if (matcher.matches()) {
            String enumName = String.valueOf(relTable) + "_" + relCol;
            String[] constraintValues = matcher.group(1).trim().split(",");
            ArrayList<String> values = new ArrayList<String>();
            int j = 0;
            while (j < constraintValues.length) {
                String value = constraintValues[j].trim();
                int ix = value.indexOf("'");
                if (ix >= 0) {
                    value = value.substring(ix + 1);
                }
                if ((ix = value.indexOf("'")) >= 0) {
                    value = value.substring(0, ix);
                }
                values.add(value);
                ++j;
            }
            DbCheckConstraint dbCheckConstraint = new DbCheckConstraint();
            dbCheckConstraint.setConstraintName(enumName);
            dbCheckConstraint.setCheckClause(clause);
            dbCheckConstraint.setEnumName(enumName);
            dbCheckConstraint.setValues(values);
            dbCheckConstraint.setTable(relTable);
            dbCheckConstraint.setColumn(relCol);
            return dbCheckConstraint;
        }
        return null;
    }

    public static DbCheckConstraint parseMysql(String relCol, String clause, String relTable) {
        Matcher matcher = MYSQL_CHECK.matcher(clause.trim());
        if (matcher.matches()) {
            String enumName = String.valueOf(relTable) + "_" + relCol;
            String[] constraintValues = matcher.group(1).trim().split(",");
            ArrayList<String> values = new ArrayList<String>();
            int j = 0;
            while (j < constraintValues.length) {
                String value = constraintValues[j].trim();
                value = value.replaceAll("'", "");
                values.add(value);
                ++j;
            }
            DbCheckConstraint dbCheckConstraint = new DbCheckConstraint();
            dbCheckConstraint.setConstraintName(enumName);
            dbCheckConstraint.setCheckClause(clause);
            dbCheckConstraint.setEnumName(enumName);
            dbCheckConstraint.setValues(values);
            dbCheckConstraint.setTable(relTable);
            dbCheckConstraint.setColumn(relCol);
            return dbCheckConstraint;
        }
        return null;
    }

    public static DbCheckConstraint parsePostgresql(String relCol, String clause, String relTable) {
        ArrayList<String> values = new ArrayList<String>();
        String enumName = String.valueOf(relTable) + "_" + relCol;
        Matcher matcher = POSTGRESQL_CHECK.matcher(clause.trim());
        if (matcher.matches()) {
            String[] constraintValues = matcher.group(1).trim().split(",");
            int j = 0;
            while (j < constraintValues.length) {
                String value = constraintValues[j].trim();
                int ix = value.indexOf("'");
                if (ix >= 0) {
                    value = value.substring(ix + 1);
                }
                if ((ix = value.indexOf("'")) >= 0) {
                    value = value.substring(0, ix);
                }
                values.add(value);
                ++j;
            }
        }
        if (!values.isEmpty()) {
            DbCheckConstraint dbCheckConstraint = new DbCheckConstraint();
            dbCheckConstraint.setConstraintName(enumName);
            dbCheckConstraint.setCheckClause(clause);
            dbCheckConstraint.setEnumName(enumName);
            dbCheckConstraint.setValues(values);
            dbCheckConstraint.setTable(relTable);
            dbCheckConstraint.setColumn(relCol);
            return dbCheckConstraint;
        }
        return null;
    }

    public static DbCheckConstraint parseMssql(String name, String clause, String relTable) {
        Matcher matcher = MSSQL_CHECK.matcher(clause.trim());
        if (matcher.matches()) {
            String[] constraintValues = matcher.group(1).trim().split("OR");
            String relCol = null;
            ArrayList<String> values = new ArrayList<String>();
            int j = 0;
            while (j < constraintValues.length) {
                String value;
                String[] values2 = constraintValues[j].trim().split("=");
                if (relCol == null) {
                    relCol = values2[0];
                    if (relCol.startsWith("[")) {
                        relCol = relCol.substring(1);
                    }
                    if (relCol.endsWith("]")) {
                        relCol = relCol.substring(0, relCol.length() - 1);
                    }
                }
                if ((value = values2[1]).startsWith("(")) {
                    value = value.substring(1);
                }
                if (value.endsWith(")")) {
                    value = value.substring(0, value.length() - 1);
                }
                if (value.startsWith("'")) {
                    value = value.substring(1);
                }
                if (value.endsWith("'")) {
                    value = value.substring(0, value.length() - 1);
                }
                values.add(value);
                ++j;
            }
            String enumName = String.valueOf(relTable) + "_" + relCol;
            DbCheckConstraint dbCheckConstraint = new DbCheckConstraint();
            dbCheckConstraint.setConstraintName(name);
            dbCheckConstraint.setCheckClause(clause);
            dbCheckConstraint.setEnumName(enumName);
            dbCheckConstraint.setValues(values);
            dbCheckConstraint.setTable(relTable);
            dbCheckConstraint.setColumn(relCol);
            return dbCheckConstraint;
        }
        return null;
    }

    public static void main(String[] args) {
        Matcher matcher = MSSQL_CHECK.matcher("([GENDER]='0' OR [GENDER]='F' OR [GENDER]='M')");
        if (matcher.matches()) {
            String[] constraintValues = matcher.group(1).trim().split("OR");
            ArrayList values = new ArrayList();
            int j = 0;
            while (j < constraintValues.length) {
                ++j;
            }
            System.out.println("9 " + values);
        } else {
            System.out.println("uch");
        }
    }

    public String toString() {
        return "DbCheckConstraint [constraintName=" + this.constraintName + ", checkClause=" + this.checkClause + ", enumName=" + this.enumName + ", values=" + this.values + ", table=" + this.table + ", column=" + this.column + "]";
    }
}

