/*
 * generated by Xtext
 */
package org.sqlproc.dsl.generator

import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.IGenerator
import org.eclipse.xtext.generator.IFileSystemAccess
import org.sqlproc.dsl.processorDsl.PojoEntity
import com.google.inject.Inject
import org.eclipse.xtext.naming.IQualifiedNameProvider
import org.sqlproc.dsl.processorDsl.PojoProperty
import org.sqlproc.dsl.ImportManager

import static org.sqlproc.dsl.util.Utils.*;
import java.util.ArrayList
import org.sqlproc.dsl.processorDsl.Implements
import org.sqlproc.dsl.processorDsl.Extends
import org.sqlproc.dsl.processorDsl.PojoDao
import java.util.List
import org.sqlproc.dsl.processorDsl.PojoMethodArg
import java.util.Map
import org.sqlproc.dsl.processorDsl.ImplPackage
import org.sqlproc.dsl.processorDsl.PojoMethod
import org.sqlproc.dsl.processorDsl.PojoType
import org.sqlproc.dsl.processorDsl.EnumEntity
import org.sqlproc.dsl.processorDsl.EnumProperty
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty
import org.sqlproc.dsl.processorDsl.AnnotatedEntity
import org.sqlproc.dsl.processorDsl.Annotation
import org.sqlproc.dsl.processorDsl.AnnotationProperty

class ProcessorDslGenerator implements IGenerator {
	
@Inject extension IQualifiedNameProvider
	
override void doGenerate(Resource resource, IFileSystemAccess fsa) {
	for(e: resource.allContents.toIterable.filter(typeof(AnnotatedEntity))) {
		fsa.generateFile(e.eContainer.fullyQualifiedName.toString("/") + "/"+
			e.fullyQualifiedName + ".java",e.compile
		)
	}
//	for(e: resource.allContents.toIterable.filter(typeof(EnumEntity))) {
//		fsa.generateFile(e.eContainer.fullyQualifiedName.toString("/") + "/"+
//			e.fullyQualifiedName + ".java",e.compile
//		)
//	}
//	for(e: resource.allContents.toIterable.filter(typeof(PojoEntity))) {
//		fsa.generateFile(e.eContainer.fullyQualifiedName.toString("/") + "/"+
//			e.fullyQualifiedName + ".java",e.compile
//		)
//	}
	for(d: resource.allContents.toIterable.filter(typeof(PojoDao))) {
		if (d.implPackage != null) {
    		fsa.generateFile(d.eContainer.fullyQualifiedName.toString("/") + "/"+
	      		d.fullyQualifiedName + ".java",d.compileIfx
		    )
    		fsa.generateFile(d.eContainer.fullyQualifiedName.toString("/") + "/"+ 
	      		d.implPackage + "/" + d.fullyQualifiedName + "Impl.java",d.compile
		    )
		}
		else {
    		fsa.generateFile(d.eContainer.fullyQualifiedName.toString("/") + "/"+
	      		d.fullyQualifiedName + ".java",d.compile
		    )
		}
	}
}

def compile(AnnotatedEntity e) '''
«IF e.entity instanceof EnumEntity»«enumEntity(e).compile»«ENDIF»«IF e.entity instanceof PojoEntity»«compile(pojoEntity(e), e)»«ENDIF»
'''

def compile(EnumEntity e) '''
«val im = new ImportManager(true)»
«val eattr = getEnumAttr(e)»
«addImplements(e, im)»
«addExtends(e, im)»
«val classBody = compile(e, im, eattr)»
«IF e.eContainer != null»package «e.eContainer.eContainer.fullyQualifiedName»;«ENDIF»
  «IF !im.imports.empty»
  
  «FOR i : im.imports»
import «i»;
  «ENDFOR»
  «ENDIF»
  «IF getSernum(e) != null»

import java.io.Serializable;
  «ENDIF»
  «IF !e.features.empty»
import java.util.HashMap;
import java.util.Map;
  «ENDIF»

«classBody»
'''
def compile(EnumEntity e, ImportManager im, EnumProperty ea) '''
public enum «e.name» «compileExtends(e, im)»«compileImplements(e)»{

  «FOR f:e.features.filter(x| x.value!=null) SEPARATOR ", "»«f.name»(«f.value»)«ENDFOR»;
  «IF getSernum(e) != null»
  
  private static final long serialVersionUID = «getSernum(e)»L;
  «ENDIF»
  
  private static Map<«ea.compileType(im)», «e.name»> identifierMap = new HashMap<«ea.compileType(im)», «e.name»>();

    static {
        for («e.name» value : «e.name».values()) {
            identifierMap.put(value.getValue(), value);
        }
    }

    private «ea.compileType(im)» «ea.name»;

    private «e.name»(«ea.compileType(im)» value) {
        this.«ea.name» = value;
    }

    public static «e.name» fromValue(«ea.compileType(im)» value) {
        «e.name» result = identifierMap.get(value);
        if (result == null) {
            throw new IllegalArgumentException("No «e.name» for value: " + value);
        }
        return result;
    }

    public «ea.compileType(im)» getValue() {
        return «ea.name»;
    }

    public String getName() {
        return name();
    }
}
'''


def compile(PojoEntity e, AnnotatedEntity ae) '''
«val im = new ImportManager(true)»
«addImplements(e, im)»
«addExtends(e, im)»
«val classBody = compile(e, ae, im)»
«IF e.eContainer != null»package «e.eContainer.eContainer.fullyQualifiedName»;«ENDIF»
  «IF !im.imports.empty»
  
  «FOR i : im.imports»
import «i»;
  «ENDFOR»
  «ENDIF»
  «IF getSernum(e) != null»

import java.io.Serializable;
  «ENDIF»
  «IF !e.listFeatures.empty»
import java.util.ArrayList;
  «ENDIF»
  «IF e.hasIsDef != null || e.hasToInit != null»
import java.util.Set;
import java.util.HashSet;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.MethodUtils;
  «ENDIF»
  «IF hasOperators(e) && getOperatorsSuffix(e) == null»
import java.util.Map;
import java.util.HashMap;
  «ENDIF»

«classBody»
'''

def compile(PojoEntity e, AnnotatedEntity ae, ImportManager im) '''
  «FOR a:ae.annotations»
@«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR f:a.features SEPARATOR ", "»«compileAnnotationProperty(f, im)»«ENDFOR»)«ENDIF»
  «ENDFOR»
public «IF isAbstract(e)»abstract «ENDIF»class «e.name» «compileExtends(e, im)»«compileImplements(e)»{
  «IF getSernum(e) != null»
  
  private static final long serialVersionUID = «getSernum(e)»L;
  «ENDIF»
  «FOR f:e.features.filter(x| getIndex(x.feature)!=null)»
  «FOR a:ae.staticAnnotations»
  @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
  «ENDFOR»
  public static final int ORDER_BY_«constName(f.feature)» = «getIndex(f.feature)»;
  «ENDFOR»
  «FOR f:e.features.filter(x| x.feature.name.startsWith("index="))»
  «FOR a:ae.staticAnnotations»
  @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
  «ENDFOR»
  public static final int ORDER_BY_«constName2(f.feature)» = «f.feature.name.substring(6)»;
  «ENDFOR»
	
  «FOR a:ae.constructorAnnotations»
  @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR f:a.features SEPARATOR ", "»«compileAnnotationProperty(f, im)»«ENDFOR»)«ENDIF»
  «ENDFOR»
  public «e.name»() {
  }
  «IF !e.requiredFeatures.empty»
  
  «FOR a:ae.constructorAnnotations»
  @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR f:a.features SEPARATOR ", "»«compileAnnotationProperty(f, im)»«ENDFOR»)«ENDIF»
  «ENDFOR»
  public «e.name»(«FOR f:e.requiredFeatures SEPARATOR ", "»«getFullName(e, f, f.feature.compileType(im), im)» «f.feature.name»«ENDFOR») {
  «FOR f:e.requiredSuperFeatures BEFORE "  super(" SEPARATOR ", " AFTER ");"»«f.feature.name»«ENDFOR»
  «FOR f:e.requiredFeatures1 SEPARATOR "
"»  this.«f.feature.name» = «f.feature.name»;«ENDFOR»
  }
  «ENDIF»
  «FOR f:e.features.filter(x| isAttribute(x.feature))»
    «f.feature.compile(f, im, e, ae, getOperatorsSuffix(e))»
  «ENDFOR»
  «FOR f:e.features.filter(x| !isAttribute(x.feature))»«IF f.feature.name.equalsIgnoreCase("hashCode")»«f.feature.compileHashCode(f, im, e, ae)»
  «ELSEIF f.feature.name.equalsIgnoreCase("equals")»«f.feature.compileEquals(f, im, e, ae)»
  «ELSEIF f.feature.name.equalsIgnoreCase("toInit")»«f.feature.compileToInit(f, im, e, ae)»
  «ELSEIF f.feature.name.equalsIgnoreCase("enumInit")»«f.feature.compileEnumInit(f, im, e, ae)»
  «ELSEIF f.feature.name.equalsIgnoreCase("isDef")»«f.feature.compileIsDef(f, im, e, ae)»
  «ELSEIF f.feature.name.equalsIgnoreCase("enumDef")»«f.feature.compileEnumDef(f, im, e, ae)»
  «ELSEIF f.feature.name.equalsIgnoreCase("toString")»«f.feature.compileToString(f, im, e, ae)»«ENDIF»«ENDFOR»«IF hasOperators(e) && getOperatorsSuffix(e) == null»
  «compileOperators(im, e, ae)»«ENDIF»
}
'''

def compileAnnotationProperty(AnnotationProperty f, ImportManager im) '''
  «f.name» = «IF f.getType != null»«im.serialize(f.getType)»«ELSEIF f.getRef != null»«f.getRef.fullyQualifiedName»«ENDIF»«getAnnotationValue(f)»'''

def compile(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae, String operatorSuffix) '''

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    private «f.compileType(im)» «f.name»«IF isList(f)» = new Array«f.compileType(im)»()«ELSEIF isOptLock(f)» = 0«ENDIF»;

    «FOR a:aaf.getterAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public «f.compileType(im)» get«f.name.toFirstUpper»() {
      return «f.name»;
    }

    «FOR a:aaf.setterAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void set«f.name.toFirstUpper»(«f.compileType(im)» «f.name») {
      this.«f.name» = «f.name»;
      «IF getUpdateColumn1(f) != null»
      if (this.«f.name» != null)
        this.«getUpdateColumn2(f)» = this.«f.name».get«getUpdateColumn1(f).toFirstUpper»();
      «ENDIF»
      «IF getCreateColumn1(f) != null»
        if (this.«getCreateColumn1(f)» == null)
            this.«getCreateColumn1(f)» = new «getAttribute(e, getCreateColumn1(f)).compileType(im)»();
        this.«getCreateColumn1(f)».set«getCreateColumn2(f).toFirstUpper»(«f.name»);
      «ENDIF»
    }

    public «e.name» _set«f.name.toFirstUpper»(«f.compileType(im)» «f.name») {
      this.«f.name» = «f.name»;
      «IF getUpdateColumn1(f) != null»
      if (this.«f.name» != null)
        this.«getUpdateColumn2(f)» = this.«f.name».get«getUpdateColumn1(f).toFirstUpper»();
      «ENDIF»
      «IF getCreateColumn1(f) != null»
        if (this.«getCreateColumn1(f)» == null)
            this.«getCreateColumn1(f)» = new «getAttribute(e, getCreateColumn1(f)).compileType(im)»();
        this.«getCreateColumn1(f)».set«getCreateColumn2(f).toFirstUpper»(«f.name»);
      «ENDIF»
      return this;
    }«IF hasOperators(e) && operatorSuffix != null»

    private String «f.name»«operatorSuffix»;

    public String get«f.name.toFirstUpper»«operatorSuffix»() {
      return «f.name»«operatorSuffix»;
    }

    public void set«f.name.toFirstUpper»«operatorSuffix»(String «f.name»«operatorSuffix») {
      this.«f.name»«operatorSuffix» = «f.name»«operatorSuffix»;
    }

    public «e.name» _set«f.name.toFirstUpper»«operatorSuffix»(String «f.name»«operatorSuffix») {
      this.«f.name»«operatorSuffix» = «f.name»«operatorSuffix»;
      return this;
    }«ENDIF»
'''

def compileHashCode(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) '''

    @Override
    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public int hashCode() {
      final int prime = 31;
      int result = 1;
      «FOR f2:f.attrs»
      result = prime * result + «IF f2.native != null»(int) («f2.name» ^ («f2.name» >>> 32))«ELSE»((«f2.name» != null) ? «f2.name».hashCode() : 0)«ENDIF»;
      «ENDFOR»
      return result;
    }  
'''

def compileEquals(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) '''

    @Override
    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public boolean equals(Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      «e.name» other = («e.name») obj;
      «FOR f2:f.attrs»
      «IF f2.native != null»if («f2.name» != other.«f2.name»)«ELSE»if («f2.name» == null || !«f2.name».equals(other.«f2.name»))«ENDIF»
        return false;
      «ENDFOR»
      return true;
    }  
'''

def compileToString(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) '''

    @Override
    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public String toString() {
      return "«e.name» [«FOR f2:f.simplAttrs SEPARATOR " + \", "»«f2.name»=" + «f2.name»«ENDFOR»«IF getSuperType(e) != null» + super.toString()«ENDIF» + "]";
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public String toStringFull() {
      return "«e.name» [«FOR f2:f.attrs SEPARATOR " + \", "»«f2.name»=" + «f2.name»«ENDFOR»«IF getSuperType(e) != null» + super.toString()«ENDIF» + "]";
    }
'''

def compileIsDef(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) '''

    public enum Attribute {
      «FOR f2:f.attrs SEPARATOR ", "»«f2.name»«ENDFOR»
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    private Set<String> nullValues = new HashSet<String>();

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    «FOR a:ae.conflictAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void setNull(Attribute... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (Attribute attribute : attributes)
        nullValues.add(attribute.name());
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    «FOR a:ae.conflictAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void clearNull(Attribute... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (Attribute attribute : attributes)
        nullValues.remove(attribute.name());
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void setNull(String... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (String attribute : attributes)
        nullValues.add(attribute);
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void clearNull(String... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (String attribute : attributes)
        nullValues.remove(attribute);
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public Boolean isNull(String attrName) {
      if (attrName == null)
        throw new IllegalArgumentException();
      return nullValues.contains(attrName);
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    «FOR a:ae.conflictAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public Boolean isNull(Attribute attribute) {
      if (attribute == null)
        throw new IllegalArgumentException();
      return nullValues.contains(attribute.name());
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public Boolean isDef(String attrName) {
      if (attrName == null)
        throw new IllegalArgumentException();
      if (nullValues.contains(attrName))
        return true;
      try {
        Object result = MethodUtils.invokeMethod(this, "get" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1, attrName.length()), null);
        return (result != null) ? true : false;
      } catch (NoSuchMethodException e) {
      } catch (IllegalAccessException e) {
        throw new RuntimeException(e);
      } catch (InvocationTargetException e) {
        throw new RuntimeException(e);
      }
      try {
        Object result = MethodUtils.invokeMethod(this, "is" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1, attrName.length()), null);
        return (result != null) ? true : false;
      } catch (NoSuchMethodException e) {
      } catch (IllegalAccessException e) {
        throw new RuntimeException(e);
      } catch (InvocationTargetException e) {
        throw new RuntimeException(e);
      }
      return false;
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void clearAllNull() {
      nullValues = new HashSet<String>();
    }
'''

def compileEnumDef(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) '''

    public enum Attribute {
      «FOR f2:f.attrs SEPARATOR ", "»«f2.name»«ENDFOR»
    }
'''

def compileToInit(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) '''

    public enum Association {
      «FOR f2:f.attrs SEPARATOR ", "»«f2.name»«ENDFOR»
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    private Set<String> initAssociations = new HashSet<String>();

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    «FOR a:ae.conflictAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void setInit(Association... associations) {
      if (associations == null)
        throw new IllegalArgumentException();
      for (Association association : associations)
        initAssociations.add(association.name());
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    «FOR a:ae.conflictAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void clearInit(Association... associations) {
      if (associations == null)
        throw new IllegalArgumentException();
      for (Association association : associations)
        initAssociations.remove(association.name());
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void setInit(String... associations) {
      if (associations == null)
        throw new IllegalArgumentException();
      for (String association : associations)
        initAssociations.add(association);
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void clearInit(String... associations) {
      if (associations == null)
        throw new IllegalArgumentException();
      for (String association : associations)
        initAssociations.remove(association);
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public Boolean toInit(String association) {
      if (association == null)
        throw new IllegalArgumentException();
      return initAssociations.contains(association);
    }

    «FOR a:aaf.attributeAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR af:a.features SEPARATOR ", "»«compileAnnotationProperty(af, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void clearAllInit() {
      initAssociations = new HashSet<String>();
    }
'''

def compileEnumInit(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae) '''

    public enum Association {
      «FOR f2:f.attrs SEPARATOR ", "»«f2.name»«ENDFOR»
    }
'''

def compileOperators(ImportManager im, PojoEntity e, AnnotatedEntity ae) '''

    public enum OpAttribute {
        «FOR f:e.features.filter(x| isAttribute(x.feature)) SEPARATOR ", "»«f.feature.name»«ENDFOR»
    }

    private Map<String, String> operators = new HashMap<String, String>();

    public Map<String, String> getOperators() {
      return operators;
    }

    «FOR a:ae.conflictAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void setOp(String operator, OpAttribute... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (OpAttribute attribute : attributes)
        operators.put(attribute.name(), operator);
    }

    «FOR a:ae.conflictAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void clearOp(OpAttribute... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (OpAttribute attribute : attributes)
        operators.remove(attribute.name());
    }

    public void setOp(String operator, String... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (String attribute : attributes)
        operators.put(attribute, operator);
    }

    public void clearOp(String... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (String attribute : attributes)
        operators.remove(attribute);
    }

    «FOR a:ae.conflictAnnotations»
    @«im.serialize(a.getType)»«IF !a.features.isEmpty»(«FOR ff:a.features SEPARATOR ", "»«compileAnnotationProperty(ff, im)»«ENDFOR»)«ENDIF»
    «ENDFOR»
    public void setNullOp(OpAttribute... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (OpAttribute attribute : attributes)
        operators.put(attribute.name(), "is null");
    }

    public void setNullOp(String... attributes) {
      if (attributes == null)
        throw new IllegalArgumentException();
      for (String attribute : attributes)
        operators.put(attribute, "is null");
    }

    public void clearAllOps() {
      operators = new HashMap<String, String>();
    }
'''

def compileType(EnumProperty f, ImportManager im) '''
  «IF f.getNative != null»«f.getNative.substring(1)»«ELSEIF f.getType != null»«im.serialize(f.getType)»«ENDIF»'''
  
def compileType(PojoProperty f, ImportManager im) '''
  «IF f.getNative != null»«f.getNative.substring(1)»«ELSEIF f.getRef != null»«f.getRef.fullyQualifiedName»«ELSEIF f.getType != null»«im.serialize(f.getType)»«ENDIF»«IF f.getGtype != null»<«im.serialize(f.getGtype)»>«ENDIF»«IF f.getGref != null»<«f.getGref.fullyQualifiedName»>«ENDIF»«IF f.array»[]«ENDIF»'''
  
def compileType(PojoType f, ImportManager im) '''
  «IF f.getNative != null»«f.getNative.substring(1)»«ELSEIF f.getRef != null»«im.serialize(pojoMethod2jvmType(f.getRef))»«ELSEIF f.getType != null»«im.serialize(f.getType)»«ENDIF»«IF f.getGtype != null»<«im.serialize(f.getGtype)»>«ENDIF»«IF f.getGref != null»<«im.serialize(pojoMethod2jvmType(f.getGref))»>«ENDIF»«IF f.array»[]«ENDIF»'''

def compile(PojoDao d) '''
«val im = new ImportManager(true)»
«addImplements(d, im)»
«addExtends(d, im)»
«val toInits = getToInits(d)»
«val classBody = compile(d, d.pojo, toInits, im)»
«IF d.eContainer != null»package «d.eContainer.fullyQualifiedName»«IF d.implPackage != null».«d.implPackage»«ENDIF»;«ENDIF»
  «IF d.implPackage != null»

import «d.eContainer.fullyQualifiedName».«d.name»;
  «ENDIF»
  «IF !im.imports.empty»
  
  «FOR i : im.imports»
import «i»;
  «ENDFOR»
  «ENDIF»
  «IF getSernum(d) != null»

import java.io.Serializable;
  «ENDIF»

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.SqlSessionFactory;
import org.sqlproc.engine.impl.SqlStandardControl;
«IF d.pojo != null»import «d.pojo.completeName»;«ENDIF»
«FOR f:toInits.entrySet»«FOR a:f.value SEPARATOR "
"»import «a.type.ref.completeName»;«ENDFOR»«ENDFOR»

«classBody»
'''

def compile(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im) '''
public «IF isAbstract(d)»abstract «ENDIF»class «d.name»«IF d.implPackage != null»Impl«ENDIF» «compileExtends(d, im)»«compileImplements(d)»{
  «IF getSernum(d) != null»
  
  private static final long serialVersionUID = «getSernum(d)»L;
  «ENDIF»
  protected final Logger logger = LoggerFactory.getLogger(getClass());

  protected SqlEngineFactory sqlEngineFactory;
  protected SqlSessionFactory sqlSessionFactory;
    	
  public «d.name»«IF d.implPackage != null»Impl«ENDIF»(SqlEngineFactory sqlEngineFactory) {
    this.sqlEngineFactory = sqlEngineFactory;
  }
    	
  public «d.name»«IF d.implPackage != null»Impl«ENDIF»(SqlEngineFactory sqlEngineFactory, SqlSessionFactory sqlSessionFactory) {
    this.sqlEngineFactory = sqlEngineFactory;
    this.sqlSessionFactory = sqlSessionFactory;
  }
  
  «FOR m:d.methods»«IF m.name == "scaffold"»«compileInsert(d, e, getParent(e), im)»
  «compileGet(d, e, toInits, im)»
  «compileUpdate(d, e, getParent(e), im)»
  «compileDelete(d, e, getParent(e), im)»
  «compileList(d, e, toInits, im)»
  «compileCount(d, e, toInits, im)»
  «IF !toInits.empty»«compileMoreResultClasses(d, e, toInits, im)»«ENDIF»«ELSEIF isCallUpdate(m)»
  «compileCallUpdate(d, m, im)»«ELSEIF isCallFunction(m)»«compileCallFunction(d, m, im)»«ELSEIF isCallQuery(m) || isCallQueryFunction(m)»«compileCallQuery(d, m, im, isCallQueryFunction(m))»«ELSEIF isCallSelectFunction(m)»«compileCallSelectFunction(d, m, im)»«ENDIF»«ENDFOR»
}
'''

def compileCallQuery(PojoDao d, PojoMethod m, ImportManager im, boolean isFunction) '''

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("«m.name»: " + «FOR ma:m.args SEPARATOR " + \" \" "»«ma.name»«ENDFOR» + " " + sqlControl);
      }
      SqlProcedureEngine sqlProc«m.name.toFirstUpper» = sqlEngineFactory.getCheckedProcedureEngine("«IF isFunction»FUN«ELSE»PROC«ENDIF»_«dbName(m)»");
      «m.type.compileType(im)» list = sqlProc«m.name.toFirstUpper».callQuery(sqlSession, «m.type.gref.name».class, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
      if (logger.isTraceEnabled()) {
        logger.trace("«m.name» result: " + list);
      }
      return list;
    }

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
    	return «m.name»(sqlSessionFactory.getSqlSession(), «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
    }

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
      return «m.name»(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
    }

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
      return «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
    }
'''

def compileCallFunction(PojoDao d, PojoMethod m, ImportManager im) '''

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("«m.name»: " + «FOR ma:m.args SEPARATOR " + \" \" "»«ma.name»«ENDFOR» + " " + sqlControl);
      }
      SqlProcedureEngine sqlFun«m.name.toFirstUpper» = sqlEngineFactory.getCheckedProcedureEngine("FUN_«dbName(m)»");
      Object result = sqlFun«m.name.toFirstUpper».callFunction(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
      if (logger.isTraceEnabled()) {
        logger.trace("«m.name» result: " + result);
      }
      return («m.type.compileType(im)») result;
    }

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
    	return «m.name»(sqlSessionFactory.getSqlSession(), «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
    }

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
      return «m.name»(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
    }

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
      return «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
    }
'''

def compileCallUpdate(PojoDao d, PojoMethod m, ImportManager im) '''

    public int «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("«m.name»: " + «FOR ma:m.args SEPARATOR " + \" \" "»«ma.name»«ENDFOR» + " " + sqlControl);
      }
      SqlProcedureEngine sqlProc«m.name.toFirstUpper» = sqlEngineFactory.getCheckedProcedureEngine("PROC_«dbName(m)»");
      int count = sqlProc«m.name.toFirstUpper».callUpdate(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
      if (logger.isTraceEnabled()) {
        logger.trace("«m.name» result: " + count);
      }
      return count;
    }

    public int «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
    	return «m.name»(sqlSessionFactory.getSqlSession(), «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
    }

    public int «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
      return «m.name»(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
    }

    public int «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
      return «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
    }
'''

def compileCallSelectFunction(PojoDao d, PojoMethod m, ImportManager im) '''

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("«m.name»: " + «FOR ma:m.args SEPARATOR " + \" \" "»«ma.name»«ENDFOR» + " " + sqlControl);
      }
      SqlQueryEngine sqlFun«m.name.toFirstUpper» = sqlEngineFactory.getCheckedQueryEngine("FUN_«dbName(m)»");
      java.util.List<«m.args.get(0).type.compileType(im)»> list = sqlFun«m.name.toFirstUpper».query(sqlSession, «m.args.get(0).type.compileType(im)».class, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
      if (logger.isTraceEnabled()) {
        logger.trace("«m.name» result: " + list);
      }
      return (list != null && !list.isEmpty()) ? list.get(0).getResult() : null;
    }

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl) {
    	return «m.name»(sqlSessionFactory.getSqlSession(), «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», sqlControl);
    }

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
      return «m.name»(sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
    }

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR») {
      return «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.name»«ENDFOR», null);
    }
'''

def compileInsert(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im) '''

    public «e.name» insert(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("insert «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
      }
      SqlCrudEngine sqlInsert«e.name» = sqlEngineFactory.getCheckedCrudEngine("INSERT_«dbName(e)»");«IF pe != null»
      SqlCrudEngine sqlInsert«pe.name» = sqlEngineFactory.getCheckedCrudEngine("INSERT_«dbName(pe)»");
      int count = sqlInsert«pe.name».insert(sqlSession, «e.name.toFirstLower», sqlControl);
      if (count > 0) {
        sqlInsert«e.name».insert(sqlSession, «e.name.toFirstLower», sqlControl);
      }«ELSE»
      int count = sqlInsert«e.name».insert(sqlSession, «e.name.toFirstLower», sqlControl);«ENDIF»
      if (logger.isTraceEnabled()) {
        logger.trace("insert «e.name.toFirstLower» result: " + count + " " + «e.name.toFirstLower»);
      }
      return (count > 0) ? «e.name.toFirstLower» : null;
    }

    public «e.name» insert(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
    	return insert(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
    }

    public «e.name» insert(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
      return insert(sqlSession, «e.name.toFirstLower», null);
    }

    public «e.name» insert(«e.name» «e.name.toFirstLower») {
      return insert(«e.name.toFirstLower», null);
    }
'''

def compileGet(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im) '''

    public «e.name» get(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("get get: " + «e.name.toFirstLower» + " " + sqlControl);
      }
      SqlCrudEngine sqlGetEngine«e.name» = sqlEngineFactory.getCheckedCrudEngine("GET_«dbName(e)»");
      «IF toInits.empty»//«ENDIF»sqlControl = getMoreResultClasses(«e.name.toFirstLower», sqlControl);
      «e.name» «e.name.toFirstLower»Got = sqlGetEngine«e.name».get(sqlSession, «e.name».class, «e.name.toFirstLower», sqlControl);
      if (logger.isTraceEnabled()) {
        logger.trace("get «e.name.toFirstLower» result: " + «e.name.toFirstLower»Got);
      }
      return «e.name.toFirstLower»Got;
    }
	
    public «e.name» get(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
    	return get(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
    }

    public «e.name» get(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
      return get(sqlSession, «e.name.toFirstLower», null);
    }

    public «e.name» get(«e.name» «e.name.toFirstLower») {
      return get(«e.name.toFirstLower», null);
    }
'''

def compileUpdate(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im) '''

    public int update(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("update «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
      }
      SqlCrudEngine sqlUpdateEngine«e.name» = sqlEngineFactory.getCheckedCrudEngine("UPDATE_«dbName(e)»");«IF pe != null»
      SqlCrudEngine sqlUpdate«pe.name» = sqlEngineFactory.getCheckedCrudEngine("UPDATE_«dbName(pe)»");«ENDIF»
      int count = sqlUpdateEngine«e.name».update(sqlSession, «e.name.toFirstLower», sqlControl);«IF pe != null»
      if (count > 0) {
      	sqlUpdate«pe.name».update(sqlSession, «e.name.toFirstLower», sqlControl);
      }«ENDIF»«val f=getOptLock(e)»«IF f != null»
      if (count > 0) {
      	«e.name.toFirstLower».set«f.name.toFirstUpper»(«e.name.toFirstLower».get«f.name.toFirstUpper»() + 1);
      }«ENDIF»
      if (logger.isTraceEnabled()) {
        logger.trace("update «e.name.toFirstLower» result count: " + count);
      }
      return count;
    }

    public int update(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
    	return update(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
    }
    
    public int update(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
      return update(sqlSession, «e.name.toFirstLower», null);
    }
    
    public int update(«e.name» «e.name.toFirstLower») {
      return update(«e.name.toFirstLower», null);
    }
'''

def compileDelete(PojoDao d, PojoEntity e, PojoEntity pe, ImportManager im) '''

    public int delete(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("delete «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
      }
      SqlCrudEngine sqlDeleteEngine«e.name» = sqlEngineFactory.getCheckedCrudEngine("DELETE_«dbName(e)»");«IF pe != null»
      SqlCrudEngine sqlDelete«pe.name» = sqlEngineFactory.getCheckedCrudEngine("DELETE_«dbName(pe)»");«ENDIF»
      int count = sqlDeleteEngine«e.name».delete(sqlSession, «e.name.toFirstLower», sqlControl);«IF pe != null»
      if (count > 0) {
      	sqlDelete«pe.name».delete(sqlSession, «e.name.toFirstLower», sqlControl);
      }«ENDIF»«val f=getOptLock(e)»«IF f != null»
      if (count > 0) {
      	«e.name.toFirstLower».set«f.name.toFirstUpper»(«e.name.toFirstLower».get«f.name.toFirstUpper»() + 1);
      }«ENDIF»
      if (logger.isTraceEnabled()) {
        logger.trace("delete «e.name.toFirstLower» result count: " + count);
      }
      return count;
    }

    public int delete(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
    	return delete(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
    }

    public int delete(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
      return delete(sqlSession, «e.name.toFirstLower», null);
    }

    public int delete(«e.name» «e.name.toFirstLower») {
      return delete(«e.name.toFirstLower», null);
    }
'''

def compileList(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im) '''

    public List<«e.name»> list(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("list «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
      }
      SqlQueryEngine sqlEngine«e.name» = sqlEngineFactory.getCheckedQueryEngine("SELECT_«dbName(e)»");
      «IF toInits.empty»//«ENDIF»sqlControl = getMoreResultClasses(«e.name.toFirstLower», sqlControl);
      List<«e.name»> «e.name.toFirstLower»List = sqlEngine«e.name».query(sqlSession, «e.name».class, «e.name.toFirstLower», sqlControl);
      if (logger.isTraceEnabled()) {
        logger.trace("list «e.name.toFirstLower» size: " + ((«e.name.toFirstLower»List != null) ? «e.name.toFirstLower»List.size() : "null"));
      }
      return «e.name.toFirstLower»List;
    }

    public List<«e.name»> list(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
    	return list(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
    }
    
    public List<«e.name»> list(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
      return list(sqlSession, «e.name.toFirstLower», null);
    }
    
    public List<«e.name»> list(«e.name» «e.name.toFirstLower») {
      return list(«e.name.toFirstLower», null);
    }
'''

def compileCount(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im) '''

    public int count(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl) {
      if (logger.isTraceEnabled()) {
        logger.trace("count «e.name.toFirstLower»: " + «e.name.toFirstLower» + " " + sqlControl);
      }
      SqlQueryEngine sqlEngine«e.name» = sqlEngineFactory.getCheckedQueryEngine("SELECT_«dbName(e)»");
      «IF toInits.empty»//«ENDIF»sqlControl = getMoreResultClasses(«e.name.toFirstLower», sqlControl);
      int count = sqlEngine«e.name».queryCount(sqlSession, «e.name.toFirstLower», sqlControl);
      if (logger.isTraceEnabled()) {
        logger.trace("count: " + count);
      }
      return count;
    }

    public int count(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
    	return count(sqlSessionFactory.getSqlSession(), «e.name.toFirstLower», sqlControl);
    }
    
    public int count(SqlSession sqlSession, «e.name» «e.name.toFirstLower») {
      return count(sqlSession, «e.name.toFirstLower», null);
    }
    
    public int count(«e.name» «e.name.toFirstLower») {
      return count(«e.name.toFirstLower», null);
    }
'''

def compileMoreResultClasses(PojoDao d, PojoEntity e, Map<String, List<PojoMethodArg>> toInits, ImportManager im) '''

    SqlControl getMoreResultClasses(«e.name» «e.name.toFirstLower», SqlControl sqlControl) {
      if (sqlControl != null && sqlControl.getMoreResultClasses() != null)
        return sqlControl;
      Map<String, Class<?>> moreResultClasses = null;
    «FOR f:toInits.entrySet SEPARATOR "
"»  if («e.name.toFirstLower» != null && «e.name.toFirstLower».toInit(«e.name».Association.«f.key».name())) {
        if (moreResultClasses == null)
          moreResultClasses = new HashMap<String, Class<?>>();
    «FOR a:f.value SEPARATOR "
"»    moreResultClasses.put("«a.name»", «a.type.ref.fullyQualifiedName».class);«ENDFOR»
      }
      «ENDFOR»
      if (moreResultClasses != null) {
        sqlControl = new SqlStandardControl(sqlControl);
        ((SqlStandardControl) sqlControl).setMoreResultClasses(moreResultClasses);
      }
      return sqlControl;
    }
'''

def compileIfx(PojoDao d) '''
«val im = new ImportManager(true)»
«addImplements(d, im)»
«addExtends(d, im)»
«val classBody = compileIfx(d, d.pojo, im)»
«IF d.eContainer != null»package «d.eContainer.fullyQualifiedName»;«ENDIF»

import java.util.List;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.SqlControl;
import «d.pojo.completeName»;

«classBody»
'''

def compileIfx(PojoDao d, PojoEntity e, ImportManager im) '''
public interface «d.name» {
  «FOR m:d.methods»«IF m.name == "scaffold"»«compileInsertIfx(d, e, im)»
  «compileGetIfx(d, e, im)»
  «compileUpdateIfx(d, e, im)»
  «compileDeleteIfx(d, e, im)»
  «compileListIfx(d, e, im)»
  «compileCountIfx(d, e, im)»
  «ELSEIF isCallUpdate(m)»
  «compileCallUpdateIfx(d, m, im)»«ELSEIF isCallFunction(m)»«compileCallFunctionIfx(d, m, im)»«ELSEIF isCallQuery(m) || isCallQueryFunction(m)»«compileCallQueryIfx(d, m, im, isCallQueryFunction(m))»«ELSEIF isCallSelectFunction(m)»«compileCallSelectFunctionIfx(d, m, im)»«ENDIF»«ENDFOR»
}
'''

def compileCallQueryIfx(PojoDao d, PojoMethod m, ImportManager im, boolean isFunction) '''

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
'''

def compileCallFunctionIfx(PojoDao d, PojoMethod m, ImportManager im) '''

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
'''

def compileCallUpdateIfx(PojoDao d, PojoMethod m, ImportManager im) '''

    public int «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);

    public int «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);

    public int «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);

    public int «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
'''

def compileCallSelectFunctionIfx(PojoDao d, PojoMethod m, ImportManager im) '''

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR», SqlControl sqlControl);

    public «m.type.compileType(im)» «m.name»(SqlSession sqlSession, «FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);

    public «m.type.compileType(im)» «m.name»(«FOR ma:m.args SEPARATOR ", "»«ma.type.compileType(im)» «ma.name»«ENDFOR»);
'''

def compileInsertIfx(PojoDao d, PojoEntity e, ImportManager im) '''

    public «e.name» insert(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public «e.name» insert(«e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public «e.name» insert(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);

    public «e.name» insert(«e.name» «e.name.toFirstLower»);
'''

def compileGetIfx(PojoDao d, PojoEntity e, ImportManager im) '''

    public «e.name» get(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);
	
    public «e.name» get(«e.name» «e.name.toFirstLower», SqlControl sqlControl);
	
    public «e.name» get(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);
	
    public «e.name» get(«e.name» «e.name.toFirstLower»);
'''

def compileUpdateIfx(PojoDao d, PojoEntity e, ImportManager im) '''

    public int update(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public int update(«e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public int update(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);

    public int update(«e.name» «e.name.toFirstLower»);
'''

def compileDeleteIfx(PojoDao d, PojoEntity e, ImportManager im) '''

    public int delete(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public int delete(«e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public int delete(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);

    public int delete(«e.name» «e.name.toFirstLower»);
'''

def compileListIfx(PojoDao d, PojoEntity e, ImportManager im) '''

    public List<«e.name»> list(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public List<«e.name»> list(«e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public List<«e.name»> list(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);

    public List<«e.name»> list(«e.name» «e.name.toFirstLower»);
'''

def compileCountIfx(PojoDao d, PojoEntity e, ImportManager im) '''

    public int count(SqlSession sqlSession, «e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public int count(«e.name» «e.name.toFirstLower», SqlControl sqlControl);

    public int count(SqlSession sqlSession, «e.name» «e.name.toFirstLower»);

    public int count(«e.name» «e.name.toFirstLower»);
'''

def List<PojoAnnotatedProperty> listFeatures(PojoEntity e) {
	
   	val list = new ArrayList<PojoAnnotatedProperty>()
	if (getSuperType(e) != null)
	  list.addAll(getSuperType(e).listFeatures)
	list.addAll(e.listFeatures1)
    return list
}

def listFeatures1(PojoEntity e) {
	return e.features.filter(f|isList(f.feature)).toList
}
  
def List<PojoAnnotatedProperty> requiredFeatures(PojoEntity e) {
	
   	val list = new ArrayList<PojoAnnotatedProperty>()
	if (getSuperType(e) != null)
	  list.addAll(getSuperType(e).requiredFeatures)
	list.addAll(e.requiredFeatures1)
    return list
}

def requiredSuperFeatures(PojoEntity e) {
	
   	val list = new ArrayList<PojoAnnotatedProperty>()
	if (getSuperType(e) != null)
	  list.addAll(getSuperType(e).requiredFeatures)
    return list
}

def requiredFeatures1(PojoEntity e) {
	return e.features.filter(f|isRequired(f.feature)).toList
}

def hasIsDef(PojoEntity e) {
	return e.features.findFirst(f|f.feature.name == "isDef")
}

def hasToInit(PojoEntity e) {
	return e.features.findFirst(f|f.feature.name == "toInit")
}

def isAttribute(PojoProperty f) {
    return f.getNative != null || f.getRef != null || f.getType != null
}

def simplAttrs(PojoProperty f) {
	return f.attrs.filter(f2|f2.getNative != null || f2.getType != null).toList
}

def compileExtends(EnumEntity e, ImportManager im) '''
	«IF getSuperType(e) != null»extends «getFullName(e, getSuperType(e), getSuperType(e).fullyQualifiedName, im)» «ELSEIF getExtends(e) != ""»extends «getExtends(e)» «ENDIF»'''

def compileImplements(EnumEntity e) '''
	«IF isImplements(e) || getSernum(e) != null»implements «FOR f:e.eContainer.eContents.filter(typeof(Implements)) SEPARATOR ", " »«f.getImplements().simpleName»«ENDFOR»«IF getSernum(e) != null»«IF isImplements(e)», «ENDIF»Serializable«ENDIF» «ENDIF»'''

def compileExtends(PojoEntity e, ImportManager im) '''
	«IF getSuperType(e) != null»extends «getFullName(e, getSuperType(e), getSuperType(e).fullyQualifiedName, im)» «ELSEIF getExtends(e) != ""»extends «getExtends(e)» «ENDIF»'''

def compileImplements(PojoEntity e) '''
	«IF isImplements(e) || getSernum(e) != null»implements «FOR f:e.eContainer.eContents.filter(typeof(Implements)) SEPARATOR ", " »«f.getImplements().simpleName»«ENDFOR»«IF getSernum(e) != null»«IF isImplements(e)», «ENDIF»Serializable«ENDIF» «ENDIF»'''

def compileExtends(PojoDao e, ImportManager im) '''
	«IF getSuperType(e) != null»extends «getFullName(e, getSuperType(e), getSuperType(e).fullyQualifiedName, im)» «ELSEIF getExtends(e) != ""»extends «getExtends(e)» «ENDIF»'''

def compileImplements(PojoDao d) '''
	«IF isImplements(d) || getSernum(d) != null || d.implPackage != null»implements «FOR f:d.eContainer.eContents.filter(typeof(Implements)) SEPARATOR ", " »«f.getImplements().simpleName»«ENDFOR»«IF getSernum(d) != null»«IF isImplements(d)», «ENDIF»Serializable«ENDIF»«IF d.implPackage != null»«IF isImplements(d) || getSernum(d) != null», «ENDIF»«d.name»«ENDIF» «ENDIF»'''

def compile(Extends e, ImportManager im) {
	im.addImportFor(e.getExtends())
}

def addImplements(EnumEntity e, ImportManager im) {
	for(impl: e.eContainer.eContents.filter(typeof(Implements))) {
		im.addImportFor(impl.getImplements())
	}
}

def addExtends(EnumEntity e, ImportManager im) {
	for(ext: e.eContainer.eContents.filter(typeof(Extends))) {
		im.addImportFor(ext.getExtends())
	}
}

def addImplements(PojoEntity e, ImportManager im) {
	for(impl: e.eContainer.eContents.filter(typeof(Implements))) {
		im.addImportFor(impl.getImplements())
	}
}

def addExtends(PojoEntity e, ImportManager im) {
	for(ext: e.eContainer.eContents.filter(typeof(Extends))) {
		im.addImportFor(ext.getExtends())
	}
}

def addImplements(PojoDao e, ImportManager im) {
	for(impl: e.eContainer.eContents.filter(typeof(Implements))) {
		im.addImportFor(impl.getImplements())
	}
}

def addExtends(PojoDao e, ImportManager im) {
	for(ext: e.eContainer.eContents.filter(typeof(Extends))) {
		im.addImportFor(ext.getExtends())
	}
}

def addAnnotations(List<Annotation> annotations, ImportManager im) {
	for(a: annotations) {
		im.serialize(a.getType)
	}
}

def getExtends(EnumEntity e) {
	for(ext: e.eContainer.eContents.filter(typeof(Extends))) {
		return ext.getExtends().simpleName
	}
	return ""
}

def isImplements(EnumEntity e) {
	for(ext: e.eContainer.eContents.filter(typeof(Implements))) {
		return true
	}
	return false
}

def getExtends(PojoEntity e) {
	for(ext: e.eContainer.eContents.filter(typeof(Extends))) {
		return ext.getExtends().simpleName
	}
	return ""
}

def isImplements(PojoEntity e) {
	for(ext: e.eContainer.eContents.filter(typeof(Implements))) {
		return true
	}
	return false
}

def getExtends(PojoDao e) {
	for(ext: e.eContainer.eContents.filter(typeof(Extends))) {
		return ext.getExtends().simpleName
	}
	return ""
}

def isImplements(PojoDao e) {
	for(ext: e.eContainer.eContents.filter(typeof(Implements))) {
		return true
	}
	return false
}

def getImplPackage(PojoDao e) {
	for(ext: e.eContainer.eContents.filter(typeof(ImplPackage))) {
		return ext.name
	}
	return null
}

def completeName(PojoEntity e) {
	return getPackage(e)+"."+e.name;
}
}